/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.hx;

import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

public class HxScheduleSupport {
    private static String[] weekdays = new String[]{"Any Weekday", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static String[] weeks = new String[]{"Any Week", "Week 1", "Week 2", "Week 3", "Week 4", "Week 5", "Last 7 days"};
    private static String[] days = new String[32];
    private static String[] months = new String[]{"Any Month", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static BOrd[] getReferenceSchedules(HxOp hxOp) {
        BOrd bOrd = BOrd.make((String)"station:|slot:/|bql: select slotPathOrd from schedule:CalendarSchedule where parent.type != schedule:AbstractSchedule");
        BICollection bICollection = (BICollection)bOrd.get(hxOp.get());
        BITable bITable = bICollection.toTable();
        Column column = bITable.getColumns().get(0);
        BOrd[] bOrdArray = new BOrd[bITable.size()];
        int n = 0;
        while (n < bOrdArray.length) {
            bOrdArray[n] = BOrd.make((String)bITable.get(n, column).toString((Context)hxOp));
            ++n;
        }
        return bOrdArray;
    }

    public static void writeWeekday(String string, int n, HxOp hxOp) throws Exception {
        HxScheduleSupport.writeList(weekdays, string, n, hxOp);
    }

    public static void writeDay(String string, int n, HxOp hxOp) throws Exception {
        if (n > 0) {
            --n;
        }
        HxScheduleSupport.writeList(days, string, n, hxOp);
    }

    public static void writeMonth(String string, int n, HxOp hxOp) throws Exception {
        HxScheduleSupport.writeList(months, string, n, hxOp);
    }

    public static void writeYear(String string, int n, HxOp hxOp) throws Exception {
        String[] stringArray = new String[11];
        stringArray[0] = "Any Year";
        int n2 = BAbsTime.now().getYear();
        int n3 = 1;
        while (n3 < stringArray.length) {
            if (n == n2) {
                n = n3 - 1;
            }
            stringArray[n3] = Integer.toString(n2);
            ++n2;
            ++n3;
        }
        HxScheduleSupport.writeList(stringArray, string, n, hxOp);
    }

    public static int saveWeekday(String string) {
        return Integer.parseInt(string);
    }

    public static int saveDay(String string) {
        int n = Integer.parseInt(string);
        if (n != -1) {
            ++n;
        }
        return n;
    }

    public static int saveMonth(String string) {
        return Integer.parseInt(string);
    }

    public static int saveYear(String string) {
        int n = Integer.parseInt(string);
        if (n != -1) {
            n += BAbsTime.now().getYear();
        }
        return n;
    }

    private static final void writeList(String[] stringArray, String string, int n, HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)"<select ").attr("name", hxOp.scope(string)).w((Object)">");
        int n2 = 0;
        while (n2 < stringArray.length) {
            htmlWriter.w((Object)"<option value='").w(n2 - 1).w((Object)"'");
            if (n2 == n + 1) {
                htmlWriter.w((Object)" selected='selected'");
            }
            htmlWriter.w((Object)">").w((Object)stringArray[n2]).w((Object)"</option>");
            ++n2;
        }
        htmlWriter.w((Object)"</select>");
    }

    static {
        HxScheduleSupport.days[0] = "Any Day";
        int n = 1;
        while (n < days.length) {
            HxScheduleSupport.days[n] = Integer.toString(n);
            ++n;
        }
    }
}

