/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.schedule.ScheduleSpyManager;
import java.util.Hashtable;
import java.util.LinkedList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExecutionQueue {
    public static ScheduleSpyManager scheduleManager = new ScheduleSpyManager();
    private int busyThreads;
    private Hashtable map;
    private int maxQueueSize;
    private int maxThreads;
    private int minThreads;
    private LinkedList queue;
    private boolean running;
    private String threadName;
    private int totalThreads;

    public synchronized Runnable dequeue() {
        --this.busyThreads;
        while (this.queue.size() == 0) {
            if (this.totalThreads > this.minThreads) {
                return this.killThread();
            }
            if (!this.running) {
                return this.killThread();
            }
            try {
                this.wait(10000L);
            }
            catch (Exception exception) {}
        }
        if (!this.running) {
            return this.killThread();
        }
        Runnable runnable = (Runnable)this.queue.removeFirst();
        ++this.busyThreads;
        this.map.remove(runnable);
        scheduleManager.dequeueSpy(runnable);
        return runnable;
    }

    public synchronized void clear() {
        this.queue.clear();
        this.map.clear();
    }

    public synchronized void enqueue(Runnable runnable) throws QueueFull {
        if (!this.running) {
            throw new IllegalStateException();
        }
        if (this.maxQueueSize > 0 && this.queue.size() >= this.maxQueueSize) {
            throw new QueueFull();
        }
        if (this.map.containsKey(runnable)) {
            return;
        }
        this.map.put(runnable, runnable);
        this.queue.addLast(runnable);
        if (this.busyThreads == this.totalThreads && this.maxThreads > this.totalThreads) {
            this.createThread();
        }
        scheduleManager.enqueueSpy(runnable);
        this.notify();
    }

    public void start() {
        this.running = true;
        int n = this.minThreads;
        while (--n >= 0) {
            this.createThread();
        }
    }

    public synchronized void stop() {
        this.running = false;
        this.queue.clear();
        this.notifyAll();
    }

    private final synchronized void createThread() {
        ++this.totalThreads;
        ++this.busyThreads;
        new RunThread(this.threadName).start();
    }

    private final Runnable killThread() {
        --this.totalThreads;
        return null;
    }

    private final /* synthetic */ void this() {
        this.busyThreads = 0;
        this.map = new Hashtable();
        this.maxQueueSize = 0;
        this.maxThreads = 1;
        this.minThreads = 1;
        this.queue = new LinkedList();
        this.running = false;
        this.totalThreads = 0;
    }

    public ExecutionQueue(String string) {
        this.this();
        this.threadName = string;
    }

    public ExecutionQueue(String string, boolean bl) {
        this.this();
        this.threadName = string;
        if (bl) {
            this.start();
        }
    }

    public ExecutionQueue(String string, int n, int n2, int n3) {
        this.this();
        this.threadName = string;
        this.minThreads = n;
        this.maxThreads = n2;
        this.maxQueueSize = n3;
    }

    public static class QueueFull
    extends RuntimeException {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RunThread
    extends Thread {
        public void run() {
            Runnable runnable = ExecutionQueue.this.dequeue();
            while (runnable != null) {
                runnable.run();
                runnable = ExecutionQueue.this.dequeue();
            }
        }

        public RunThread(String string) {
            super(string);
            try {
                this.setPriority(Math.max(this.getPriority() - 1, 1));
            }
            catch (Exception exception) {}
        }
    }
}

