/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jndi;

import COM.ibm.db2.jdbc.DB2DataSource;
import COM.ibm.db2.jndi.DB2NameClassList;
import COM.ibm.db2.jndi.DB2NameClassObjectList;
import COM.ibm.db2.mri.DB2Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

class DB2Context
implements Context {
    private Hashtable env;
    protected Hashtable bindings = null;
    private File storageFile = null;
    private boolean saveBeforeExit = false;
    private boolean calledByApplet = false;
    private DB2Messages msg = null;
    private String[] tokens = new String[1];
    private static final String DEFAULT_STORAGE_FILENAME = ".db2.jndi";

    DB2Context(Hashtable env) {
        this.env = env != null ? (Hashtable)env.clone() : null;
        this.msg = new DB2Messages();
        try {
            String home = System.getProperty("user.home");
            this.storageFile = new File(home, DEFAULT_STORAGE_FILENAME);
        }
        catch (SecurityException e2) {
            this.calledByApplet = true;
        }
        try {
            InputStream inStream;
            if (this.calledByApplet) {
                if (env == null) {
                    this.tokens[0] = "java.naming.provider.url";
                    throw new MalformedURLException(this.msg.getString("0636", this.tokens));
                }
                String providerURL = (String)env.get("java.naming.provider.url");
                if (providerURL == null) {
                    System.out.println("DB2Context Environment Properties:");
                    Enumeration e3 = env.keys();
                    if (!e3.hasMoreElements()) {
                        System.out.println("  None");
                    }
                    while (e3.hasMoreElements()) {
                        String pName = (String)e3.nextElement();
                        String pValue = (String)env.get(pName);
                        System.out.println("  " + pName + " = " + pValue);
                    }
                    this.tokens[0] = "java.naming.provider.url";
                    throw new MalformedURLException(this.msg.getString("0636", this.tokens));
                }
                URL url = new URL(providerURL + "/" + DEFAULT_STORAGE_FILENAME);
                inStream = url.openStream();
            } else {
                inStream = new FileInputStream(this.storageFile);
            }
            ObjectInputStream objInStream = new ObjectInputStream(inStream);
            try {
                if (((InputStream)inStream).available() > 0) {
                    this.bindings = (Hashtable)objInStream.readObject();
                }
            }
            catch (ClassNotFoundException e4) {
                System.out.println(e4.toString());
            }
            objInStream.close();
            ((InputStream)inStream).close();
        }
        catch (MalformedURLException e5) {
            e5.printStackTrace();
        }
        catch (IOException e6) {
            this.bindings = new Hashtable(11);
        }
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new DB2Context(this.env);
        }
        Object objRef = this.bindings.get(name);
        if (objRef == null) {
            this.tokens[0] = name;
            throw new NameNotFoundException(this.msg.getString("0637", this.tokens));
        }
        return this.dereference(objRef);
    }

    protected Object dereference(Object objRef) {
        if (objRef instanceof Reference) {
            Object objReal = null;
            try {
                objReal = NamingManager.getObjectInstance(objRef, null, this, this.env);
            }
            catch (Exception e2) {
                System.out.println(e2.toString());
            }
            return objReal;
        }
        return objRef;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "bind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (name.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        if (this.bindings.get(name) != null) {
            this.tokens[0] = name;
            throw new NameAlreadyBoundException(this.msg.getString("0638", this.tokens));
        }
        this.bindings.put(name, ((DB2DataSource)obj).getReference());
        this.saveBeforeExit = true;
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "rebind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (name.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        this.bindings.put(name, ((DB2DataSource)obj).getReference());
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "unbind()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (name.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        this.bindings.remove(name);
        this.saveBeforeExit = true;
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (this.calledByApplet) {
            this.tokens[0] = "rename()";
            throw new OperationNotSupportedException(this.msg.getString("0635", this.tokens));
        }
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException(this.msg.getString("0639"));
        }
        if (this.bindings.get(newname) != null) {
            this.tokens[0] = newname;
            throw new NameAlreadyBoundException("0638");
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            this.tokens[0] = oldname;
            throw new NameNotFoundException(this.msg.getString("0637", this.tokens));
        }
        this.bindings.put(newname, oldBinding);
        this.saveBeforeExit = true;
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new DB2NameClassList(this.bindings);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        this.tokens[0] = name;
        throw new NotContextException(this.msg.getString("0640", this.tokens));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new DB2NameClassObjectList(this);
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        this.tokens[0] = name;
        throw new NotContextException(this.msg.getString("0640", this.tokens));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        this.tokens[0] = "destroySubcontext()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        this.tokens[0] = "createSubcontext()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        this.tokens[0] = "getNameParser()";
        throw new OperationNotSupportedException(this.msg.getString("0626", this.tokens));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(5, 0.75f);
        }
        return this.env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.env == null) {
            this.env = new Hashtable(3, 0.75f);
        }
        return this.env;
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
        if (!this.calledByApplet && this.saveBeforeExit) {
            try {
                FileOutputStream fileOutStream = new FileOutputStream(this.storageFile);
                ObjectOutputStream objOutStream = new ObjectOutputStream(fileOutStream);
                objOutStream.writeObject(this.bindings);
                objOutStream.flush();
                objOutStream.close();
                fileOutStream.close();
            }
            catch (IOException e2) {
                System.out.println(e2.toString());
            }
        }
        this.env = null;
        this.bindings = null;
    }
}

