/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Exception;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2DataTruncation;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.DB2Warning;
import COM.ibm.db2.mri.DB2Messages;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class SQLExceptionGenerator {
    protected String SQLState = null;
    protected String SQLmessage = null;
    protected int SQLnativeCode = 0;
    protected byte[] SQLca = null;
    protected DB2Messages errMsgClass;
    protected int PSMLineNumber = 0;
    protected String SQLerrmc = null;

    protected native int SQLConnectionError(int var1, int var2);

    protected native int SQLStatementError(int var1, int var2);

    public SQLExceptionGenerator(ResourceBundle m2) {
        this.errMsgClass = new DB2Messages(m2);
    }

    protected void TraceException(String str) {
        DB2Trace.getTraceObj().traceEntry("SQLExceptionGenerator", str);
        DB2Trace.getTraceObj().println("SQLState = " + this.SQLState);
        DB2Trace.getTraceObj().println("SQLmessage = " + this.SQLmessage);
        DB2Trace.getTraceObj().println("SQLnativeCode = " + this.SQLnativeCode);
        DB2Trace.getTraceObj().traceExit("SQLExceptionGenerator", str);
        DB2Trace.flush();
    }

    public void throw_SQLException(DB2Connection con) throws SQLException {
        DB2Exception current = null;
        DB2Exception head = null;
        int rc2 = this.getSQLConnectionError(con);
        while (rc2 != 100 && rc2 != -2) {
            String trimedState = this.SQLState.trim();
            if (trimedState.startsWith("01") && !trimedState.equals("01004")) {
                con.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
            } else if (head == null) {
                current = head = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
            } else {
                DB2Exception next = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca);
                current.setNextException(next);
                current = next;
            }
            rc2 = this.getSQLConnectionError(con);
        }
        if (null != head) {
            throw head;
        }
    }

    public void throw_SQLException(DB2Statement stmt) throws SQLException {
        this.throw_SQLException(stmt, false);
    }

    public void throw_SQLException(DB2Statement stmt, boolean isBatch) throws SQLException {
        SQLException head = null;
        SQLException current = null;
        int se2 = this.getSQLStatementError(stmt);
        while (se2 != 100 && se2 != -2) {
            String trimedState = this.SQLState.trim();
            if (trimedState.startsWith("01") && !trimedState.equals("01004")) {
                if (trimedState.equals("01004")) {
                    stmt.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else if (trimedState.equals("01592")) {
                    stmt.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                } else {
                    stmt.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
                }
            } else if (head == null) {
                if (isBatch) {
                    int[] batchReturn = stmt.getBatchReturn();
                    head = new BatchUpdateException(this.SQLmessage, this.SQLState, this.SQLnativeCode, batchReturn);
                } else {
                    head = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
                }
                current = head;
            } else {
                DB2Exception next = new DB2Exception(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc);
                current.setNextException(next);
                current = next;
            }
            se2 = this.getSQLStatementError(stmt);
        }
        if (se2 == -2) {
            this.throwClosedError();
        } else if (null != head) {
            throw head;
        }
    }

    public void addWarning(DB2Connection con) {
        if (this.getSQLConnectionError(con) != 100) {
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Connection)");
            }
            con.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
        }
    }

    public void addWarning(DB2Statement stmt) {
        int statementError = this.getSQLStatementError(stmt);
        while (statementError == 0 || statementError == 1) {
            String trimedState;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement)");
            }
            if ((trimedState = this.SQLState.trim()).equals("01004") || trimedState.equals("01592") || trimedState.equals("01S07")) {
                stmt.addWarning(new DB2DataTruncation(-1, true, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else {
                stmt.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            }
            statementError = this.getSQLStatementError(stmt);
        }
    }

    public void addWarning(DB2Statement stmt, DB2ResultSet rs) {
        int statementError = this.getSQLStatementError(stmt);
        if (statementError == 0 || statementError == 1) {
            String trimedState;
            if (DB2Trace.TraceOn) {
                this.TraceException("addWarning(DB2Statement, DB2ResultSet)");
            }
            if ((trimedState = this.SQLState.trim()).equals("01004") || trimedState.equals("01592") || trimedState.equals("01S07")) {
                rs.addWarning(new DB2DataTruncation(-1, false, false, -1, -1, this.SQLca, this.PSMLineNumber, this.SQLerrmc));
            } else {
                rs.addWarning(new DB2Warning(this.SQLmessage, this.SQLState, this.SQLnativeCode, this.SQLca));
            }
            statementError = this.getSQLStatementError(stmt);
        }
    }

    public void check_return_code(DB2Connection conn, int rc2) throws SQLException {
        switch (rc2) {
            case 0: {
                break;
            }
            case 1: {
                this.addWarning(conn);
                break;
            }
            case -2: {
                throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
            }
            default: {
                this.throw_SQLException(conn);
            }
        }
    }

    public void check_return_code(DB2Statement stmt, int rc2) throws SQLException {
        switch (rc2) {
            case 0: {
                break;
            }
            case 1: {
                this.addWarning(stmt);
                break;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(stmt);
            }
        }
    }

    public void check_return_code(DB2Statement stmt, DB2ResultSet rs, int rc2) throws SQLException {
        switch (rc2) {
            case 0: {
                break;
            }
            case 1: {
                this.addWarning(stmt, rs);
                break;
            }
            case -2: {
                this.throwClosedError();
            }
            default: {
                this.throw_SQLException(stmt);
            }
        }
    }

    public void check_address(long addr, boolean exec) throws SQLException {
        if (0L == addr) {
            throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
        }
        if (!exec) {
            throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
        }
    }

    public void check_type(int expected, int actual) throws SQLException {
        if (expected != actual) {
            throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
        }
    }

    public void checkColumnIndex(int columnIndex, int totalColumns) throws SQLException {
        if (columnIndex < 1 || columnIndex > totalColumns) {
            throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
        }
    }

    public void checkParamIndex(int paramIndex, int total) throws SQLException {
        if (paramIndex < 1 || paramIndex > total) {
            throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
        }
    }

    public void throwNotOutputParameterError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0603"), "S1010", -99999, null);
    }

    public void throwNotExecutedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0604"), "S1010", -99999, null);
    }

    public void throwTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0605"), "22005", -99999, null);
    }

    public void throwOutOfRangeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
    }

    public void throwConnectionClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0600"), "S1000", -99999, null);
    }

    public void throwInvalidQueryError() throws SQLException {
        String[] tokens = new String[]{"QUERY"};
        throw new DB2Exception(this.errMsgClass.getString("0637", tokens), "S1000", -99999, null);
    }

    public void throwInvalidUpdateError() throws SQLException {
        String[] tokens = new String[]{"UPDATE"};
        throw new DB2Exception(this.errMsgClass.getString("0637", tokens), "S1000", -99999, null);
    }

    public void throwNullError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0639"));
    }

    public void throwColumnIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0610"), "S1002", -99999, null);
    }

    public void throwColumnDataTypeError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
    }

    public void throwParamIndexError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0612"), "S1093", -99999, null);
    }

    public void throwClosedError() throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0601"), "S1000", -99999, null);
    }

    public void pstmtException(String sqlState) throws SQLException {
        if (sqlState.equals("S1003")) {
            throw new DB2Exception(this.errMsgClass.getString("0613"), "S1003", -99999, null);
        }
        if (sqlState.equals("22003")) {
            throw new DB2Exception(this.errMsgClass.getString("0609"), "22003", -99999, null);
        }
    }

    public void rsException(String sqlState) throws SQLException {
        if (sqlState.equals("S0022")) {
            throw new DB2Exception(this.errMsgClass.getString("0611"), "S0022", -99999, null);
        }
        if (sqlState.equals("22005")) {
            throw new DB2Exception(this.errMsgClass.getString("0606"), "22005", -99999, null);
        }
        if (sqlState.equals("07006")) {
            throw new DB2Exception(this.errMsgClass.getString("0608"), "07006", -99999, null);
        }
    }

    public void throw_IOException(IOException e2) throws SQLException {
        throw new DB2Exception(this.errMsgClass.getString("0620"), "22021", -99999, null);
    }

    public void connException(String sqlState) throws SQLException {
        if (sqlState.trim().equals("S1C00")) {
            throw new DB2Exception(this.errMsgClass.getString("0700"), "S1C00", -99999, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSQLConnectionError(DB2Connection con) {
        int rc2 = 0;
        DB2Connection dB2Connection = con;
        synchronized (dB2Connection) {
            try {
                rc2 = this.SQLConnectionError(con.connectionHandle, DB2Driver.getJVMHenv());
            }
            catch (SQLException e2) {
                // empty catch block
            }
        }
        return rc2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSQLStatementError(DB2Statement stmt) {
        int rc2 = 0;
        if (stmt.cachedError) {
            this.SQLState = stmt.SQLState;
            this.SQLmessage = stmt.SQLmessage;
            this.SQLnativeCode = stmt.SQLnativeCode;
            this.SQLca = stmt.SQLca;
            stmt.cachedError = false;
            stmt.SQLState = null;
            stmt.SQLmessage = null;
            stmt.SQLnativeCode = 0;
        } else {
            this.SQLState = "";
            this.SQLmessage = "";
            this.SQLnativeCode = 0;
            this.SQLca = null;
            this.PSMLineNumber = 0;
            this.SQLerrmc = "";
            DB2Connection dB2Connection = stmt.connection;
            synchronized (dB2Connection) {
                rc2 = this.SQLStatementError(stmt.statementHandle, stmt.connection.connectionHandle);
            }
        }
        return rc2;
    }

    public void throwNot20() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0625"));
    }

    public void throwNotSupportedByDB2(String fName) throws SQLException {
        String[] tokens = new String[]{fName};
        throw new SQLException(this.errMsgClass.getString("0626", tokens));
    }

    public void throwNotScrollable() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0627"));
    }

    public void throwNotSet(int row, int col, int[] batchReturn) throws SQLException {
        String[] tokens = new String[]{String.valueOf(col + 1), String.valueOf(row + 1)};
        throw new BatchUpdateException(this.errMsgClass.getString("0628", tokens), "", -99999, batchReturn);
    }

    public void throwNotSupportedIO(String name) throws IOException {
        String[] tokens = new String[]{name};
        throw new IOException(this.errMsgClass.getString("0629", tokens));
    }

    public void throwUnknownResultSetType(int value) throws SQLException {
        String[] tokens = new String[]{String.valueOf(value)};
        throw new SQLException(this.errMsgClass.getString("0630", tokens));
    }

    public void throwNoRandomAccess() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0631"));
    }

    public void throwFetchSizeError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0632"));
    }

    public void throwInvalidRelativeCall() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0633"));
    }

    public void throwQueryInBatch() throws SQLException {
        throw new BatchUpdateException(this.errMsgClass.getString("0641"), new int[0]);
    }

    public void throwFetchDirectionError() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0642"));
    }

    public void throwBatchSizeError() throws SQLException {
        throw new BatchUpdateException(this.errMsgClass.getString("0643"), new int[0]);
    }

    public void throwInvalidAbsoluteCall() throws SQLException {
        throw new SQLException(this.errMsgClass.getString("0644"));
    }

    public void check_batch_return_code(DB2Statement stmt, int rc2) throws SQLException {
        switch (rc2) {
            case 0: {
                break;
            }
            case -2: {
                this.throwClosedError();
                break;
            }
            case 1: {
                this.addWarning(stmt);
                break;
            }
            default: {
                this.throw_SQLException(stmt, true);
            }
        }
    }

    public void throwBatchCTypeChanged(int dIndex) throws SQLException {
        String msg = "Switching types in a batch is not allowed. Fix parameter " + dIndex + ".";
        throw new DB2Exception(msg, "07006", -99999, null);
    }
}

