/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DB2XAResource
implements XAResource {
    public static final int TMTIMEOUT = 256;
    private XAConnection xacon;
    private int hdbc;
    private byte[] xaResourcePtr;
    private int retCode;

    private native int xaCommit(int var1, byte[] var2, byte[] var3, int var4);

    private native int xaEnd(int var1, byte[] var2, byte[] var3, int var4);

    private native int xaForget(int var1, byte[] var2, byte[] var3);

    private native int xaGetTransTimeOut(Integer var1);

    private native int xaSetTransTimeOut(int var1);

    private native Xid[] xaRecover(int var1);

    private native int xaPrepare(int var1, byte[] var2, byte[] var3);

    private native int xaRollback(int var1, byte[] var2, byte[] var3);

    private native int xaStart(int var1, byte[] var2, byte[] var3, int var4);

    private native boolean cliIsSameRM(int var1, int var2);

    public DB2XAResource(XAConnection xacon, int handle, byte[] xaPtr) {
        this.xacon = xacon;
        this.hdbc = handle;
        this.xaResourcePtr = xaPtr;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        int rc2;
        int flag = 0;
        if (onePhase) {
            flag = 0x40000000;
        }
        if ((rc2 = this.xaCommit(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), flag)) != 0) {
            this.throwXAException(rc2);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        int rc2 = this.xaEnd(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), flags);
        if (rc2 != 0) {
            this.throwXAException(rc2);
        }
    }

    public void forget(Xid xid) throws XAException {
        int rc2 = this.xaForget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (rc2 != 0) {
            this.throwXAException(rc2);
        }
    }

    public int getTransactionTimeout() throws XAException {
        Integer seconds = new Integer(0);
        int rc2 = this.xaGetTransTimeOut(seconds);
        if (rc2 != 0) {
            this.throwXAException(rc2);
        }
        return seconds;
    }

    public int prepare(Xid xid) throws XAException {
        int rc2 = this.xaPrepare(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (rc2 != 0 && rc2 != 3) {
            this.throwXAException(rc2);
        }
        return rc2;
    }

    public Xid[] recover(int flag) throws XAException {
        Xid[] xids = this.xaRecover(flag);
        if (this.retCode < 0) {
            this.throwXAException(this.retCode);
        }
        return xids;
    }

    public void rollback(Xid xid) throws XAException {
        int rc2 = this.xaRollback(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        if (rc2 != 0) {
            this.throwXAException(rc2);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        int rc2 = this.xaStart(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), flags);
        if (rc2 != 0) {
            this.throwXAException(rc2);
        }
    }

    private void throwXAException(int rc2) throws XAException {
        throw new XAException(rc2);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (!(xares instanceof DB2XAResource)) {
            return false;
        }
        DB2XAResource db2xares = (DB2XAResource)xares;
        return this.cliIsSameRM(this.hdbc, db2xares.hdbc);
    }
}

