/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2ResultSetTrace;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSet;
import COM.ibm.db2.jdbc.app.DB2ScrollableResultSetTrace;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DB2Statement
implements Statement {
    protected static final short STMT_TYPE_QUERY = 24;
    protected static final short STMT_TYPE_CALL = 25;
    protected static final short STMT_TYPE_OTHER = 26;
    protected static final short STMT_TYPE_SQLJ = 27;
    protected int statementHandle = 0;
    protected DB2Connection connection;
    SQLWarning warnings = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int rowCount = 0;
    protected short colCount = 0;
    protected int returnCode = 0;
    protected boolean closed = false;
    protected boolean internalStmt = false;
    protected DB2ResultSet resultSet = null;
    protected boolean moreResults = true;
    protected boolean prefetchedMoreResults = false;
    protected SQLExceptionGenerator sqlExcptGen;
    protected String[] colNames4JSQL = null;
    protected int colCount4JSQL = 0;
    protected String SQLState = null;
    protected String SQLmessage = null;
    protected int SQLnativeCode = 0;
    protected byte[] SQLca = null;
    protected boolean cachedError = false;
    protected int SQLNextErrorRC = 0;
    protected int sqlSuccess = 0;
    protected int rsType = 1003;
    protected int rsConcur = 1007;
    protected int rsTypeAllocated = this.rsType;
    private boolean counted = false;
    private static int statementCount = 0;
    private static int peakStatementCount = 0;
    protected String sql = null;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected String batchQuery = null;
    protected int batchSize = 0;
    protected int[] batchReturn = null;
    protected BatchUpdateException batchUpdateException = null;

    protected native int SQLAllocStmt(int var1, int var2, int var3);

    protected native int SQLExecDirect(String var1, int var2, int var3);

    protected native int SQLGetColumnCount(int var1);

    protected native int SQLGetRowCount(int var1);

    protected native int SQLFreeStmt(int var1);

    protected native int SQLCancel(int var1);

    protected native int SQLMoreResults(int var1, int var2);

    protected native int SQLMaxFieldSize(int var1, int var2);

    protected native int SQLMaxRows(int var1, int var2);

    protected native int SQLScan(boolean var1, int var2);

    protected native int SQLSetQueryTimeout(int var1, int var2);

    protected native int SQLGetQueryTimeout(int var1);

    protected native int SQLSetCursorName(String var1, int var2, int var3);

    protected native int SQLGetStmtAttr(int var1, int var2);

    protected native int SQLSetStmtAttr(int var1, int var2, int var3);

    public String toString() {
        return this.toString("", true);
    }

    protected String toString(String ident, boolean displayRSObj) {
        StringBuffer sb2 = new StringBuffer("\r\n" + ident + "DB2Statement \r\n" + ident + "{");
        if (this.connection != null) {
            sb2.append(this.connection.toString(ident + "    Connection -> "));
        } else {
            sb2.append("\r\n" + ident + "    Connection -> null");
        }
        if (displayRSObj) {
            if (this.resultSet != null) {
                sb2.append(this.resultSet.toString(ident + "    ResultSet -> ", false));
            } else {
                sb2.append("\r\n" + ident + "    ResultSet -> null\r\n");
            }
        }
        sb2.append("\r\n");
        sb2.append(ident + "    statementHandle = " + this.getTraceHandle() + "\r\n");
        sb2.append(ident + "    SQL = " + this.sql + "\r\n");
        sb2.append(ident + "    maxRows = " + this.maxRows + "\r\n");
        sb2.append(ident + "    maxFieldSize = " + this.maxFieldSize + "\r\n");
        sb2.append(ident + "    rowCount = " + this.rowCount + "\r\n");
        sb2.append(ident + "    colCount = " + this.colCount + "\r\n");
        sb2.append(ident + "    closed = " + this.closed + "\r\n");
        sb2.append(ident + "    internalStmt = " + this.internalStmt + "\r\n");
        sb2.append(ident + "    returnCode = " + this.returnCode + "\r\n");
        sb2.append(ident + "}\r\n");
        return sb2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DB2Statement(DB2Connection con, int rsType, int rsConcur) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Statement( con, " + rsType + ", " + rsConcur + " )");
            }
            this.connection = con;
            this.sqlExcptGen = this.connection.sqlExcptGen;
            this.rsType = rsType;
            this.rsConcur = rsConcur;
            this.checkResultSetType(rsType, rsConcur);
            this.rsTypeAllocated = this.rsType;
            this.returnCode = 0;
            this.statementHandle = this.SQLAllocStmt(this.connection.connectionHandle, rsType, rsConcur);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
                if (this.returnCode == 1 && this.rsTypeAllocated != 1003) {
                    for (SQLWarning w2 = this.getWarnings(); w2 != null; w2 = w2.getNextWarning()) {
                        if (!w2.getSQLState().equalsIgnoreCase("01S02")) continue;
                        this.rsTypeAllocated = this.rsType = 1003;
                        this.connection.addWarning(new SQLWarning("Cursor downgraded to TYPE_FORWARD_ONLY", "01S02", -99999));
                        if (!DB2Trace.TraceOn) continue;
                        DB2Trace.data(10, "Cursor downgraded to TYPE_FORWARD_ONLY");
                    }
                }
            }
            this.incrementStatementCount();
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            DB2Trace.methodExit(this, "DB2Statement()");
            throw throwable;
        }
        DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
        DB2Trace.methodExit(this, "DB2Statement()");
    }

    public DB2Statement(DB2Connection con) throws SQLException {
        this(con, 1003, 1007);
    }

    public DB2Statement(DB2Connection con, boolean internal) throws SQLException {
        this(con);
        this.internalStmt = internal;
    }

    private synchronized void incrementStatementCount() {
        if (!this.counted) {
            DB2Statement.adjustStatementCount(1);
            this.counted = true;
        }
    }

    private synchronized void decrementStatementCount() {
        if (this.counted) {
            DB2Statement.adjustStatementCount(-1);
            this.counted = false;
        }
    }

    private static synchronized void adjustStatementCount(int i2) {
        if ((statementCount += i2) > peakStatementCount) {
            peakStatementCount = statementCount;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Peak statements", peakStatementCount);
            }
            DriverManager.println("DB2 Peak statements = " + peakStatementCount);
        }
    }

    public static int getStatementCount() {
        return statementCount;
    }

    public static int getPeakStatementCount() {
        return peakStatementCount;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DB2Connection getDB2Connection() {
        return this.connection;
    }

    public int getHandle() {
        return this.statementHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        boolean bl2;
        block7: {
            boolean retVal;
            block5: {
                boolean bl3;
                block6: {
                    this.sql = sql;
                    retVal = false;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "execute( " + sql + " )");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (null == sql || 0 == sql.trim().length()) {
                            this.sqlExcptGen.throwNullError();
                        }
                        this.execute2(sql);
                        this.getResultSet();
                        if (this.resultSet.numCols <= 0) break block5;
                        bl3 = retVal = true;
                        Object var5_5 = null;
                        if (!DB2Trace.TraceOn) break block6;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var5_7 = null;
                            if (!DB2Trace.TraceOn) break block8;
                            DB2Trace.methodExit((Object)this, "execute()", String.valueOf(retVal));
                        }
                        throw throwable;
                    }
                    DB2Trace.methodExit((Object)this, "execute()", String.valueOf(retVal));
                }
                return bl3;
            }
            bl2 = retVal = false;
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) break block7;
            DB2Trace.methodExit((Object)this, "execute()", String.valueOf(retVal));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String query) throws SQLException {
        this.sql = query;
        try {
            short statementType;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeQuery( " + query + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (null == query || 0 == query.trim().length()) {
                this.sqlExcptGen.throwNullError();
            }
            if (24 != (statementType = this.getStatementType(query)) && 25 != statementType && 27 != statementType) {
                this.sqlExcptGen.throwInvalidQueryError();
            }
            this.execute2(query);
            this.getResultSet();
            DB2ResultSet dB2ResultSet = this.resultSet;
            return dB2ResultSet;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "executeQuery()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected short getStatementType(String query) {
        int n2;
        int retVal;
        block26: {
            String type2;
            int n3;
            block25: {
                retVal = 26;
                try {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.methodEntry(this, "getStatementType( " + query + " )");
                    }
                    if (null != query) {
                        int index;
                        int len = query.length();
                        if (len > 0 && '#' == query.charAt(0)) {
                            n3 = retVal = 27;
                            Object var9_6 = null;
                            if (!DB2Trace.TraceOn) return (short)n3;
                            type2 = null;
                            break block25;
                        }
                        boolean inSimpleComment = false;
                        int bracketedCommentLevel = 0;
                        for (index = 0; index < len; ++index) {
                            if (inSimpleComment) {
                                if (query.charAt(index) != '\n') continue;
                                inSimpleComment = false;
                                continue;
                            }
                            if (query.startsWith("/*", index)) {
                                ++bracketedCommentLevel;
                                ++index;
                                continue;
                            }
                            if (bracketedCommentLevel > 0) {
                                if (!query.startsWith("*/", index)) continue;
                                --bracketedCommentLevel;
                                ++index;
                                continue;
                            }
                            if (query.startsWith("--", index)) {
                                inSimpleComment = true;
                                ++index;
                                continue;
                            }
                            char c2 = query.charAt(index);
                            if (!Character.isWhitespace(c2) && c2 != '{' && c2 != ';' && c2 != '?' && c2 != '(' && c2 != '=') break;
                        }
                        retVal = query.regionMatches(true, index, "select", 0, 6) || query.regionMatches(true, index, "values", 0, 6) || query.regionMatches(true, index, "with", 0, 4) ? 24 : (query.regionMatches(true, index, "call", 0, 4) ? 25 : 26);
                    }
                    n2 = retVal;
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    if (!DB2Trace.TraceOn) throw throwable;
                    String type2 = null;
                    switch (retVal) {
                        case 24: {
                            type2 = "STMT_TYPE_QUERY (24)";
                            break;
                        }
                        case 25: {
                            type2 = "STMT_TYPE_CALL (25)";
                            break;
                        }
                        case 27: {
                            type2 = "STMT_TYPE_SQLJ (27)";
                            break;
                        }
                        default: {
                            type2 = "STMT_TYPE_OTHER (26)";
                        }
                    }
                    DB2Trace.methodExit((Object)this, "getStatementType()", type2);
                    throw throwable;
                }
            }
            switch (retVal) {
                case 24: {
                    type2 = "STMT_TYPE_QUERY (24)";
                    break;
                }
                case 25: {
                    type2 = "STMT_TYPE_CALL (25)";
                    break;
                }
                case 27: {
                    type2 = "STMT_TYPE_SQLJ (27)";
                    break;
                }
                default: {
                    type2 = "STMT_TYPE_OTHER (26)";
                }
            }
            DB2Trace.methodExit((Object)this, "getStatementType()", type2);
            return (short)n3;
        }
        Object var9_7 = null;
        if (!DB2Trace.TraceOn) return (short)n2;
        String type2 = null;
        switch (retVal) {
            case 24: {
                type2 = "STMT_TYPE_QUERY (24)";
                break;
            }
            case 25: {
                type2 = "STMT_TYPE_CALL (25)";
                break;
            }
            case 27: {
                type2 = "STMT_TYPE_SQLJ (27)";
                break;
            }
            default: {
                type2 = "STMT_TYPE_OTHER (26)";
            }
        }
        DB2Trace.methodExit((Object)this, "getStatementType()", type2);
        return (short)n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        this.sql = sql;
        int retVal = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeUpdate( " + sql + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (24 == this.getStatementType(sql)) {
                this.sqlExcptGen.throwInvalidUpdateError();
            }
            this.execute2(sql);
            int n2 = retVal = this.getUpdateCount();
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "executeUpdate", retVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void execute2(String sql) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "execute2( " + sql + " )");
                DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
            }
            this.moreResults = true;
            this.prefetchedMoreResults = false;
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (null == sql || 0 == sql.trim().length()) {
                this.sqlExcptGen.throwNullError();
            }
            this.warnings = null;
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            this.rowCount = 0;
            if (this.rsTypeAllocated != 1003 && this.rsType == 1003) {
                this.returnCode = 0;
                int rc2 = this.SQLSetStmtAttr(this.statementHandle, 6, 3);
                if (rc2 != 0) {
                    this.sqlExcptGen.check_return_code(this, rc2);
                }
                this.rsType = this.rsTypeAllocated;
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "rsType upgraded (rsTypeAllocated,rsType)", this.rsTypeAllocated + "," + this.rsType);
                }
            }
            this.returnCode = 0;
            DB2Connection dB2Connection = this.connection;
            // MONITORENTER : dB2Connection
            this.returnCode = (short)this.SQLExecDirect(sql, this.statementHandle, this.connection.connectionHandle);
            // MONITOREXIT : dB2Connection
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "SQLExecDirect - returnCode ", this.returnCode);
            }
            if (this.returnCode == 100) {
                this.rowCount = 0;
                this.addWarning(new SQLWarning("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table.", "02000", 100));
                Object var5_4 = null;
                if (!DB2Trace.TraceOn) return;
                DB2Trace.data(10, "rowCount", this.rowCount);
                DB2Trace.methodExit(this, "execute2()");
                return;
            }
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) return;
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit(this, "execute2()");
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit(this, "execute2()");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
                DB2Trace.data(10, "StatementHandle ", this.getTraceHandle());
            }
            if (!this.closed) {
                this.close2(true);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void close2(boolean explicitClose) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close2( " + explicitClose + " )");
            }
            this.closed = true;
            this.decrementStatementCount();
            if (this.connection == null) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "connection is null");
                }
                return;
            }
            if (this.statementHandle == 0) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(20, "statementHandle = 0");
                }
                return;
            }
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                block20: {
                    if (!this.connection.closed) break block20;
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(30, "connection is closed");
                    }
                    return;
                }
                if (this.resultSet != null) {
                    this.resultSet.clearIsList();
                }
                if (!this.connection.SPConnected || this.connection.SPConnected && explicitClose) {
                    rc2 = this.SQLFreeStmt(this.statementHandle);
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, rc2);
                    }
                    this.statementHandle = 0;
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "close2()", rc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            if (!this.closed) {
                String msg = null;
                msg = this instanceof DB2CallableStatement ? "DB2CallableStatement closed in finalizer: \"" + this.sql + "\"" : (this instanceof DB2PreparedStatement ? "DB2PreparedStatement closed in finalizer: \"" + this.sql + "\"" : "DB2Statement closed in finalizer, last SQL: \"" + this.sql + "\"");
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, msg);
                }
                DriverManager.println(msg);
                this.close();
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        boolean bl2;
        block18: {
            block16: {
                boolean bl3;
                block17: {
                    block14: {
                        boolean bl4;
                        block15: {
                            block12: {
                                boolean bl5;
                                block13: {
                                    block10: {
                                        boolean bl6;
                                        block11: {
                                            try {
                                                if (DB2Trace.TraceOn) {
                                                    DB2Trace.methodEntry(this, "getMoreResults()");
                                                }
                                                if (!this.prefetchedMoreResults) break block10;
                                                this.prefetchedMoreResults = false;
                                                bl6 = this.moreResults;
                                                Object var5_3 = null;
                                                if (!DB2Trace.TraceOn) break block11;
                                            }
                                            catch (Throwable throwable) {
                                                block19: {
                                                    Object var5_8 = null;
                                                    if (!DB2Trace.TraceOn) break block19;
                                                    DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                                                }
                                                throw throwable;
                                            }
                                            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                                        }
                                        return bl6;
                                    }
                                    if (this.connection.closed) {
                                        this.sqlExcptGen.throwConnectionClosedError();
                                    }
                                    if (this.closed) {
                                        this.sqlExcptGen.throwClosedError();
                                    }
                                    if (this.moreResults) break block12;
                                    bl5 = false;
                                    Object var5_4 = null;
                                    if (!DB2Trace.TraceOn) break block13;
                                    DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                                }
                                return bl5;
                            }
                            this.rowCount = 0;
                            this.returnCode = 0;
                            this.returnCode = (short)this.SQLMoreResults(this.statementHandle, this.connection.connectionHandle);
                            if (this.returnCode != 100) break block14;
                            this.moreResults = false;
                            bl4 = false;
                            Object var5_5 = null;
                            if (!DB2Trace.TraceOn) break block15;
                            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                        }
                        return bl4;
                    }
                    if (this.returnCode != 0) {
                        this.sqlExcptGen.check_return_code(this, this.returnCode);
                    }
                    if (this.returnCode != 0 && this.returnCode != 1) break block16;
                    bl3 = this.moreResults = true;
                    Object var5_6 = null;
                    if (!DB2Trace.TraceOn) break block17;
                    DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
                }
                return bl3;
            }
            bl2 = this.moreResults = false;
            Object var5_7 = null;
            if (!DB2Trace.TraceOn) break block18;
            DB2Trace.methodExit((Object)this, "getMoreResults()", String.valueOf(this.moreResults));
        }
        return bl2;
    }

    protected int getColCount() throws SQLException {
        this.returnCode = 0;
        this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
        if (this.returnCode != 0) {
            this.sqlExcptGen.check_return_code(this, this.returnCode);
        }
        return this.colCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet() throws SQLException {
        this.returnCode = 0;
        try {
            DB2ResultSet dB2ResultSet;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSet()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.prefetchedMoreResults) {
                ResultSet resultSet = null;
                return resultSet;
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            boolean rsTypeDowngraded = false;
            if (this.rsTypeAllocated != 1003) {
                for (SQLWarning w2 = this.getWarnings(); w2 != null; w2 = w2.getNextWarning()) {
                    if (!w2.getSQLState().equalsIgnoreCase("01S02")) continue;
                    this.rsType = 1003;
                    rsTypeDowngraded = true;
                    if (this.resultSet == null || this.resultSet instanceof DB2ScrollableResultSet) {
                        // empty if block
                    }
                    this.resultSet = null;
                }
                if (this.resultSet != null && !rsTypeDowngraded && !(this.resultSet instanceof DB2ScrollableResultSet)) {
                    this.resultSet = null;
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "rsTypeAllocated,rsType,rsTypeDowngraded", this.rsTypeAllocated + "," + this.rsType + "," + rsTypeDowngraded);
                }
            }
            if (this.moreResults && this.rsType != 1003 && 0 == this.rowCount) {
                this.rowCount = this.SQLGetRowCount(this.statementHandle);
                if (this.returnCode != 0) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
            }
            if (this.resultSet == null) {
                this.resultSet = this.rsType != 1003 ? (DB2Trace.TraceOn ? new DB2ScrollableResultSetTrace(this, 0, this.rowCount) : new DB2ScrollableResultSet(this, 0, this.rowCount)) : (DB2Trace.TraceOn ? new DB2ResultSetTrace(this, 0) : new DB2ResultSet(this, 0));
            } else if (this.rsType != 1003) {
                this.resultSet.reset(this.resultSet.numCols, this.rowCount);
            } else if (!(this instanceof DB2PreparedStatement) || 24 != ((DB2PreparedStatement)this).statementType) {
                this.resultSet.reset(this.resultSet.numCols);
            } else {
                this.resultSet.setClosed(false);
                this.resultSet.currentRowId = 0;
            }
            if (this.resultSet.numCols <= 0 || !this.moreResults) {
                dB2ResultSet = null;
                return dB2ResultSet;
            }
            dB2ResultSet = this.resultSet;
            return dB2ResultSet;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getResultSet()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        int n2;
        block13: {
            int retVal;
            block11: {
                int n3;
                block12: {
                    retVal = 0;
                    this.returnCode = 0;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "getUpdateCount()");
                            DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
                        }
                        if (this.connection.closed) {
                            this.sqlExcptGen.throwConnectionClosedError();
                        }
                        if (this.closed) {
                            this.sqlExcptGen.throwClosedError();
                        }
                        if (this.moreResults) {
                            this.colCount = (short)this.SQLGetColumnCount(this.statementHandle);
                            if (this.returnCode != 0) {
                                this.sqlExcptGen.check_return_code(this, this.returnCode);
                                this.returnCode = 0;
                            }
                            if (DB2Trace.TraceOn) {
                                DB2Trace.data(10, "colCount", this.colCount);
                            }
                        }
                        if (this.colCount <= 0 && this.moreResults) break block11;
                        n3 = retVal = -1;
                        Object var4_4 = null;
                        if (!DB2Trace.TraceOn) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var4_6 = null;
                            if (!DB2Trace.TraceOn) break block14;
                            DB2Trace.data(10, "rowCount", this.rowCount);
                            DB2Trace.methodExit((Object)this, "getUpdateCount()", retVal);
                        }
                        throw throwable;
                    }
                    DB2Trace.data(10, "rowCount", this.rowCount);
                    DB2Trace.methodExit((Object)this, "getUpdateCount()", retVal);
                }
                return n3;
            }
            if (0 == this.rowCount) {
                this.rowCount = this.SQLGetRowCount(this.statementHandle);
            }
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            retVal = this.rowCount < 0 ? 0 : this.rowCount;
            n2 = retVal;
            Object var4_5 = null;
            if (!DB2Trace.TraceOn) break block13;
            DB2Trace.data(10, "rowCount", this.rowCount);
            DB2Trace.methodExit((Object)this, "getUpdateCount()", retVal);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCursorName(String name) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setCursorName( " + name + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                rc2 = this.SQLSetCursorName(name, this.statementHandle, this.connection.connectionHandle);
            }
            if (rc2 != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            Object var6_5 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "SQLSetCursorName - rc ", rc2);
            DB2Trace.methodExit(this, "setCursorName()");
            throw throwable;
        }
        DB2Trace.data(10, "SQLSetCursorName - rc ", rc2);
        DB2Trace.methodExit(this, "setCursorName()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxFieldSize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxFieldSize()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.maxFieldSize;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getMaxFieldSize()", this.maxFieldSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaxFieldSize(int max) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxFieldSize( " + max + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (max < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((rc2 = this.SQLMaxFieldSize(max, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            this.maxFieldSize = max;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "SQLMaxFieldSize- rc ", rc2);
            DB2Trace.data(10, "maxFieldSize ", this.maxFieldSize);
            DB2Trace.methodExit(this, "setMaxFieldSize()");
            throw throwable;
        }
        DB2Trace.data(10, "SQLMaxFieldSize- rc ", rc2);
        DB2Trace.data(10, "maxFieldSize ", this.maxFieldSize);
        DB2Trace.methodExit(this, "setMaxFieldSize()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRows() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getMaxRows()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.maxRows;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getMaxRows()", this.maxRows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaxRows(int max) throws SQLException {
        try {
            int rc2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setMaxRows( " + max + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (max < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((rc2 = this.SQLMaxRows(max, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            this.maxRows = max;
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "maxRows ", this.maxRows);
            DB2Trace.methodExit(this, "setMaxRows()");
            throw throwable;
        }
        DB2Trace.data(10, "maxRows ", this.maxRows);
        DB2Trace.methodExit(this, "setMaxRows()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEscapeProcessing(boolean enable) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setEscapeProcessing( " + enable + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if ((rc2 = this.SQLScan(enable, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "SQLScan- rc ", rc2);
            DB2Trace.methodExit(this, "setEscapeProcessing()");
            throw throwable;
        }
        DB2Trace.data(10, "SQLScan- rc ", rc2);
        DB2Trace.methodExit(this, "setEscapeProcessing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryTimeout() throws SQLException {
        int seconds = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getQueryTimeOut()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.returnCode = 0;
            seconds = this.SQLGetQueryTimeout(this.statementHandle);
            if (this.returnCode != 0) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            int n2 = seconds;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getQueryTimeOut()", seconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setQueryTimeout(int seconds) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setQueryTimeOut( " + seconds + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (seconds < 0) {
                this.sqlExcptGen.throwOutOfRangeError();
            }
            if ((rc2 = this.SQLSetQueryTimeout(seconds, this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            Object var4_3 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, " SQLSetQueryTimeout- rc ", rc2);
            DB2Trace.methodExit(this, "setQueryTimeOut()");
            throw throwable;
        }
        DB2Trace.data(10, " SQLSetQueryTimeout- rc ", rc2);
        DB2Trace.methodExit(this, "setQueryTimeOut()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancel() throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "cancel()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.statementHandle != 0 && (rc2 = this.SQLCancel(this.statementHandle)) != 0) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "SQLCancel- rc ", rc2);
            DB2Trace.methodExit(this, "cancel()");
            throw throwable;
        }
        DB2Trace.data(10, "SQLCancel- rc ", rc2);
        DB2Trace.methodExit(this, "cancel()");
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWarning(SQLWarning warning) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addWarning()");
            }
            if (this.warnings == null) {
                this.warnings = warning;
            } else {
                SQLWarning current = this.warnings;
                while (current.getNextWarning() != null) {
                    current = current.getNextWarning();
                }
                current.setNextWarning(warning);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "addWarning()");
            }
        }
    }

    protected int getStatementHandle() throws SQLException {
        return this.statementHandle;
    }

    protected String getTraceHandle() {
        int cHandle = this.statementHandle >> 16;
        int sHandle = this.statementHandle & 0xFFFF;
        String sh2 = cHandle + ":" + sHandle;
        return sh2;
    }

    protected native int SQLExecBatch(String var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchDirection(int direction) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchDirection( " + direction + " )");
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchDirection(this.rsType, direction);
            this.fetchDirection = direction;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "fetchDirection ", this.fetchDirection);
            DB2Trace.methodExit(this, "setFetchDirection()");
            throw throwable;
        }
        DB2Trace.data(10, "fetchDirection ", this.fetchDirection);
        DB2Trace.methodExit(this, "setFetchDirection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchDirection()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.fetchDirection;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getFetchDirection()", this.fetchDirection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFetchSize(int rows) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setFetchSize( " + rows + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.checkFetchSize(this.maxRows, rows);
            this.fetchSize = rows;
            Object var3_2 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "fetchSize ", this.fetchSize);
            DB2Trace.methodExit(this, "setFetchSize()");
            throw throwable;
        }
        DB2Trace.data(10, "fetchSize ", this.fetchSize);
        DB2Trace.methodExit(this, "setFetchSize()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getFetchSize()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.fetchSize;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getFetchSize()", this.fetchSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetConcurrency() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetConcurrency()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.rsConcur;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getResultSetConcurrency()", this.rsConcur);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResultSetType() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getResultSetType()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            int n2 = this.rsType;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getResultSetType()", this.rsType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String sql) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "addBatch( " + sql + " )");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchQuery = 0 == this.batchSize ? sql : this.batchQuery + ";" + sql;
            ++this.batchSize;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "addBatch()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "clearBatch()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            this.batchSize = 0;
            this.batchQuery = null;
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(10, "batchSize ", this.batchSize);
            DB2Trace.methodExit(this, "clearBatch()");
            throw throwable;
        }
        DB2Trace.data(10, "batchSize ", this.batchSize);
        DB2Trace.methodExit(this, "clearBatch()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "executeBatch()");
                DB2Trace.data(10, "Statement Handle", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (this.resultSet != null) {
                this.resultSet.realClose();
            }
            if (0 == this.batchSize) {
                int[] nArray = new int[]{};
                return nArray;
            }
            this.batchReturn = null;
            this.batchUpdateException = null;
            int rc2 = this.SQLExecBatch(this.batchQuery, this.batchSize, this.statementHandle, this.connection.connectionHandle);
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "SQLExecBatch - return code", rc2);
            }
            if (0 != rc2 && 1 != rc2) {
                this.sqlExcptGen.check_batch_return_code(this, rc2);
            }
            this.clearBatch();
            if (this.batchUpdateException != null) {
                BatchUpdateException e2 = this.batchUpdateException;
                this.batchUpdateException = null;
                throw e2;
            }
            int[] nArray = this.batchReturn;
            return nArray;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "executeBatch()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkResultSetType(int rst, int rsc) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkResultSetType( " + rst + ", " + rsc + " )");
            }
            if (1008 == rsc) {
                this.connection.addWarning(new SQLWarning("ResultSet.CONCUR_UPDATABLE not supported. ResultSet concurrency set to READ_ONLY.", "00000", -99999));
                this.rsConcur = 1007;
            } else if (1007 != rsc) {
                this.sqlExcptGen.throwUnknownResultSetType(rsc);
            }
            if (1005 == rst) {
                this.connection.addWarning(new SQLWarning("ResultSet.TYPE_SCROLL_SENSITIVE not supported. ResultSet type downgraded.", "00000", -99999));
                this.rsType = 1004;
            } else if (1003 != rst && 1004 != rst) {
                this.sqlExcptGen.throwUnknownResultSetType(rst);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "checkResultSetType()");
            }
        }
    }

    protected int[] getBatchReturn() {
        return this.batchReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFetchDirection(int rsType, int direction) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkFetchDirection( " + rsType + ", " + direction + " )");
            }
            if (direction != 1000 && direction != 1001 && direction != 1002) {
                this.sqlExcptGen.throwFetchDirectionError();
            }
            if (1003 == rsType && direction == 1001) {
                this.sqlExcptGen.throwFetchDirectionError();
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "checkFetchDirection()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFetchSize(int maxRows, int rows) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkFetchSize( " + maxRows + ", " + rows + " )");
            }
            if (maxRows != 0 && rows > maxRows || rows < 0) {
                this.sqlExcptGen.throwFetchSizeError();
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "checkFetchSize()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newBatchUpdateException(String errorMessage, String SQLState, int SQLCode, int[] updateCounts) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "newBatchUpdateException()");
            }
            if (null == this.batchUpdateException) {
                this.batchUpdateException = new BatchUpdateException(errorMessage, SQLState, SQLCode, updateCounts);
            } else {
                SQLException e2 = new SQLException(errorMessage, SQLState, SQLCode);
                this.batchUpdateException.setNextException(e2);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "newBatchUpdateException()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectInBatchUpdateException(int[] updateCounts) {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "selectInBatchUpdateException()");
            }
            this.newBatchUpdateException(this.sqlExcptGen.errMsgClass.getString("0641"), "HY0000", -99999, updateCounts);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "selectInBatchUpdateException()");
            }
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getMoreResults with multiple open ResultSets");
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getGeneratedKeys");
        return null;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("executeUpdate with auto-generated keys");
        return 0;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("executeUpdate with auto-generated keys");
        return 0;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("executeUpdate with auto-generated keys");
        return 0;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("execute with auto-generated keys");
        return false;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("execute with auto-generated keys");
        return false;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("execute with auto-generated keys");
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getResultSetHoldability");
        return 0;
    }
}

