/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2ResultSet;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DB2ResultSetMetaData
implements ResultSetMetaData {
    protected DB2Statement statement;
    protected DB2Connection connection;
    protected DB2ResultSet resultset;
    protected int numberOfColumns;
    protected boolean mappedRS;
    protected int[] colBaseTypesNotAdjusted = null;

    protected native String SQLColAttributes(int var1, int var2, Integer var3, Integer var4, int var5, int var6);

    public DB2ResultSetMetaData(DB2Statement stmt, DB2ResultSet rs, int numCols, boolean mapped) {
        this.statement = stmt;
        this.connection = stmt.getDB2Connection();
        this.resultset = rs;
        this.numberOfColumns = numCols;
        this.mappedRS = mapped;
    }

    public DB2ResultSetMetaData(DB2PreparedStatement pstmt) {
        this.statement = pstmt;
        this.connection = pstmt.getDB2Connection();
        this.resultset = null;
        this.numberOfColumns = 0;
        this.mappedRS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnCount() throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null == this.resultset || this.resultset.numCols <= 0) {
            Integer count = new Integer(0);
            Integer rc2 = new Integer(0);
            DB2Connection dB2Connection = this.connection;
            synchronized (dB2Connection) {
                String str = this.SQLColAttributes(1, 0, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
            }
            int rcValue = rc2;
            if (rcValue != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
            }
            this.numberOfColumns = count;
            if (this.resultset != null) {
                this.resultset.numCols = this.numberOfColumns;
            }
        } else {
            this.numberOfColumns = this.resultset.numCols;
        }
        return this.numberOfColumns;
    }

    protected int getMappedColumn(int column) throws SQLException {
        if (this.mappedRS) {
            int mCol = this.resultset.getMappedColumn(column);
            return mCol;
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoIncrement(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 11, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 1 == count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCaseSensitive(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 12, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 1 == count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearchable(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 13, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 0 != count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrency(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 9, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 1 == count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isNullable(int column) throws SQLException {
        int c2;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 7, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if (1 == (c2 = count.intValue())) {
            return 1;
        }
        if (0 == c2) {
            return 0;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSigned(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 8, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 1 != count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnDisplaySize(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        String colType = this.getColumnTypeName(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 6, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if (colType.equals("GRAPHIC") || colType.equals("VARGRAPHIC") || colType.equals("DBCLOB")) {
            return count / 2;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnLabel(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 18, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        if (null != this.resultset && null != this.resultset.mappedColumnNames && this.resultset.mappedColumnNames.length >= column && null != this.resultset.mappedColumnNames[column - 1]) {
            return this.resultset.mappedColumnNames[column - 1];
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 1, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 16, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if (null == str) {
            return new String("");
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrecision(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 4, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScale(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 5, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableName(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 15, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if (null == str) {
            return new String("");
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCatalogName(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 17, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if (null == str) {
            return new String("");
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnType(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer columnType = new Integer(0);
        Integer UDTType = new Integer(0);
        Integer UDTBaseType = new Integer(0);
        Integer rc2 = new Integer(0);
        int DB2ColType = 0;
        int DB2ColBaseTypeNotAdjusted = 0;
        int mappedColumn = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(mappedColumn, 2, rc2, columnType, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        if ((DB2ColBaseTypeNotAdjusted = columnType.intValue()) == -450) {
            DB2Connection dB2Connection2 = this.connection;
            synchronized (dB2Connection2) {
                str = this.SQLColAttributes(mappedColumn, 1098, rc2, UDTType, this.statement.statementHandle, this.connection.connectionHandle);
            }
            rcValue = rc2;
            if (rcValue != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
            }
            if ((DB2ColType = UDTType.intValue()) == 1) {
                DB2ColType = 2001;
            } else if (DB2ColType == 2) {
                DB2ColType = 2002;
            } else if (DB2ColType == 3) {
                DB2ColType = 2006;
            }
            dB2Connection2 = this.connection;
            synchronized (dB2Connection2) {
                str = this.SQLColAttributes(mappedColumn, 1254, rc2, UDTBaseType, this.statement.statementHandle, this.connection.connectionHandle);
            }
            rcValue = rc2;
            if (rcValue != 0) {
                this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
            }
            DB2ColBaseTypeNotAdjusted = UDTBaseType;
        } else {
            DB2ColType = this.connection.adjust(DB2ColBaseTypeNotAdjusted);
        }
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted.length < column) {
            int numColumns = this.getColumnCount();
            this.colBaseTypesNotAdjusted = new int[numColumns];
            for (int i2 = 0; i2 < numColumns; ++i2) {
                this.colBaseTypesNotAdjusted[i2] = -99999;
            }
        }
        this.colBaseTypesNotAdjusted[column - 1] = DB2ColBaseTypeNotAdjusted;
        if (DB2Trace.TraceOn) {
            DB2Trace.data(30, "DB2ColType", DB2ColType);
            DB2Trace.data(30, "DB2ColBaseTypeNotAdjusted", DB2ColBaseTypeNotAdjusted);
        }
        return DB2ColType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnTypeName(int column) throws SQLException {
        String str;
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            str = this.SQLColAttributes(column, 14, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        Integer count = new Integer(0);
        Integer rc2 = new Integer(0);
        column = this.getMappedColumn(column);
        DB2Connection dB2Connection = this.connection;
        synchronized (dB2Connection) {
            String str = this.SQLColAttributes(column, 10, rc2, count, this.statement.statementHandle, this.connection.connectionHandle);
        }
        int rcValue = rc2;
        if (rcValue != 0) {
            this.connection.sqlExcptGen.check_return_code(this.statement, rcValue);
        }
        return 0 == count;
    }

    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getColumnClassName( " + column + " )");
        }
        if (this.connection.closed) {
            this.connection.sqlExcptGen.throwConnectionClosedError();
        }
        if (this.statement.closed) {
            this.connection.sqlExcptGen.throwClosedError();
        }
        String retStr = null;
        if (this.colBaseTypesNotAdjusted == null || this.colBaseTypesNotAdjusted[column - 1] == -99999) {
            this.getColumnType(column);
        }
        int colBaseType = this.connection.adjust(this.colBaseTypesNotAdjusted[column - 1]);
        switch (colBaseType) {
            case -1: 
            case 1: 
            case 12: {
                retStr = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                retStr = "java.math.BigDecimal";
                break;
            }
            case -7: {
                retStr = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                retStr = "java.lang.Integer";
                break;
            }
            case -5: {
                retStr = "java.lang.Long";
                break;
            }
            case 7: {
                retStr = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                retStr = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                retStr = "[B";
                break;
            }
            case 91: {
                retStr = "java.sql.Date";
                break;
            }
            case 92: {
                retStr = "java.sql.Time";
                break;
            }
            case 93: {
                retStr = "java.sql.Timestamp";
                break;
            }
            case 70: {
                retStr = "java.net.URL";
                break;
            }
            case 2004: {
                retStr = "java.sql.Blob";
                break;
            }
            case 2005: {
                retStr = "java.sql.Clob";
                break;
            }
            case 2001: {
                retStr = "java.sql.Distinct";
                break;
            }
            case 2006: {
                retStr = "java.sql.Ref";
                break;
            }
            case 2002: {
                retStr = "java.sql.Struct";
                break;
            }
            default: {
                this.connection.sqlExcptGen.rsException("S1004");
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "getColumnClassName()", retStr);
        }
        return retStr;
    }
}

