/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.mri.DB2Messages;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class DB2Driver
implements Driver {
    private static DB2Driver ourDriver = null;
    public static final int MajorVersion = 9;
    public static final int MinorVersion = 5;
    private static final String libraryName = "libdb2jdbc.so";
    private static final String HPlibraryName = "libdb2jdbc.sl";
    private static final String libpath32_unix = "lib32";
    private static final String libpath64_unix = "lib64";
    private static final String libpath_nt = "bin";
    private static final String DLLName = "db2jdbc";
    private static final String DLLName64 = "db2jdbc64";
    private static String language = "C";
    public static boolean loaded = false;
    protected int traceOn = 0;
    protected static int jvmHenv = 0;
    public static final String buildLevel = "n110722";

    protected native int SQLAllocEnv(int[] var1);

    protected native String SQLGetTracePath(Integer var1, Integer var2, Integer var3, int var4);

    protected native int SQLFreeEnv(int var1);

    public native String getDLLVersion();

    protected native int currentSPNestLevel();

    public String toString() {
        return "DB2Driver: JDBC 2.0 n110722";
    }

    public DB2Driver() throws SQLException {
        if (!loaded) {
            this.traceOn = 0;
            String library = null;
            String instpath = null;
            boolean useLoadLibrary = false;
            try {
                String libToLoad;
                final String[] sysProps = new String[5];
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        sysProps[0] = System.getProperty("ibm.db2.instance.path");
                        sysProps[1] = System.getProperty("file.separator");
                        sysProps[2] = System.getProperty("os.arch");
                        sysProps[3] = System.getProperty("os.name");
                        sysProps[4] = System.getProperty("path.separator");
                        return null;
                    }
                });
                instpath = sysProps[0];
                String SLASH = sysProps[1];
                String arch = sysProps[2];
                String osName = sysProps[3];
                String pathSeparator = sysProps[4];
                if (instpath != null) {
                    if (SLASH != null && SLASH.equals("/")) {
                        library = arch != null && (arch.indexOf("64") != -1 || arch.indexOf("s390x") != -1 || arch.indexOf("sparcv") != -1 || arch.indexOf("PA_RISC2.0W") != -1) ? instpath + SLASH + libpath64_unix + SLASH : instpath + SLASH + libpath32_unix + SLASH;
                        library = arch != null && arch.indexOf("PA_RISC") != -1 ? library + HPlibraryName : library + libraryName;
                    } else {
                        library = instpath + SLASH + libpath_nt + SLASH;
                        library = arch != null && arch.indexOf("64") != -1 ? library + DLLName64 : library + DLLName;
                        library = library + ".dll";
                    }
                    libToLoad = library;
                } else if (SLASH != null && SLASH.equals("\\")) {
                    int curIndex = -1;
                    StringBuffer loadLocation = new StringBuffer("");
                    try {
                        loadLocation.append(URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
                        curIndex = loadLocation.indexOf("java/db2java.zip");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    if (curIndex == -1) {
                        library = arch != null && arch.indexOf("64") != -1 ? DLLName64 : DLLName;
                        useLoadLibrary = true;
                        libToLoad = library;
                    } else {
                        loadLocation.delete(curIndex, loadLocation.length());
                        loadLocation.deleteCharAt(0);
                        curIndex = loadLocation.indexOf("/");
                        while (curIndex != -1) {
                            loadLocation.replace(curIndex, curIndex + 1, SLASH);
                            curIndex = loadLocation.indexOf("/");
                        }
                        if (arch != null && arch.indexOf("64") != -1) {
                            loadLocation.append(libpath_nt + SLASH + DLLName64 + ".dll");
                        } else {
                            loadLocation.append(libpath_nt + SLASH + DLLName + ".dll");
                        }
                        library = loadLocation.toString();
                        libToLoad = loadLocation.toString();
                    }
                } else {
                    useLoadLibrary = true;
                    libToLoad = DLLName;
                }
                if (useLoadLibrary) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(libToLoad);
                            return null;
                        }
                    });
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.load(libToLoad);
                            return null;
                        }
                    });
                }
            }
            catch (UnsatisfiedLinkError e3) {
                String[] tokens = new String[]{library};
                String msg = new DB2Messages().getString("0646", tokens);
                DriverManager.println(msg);
                DriverManager.println(e3.toString());
                throw new SQLException(e3.toString());
            }
            int[] henv = new int[1];
            int rc2 = this.SQLAllocEnv(henv);
            jvmHenv = henv[0];
            if (rc2 != 0) {
                String[] tokens = new String[]{String.valueOf(rc2)};
                String msg = new DB2Messages().getString("0647", tokens);
                DriverManager.println(msg);
                throw new SQLException(msg);
            }
            if (this.traceOn == 1) {
                Integer rc22 = new Integer(0);
                Integer myPID = new Integer(0);
                Integer flushOn = new Integer(0);
                String tracePathName = this.SQLGetTracePath(rc22, myPID, flushOn, jvmHenv);
                if (flushOn != 0) {
                    DB2Trace.setTraceFlush(true);
                }
                if (rc22 == 0 && tracePathName != null) {
                    DB2Trace.setTracePath(tracePathName);
                }
                if (!DB2Trace.isInitialized()) {
                    DB2Trace t2 = new DB2Trace(myPID);
                    DB2Trace.methodEntry(this, "DB2Driver()");
                    t2.println("Loaded " + library);
                    t2.println("DB2Driver: JDBC 2.0,  BuildLevel: n110722");
                    DB2Trace.methodExit(this, "DB2Driver()");
                }
            }
            loaded = true;
        }
    }

    public static void setLanguage(String lang) {
        language = lang;
    }

    public synchronized Connection connect(String url, Properties info) throws SQLException {
        String protocol = new String();
        String subprotocol = new String();
        String source = new String();
        int iprotocol = url.indexOf(58);
        if (-1 == iprotocol) {
            return null;
        }
        protocol = url.substring(0, iprotocol);
        int isubprotocol = url.indexOf(58, iprotocol + 1);
        if (-1 == isubprotocol) {
            return null;
        }
        subprotocol = url.substring(iprotocol + 1, isubprotocol);
        source = url.substring(isubprotocol + 1);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect(" + url + ")\n");
        }
        if (protocol.equalsIgnoreCase("JDBC") && subprotocol.equalsIgnoreCase("DEPRECATED-DB2") && !source.startsWith("//")) {
            info.put("language", language);
            return new DB2Connection(source, info, this);
        }
        return null;
    }

    public Connection connect() throws SQLException {
        Properties p2 = new Properties();
        p2.put("language", language);
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().println("DB2Driver - connect()\n");
        }
        return new DB2Connection(p2, this);
    }

    public int getMajorVersion() {
        return 9;
    }

    public int getMinorVersion() {
        return 5;
    }

    public int getRelease() {
        return 0;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceEntry(this.getClass().getName(), "DB2Connection(" + url + ")");
        }
        String protocol = new String();
        String subprotocol = new String();
        String source = new String();
        int iprotocol = url.indexOf(58);
        protocol = url.substring(0, iprotocol);
        int isubprotocol = url.indexOf(58, iprotocol + 1);
        subprotocol = url.substring(iprotocol + 1, isubprotocol);
        source = url.substring(isubprotocol + 1);
        boolean rc2 = protocol.equalsIgnoreCase("JDBC") && subprotocol.equalsIgnoreCase("DEPRECATED-DB2") && !source.startsWith("//");
        if (DB2Trace.TraceOn) {
            DB2Trace.getTraceObj().traceExit(this.getClass().getName(), "DB2Connection - Return value = " + rc2);
        }
        return rc2;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        DriverPropertyInfo[] result = new DriverPropertyInfo[]{new DriverPropertyInfo("user", null), new DriverPropertyInfo("password", null)};
        Enumeration<?> e2 = info.propertyNames();
        while (e2.hasMoreElements()) {
            String next = (String)e2.nextElement();
            if (next.equals("user")) {
                result[0].value = info.getProperty("user");
                continue;
            }
            if (!next.equals("password")) continue;
            result[1].value = info.getProperty("password");
        }
        return result;
    }

    public static int getJVMHenv() throws SQLException {
        return jvmHenv;
    }

    public void finalize() throws SQLException {
        if (this == ourDriver) {
            this.SQLFreeEnv(jvmHenv);
            ourDriver = null;
            loaded = false;
            language = "C";
            jvmHenv = 0;
        }
    }

    static {
        try {
            if (ourDriver == null) {
                ourDriver = new DB2Driver();
                DriverManager.registerDriver(ourDriver);
            }
        }
        catch (SQLException e2) {
            String[] tokens = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", e2.getMessage(), e2.getSQLState(), String.valueOf(e2.getErrorCode())};
            String msg = new DB2Messages().getString("0645", tokens);
            DriverManager.println(msg);
        }
    }
}

