/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2CallableStatement;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaData;
import COM.ibm.db2.jdbc.app.DB2DatabaseMetaDataTrace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import COM.ibm.db2.jdbc.app.DB2Statement;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJConnection;
import com.ibm.db2.jcc.SQLJLogWriter;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJSection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class DB2Connection
implements Connection,
SQLJConnection {
    protected int connectionHandle = 0;
    protected boolean SPConnected;
    protected String source;
    protected String user = "";
    protected String password = "";
    protected String conArgs = "";
    protected boolean materializeLobData = false;
    protected boolean closed = true;
    protected boolean describeCached = false;
    protected boolean describeParam = true;
    protected int realSqlType = -1;
    protected int blobSqlType = 0;
    protected int returnCode = 0;
    protected int hostType = 0;
    protected DB2Statement inputStreamStmt = null;
    private int typeMaxChar = -1;
    private int typeMaxVarChar = -1;
    private int typeMaxLongVarChar = -1;
    private int typeMaxDecimal = -1;
    private Boolean supportsLOB = null;
    private Boolean supportsBigInt = null;
    int JDBCLevel = 200;
    protected ResourceBundle errMsgClass = null;
    protected SQLExceptionGenerator sqlExcptGen;
    private int sqlSuccess = 0;
    private boolean isLDCompat = false;
    protected boolean isReadOnly = false;
    protected int transactionIsolationLevel = 2;
    protected boolean autoClose = false;
    protected boolean defaultIsReadOnly = false;
    protected int defaultTransactionIsolationLevel = 2;
    protected boolean defaultAutoCommit = true;
    private boolean disconnected = true;
    SQLWarning warnings = null;
    private int[] timeZoneOffset = new int[]{100, 0, 0};

    protected native int SQLConnect(String var1, int var2, int var3);

    protected native int SPConnect(int var1, int var2);

    protected native int SQLDisconnect(int var1);

    protected native int SQLFreeConnect(int var1);

    protected native int SQLSetConnectOptionInt(int var1, int var2, int var3);

    protected native int SQLSetConnectOptionString(int var1, String var2, int var3);

    protected native int SQLGetConnectOption(int var1, int var2);

    protected native int SQLGetDescribeParamSupported(int var1);

    protected native int SQLCommit(int var1, int var2);

    protected native int SQLRollback(int var1, int var2);

    protected native int SQLHasType(int var1, int var2);

    protected native String SQLNativeSQL(String var1, int var2);

    protected native boolean isConnectionAlive(int var1);

    protected native int SQLSetCodePage(int var1);

    protected native int SQLGetTypeMaxLen(int var1, int var2);

    protected native int SQLGetHostType(int var1);

    public String toString() {
        return this.toString("");
    }

    protected String toString(String ident) {
        StringBuffer sb2 = new StringBuffer("\n" + ident + "DB2Connection\n" + ident + "{\n");
        sb2.append(ident + "    connectionHandle = " + this.connectionHandle + "\n");
        sb2.append(ident + "    SPConnected = " + this.SPConnected + "\n");
        sb2.append(ident + "    source = " + this.source + "\n");
        sb2.append(ident + "    user = " + this.user + "\n");
        sb2.append(ident + "    conArgs = " + this.conArgs + "\n");
        sb2.append(ident + "    closed = " + this.closed + "\n");
        sb2.append(ident + "    describeCached = " + this.describeCached + "\n");
        sb2.append(ident + "    describeParam = " + this.describeParam + "\n");
        sb2.append(ident + "    isReadOnly = " + this.isReadOnly + "\n");
        sb2.append(ident + "    autoClose = " + this.autoClose + "\n");
        sb2.append(ident + "    LONGDATA compat = " + this.isLDCompat + "\n");
        sb2.append(ident + "}\n");
        return sb2.toString();
    }

    protected void loadDefaultMessage() {
        this.errMsgClass = ResourceBundle.getBundle("COM.ibm.db2.mri.DB2ErrorMessages");
    }

    public String getSource() {
        return this.source;
    }

    public DB2Connection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2Connection(Properties info, DB2Driver db2driver) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Connection( info, " + db2driver + " )");
            }
            this.loadDefaultMessage();
            this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
            this.warnings = null;
            this.returnCode = this.sqlSuccess;
            this.connectionHandle = this.SPConnect(this.connectionHandle, DB2Driver.getJVMHenv());
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                catch (SQLException e2) {
                    if (this.connectionHandle > 0) {
                        this.SQLFreeConnect(this.connectionHandle);
                    }
                    throw e2;
                }
            }
            this.realSqlType = -1;
            this.closed = false;
            this.autoClose = false;
            this.SPConnected = true;
            this.disconnected = false;
            this.defaultAutoCommit = this.getAutoCommit();
            this.defaultTransactionIsolationLevel = this.getTransactionIsolation2();
            this.defaultIsReadOnly = this.isReadOnly2();
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2Connection()");
            }
        }
    }

    public DB2Connection(String source, Properties info, DB2Driver db2driver) throws SQLException {
        this.connect(source, info, db2driver, 0, false);
    }

    public DB2Connection(String source, Properties info, DB2Driver db2driver, int hdbc) throws SQLException {
        this.connect(source, info, db2driver, hdbc, false);
    }

    public DB2Connection(String source, Properties info, int hdbc, boolean fConnected) throws SQLException {
        this.connect(source, info, null, hdbc, fConnected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String source, Properties info, DB2Driver db2driver, int hdbc, boolean fConnected) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "connect( " + source + ", info, " + db2driver + ", " + hdbc + ", " + fConnected + " )");
            }
            this.loadDefaultMessage();
            this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
            this.warnings = null;
            this.source = source;
            Object e2 = info.propertyNames();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (key.equals("user")) {
                    this.user = info.getProperty("user", "");
                    continue;
                }
                if (key.equals("password")) {
                    this.password = info.getProperty("password", "");
                    continue;
                }
                if (key.equalsIgnoreCase("JDBCVERSION")) {
                    String value = (String)info.get(key);
                    if (value == null) continue;
                    this.JDBCLevel = new Integer(value);
                    if (!DB2Trace.TraceOn) continue;
                    DB2Trace.data(20, "JDBCLevel key", this.JDBCLevel);
                    continue;
                }
                if (key.equals("connectionAttribute")) {
                    this.conArgs = this.conArgs + ";" + info.getProperty(key, "");
                    continue;
                }
                if (key.equals("fullyMaterializeLobData")) {
                    this.materializeLobData = new Boolean(info.getProperty("fullyMaterializeLobData", ""));
                    continue;
                }
                if (key.equals("language")) continue;
                this.conArgs = this.conArgs + ";" + key + "=" + info.getProperty(key, "");
            }
            this.connectionHandle = hdbc;
            this.returnCode = this.sqlSuccess;
            if (!fConnected) {
                e2 = this;
                synchronized (e2) {
                    this.connectionHandle = this.SQLConnect("DSN=" + source + ";UID=" + this.user + ";PWD=" + this.password + this.conArgs, this.connectionHandle, DB2Driver.getJVMHenv());
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "conArg", this.conArgs);
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (this.returnCode != this.sqlSuccess) {
                try {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                catch (SQLException e3) {
                    if (this.connectionHandle > 0) {
                        this.SQLFreeConnect(this.connectionHandle);
                    }
                    throw e3;
                }
            }
            this.closed = false;
            this.autoClose = false;
            this.SPConnected = false;
            this.disconnected = false;
            this.defaultAutoCommit = this.getAutoCommit();
            this.defaultTransactionIsolationLevel = this.getTransactionIsolation2();
            this.defaultIsReadOnly = this.isReadOnly2();
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "connect()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Statement createStatement() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement()");
            }
            DB2Statement dB2Statement = new DB2Statement(this);
            return dB2Statement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "createStatement()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement createStatement(boolean internal) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "createStatement( " + internal + " )");
            }
            DB2Statement dB2Statement = new DB2Statement(this, internal);
            return dB2Statement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "createStatement()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareStatement( " + sql + " )");
            }
            DB2PreparedStatement dB2PreparedStatement = new DB2PreparedStatement(sql, this);
            return dB2PreparedStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareStatement()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareCall( " + sql + " )");
            }
            DB2CallableStatement dB2CallableStatement = new DB2CallableStatement(sql, this);
            return dB2CallableStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareCall()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nativeSQL(String query) throws SQLException {
        Object object;
        block8: {
            String result = null;
            this.returnCode = this.sqlSuccess;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "nativeSQL( " + query + " )");
                }
                object = this;
                synchronized (object) {
                    result = this.SQLNativeSQL(query, this.connectionHandle);
                }
                if (this.returnCode != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                object = result;
                if (!DB2Trace.TraceOn) break block8;
            }
            catch (Throwable throwable) {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit((Object)this, "nativeSQL()", result);
                }
                throw throwable;
            }
            DB2Trace.methodExit((Object)this, "nativeSQL()", result);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean enableAutoCommit) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.setAutoCommit2(enableAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAutoCommit2(boolean enableAutoCommit) throws SQLException {
        int rc2 = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setAutoCommit2( " + enableAutoCommit + " )");
                DB2Trace.data(10, "Connection handle ", this.connectionHandle);
            }
            if ((rc2 = enableAutoCommit ? this.SQLSetConnectOptionInt(102, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(102, 0, this.connectionHandle)) != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "setAutoCommit2()", rc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        int rc2 = this.sqlSuccess;
        try {
            int localHandle;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "commit()");
                DB2Trace.data(10, "Connection handle ", this.connectionHandle);
            }
            if ((localHandle = this.connectionHandle) <= 0 || this.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            } else {
                rc2 = this.SQLCommit(localHandle, DB2Driver.getJVMHenv());
                if (rc2 != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, rc2);
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "commit()", rc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        int rc2 = this.sqlSuccess;
        try {
            int localHandle;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "rollback()");
                DB2Trace.data(10, "Connection handle ", this.connectionHandle);
            }
            if ((localHandle = this.connectionHandle) <= 0 || this.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            } else {
                rc2 = this.SQLRollback(localHandle, DB2Driver.getJVMHenv());
                if (rc2 != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, rc2);
                }
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "rollback()", rc2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close( Closed=" + this.closed + " )");
            }
            if (!this.closed) {
                if (this.SPConnected) {
                    if (DB2Trace.TraceOn) {
                        DB2Trace.data(10, "Close deferred");
                    }
                } else {
                    this.close2();
                }
            }
            Object var2_1 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
            DB2Trace.flush();
            throw throwable;
        }
        DB2Trace.methodExit((Object)this, "close()", String.valueOf(this.closed));
        DB2Trace.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void close2() throws SQLException {
        int rc2 = -99999;
        int rc22 = -99999;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close2( Closed=" + this.closed + " Disconnected=" + this.disconnected + ")");
                DB2Trace.data(10, "connectionHandle", this.connectionHandle);
            }
            if (!this.disconnected) {
                if (this.inputStreamStmt != null) {
                    try {
                        this.inputStreamStmt.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.inputStreamStmt = null;
                }
                if ((rc2 = this.SQLDisconnect(this.connectionHandle)) != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, rc2);
                }
                this.disconnected = true;
            }
            if (this.connectionHandle > 0) {
                rc22 = this.SQLFreeConnect(this.connectionHandle);
                if (rc22 != this.sqlSuccess) {
                    this.sqlExcptGen.check_return_code(this, rc22);
                }
                this.closed = true;
                this.connectionHandle = 0;
            }
            Object var5_4 = null;
            if (!DB2Trace.TraceOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!DB2Trace.TraceOn) throw throwable;
            DB2Trace.data(20, "SQLDisconnect()", rc2);
            DB2Trace.data(20, "SQLFreeConnect()", rc22);
            DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
            throw throwable;
        }
        DB2Trace.data(20, "SQLDisconnect()", rc2);
        DB2Trace.data(20, "SQLFreeConnect()", rc22);
        DB2Trace.methodExit((Object)this, "close2()", String.valueOf(this.closed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws SQLException {
        block12: {
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "finalize()");
                }
                if (this.closed) break block12;
                String msg = "DB2Connection closed in finalizer" + this.toString();
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, msg);
                }
                DriverManager.println(msg);
                try {
                    this.close();
                    Object var3_2 = null;
                    if (this.closed) break block12;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (!this.closed) {
                        this.rollback();
                        this.close();
                    }
                    throw throwable;
                }
                this.rollback();
                this.close();
            }
            finally {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodExit(this, "finalize()");
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    synchronized void setClosed(boolean isclosed) {
        this.closed = isclosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DB2DatabaseMetaData dmd = DB2Trace.TraceOn ? new DB2DatabaseMetaDataTrace(this) : new DB2DatabaseMetaData(this);
        return dmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isReadOnly != readOnly) {
            int rc2 = 0;
            DB2Connection dB2Connection = this;
            synchronized (dB2Connection) {
                rc2 = readOnly ? this.SQLSetConnectOptionInt(101, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(101, 0, this.connectionHandle);
            }
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            this.isReadOnly = readOnly;
        }
    }

    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isReadOnly2() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int value = this.SQLGetConnectOption(101, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            this.isReadOnly = 0 != value;
            return this.isReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongDataCompat(boolean compatOn) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int rc2 = compatOn ? this.SQLSetConnectOptionInt(1253, 1, this.connectionHandle) : this.SQLSetConnectOptionInt(1253, 0, this.connectionHandle);
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            this.isLDCompat = compatOn;
        }
    }

    public boolean isLongDataCompat() {
        return this.isLDCompat;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int rc2 = this.SQLSetConnectOptionInt(108, level, this.connectionHandle);
            if (rc2 != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, rc2);
            }
            this.transactionIsolationLevel = level;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTransactionIsolation2() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int tempLevel = this.SQLGetConnectOption(108, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            this.transactionIsolationLevel = tempLevel;
            return this.transactionIsolationLevel;
        }
    }

    public void setAutoClose(boolean autoclose) throws SQLException {
        if (autoclose) {
            this.sqlExcptGen.connException("S1C00");
        }
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoCommit() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int level = this.SQLGetConnectOption(102, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            return 1 == level;
            {
            }
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public synchronized void clearWarnings() {
        this.warnings = null;
    }

    public synchronized void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            SQLWarning current = this.warnings;
            while (current.getNextWarning() != null) {
                current = current.getNextWarning();
            }
            current.setNextWarning(warning);
        }
    }

    ResourceBundle getErrMsgClass() {
        return this.errMsgClass;
    }

    void setErrMsgClass(ResourceBundle errClass) {
        this.errMsgClass = errClass;
        this.sqlExcptGen = new SQLExceptionGenerator(this.errMsgClass);
    }

    protected boolean isDescribeParamSupported() {
        if (this.describeCached) {
            return this.describeParam;
        }
        int rc2 = this.SQLGetDescribeParamSupported(this.connectionHandle);
        this.describeParam = rc2 == this.sqlSuccess;
        this.describeCached = true;
        return this.describeParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectOption(int option, String value) throws SQLException {
        int rc2;
        if (value == null) {
            value = "";
        }
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            rc2 = this.SQLSetConnectOptionString(option, value, this.connectionHandle);
        }
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, rc2);
        }
    }

    public void setConnectOption(int option, int value) throws SQLException {
        int rc2 = this.SQLSetConnectOptionInt(option, value, this.connectionHandle);
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, rc2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectOption(int option) throws SQLException {
        int retValue = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getConnectOption( " + option + " )");
            }
            this.returnCode = this.sqlSuccess;
            retValue = this.SQLGetConnectOption(option, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            int n2 = retValue;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getConnectOption()", retValue);
            }
        }
    }

    protected int getRealSqlType() throws SQLException {
        if (this.realSqlType == -1) {
            int rc2 = this.SQLHasType(this.connectionHandle, 7);
            this.realSqlType = rc2 == 0 ? 7 : 8;
        }
        return this.realSqlType;
    }

    protected boolean isLOBSupported() throws SQLException {
        if (null == this.supportsLOB) {
            int rc2 = this.SQLHasType(this.connectionHandle, -98);
            this.supportsLOB = 0 == rc2 ? new Boolean(true) : new Boolean(false);
        }
        return this.supportsLOB;
    }

    protected int getBlobSqlType() throws SQLException {
        if (0 == this.blobSqlType) {
            int rc2 = this.SQLHasType(this.connectionHandle, -98);
            this.blobSqlType = 0 == rc2 ? -98 : -4;
        }
        return this.blobSqlType;
    }

    protected int getDecMaxLength(int sqltype, int colType) throws SQLException {
        return this.getTypeMaxLength(sqltype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getTypeMaxLength(int sqltype) throws SQLException {
        int length = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTypeMaxLength( " + sqltype + " )");
            }
            switch (sqltype) {
                case -2: 
                case 1: {
                    length = this.typeMaxChar;
                    break;
                }
                case -3: 
                case 12: {
                    length = this.typeMaxVarChar;
                    break;
                }
                case -4: 
                case -1: {
                    length = this.typeMaxLongVarChar;
                    break;
                }
                case -99: 
                case -98: {
                    length = Integer.MAX_VALUE;
                    break;
                }
                case -95: {
                    length = this.typeMaxChar;
                    if (-1 == length) break;
                    length /= 2;
                    break;
                }
                case -96: {
                    length = this.typeMaxVarChar;
                    if (-1 == length) break;
                    length /= 2;
                    break;
                }
                case -97: {
                    length = this.typeMaxLongVarChar;
                    if (-1 == length) break;
                    length /= 2;
                    break;
                }
                case -350: {
                    length = 0x3FFFFFFF;
                    break;
                }
                case 2: 
                case 3: {
                    length = this.typeMaxDecimal;
                    break;
                }
                default: {
                    length = 0;
                }
            }
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Length", length);
            }
            if (-1 == length) {
                this.returnCode = this.sqlSuccess;
                length = this.SQLGetTypeMaxLen(this.connectionHandle, sqltype);
                if (this.sqlSuccess != this.returnCode) {
                    this.sqlExcptGen.check_return_code(this, this.returnCode);
                }
                switch (sqltype) {
                    case -2: 
                    case 1: {
                        this.typeMaxChar = length;
                        break;
                    }
                    case -3: 
                    case 12: {
                        this.typeMaxVarChar = length;
                        break;
                    }
                    case -4: 
                    case -1: {
                        this.typeMaxLongVarChar = length;
                        break;
                    }
                    case -95: {
                        this.typeMaxChar = length * 2;
                        break;
                    }
                    case -96: {
                        this.typeMaxVarChar = length * 2;
                        break;
                    }
                    case -97: {
                        this.typeMaxLongVarChar = length * 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.typeMaxDecimal = length;
                    }
                }
            }
            int n2 = length;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getTypeMaxLength()", length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DB2Statement getInputStreamStmt() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getInputStreamStmt()");
            }
            if (this.inputStreamStmt == null) {
                this.inputStreamStmt = new DB2Statement(this, true);
            }
            DB2Statement dB2Statement = this.inputStreamStmt;
            return dB2Statement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getInputStreamStmt()");
            }
        }
    }

    public void setCodePage(int codePage) throws SQLException {
        int rc2 = this.SQLSetCodePage(codePage);
        if (rc2 != this.sqlSuccess) {
            this.sqlExcptGen.check_return_code(this, rc2);
        }
    }

    public int getHandle() {
        return this.connectionHandle;
    }

    public int getConnectionHandle() {
        return this.connectionHandle;
    }

    public final boolean is20() {
        return 200 == this.JDBCLevel;
    }

    public final int getJDBCLevel() {
        return this.JDBCLevel;
    }

    int adjust(int db2type) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "adjust( " + db2type + " )");
        }
        int jdbctype = db2type;
        switch (db2type) {
            case 9: {
                jdbctype = 91;
                break;
            }
            case 10: {
                jdbctype = 92;
                break;
            }
            case 11: {
                jdbctype = 93;
                break;
            }
            case -95: 
            case -8: {
                jdbctype = 1;
                break;
            }
            case -96: 
            case -9: {
                jdbctype = 12;
                break;
            }
            case -97: 
            case -10: {
                jdbctype = -1;
                break;
            }
            case -350: {
                jdbctype = -99;
                break;
            }
            case -400: {
                jdbctype = 70;
                break;
            }
            case -450: {
                jdbctype = 2001;
                break;
            }
            case -370: {
                jdbctype = 1111;
            }
        }
        if (jdbctype == -99 || jdbctype == -98) {
            jdbctype = jdbctype == -99 ? 2005 : 2004;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "adjust()", jdbctype);
        }
        return jdbctype;
    }

    public void resetConnectionDefaults() throws SQLException {
        this.setAutoCommit(this.defaultAutoCommit);
        if (this.transactionIsolationLevel != this.defaultTransactionIsolationLevel) {
            this.setTransactionIsolation(this.defaultTransactionIsolationLevel);
        }
        if (this.isReadOnly != this.defaultIsReadOnly) {
            this.setReadOnly(this.defaultIsReadOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDQPFlag(int flag) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "setDQPFlag( " + flag + " )");
            }
            this.setConnectOption(2466, flag);
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "setDQPFlag()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDQPFlag() throws SQLException {
        int retValue = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getDQPFlag()");
            }
            int n2 = retValue = this.getConnectOption(2466);
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getDQPFlag()", retValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getHostType() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getHostType()");
            }
            if (0 == this.hostType) {
                this.hostType = this.SQLGetHostType(this.connectionHandle);
            }
            int n2 = this.hostType;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getHostType()", this.hostType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingDB2() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            int value = 0;
            this.returnCode = this.sqlSuccess;
            value = this.SQLGetConnectOption(2545, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            return value != 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDB2GatewayConnection() throws SQLException {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this.returnCode = this.sqlSuccess;
            int value = this.SQLGetConnectOption(2537, this.connectionHandle);
            if (this.returnCode != this.sqlSuccess) {
                this.sqlExcptGen.check_return_code(this, this.returnCode);
            }
            return 0 != value;
            {
            }
        }
    }

    private native void setTimeZoneOffset(int var1, int[] var2);

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DB2Statement(this, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DB2PreparedStatement(sql, this, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DB2CallableStatement(sql, this, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTypeMap");
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTypeMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getTimeZoneOffset() {
        int[] nArray = this.timeZoneOffset;
        synchronized (this.timeZoneOffset) {
            if (100 == this.timeZoneOffset[0]) {
                this.setTimeZoneOffset(this.connectionHandle, this.timeZoneOffset);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.timeZoneOffset;
        }
    }

    public String getDatabaseName() throws SQLException {
        return this.source;
    }

    public SQLJLogWriter getSQLJLogWriter() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLJCallableStatement prepareSQLJCall(String sql, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int db2SqljStatementType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareSQLJCall( " + sql + ", " + statementRole + ", " + dynamicExecution + ", " + needsDescribe + ", " + resultSetType + ", " + resultSetConcurrency + " )");
            }
            DB2CallableStatement dB2CallableStatement = new DB2CallableStatement(sql, this, statementRole, section, parameterMetaData, resultSetMetaData, dynamicExecution, needsDescribe, resultSetType, 1007);
            return dB2CallableStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareSQLJCall()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLJCallableStatement prepareSQLJCall(String sql, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int db2SqljStatementType, String cacheKeySuffix, Object[] additionalArgs) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareSQLJCall( " + sql + ", " + statementRole + ", " + dynamicExecution + ", " + needsDescribe + ", " + resultSetType + ", " + resultSetConcurrency + " )");
            }
            DB2CallableStatement dB2CallableStatement = new DB2CallableStatement(sql, this, statementRole, section, parameterMetaData, resultSetMetaData, dynamicExecution, needsDescribe, resultSetType, 1007);
            return dB2CallableStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareSQLJCall()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLJPreparedStatement prepareSQLJStatement(String sql, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int db2SqljStatementType) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareSQLJStatement( " + sql + ", " + statementRole + ", " + dynamicExecution + ", " + needsDescribe + ", " + resultSetType + ", " + resultSetConcurrency + " )");
            }
            DB2PreparedStatement dB2PreparedStatement = new DB2PreparedStatement(sql, this, statementRole, section, parameterMetaData, resultSetMetaData, dynamicExecution, needsDescribe, resultSetType, 1007);
            return dB2PreparedStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareSQLJStatement()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLJPreparedStatement prepareSQLJStatement(String sql, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int db2SqljStatementType, String cacheKeySuffix, Object[] additionalArgs) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "prepareSQLJStatement( " + sql + ", " + statementRole + ", " + dynamicExecution + ", " + needsDescribe + ", " + resultSetType + ", " + resultSetConcurrency + " )");
            }
            DB2PreparedStatement dB2PreparedStatement = new DB2PreparedStatement(sql, this, statementRole, section, parameterMetaData, resultSetMetaData, dynamicExecution, needsDescribe, resultSetType, 1007);
            return dB2PreparedStatement;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "prepareSQLJStatement()");
            }
        }
    }

    public boolean enableDuplicateStaticQueries() {
        return false;
    }

    public boolean isJccDriver() {
        return false;
    }

    public String getDriverVersion() {
        return "n110722";
    }

    public int getInterfaceVersion() {
        return 1;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setHoldability");
    }

    public int getHoldability() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getHoldability");
        return 0;
    }

    public Savepoint setSavepoint() throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setSavepoint");
        return null;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setSavepoint");
        return null;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("rollback to Savepoint");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("releaseSavepoint");
    }

    public Statement createStatement(int type, int concur, int holdability) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("createStatement with holdability");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concur, int holdability) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("prepareStatement with holdability");
        return null;
    }

    public CallableStatement prepareCall(String sql, int type, int concur, int holdability) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("prepareCall with holdability");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("prepareStatement with auto-generated keys");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("prepareStatement with auto-generated keys");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("prepareStatement with auto-generated keys");
        return null;
    }
}

