/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DB2CharReader
extends Reader {
    protected int lobType;
    protected int lobLocator;
    protected int docLength;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected boolean closed;
    protected boolean markSupported = true;
    protected int maxFieldSize;
    protected int rc = 0;
    protected int encoding;
    protected int currentPosition;
    protected int numBytesRead;
    protected int markedPosition;
    protected int bufferPos = 0;
    protected int bufferEnd = 0;
    protected static final int defaultBufferSize = 16000;
    protected char[] buffer = null;

    protected native int SQLGetLength(int var1);

    protected native String SQLReadStr(int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2CharReader(DB2Statement stmt, int type, int locator) throws SQLException {
        this.lobType = type;
        this.lobLocator = locator;
        DB2Connection dB2Connection = this.connection = (DB2Connection)stmt.getConnection();
        synchronized (dB2Connection) {
            this.maxFieldSize = stmt.getMaxFieldSize();
            this.statement = this.connection.getInputStreamStmt();
            this.docLength = this.SQLGetLength(this.statement.statementHandle);
            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            if (this.maxFieldSize != 0 && this.maxFieldSize < this.docLength) {
                this.docLength = this.maxFieldSize;
            }
            this.closed = false;
            this.currentPosition = 1;
            this.markedPosition = 1;
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        char[] singleChar = new char[1];
        int numRead = this.read(singleChar, 0, 1);
        if (numRead == -1) {
            return -1;
        }
        return singleChar[0];
    }

    public int read(char[] buf) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        return this.read(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        int charsRead = 0;
        try {
            int charsAvailable;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "read( buf, " + off + ", " + len + " )");
            }
            int charsToRead = len;
            if (this.buffer != null && (charsAvailable = this.bufferEnd - this.bufferPos) != 0) {
                if (charsToRead <= charsAvailable) {
                    System.arraycopy(this.buffer, this.bufferPos, buf, off, charsToRead);
                    this.bufferPos += charsToRead;
                    charsRead = charsToRead;
                    charsToRead = 0;
                } else {
                    System.arraycopy(this.buffer, this.bufferPos, buf, off, charsAvailable);
                    this.bufferPos += charsAvailable;
                    charsRead = charsAvailable;
                    charsToRead -= charsAvailable;
                }
            }
            if (charsToRead != 0 && this.currentPosition <= this.docLength) {
                String str;
                charsAvailable = 0;
                len = Math.max(16000, charsToRead);
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(30, "currentPosition", this.currentPosition);
                    DB2Trace.data(30, "charsToRead", charsToRead);
                    DB2Trace.data(30, "len", len);
                }
                try {
                    this.numBytesRead = 0;
                    DB2Statement dB2Statement = this.statement;
                    synchronized (dB2Statement) {
                        str = this.SQLReadStr(len, this.statement.statementHandle, this.connection.connectionHandle);
                        if (this.rc != 0) {
                            this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
                        }
                    }
                }
                catch (SQLException e2) {
                    throw new IOException(e2.getMessage());
                }
                if (str != null) {
                    int numCharsRead = str.length();
                    this.buffer = str.toCharArray();
                    charsAvailable = numCharsRead;
                    this.currentPosition = this.lobType == 41 ? (this.currentPosition += this.numBytesRead) : (this.currentPosition += numCharsRead);
                }
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(40, "numBytesRead", this.numBytesRead);
                    DB2Trace.data(40, "charsAvailable", charsAvailable);
                }
                this.bufferPos = 0;
                this.bufferEnd = charsAvailable;
                if (charsAvailable != 0) {
                    if (charsToRead <= charsAvailable) {
                        System.arraycopy(this.buffer, this.bufferPos, buf, off + charsRead, charsToRead);
                        this.bufferPos += charsToRead;
                        charsRead += charsToRead;
                    } else {
                        System.arraycopy(this.buffer, this.bufferPos, buf, off + charsRead, charsAvailable);
                        this.bufferPos += charsAvailable;
                        charsRead += charsAvailable;
                    }
                }
            }
            if (charsRead == 0) {
                charsRead = -1;
            }
            int n2 = charsRead;
            return n2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "read()", charsRead);
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public boolean markSupported() {
        return this.markSupported;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("Mark()");
        }
        this.markedPosition = this.currentPosition;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("reset()");
        }
        this.currentPosition = this.markedPosition;
    }

    public long skip(long n2) throws IOException {
        int left;
        if (this.closed) {
            throw new IOException(this.connection.sqlExcptGen.errMsgClass.getString("0620"));
        }
        if (!this.markSupported()) {
            this.connection.sqlExcptGen.throwNotSupportedIO("skip()");
        }
        if ((long)(left = this.docLength - this.currentPosition) < n2) {
            this.currentPosition = this.docLength;
            return left;
        }
        this.currentPosition = (int)((long)this.currentPosition + n2);
        return n2;
    }

    int getLocator() {
        return this.lobLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLength() throws SQLException {
        int charLength = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getLength()");
            }
            DB2Statement dB2Statement = this.statement;
            synchronized (dB2Statement) {
                this.docLength = this.SQLGetLength(this.statement.statementHandle);
                this.connection.sqlExcptGen.check_return_code(this.statement, this.rc);
            }
            charLength = this.docLength;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "docLength", this.docLength);
                DB2Trace.data(10, "maxFieldSize", this.maxFieldSize);
            }
            if (this.maxFieldSize != 0 && this.maxFieldSize < charLength) {
                charLength = this.maxFieldSize;
            }
            long l2 = charLength;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getLength()", charLength);
            }
        }
    }

    void moveTo(int pos) {
        this.currentPosition = pos < this.docLength ? pos : this.docLength;
    }
}

