/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Blob;
import COM.ibm.db2.jdbc.app.DB2Clob;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2PreparedStatement;
import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJSection;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;

public class DB2CallableStatement
extends DB2PreparedStatement
implements CallableStatement,
SQLJCallableStatement {
    private boolean wasNull = true;
    private int year = 0;
    private int month = 0;
    private int date = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private int nano = 0;

    protected native int SQLBindOutParameter(int var1, int var2, int var3, int var4, int var5, long var6, long[] var8, int var9, boolean var10);

    protected native String SQLGetChar(int var1, long var2);

    protected native byte[] SQLGetBinary(long var1);

    protected native int SQLGetShort(long var1);

    protected native int SQLGetInt(long var1);

    protected native long SQLGetLong(long var1);

    protected native float SQLGetFloat(long var1);

    protected native double SQLGetDouble(long var1);

    protected native void SQLGetDate(long var1);

    protected native void SQLGetTime(long var1);

    protected native void SQLGetTimestamp(long var1);

    protected native int SQLisNull(long var1);

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String ident, boolean displayRSObj) {
        StringBuffer sb2 = new StringBuffer("\r\n" + ident + "DB2CallableStatement \r\n" + ident + "{");
        sb2.append(super.toString(ident + "    ", displayRSObj));
        sb2.append("\r\n" + ident + "    wasNull = " + this.wasNull + "\r\n");
        return sb2.toString();
    }

    protected int SQLisNull2(int paramNum) {
        return this.SQLisNull(this.parameters[paramNum - 1]);
    }

    public DB2CallableStatement(String sql, DB2Connection con, int rsType, int rsConcur) throws SQLException {
        super(sql, con, rsType, rsConcur);
    }

    public DB2CallableStatement(String sql, DB2Connection con) throws SQLException {
        super(sql, con);
    }

    public DB2CallableStatement(String sql, DB2Connection con, int statementRole, SQLJSection section, SQLJColumnMetaData parameterMetaData, SQLJColumnMetaData resultSetMetaData, boolean dynamicExecution, boolean needsDescribe, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(sql, con, statementRole, section, parameterMetaData, resultSetMetaData, dynamicExecution, needsDescribe, resultSetType, resultSetConcurrency);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typename) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("User-named/REF type");
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        int dIndex = parameterIndex - 1;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "registerOutParameter( " + parameterIndex + ", " + sqlType + ", " + scale + "  )");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            if (this.connection.closed) {
                this.sqlExcptGen.throwConnectionClosedError();
            }
            if (this.closed) {
                this.sqlExcptGen.throwClosedError();
            }
            if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                this.sqlExcptGen.throwParamIndexError();
            }
            sqlType = this.convert2SQLType(sqlType);
            if (this.direction[dIndex] == 0) {
                this.direction[dIndex] = 4;
                this.sqltypes[dIndex] = sqlType;
                this.ctypes[dIndex] = this.sqlType2cType(sqlType);
                this.scales[dIndex] = scale;
            } else if (this.direction[dIndex] == 1) {
                this.direction[dIndex] = 2;
                this.sqltypes[dIndex] = sqlType;
                if (scale > this.scales[dIndex]) {
                    this.scales[dIndex] = scale;
                }
            }
            this.executed = false;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "registerOutParameter() ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkParameters() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "checkParameters() ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int precision = 0;
            for (int i2 = 0; i2 < this.maxNumParams; ++i2) {
                if (this.direction[i2] != 4) continue;
                int sqlType = this.sqltypes[i2];
                int scale = this.scales[i2];
                if (DB2Trace.TraceOn) {
                    DB2Trace.data(10, "direction[" + i2 + "]", this.direction[i2]);
                    DB2Trace.data(10, "sqltypes[" + i2 + "]", this.sqltypes[i2]);
                    DB2Trace.data(10, "scales[" + i2 + "]", this.scales[i2]);
                }
                switch (sqlType) {
                    case -7: 
                    case -6: {
                        sqlType = 5;
                        break;
                    }
                    case -5: {
                        sqlType = -5;
                        break;
                    }
                    case 7: {
                        sqlType = this.connection.getRealSqlType();
                        break;
                    }
                    case 2: 
                    case 3: {
                        precision = this.connection.getDecMaxLength(2, 4);
                        break;
                    }
                    case 2005: {
                        sqlType = -99;
                        break;
                    }
                    case 2004: {
                        sqlType = -98;
                    }
                }
                int rc2 = this.SQLBindOutParameter(this.direction[i2], i2 + 1, sqlType, precision, scale, this.parameters[i2], this.parameters, this.statementHandle, this.connection.isDescribeParamSupported());
                if (rc2 == this.sqlSuccess) continue;
                this.sqlExcptGen.check_return_code(this, rc2);
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "checkParameters() ");
            }
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int parameterIndex) throws SQLException {
        Object object;
        block17: {
            String retStr;
            block15: {
                block16: {
                    retStr = null;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "getString( " + parameterIndex + " ) ");
                            DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                        }
                        int arrayIndex = this.validateParameter(parameterIndex);
                        int type = this.sqltypes[arrayIndex];
                        switch (type) {
                            case -95: 
                            case -8: {
                                type = 1;
                                break;
                            }
                            case -96: 
                            case -9: {
                                type = 12;
                                break;
                            }
                            case -97: 
                            case -10: {
                                type = -1;
                                break;
                            }
                            case -350: {
                                type = -99;
                                break;
                            }
                        }
                        if (type != 1 && type != 12 && type != -1 && type != -99) {
                            this.sqlExcptGen.throwTypeError();
                        }
                        object = this.connection;
                        synchronized (object) {
                            retStr = this.SQLGetChar(this.connection.connectionHandle, this.parameters[parameterIndex - 1]);
                        }
                        if (0 == this.SQLisNull2(parameterIndex)) {
                            this.wasNull = false;
                            break block15;
                        }
                        this.wasNull = true;
                        object = null;
                        Object var8_7 = null;
                        if (!DB2Trace.TraceOn) break block16;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            Object var8_9 = null;
                            if (!DB2Trace.TraceOn) break block18;
                            DB2Trace.data(10, "retStr", retStr);
                            DB2Trace.methodExit(this, "getString()");
                        }
                        throw throwable;
                    }
                    DB2Trace.data(10, "retStr", retStr);
                    DB2Trace.methodExit(this, "getString()");
                }
                return object;
            }
            object = retStr;
            Object var8_8 = null;
            if (!DB2Trace.TraceOn) break block17;
            DB2Trace.data(10, "retStr", retStr);
            DB2Trace.methodExit(this, "getString()");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int parameterIndex) throws SQLException {
        boolean bl2;
        block4: {
            int retval = -1;
            boolean retBool = true;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getBoolean( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, 5);
                retval = this.SQLGetShort(this.parameters[parameterIndex - 1]);
                retBool = true;
                if (retval == 0) {
                    retBool = false;
                }
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                bl2 = retBool;
                Object var7_6 = null;
                if (!DB2Trace.TraceOn) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) break block5;
                    DB2Trace.data(10, "retval ", retval);
                    DB2Trace.data(10, "retBool ", String.valueOf(retBool));
                    DB2Trace.methodExit(this, "getBoolean() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retval ", retval);
            DB2Trace.data(10, "retBool ", String.valueOf(retBool));
            DB2Trace.methodExit(this, "getBoolean() ");
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int parameterIndex) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getByte( " + parameterIndex + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int arrayIndex = this.validateParameter(parameterIndex, 5);
            byte retByte = (byte)this.SQLGetShort(this.parameters[parameterIndex - 1]);
            this.wasNull = this.SQLisNull2(parameterIndex) != 0;
            byte by = retByte;
            return by;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getByte() ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int parameterIndex) throws SQLException {
        short s2;
        block3: {
            short retShort = -1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getShort( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, 5);
                retShort = (short)this.SQLGetShort(this.parameters[parameterIndex - 1]);
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                s2 = retShort;
                Object var6_5 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.data(10, "retShort ", retShort);
                    DB2Trace.methodExit(this, "getShort() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retShort ", retShort);
            DB2Trace.methodExit(this, "getShort() ");
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int parameterIndex) throws SQLException {
        int n2;
        block3: {
            int retInt = 0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getInt( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, 4);
                retInt = this.SQLGetInt(this.parameters[parameterIndex - 1]);
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                n2 = retInt;
                Object var6_5 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.data(10, "retInt ", retInt);
                    DB2Trace.methodExit(this, "getInt() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retInt ", retInt);
            DB2Trace.methodExit(this, "getInt() ");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int parameterIndex) throws SQLException {
        long l2;
        block3: {
            long retLong = -1L;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getLong( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, -5);
                retLong = this.SQLGetLong(this.parameters[parameterIndex - 1]);
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                l2 = retLong;
                Object var8_5 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_6 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.data(10, "retLong ", retLong);
                    DB2Trace.methodExit(this, "getLong() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retLong ", retLong);
            DB2Trace.methodExit(this, "getLong() ");
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int parameterIndex) throws SQLException {
        float f2;
        block5: {
            float retFloat = -1.0f;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getFloat( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, 7);
                int realSqlType = this.connection.getRealSqlType();
                if (realSqlType == 7) {
                    retFloat = this.SQLGetFloat(this.parameters[parameterIndex - 1]);
                } else {
                    double retDouble = this.SQLGetDouble(this.parameters[parameterIndex - 1]);
                    retFloat = (float)retDouble;
                }
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                f2 = retFloat;
                Object var8_7 = null;
                if (!DB2Trace.TraceOn) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var8_8 = null;
                    if (!DB2Trace.TraceOn) break block6;
                    DB2Trace.data(10, "retFloat ", String.valueOf(retFloat));
                    DB2Trace.methodExit(this, "getFloat() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retFloat ", String.valueOf(retFloat));
            DB2Trace.methodExit(this, "getFloat() ");
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int parameterIndex) throws SQLException {
        double d2;
        block3: {
            double retDouble = 0.0;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "getDouble( " + parameterIndex + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                int arrayIndex = this.validateParameter(parameterIndex, 8);
                retDouble = this.SQLGetDouble(this.parameters[parameterIndex - 1]);
                this.wasNull = this.SQLisNull2(parameterIndex) != 0;
                d2 = retDouble;
                Object var8_5 = null;
                if (!DB2Trace.TraceOn) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_6 = null;
                    if (!DB2Trace.TraceOn) break block4;
                    DB2Trace.data(10, "retDouble ", String.valueOf(retDouble));
                    DB2Trace.methodExit(this, "getDouble() ");
                }
                throw throwable;
            }
            DB2Trace.data(10, "retDouble ", String.valueOf(retDouble));
            DB2Trace.methodExit(this, "getDouble() ");
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        Object object;
        block13: {
            String retval;
            block11: {
                block12: {
                    block9: {
                        block10: {
                            retval = null;
                            try {
                                if (DB2Trace.TraceOn) {
                                    DB2Trace.methodEntry(this, "getBigDecimal( " + parameterIndex + " ) ");
                                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                                }
                                int arrayIndex = this.validateParameter(parameterIndex, 2);
                                object = this.connection;
                                synchronized (object) {
                                    retval = this.SQLGetChar(this.connection.connectionHandle, this.parameters[parameterIndex - 1]);
                                }
                                if (this.SQLisNull2(parameterIndex) == 0) {
                                    this.wasNull = false;
                                    break block9;
                                }
                                this.wasNull = true;
                                object = null;
                                Object var8_7 = null;
                                if (!DB2Trace.TraceOn) break block10;
                            }
                            catch (Throwable throwable) {
                                block14: {
                                    Object var8_10 = null;
                                    if (!DB2Trace.TraceOn) break block14;
                                    DB2Trace.data(10, "scale ", scale);
                                    DB2Trace.data(10, "retval ", retval);
                                    DB2Trace.methodExit(this, "getBigDecimal() ");
                                }
                                throw throwable;
                            }
                            DB2Trace.data(10, "scale ", scale);
                            DB2Trace.data(10, "retval ", retval);
                            DB2Trace.methodExit(this, "getBigDecimal() ");
                        }
                        return object;
                    }
                    if (-1 != scale) break block11;
                    object = new BigDecimal(DB2CallableStatement.translateFloat(retval));
                    Object var8_8 = null;
                    if (!DB2Trace.TraceOn) break block12;
                    DB2Trace.data(10, "scale ", scale);
                    DB2Trace.data(10, "retval ", retval);
                    DB2Trace.methodExit(this, "getBigDecimal() ");
                }
                return object;
            }
            object = new BigDecimal(DB2CallableStatement.translateFloat(retval)).setScale(scale, 4);
            Object var8_9 = null;
            if (!DB2Trace.TraceOn) break block13;
            DB2Trace.data(10, "scale ", scale);
            DB2Trace.data(10, "retval ", retval);
            DB2Trace.methodExit(this, "getBigDecimal() ");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + parameterIndex + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int arrayIndex = this.validateParameter(parameterIndex);
            int type = this.sqltypes[arrayIndex];
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "type ", type);
            }
            if (type != -2 && type != -3 && type != -4 && type != -98) {
                this.sqlExcptGen.throwTypeError();
            }
            byte[] b2 = this.SQLGetBinary(this.parameters[parameterIndex - 1]);
            if (this.SQLisNull2(parameterIndex) != 0) {
                this.wasNull = true;
                byte[] byArray = null;
                return byArray;
            }
            this.wasNull = false;
            byte[] byArray = b2;
            return byArray;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getBytes() ");
            }
        }
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate2(parameterIndex, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate2(int parameterIndex, Calendar cal) throws SQLException {
        Date date;
        block8: {
            Date retDate;
            block6: {
                Date date2;
                block7: {
                    retDate = null;
                    try {
                        if (DB2Trace.TraceOn) {
                            DB2Trace.methodEntry(this, "getDate2(" + parameterIndex + ", calTimeZone=" + cal.getTimeZone().getID() + ")");
                            DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                        }
                        int arrayIndex = this.validateParameter(parameterIndex, 91);
                        this.SQLGetDate(this.parameters[parameterIndex - 1]);
                        if (-1 != this.year || -1 != this.month || -1 != this.date) break block6;
                        this.wasNull = true;
                        date2 = null;
                        Object var7_7 = null;
                        if (!DB2Trace.TraceOn) break block7;
                        DB2Trace.methodExit((Object)this, "getDate2()", retDate == null ? "NULL" : retDate.toString());
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var7_9 = null;
                            if (!DB2Trace.TraceOn) break block9;
                            DB2Trace.methodExit((Object)this, "getDate2()", retDate == null ? "NULL" : retDate.toString());
                        }
                        throw throwable;
                    }
                }
                return date2;
            }
            this.wasNull = false;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Year", this.year);
                DB2Trace.data(10, "Month", this.month);
                DB2Trace.data(10, "Date", this.date);
            }
            cal = (Calendar)cal.clone();
            cal.set(this.year, this.month - 1, this.date, 0, 0, 0);
            cal.set(14, 0);
            retDate = new Date(cal.getTime().getTime());
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "Date ", retDate.toString());
            }
            date = retDate;
            Object var7_8 = null;
            if (!DB2Trace.TraceOn) break block8;
            DB2Trace.methodExit((Object)this, "getDate2()", retDate == null ? "NULL" : retDate.toString());
        }
        return date;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime2(parameterIndex, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime2(int parameterIndex, Calendar cal) throws SQLException {
        Time retTime = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTime2(" + parameterIndex + " calTimeZone=" + cal.getTimeZone().getID() + ")");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int arrayIndex = this.validateParameter(parameterIndex, 92);
            this.SQLGetTime(this.parameters[parameterIndex - 1]);
            if (this.hour == -1 && this.minute == -1 && this.second == -1) {
                this.wasNull = true;
                Time time = null;
                return time;
            }
            this.wasNull = false;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Hour ", this.hour);
                DB2Trace.data(10, "Minute ", this.minute);
                DB2Trace.data(10, "Second ", this.second);
            }
            cal = (Calendar)cal.clone();
            cal.set(1970, 0, 1, this.hour, this.minute, this.second);
            cal.set(14, 0);
            retTime = new Time(cal.getTime().getTime());
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "retTime", retTime.toString());
            }
            Time time = retTime;
            return time;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getTime2() ");
            }
        }
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp2(parameterIndex, new GregorianCalendar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timestamp getTimestamp2(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp retTS = null;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getTimestamp2(" + parameterIndex + " calTimeZone=" + cal.getTimeZone().getID() + ")");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int arrayIndex = this.validateParameter(parameterIndex, 93);
            this.SQLGetTimestamp(this.parameters[parameterIndex - 1]);
            if (this.year == -1 && this.month == -1 && this.date == -1) {
                this.wasNull = true;
                Timestamp timestamp = null;
                return timestamp;
            }
            this.wasNull = false;
            if (DB2Trace.TraceOn) {
                DB2Trace.data(10, "Year", this.year);
                DB2Trace.data(10, "Month", this.month);
                DB2Trace.data(10, "Date", this.date);
                DB2Trace.data(10, "Hour", this.hour);
                DB2Trace.data(10, "Minute", this.minute);
                DB2Trace.data(10, "Second", this.second);
                DB2Trace.data(10, "Nano", this.nano);
            }
            cal = (Calendar)cal.clone();
            cal.set(this.year, this.month - 1, this.date, this.hour, this.minute, this.second);
            cal.set(14, 0);
            retTS = new Timestamp(cal.getTime().getTime());
            retTS.setNanos(this.nano);
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "retTimestamp", retTS.toString());
            }
            Timestamp timestamp = retTS;
            return timestamp;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getTimestamp2() ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getObject( " + parameterIndex + " ) ");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            int arrayIndex = this.validateParameter(parameterIndex);
            Object returnObject = null;
            int sqlType = this.sqltypes[parameterIndex - 1];
            int scale = this.scales[parameterIndex - 1];
            if (DB2Trace.TraceOn) {
                DB2Trace.data(20, "sqlType ", sqlType);
                DB2Trace.data(20, "scale ", scale);
            }
            switch (sqlType) {
                case -350: 
                case -97: 
                case -96: 
                case -95: 
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    returnObject = this.getString(parameterIndex);
                    break;
                }
                case 2: 
                case 3: {
                    returnObject = this.getBigDecimal(parameterIndex, scale);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    returnObject = this.getBytes(parameterIndex);
                    break;
                }
                case 5: {
                    returnObject = new Integer(this.getShort(parameterIndex));
                    break;
                }
                case 4: {
                    returnObject = new Integer(this.getInt(parameterIndex));
                    break;
                }
                case 6: {
                    returnObject = new Double(this.getDouble(parameterIndex));
                    break;
                }
                case 7: {
                    returnObject = new Float(this.getFloat(parameterIndex));
                    break;
                }
                case 8: {
                    returnObject = new Double(this.getDouble(parameterIndex));
                    break;
                }
                case 91: {
                    returnObject = this.getDate(parameterIndex);
                    break;
                }
                case 92: {
                    returnObject = this.getTime(parameterIndex);
                    break;
                }
                case 93: {
                    returnObject = this.getTimestamp(parameterIndex);
                    break;
                }
                case -99: {
                    returnObject = this.getClob(parameterIndex);
                    break;
                }
                case -98: {
                    returnObject = this.getBlob(parameterIndex);
                    break;
                }
                case -7: {
                    returnObject = new Boolean(this.getBoolean(parameterIndex));
                    break;
                }
                case -6: {
                    returnObject = new Integer(this.getByte(parameterIndex));
                    break;
                }
                case -5: {
                    returnObject = new Long(this.getLong(parameterIndex));
                    break;
                }
                default: {
                    this.sqlExcptGen.rsException("S1004");
                }
            }
            if (this.wasNull) {
                Object var6_6 = null;
                return var6_6;
            }
            Object object = returnObject;
            return object;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getObject()");
            }
        }
    }

    private int validateParameter(int parameterIndex) throws SQLException {
        return this.validateParameter(parameterIndex, 0, false);
    }

    private int validateParameter(int parameterIndex, int inSqlType) throws SQLException {
        return this.validateParameter(parameterIndex, inSqlType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int validateParameter(int parameterIndex, int inSqlType, boolean checkType) throws SQLException {
        int n2;
        block9: {
            int index = -1;
            try {
                if (DB2Trace.TraceOn) {
                    DB2Trace.methodEntry(this, "validateParameter( " + parameterIndex + ", " + checkType + " ) ");
                    DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
                }
                if (this.connection.closed) {
                    this.sqlExcptGen.throwConnectionClosedError();
                }
                if (this.closed) {
                    this.sqlExcptGen.throwClosedError();
                }
                if (parameterIndex < 1 || parameterIndex > this.maxNumParams) {
                    this.sqlExcptGen.throwParamIndexError();
                }
                if (!this.executed) {
                    this.sqlExcptGen.throwNotExecutedError();
                }
                if (this.direction[index = parameterIndex - 1] != 4 && this.direction[index] != 2) {
                    this.sqlExcptGen.throwNotOutputParameterError();
                }
                if (checkType && this.sqltypes[index] != inSqlType) {
                    this.sqlExcptGen.throwTypeError();
                }
                n2 = index;
                Object var7_6 = null;
                if (!DB2Trace.TraceOn) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var7_7 = null;
                    if (!DB2Trace.TraceOn) break block10;
                    DB2Trace.data(10, "return value- index ", index);
                    DB2Trace.methodExit(this, "validateParameter()");
                }
                throw throwable;
            }
            DB2Trace.data(10, "return value- index ", index);
            DB2Trace.methodExit(this, "validateParameter()");
        }
        return n2;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getBigDecimal(parameterIndex, -1);
    }

    public Object getObject(int i2, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("GetObject with user-defined mapping");
        return null;
    }

    public Ref getRef(int i2) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int i2) throws SQLException {
        try {
            byte[] b2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBlob( " + i2 + " )");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            if (null == (b2 = this.getBytes(i2))) {
                Blob blob = null;
                return blob;
            }
            DB2Blob dB2Blob = new DB2Blob(b2);
            return dB2Blob;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getBlob()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int i2) throws SQLException {
        try {
            String s2;
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getClob( " + i2 + " )");
                DB2Trace.data(10, "Statement Handle ", this.getTraceHandle());
            }
            if (null == (s2 = this.getString(i2))) {
                Clob clob = null;
                return clob;
            }
            DB2Clob dB2Clob = new DB2Clob(s2);
            return dB2Clob;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getClob()");
            }
        }
    }

    public Array getArray(int i2) throws SQLException {
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getDate2(parameterIndex, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTime2(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimestamp2(parameterIndex, cal);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("registerOutParameter using named parameters");
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("registerOutParameter using named parameters");
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("registerOutParameter using named parameters");
    }

    public URL getURL(int parameterIndex) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getURL");
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setURL using named parameters");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setNull using named parameters");
    }

    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setBoolean using named parameters");
    }

    public void setByte(String parameterName, byte x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setByte using named parameters");
    }

    public void setShort(String parameterName, short x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setShort using named parameters");
    }

    public void setInt(String parameterName, int x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setInt using named parameters");
    }

    public void setLong(String parameterName, long x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setLong using named parameters");
    }

    public void setFloat(String parameterName, float x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setFloat using named parameters");
    }

    public void setDouble(String parameterName, double x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setDouble using named parameters");
    }

    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setBigDecimal using named parameters");
    }

    public void setString(String parameterName, String x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setString using named parameters");
    }

    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setBytes using named parameters");
    }

    public void setDate(String parameterName, Date x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setDate using named parameters");
    }

    public void setTime(String parameterName, Time x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTime using named parameters");
    }

    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTimestamp using named parameters");
    }

    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setAsciiStream using named parameters");
    }

    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setBinaryStream using named parameters");
    }

    public void setObject(String parameterName, Object x2, int targetType, int scale) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setObject using named parameters");
    }

    public void setObject(String parameterName, Object x2, int targetType) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setObject using named parameters");
    }

    public void setObject(String parameterName, Object x2) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setObject using named parameters");
    }

    public void setCharacterStream(String parameterName, Reader x2, int length) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setCharacterStream using named parameters");
    }

    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setDate using named parameters");
    }

    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTime using named parameters");
    }

    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setTimestamp using named parameters");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("setNull using named parameters");
    }

    public String getString(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getString using named parameters");
        return null;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getBoolean using named parameters");
        return false;
    }

    public byte getByte(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getByte using named parameters");
        return 0;
    }

    public short getShort(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getShort using named parameters");
        return 0;
    }

    public int getInt(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getInt using named parameters");
        return 0;
    }

    public long getLong(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getLong using named parameters");
        return 0L;
    }

    public float getFloat(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getFloat using named parameters");
        return 0.0f;
    }

    public double getDouble(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getDouble using named parameters");
        return 0.0;
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getBytes using named parameters");
        return null;
    }

    public Date getDate(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getDate using named parameters");
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTime using named parameters");
        return null;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTimestamp using named parameters");
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getObject using named parameters");
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getBigDecimal using named parameters");
        return null;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getObject using named parameters");
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getRef using named parameters");
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getBlob using named parameters");
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getClob using named parameters");
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getArray using named parameters");
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getDate using named parameters");
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTime using named parameters");
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getTimestamp using named parameters");
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        this.sqlExcptGen.throwNotSupportedByDB2("getURL using named parameters");
        return null;
    }
}

