/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Connection;
import COM.ibm.db2.jdbc.app.DB2InputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class DB2Blob
implements Blob {
    protected int locator;
    protected DB2Connection connection;
    protected DB2Statement statement;
    protected int lobType;
    protected boolean closed = false;
    protected long cachedLength = -1L;
    protected int[] retCode = new int[1];
    protected byte[] data = null;

    protected native int SQLGetBAPosition(int var1, int var2, int var3, byte[] var4, int var5, int var6, int[] var7);

    protected native int SQLGetBlobPosition(int var1, int var2, int var3, int var4, int var5, int[] var6);

    protected native long SQLGetLength(int var1, int var2, int var3, int[] var4);

    protected native int SQLGetByteArray(byte[] var1, int var2, int var3, int var4, long var5, int var7, int[] var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB2Blob(DB2Statement stmt, int loc, int type) throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "DB2Blob( stmt, " + loc + ", " + type + " )");
            }
            DB2Connection dB2Connection = this.connection = (DB2Connection)stmt.getConnection();
            synchronized (dB2Connection) {
                this.locator = loc;
                this.lobType = type;
                this.statement = this.connection.getInputStreamStmt();
                this.closed = false;
            }
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "DB2Blob()");
            }
        }
    }

    public DB2Blob(byte[] b2) {
        this.data = null == b2 ? new byte[0] : b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "close()");
            }
            this.closed = true;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "close()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "finalize()");
            }
            this.close();
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "finalize()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "length()");
            }
            if (this.cachedLength < 0L) {
                if (this.data != null) {
                    this.cachedLength = this.data.length;
                } else {
                    this.cachedLength = this.SQLGetLength(this.statement.statementHandle, this.locator, this.lobType, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            long l2 = this.cachedLength;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "length()", this.cachedLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBytes( " + pos + ", " + length + " )");
            }
            byte[] byteBuffer = null;
            if (this.data != null) {
                if (pos > (long)this.data.length || 0 == length) {
                    byteBuffer = new byte[]{};
                } else {
                    length = (int)Math.min((long)this.data.length - pos + 1L, (long)length);
                    byteBuffer = new byte[length];
                    System.arraycopy(this.data, (int)pos - 1, byteBuffer, 0, length);
                }
            } else {
                byteBuffer = new byte[length];
                int actualSize = this.SQLGetByteArray(byteBuffer, this.statement.statementHandle, this.lobType, this.locator, pos, length, this.retCode);
                if (this.retCode[0] != 0) {
                    this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                } else if (actualSize < length) {
                    byte[] tempBuffer = byteBuffer;
                    byteBuffer = new byte[actualSize];
                    System.arraycopy(tempBuffer, 0, byteBuffer, 0, actualSize);
                }
            }
            byte[] byArray = byteBuffer;
            return byArray;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit(this, "getBytes()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "getBinaryStream()");
            }
            if (this.data != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                return byteArrayInputStream;
            }
            DB2InputStream dB2InputStream = new DB2InputStream(this.statement, this.locator, this.lobType);
            return dB2InputStream;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "getBinaryStream()", "InputStream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] pattern, long start) throws SQLException {
        long pos = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern[], " + start + " )");
            }
            if (null == pattern || pattern.length == 0) {
                pos = -1L;
            } else if (this.data != null) {
                while (start + (long)pattern.length - 1L < (long)this.data.length) {
                    int j2;
                    int i2 = (int)start - 1;
                    for (j2 = 0; j2 < pattern.length && this.data[i2] == pattern[j2]; ++j2) {
                        ++i2;
                    }
                    if (pattern.length == j2) {
                        pos = start;
                    }
                    ++start;
                }
            } else {
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    pos = this.SQLGetBAPosition(this.statement.statementHandle, this.lobType, this.locator, pattern, pattern.length, (int)start, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            }
            long l2 = pos;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "position()", pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob pattern, long start) throws SQLException {
        long retValue = -1L;
        this.retCode[0] = 0;
        try {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodEntry(this, "position( pattern, " + start + " )");
            }
            if (pattern instanceof DB2Blob && ((DB2Blob)pattern).data == null && this.data == null) {
                Integer rc2 = new Integer(0);
                DB2Statement dB2Statement = this.statement;
                synchronized (dB2Statement) {
                    retValue = this.SQLGetBlobPosition(this.statement.statementHandle, this.lobType, this.locator, ((DB2Blob)pattern).getLocator(), (int)start, this.retCode);
                    if (this.retCode[0] != 0) {
                        this.connection.sqlExcptGen.check_return_code(this.statement, this.retCode[0]);
                    }
                }
            } else {
                long length = pattern.length();
                byte[] b2 = pattern.getBytes(0L, (int)length);
                retValue = this.position(b2, start);
            }
            long l2 = retValue;
            return l2;
        }
        finally {
            if (DB2Trace.TraceOn) {
                DB2Trace.methodExit((Object)this, "position()", retValue);
            }
        }
    }

    final int getLocator() {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "getLocator()");
            DB2Trace.methodExit((Object)this, "getLocator()", this.locator);
        }
        return this.locator;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setBytes()");
        return 0;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setBytes()");
        return 0;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("setBinaryStream()");
        return null;
    }

    public void truncate(long len) throws SQLException {
        this.connection.sqlExcptGen.throwNotSupportedByDB2("truncate()");
    }
}

