/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc.app;

import COM.ibm.db2.jdbc.app.DB2Binary2AsciiInputStream;
import COM.ibm.db2.jdbc.app.DB2Statement;
import java.io.IOException;
import java.sql.SQLException;

public class DB2Binary2UnicodeInputStream
extends DB2Binary2AsciiInputStream {
    private byte[] cvtBuffer;
    private int cvtBufPos = 0;
    private int cvtAvailable = 0;

    public DB2Binary2UnicodeInputStream(DB2Statement stmt, int loc, int type) throws SQLException {
        super(stmt, loc, type);
    }

    public int available() throws IOException {
        return super.available() * 2;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int m2) {
        super.mark(m2 / 2);
    }

    public void reset() throws IOException {
        super.reset();
    }

    private byte[] getData(int destLength) throws IOException {
        if (0 == destLength) {
            return null;
        }
        if (0 == this.cvtAvailable && !super.hasMore()) {
            return null;
        }
        if (this.cvtAvailable >= destLength) {
            byte[] retBuf = new byte[destLength];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, retBuf, 0, destLength);
            this.cvtAvailable -= destLength;
            this.cvtBufPos += destLength;
            return retBuf;
        }
        if (!super.hasMore()) {
            byte[] retBuf = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, retBuf, 0, this.cvtAvailable);
            this.cvtAvailable = 0;
            return retBuf;
        }
        byte[] leftOver = null;
        byte[] tmpBuffer = null;
        if (this.cvtAvailable != 0) {
            leftOver = new byte[this.cvtAvailable];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, leftOver, 0, this.cvtAvailable);
            tmpBuffer = new byte[(destLength - this.cvtAvailable) / 2];
        } else {
            tmpBuffer = new byte[destLength / 2];
        }
        int actualLength = super.read(tmpBuffer);
        if (actualLength > 0) {
            byte[] orgBuffer = new byte[actualLength];
            System.arraycopy(tmpBuffer, 0, orgBuffer, 0, actualLength);
            this.cvtBuffer = new byte[actualLength * 2];
            for (int t2 = 0; t2 < actualLength; ++t2) {
                this.cvtBuffer[t2 * 2] = 0;
                this.cvtBuffer[t2 * 2 + 1] = orgBuffer[t2];
            }
            this.cvtAvailable = this.cvtBuffer.length;
            this.cvtBufPos = 0;
            int retLength = this.cvtAvailable;
            if (leftOver != null) {
                byte[] retBuf = new byte[leftOver.length + retLength];
                System.arraycopy(leftOver, 0, retBuf, 0, leftOver.length);
                System.arraycopy(this.cvtBuffer, this.cvtBufPos, retBuf, leftOver.length, retLength);
                this.cvtBufPos += retLength;
                this.cvtAvailable -= retLength;
                return retBuf;
            }
            byte[] retBuf = new byte[retLength];
            System.arraycopy(this.cvtBuffer, this.cvtBufPos, retBuf, 0, retLength);
            this.cvtBufPos += retLength;
            this.cvtAvailable -= retLength;
            return retBuf;
        }
        return leftOver;
    }

    public int read() throws IOException {
        byte[] b2 = this.getData(1);
        if (b2 == null) {
            return -1;
        }
        if (b2[0] < 0) {
            return b2[0] + 256;
        }
        return b2[0];
    }

    public int read(byte[] b2) throws IOException {
        byte[] buf = this.getData(b2.length);
        if (buf == null) {
            return -1;
        }
        System.arraycopy(buf, 0, b2, 0, buf.length);
        return buf.length;
    }

    public int read(byte[] b2, int offset, int len) throws IOException {
        byte[] tmpBuf = this.getData(len);
        if (tmpBuf == null) {
            return -1;
        }
        System.arraycopy(b2, 0, tmpBuf, offset, tmpBuf.length);
        return tmpBuf.length;
    }
}

