/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import javax.transaction.xa.Xid;

public class DB2Xid
implements Xid {
    private int formatID;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data;
    private static final int XidDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab = "0123456789ABCDEF";

    public DB2Xid() {
        this.data = new byte[128];
        this.formatID = -1;
    }

    public DB2Xid(int formatID, byte[] gtrid, byte[] bqual) {
        this.formatID = formatID;
        this.gtrid_length = gtrid.length;
        this.bqual_length = bqual.length;
        this.data = new byte[128];
        System.arraycopy(gtrid, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(bqual, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int hashCode() {
        if (this.formatID == -1) {
            return -1;
        }
        return this.formatID + this.gtrid_length - this.bqual_length;
    }

    public String toString() {
        int L = this.gtrid_length + this.bqual_length;
        StringBuffer d2 = new StringBuffer(L + L);
        for (int i2 = 0; i2 < L; ++i2) {
            int v2 = this.data[i2] & 0xFF;
            d2.append(hextab.charAt(v2 / 16));
            d2.append(hextab.charAt(v2 & 0xF));
            if ((i2 + 1) % 4 != 0 || i2 + 1 >= L) continue;
            d2.append(" ");
        }
        String s2 = new String("{Xid: formatID(" + this.formatID + "), " + "gtrid_length(" + this.gtrid_length + "), " + "bqual_length(" + this.bqual_length + "), " + "data(" + d2 + ")" + "}");
        return s2;
    }

    public byte[] getBranchQualifier() {
        byte[] bqual = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, bqual, 0, this.bqual_length);
        return bqual;
    }

    public void setBranchQualifier(byte[] qual) {
        this.bqual_length = qual.length > 64 ? 64 : qual.length;
        System.arraycopy(qual, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int getFormatId() {
        return this.formatID;
    }

    public void setFormatID(int formatID) {
        this.formatID = formatID;
    }

    public byte[] getGlobalTransactionId() {
        byte[] gtrid = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, gtrid, 0, this.gtrid_length);
        return gtrid;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getGtridLength() {
        return this.gtrid_length;
    }

    public int getBqualLength() {
        return this.bqual_length;
    }
}

