/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.DB2XADataSource;
import COM.ibm.db2.jdbc.app.DB2Driver;
import COM.ibm.db2.jdbc.app.DB2XAResource;
import COM.ibm.db2.jdbc.app.SQLExceptionGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class DB2XAConnection
extends DB2PooledConnection
implements XAConnection {
    private DB2XADataSource db2ds = null;
    private byte[] xaResourcePtr = null;
    private XAResource xares = null;
    private boolean fFirstGetConnection = true;

    private native int xaConnect(int var1);

    private native int getXAResourcePtr();

    public DB2XAConnection(String databaseName, Properties info, DB2XADataSource ds) throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "DB2XAConnection( " + databaseName + ", " + "info, ds )");
        }
        this.db2ds = ds;
        int rc2 = this.xaConnect(DB2Driver.getJVMHenv());
        this.initialize(databaseName, info);
        if (rc2 != this.sqlSuccess) {
            ((SQLExceptionGenerator)this.sqlExcptGen).check_return_code(this.conApp, rc2);
        }
        if ((rc2 = this.getXAResourcePtr()) != this.sqlSuccess) {
            ((SQLExceptionGenerator)this.sqlExcptGen).check_return_code(this.conApp, rc2);
        }
        this.xares = new DB2XAResource(this, this.hdbc, this.xaResourcePtr);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "DB2XAConnection()");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.fFirstGetConnection) {
            this.fFirstGetConnection = false;
        } else {
            super.getConnection();
        }
        return this.conApp;
    }

    public XAResource getXAResource() throws SQLException {
        return this.xares;
    }

    void printToLog(String msg) {
        if (this.db2ds != null) {
            this.db2ds.printToLog(msg);
        }
    }
}

