/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.app.DB2Driver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class DB2Trace {
    protected static String NEWLINE = "\n";
    public static int TracePid = 0;
    protected static String jvmHenv = "";
    public static boolean TraceOn = false;
    public static boolean TraceFlush = false;
    protected static String TracePathName = "";
    protected static Hashtable threadTable = new Hashtable(43);
    protected static Stack timeStack = new Stack();
    protected static boolean fApplet = false;
    private static boolean fInitialized = false;
    protected StringBuffer sb = new StringBuffer("");
    protected FileWriter fw = null;
    protected String TraceThreadName = "";
    protected StringBuffer traceBuffer = new StringBuffer("");

    public DB2Trace() {
        this.DB2TraceApp();
    }

    public DB2Trace(int pid) {
        fApplet = false;
        TracePid = pid;
        try {
            jvmHenv = "_" + DB2Driver.getJVMHenv() + "_";
        }
        catch (Exception e2) {
            System.err.println(this.getClass().getName() + " - DB2Trace(pid) Error: " + e2.toString());
        }
        NEWLINE = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
        this.DB2TraceApp();
        fInitialized = true;
    }

    public void DB2TraceApp() {
        try {
            Properties systemProp = null;
            String tName = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
            final String TraceFileName = TracePid + jvmHenv + tName + ".trc";
            final String fTPath = TracePathName;
            try {
                systemProp = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return System.getProperties();
                    }
                });
                this.fw = (FileWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new FileWriter(new File(fTPath, TraceFileName).getAbsolutePath(), true);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            String sBuff = NEWLINE + "========================================================" + NEWLINE + "|    DB2 JDBC App Driver                                " + NEWLINE + "|                                                       " + NEWLINE + "|    Trace beginning on " + DB2Trace.getTimeStamp() + NEWLINE + "========================================================" + NEWLINE + NEWLINE + "System Properties:" + NEWLINE + "------------------" + NEWLINE;
            Enumeration<?> e2 = systemProp.propertyNames();
            while (e2.hasMoreElements()) {
                String pName;
                final String fName = pName = (String)e2.nextElement();
                String pValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperty(fName);
                    }
                });
                sBuff = sBuff + pName + " = " + pValue + NEWLINE;
            }
            sBuff = sBuff + "----------------------------------------" + NEWLINE + NEWLINE;
            threadTable.put(TraceFileName, this);
            TraceOn = true;
        }
        catch (Exception e3) {
            System.err.println(this.getClass().getName() + " - DB2TraceApp() Error: " + e3.toString());
        }
    }

    public static boolean isInitialized() {
        return fInitialized;
    }

    public static DB2Trace getTraceObj() {
        String tName = Thread.currentThread().getName().replace(' ', '_').replace(':', '_');
        String TraceFileName = null;
        DB2Trace obj = null;
        TraceFileName = fApplet ? tName + ".trc" : TracePid + jvmHenv + tName + ".trc";
        obj = (DB2Trace)threadTable.get(TraceFileName);
        if (obj == null) {
            obj = new DB2Trace();
        }
        return obj;
    }

    public static void setTraceOff() {
        TraceOn = false;
    }

    public static void setTraceOn() {
        TraceOn = true;
    }

    public static void setTraceFlush(boolean b2) {
        TraceFlush = b2;
    }

    public static void setTracePath(String s2) {
        TracePathName = s2;
    }

    public static long timer() {
        long msec = DB2Trace.timeInMilli();
        return msec;
    }

    public static double computeTimeDiff(long t1, long t2) {
        return (double)(t2 - t1) / 1000.0;
    }

    public static long timeInMilli() {
        long mtime = System.currentTimeMillis();
        return mtime;
    }

    public static String getTimeStamp() {
        Calendar c2 = Calendar.getInstance();
        int year = c2.get(1);
        int month = c2.get(2) + 1;
        int day = c2.get(5);
        int hour = c2.get(11);
        int minute = c2.get(12);
        int second = c2.get(13);
        int millisecond = c2.get(14);
        String timeStr = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second + "." + millisecond;
        return timeStr;
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (Exception e2) {
                System.err.println(this.getClass().getName() + " - close() Error: " + e2.toString());
            }
            this.fw = null;
        }
    }

    public void traceEntry(Object obj) {
        this.traceEntry(obj, "");
    }

    public void traceEntry(Object obj, String str) {
        if (obj != null) {
            this.traceEntry(obj.getClass().getName().substring(12), str);
        }
    }

    public void traceEntry(Object obj, String str, String strEntryTime) {
        if (obj != null) {
            this.traceEntry(obj.getClass().getName().substring(12), str, strEntryTime);
        }
    }

    public void traceEntry(String className, String str) {
        this.traceEntry(className, str, DB2Trace.getTimeStamp());
    }

    public void traceEntry(String className, String str, String strEntryTime) {
        this.println(className + " -> " + str + " (" + strEntryTime + ")");
        this.sb.append("| ");
    }

    public void traceExit(Object obj) {
        this.traceExit(obj, "");
    }

    public void traceExit(Object obj, String str) {
        this.traceExit(obj, str, "", -1.0);
    }

    public void traceExit(String className, String str) {
        this.traceExit(className, str, "", -1.0);
    }

    public void traceExit(Object obj, String str, String returnValue, double timeElapsed) {
        if (obj != null) {
            this.traceExit(obj.getClass().getName().substring(12), str, returnValue, timeElapsed, DB2Trace.getTimeStamp());
        }
    }

    public void traceExit(Object obj, String str, String returnValue, double timeElapsed, String strExitTime) {
        if (obj != null) {
            this.traceExit(obj.getClass().getName().substring(12), str, returnValue, timeElapsed, strExitTime);
        }
    }

    private void traceExit(String className, String str, String returnValue, double timeElapsed, String strExitTime) {
        int mLen = this.sb.length() - 2;
        if (mLen < 0) {
            mLen = 0;
        }
        this.sb.setLength(mLen);
        String newline = "";
        if (this.sb.length() == 0) {
            newline = NEWLINE;
        }
        this.println(className + " <- " + str + (returnValue == "" ? "" : " returns " + returnValue) + (timeElapsed == -1.0 ? "" : " [Time Elapsed = " + timeElapsed + "]") + (strExitTime == "" ? "" : " (" + strExitTime + ")") + newline);
    }

    public static void methodEntry(Object obj, String method) {
        if (TraceOn) {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            timeStack.push(ts);
            DB2Trace.getTraceObj().traceEntry(obj, method, ts.toString());
        }
    }

    public static void methodExit(Object obj, String method) {
        DB2Trace.methodExit(obj, method, "");
    }

    public static void methodExit(Object obj, String method, boolean returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, short returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, int returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, long returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, float returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, double returnValue) {
        DB2Trace.methodExit(obj, method, String.valueOf(returnValue));
    }

    public static void methodExit(Object obj, String method, String returnValue) {
        if (TraceOn) {
            Timestamp tsExitTime = new Timestamp(System.currentTimeMillis());
            Timestamp tsEntryTime = timeStack.empty() ? tsExitTime : (Timestamp)timeStack.pop();
            long entryTime = tsEntryTime.getTime() + (long)(tsEntryTime.getNanos() / 1000000);
            long exitTime = tsExitTime.getTime() + (long)(tsExitTime.getNanos() / 1000000);
            DB2Trace.getTraceObj().traceExit(obj, method, returnValue, DB2Trace.computeTimeDiff(entryTime, exitTime), tsExitTime.toString());
        }
    }

    public static void data(int tpoint, String varName, long value) {
        DB2Trace.data(tpoint, varName + " = " + value);
    }

    public static void data(int tpoint, String varName, int value) {
        DB2Trace.data(tpoint, varName + " = " + value);
    }

    public static void data(int tpoint, String varName, String value) {
        DB2Trace.data(tpoint, varName + " = " + value);
    }

    public static void data(int tpoint, String str) {
        if (TraceOn) {
            DB2Trace.getTraceObj().println(tpoint + ": " + str);
        }
    }

    public static String getNewline() {
        if (TraceOn) {
            return NEWLINE + DB2Trace.getTraceObj().sb.toString() + "| ";
        }
        return "";
    }

    public void println(String str, byte[] ba) {
        if (ba != null) {
            String bs = "";
            int max = Math.min(4096, ba.length);
            for (int i2 = 0; i2 < max; ++i2) {
                bs = bs + ba[i2];
            }
            this.println(str + bs);
        } else {
            this.println(str + "null");
        }
    }

    public void println(String str) {
        this.print(this.sb + str + NEWLINE);
    }

    public void print(String str) {
        if (str != null) {
            int sLen = str.length();
            if (sLen > 500) {
                String newStr = str.substring(0, 500);
                this.write(newStr + "(Truncated! Length was =" + sLen + ") " + NEWLINE);
            } else {
                this.write(str);
            }
        } else {
            this.print("null");
        }
    }

    public void write(String str) {
        this.writeToFile(str);
    }

    public void print(int i2) {
        String str = " " + i2;
        this.print(str);
    }

    public void println(int i2) {
        String str = " " + i2;
        this.println(str);
    }

    public void listProperties(Properties info) {
        if (fApplet || info == null) {
            return;
        }
        if (this.fw == null) {
            String comma = "";
            Enumeration<?> e2 = info.propertyNames();
            String sBuff = this.sb.toString();
            while (e2.hasMoreElements()) {
                String name = (String)e2.nextElement();
                String p2 = info.getProperty(name);
                if (name.equals("password")) {
                    p2 = "XXXXXX";
                }
                sBuff = sBuff + comma + name + " = " + p2;
                comma = ", ";
            }
            sBuff = sBuff + NEWLINE;
            this.writeToFile(sBuff);
        }
    }

    public static void flush() {
        if (TraceOn) {
            DB2Trace db2trace = DB2Trace.getTraceObj();
            db2trace.flushToFile();
        }
    }

    public boolean isFlushNeeded() {
        return this.traceBuffer.length() > 0;
    }

    private void writeToFile(String str) {
        if (this.fw == null) {
            return;
        }
        try {
            final String finalStr = str;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    DB2Trace.this.fw.write(finalStr);
                    if (TraceFlush) {
                        DB2Trace.this.fw.flush();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e2 = pae.getException();
            System.err.println(this.getClass().getName() + " - writeToFile() Error: " + e2.toString());
            this.fw = null;
        }
    }

    private void flushToFile() {
        if (this.fw == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    DB2Trace.this.fw.flush();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e2 = pae.getException();
            System.err.println(this.getClass().getName() + " - flushToFile() Error: " + e2.toString());
            this.fw = null;
        }
    }
}

