/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2BaseDataSource;
import COM.ibm.db2.jdbc.DB2ConnectionPool;
import COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DB2DataSource
extends DB2BaseDataSource
implements DataSource {
    static final long serialVersionUID = 5015223647496639101L;
    private transient DB2ConnectionPool pool;
    private DB2ConnectionPoolDataSource cpds = new DB2ConnectionPoolDataSource();

    public void setDatabaseName(String databaseName) {
        super.setDatabaseName(databaseName);
        this.cpds.setDatabaseName(databaseName);
    }

    public void setServerName(String serverName) {
        super.setServerName(serverName);
        this.cpds.setServerName(serverName);
    }

    public void setPortNumber(int portNumber) {
        super.setPortNumber(portNumber);
        this.cpds.setPortNumber(portNumber);
    }

    public void setConnectionAttribute(String attr) {
        super.setConnectionAttribute(attr);
        this.cpds.setConnectionAttribute(attr);
    }

    public void setFullyMaterializeLobData(boolean materialize) {
        super.setFullyMaterializeLobData(materialize);
        this.cpds.setFullyMaterializeLobData(materialize);
    }

    public Connection getConnection() throws SQLException {
        this.printToLog("getConnection() with no user or password");
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        PooledConnection pc2;
        this.printToLog("getConnection(): user = " + user);
        if (null == this.pool) {
            this.pool = new DB2ConnectionPool();
        }
        if ((pc2 = this.pool.lookup(user, password)) == null) {
            pc2 = this.cpds.getPooledConnection(user, password);
            pc2.addConnectionEventListener(this.pool);
        }
        return pc2.getConnection();
    }

    public void finalize() throws SQLException {
        this.pool.clear();
        this.pool = null;
        this.cpds = null;
    }
}

