/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2ConnectionInfo;
import COM.ibm.db2.jdbc.DB2PooledConnection;
import COM.ibm.db2.jdbc.DB2Trace;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

class DB2ConnectionPool
implements ConnectionEventListener {
    private DB2ConnectionInfo[] connectionList = new DB2ConnectionInfo[1024];
    private int numConnections = 0;
    private int lastEntryChecked = -1;

    DB2ConnectionPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent event) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionClosed( event )");
        }
        DB2PooledConnection pooledConnection = (DB2PooledConnection)event.getSource();
        int pooledConnectionID = pooledConnection.getID();
        if (DB2Trace.TraceOn) {
            DB2Trace.data(10, "numConnections", this.numConnections);
        }
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (pooledConnectionID > 0) {
                this.connectionList[pooledConnectionID - 1].setAvailable(true);
            } else if (this.numConnections < this.connectionList.length) {
                this.connectionList[this.numConnections] = new DB2ConnectionInfo();
                this.connectionList[this.numConnections].setPooledConnection(pooledConnection);
                ++this.numConnections;
                pooledConnection.setID(this.numConnections);
            } else {
                for (int i2 = 0; i2 < this.numConnections; ++i2) {
                    if (this.connectionList[i2].isValid() || !this.connectionList[i2].isAvailable()) continue;
                    pooledConnection.setID(i2 + 1);
                    this.connectionList[i2].setPooledConnection(pooledConnection);
                    this.connectionList[i2].setAvailable(true);
                    break;
                }
                if (pooledConnection.getID() == 0) {
                    try {
                        pooledConnection.close();
                    }
                    catch (SQLException sqle) {
                        // empty catch block
                    }
                }
            }
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionClosed()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "connectionErrorOccurred( event )");
        }
        DB2PooledConnection pooledConnection = (DB2PooledConnection)event.getSource();
        int pooledConnectionID = pooledConnection.getID();
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (pooledConnectionID != 0) {
                this.connectionList[pooledConnectionID - 1].setInvalid();
            }
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException e2) {
            // empty catch block
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "connectionErrorOccurred()");
        }
    }

    PooledConnection lookup(String userid, String password) {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "lookup()");
        }
        PooledConnection pooledConnection = null;
        int firstEntry = this.lastEntryChecked + 1;
        pooledConnection = this.searchList(firstEntry, this.numConnections, userid, password);
        if (pooledConnection == null) {
            pooledConnection = this.searchList(0, firstEntry, userid, password);
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "lookup()");
        }
        return pooledConnection;
    }

    synchronized PooledConnection searchList(int start, int end, String userid, String password) {
        int i2;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "searchList( " + start + ", " + end + ", " + userid + ", <password> )");
        }
        DB2ConnectionInfo conInfo = null;
        DB2PooledConnection pooledConnection = null;
        if (null == userid) {
            userid = "";
        }
        if (null == password) {
            password = "";
        }
        for (i2 = start; i2 < end; ++i2) {
            this.lastEntryChecked = i2;
            conInfo = this.connectionList[i2];
            if (!conInfo.isAvailable() || !conInfo.isValid()) continue;
            pooledConnection = (DB2PooledConnection)conInfo.getPooledConnection();
            if (userid.equals(pooledConnection.info.getProperty("user", "")) && password.equals(pooledConnection.info.getProperty("password", ""))) {
                conInfo.setAvailable(false);
                break;
            }
            pooledConnection = null;
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit((Object)this, "searchList()", pooledConnection == null ? "null" : "PooledConnection(id=" + (i2 + 1) + ")");
        }
        return pooledConnection;
    }

    synchronized void clear() throws SQLException {
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "clear()");
        }
        DB2ConnectionInfo conInfo = null;
        for (int i2 = 0; i2 < this.numConnections; ++i2) {
            conInfo = this.connectionList[i2];
            if (!conInfo.isValid()) continue;
            conInfo.getPooledConnection().close();
            conInfo.setInvalid();
        }
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "clear()");
        }
    }
}

