/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.jdbc;

import COM.ibm.db2.jdbc.DB2Trace;
import COM.ibm.db2.jdbc.app.DB2Driver;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class DB2BaseDataSource
implements Referenceable,
Serializable {
    static final long serialVersionUID = -3058333050951489179L;
    static final String logSource = "DB2 - ";
    private transient PrintWriter log = null;
    private int timeout = 0;
    protected String databaseName = null;
    protected String serverName = null;
    protected int portNumber = 0;
    protected String description = null;
    protected transient String password = null;
    protected transient String user = null;
    protected boolean fullyMaterializeLobData = false;
    protected String connectionAttribute = null;
    protected String language = null;

    public DB2BaseDataSource() {
        Locale locale = Locale.getDefault();
        String country = locale.getCountry();
        String javaLang = locale.getLanguage();
        this.language = javaLang.substring(0, 1).toUpperCase() + javaLang.substring(1, 2) + "_" + country;
    }

    public void setDatabaseName(String name) {
        this.printToLog("setDatabaseName(): " + name);
        this.databaseName = name;
    }

    public String getDatabaseName() {
        this.printToLog("getDatabaseName(): " + this.databaseName);
        return this.databaseName;
    }

    public void setServerName(String name) {
        this.printToLog("setServerName(): " + name);
        this.serverName = name;
    }

    public String getServerName() {
        this.printToLog("getServerName(): " + this.serverName);
        return this.serverName;
    }

    public void setPortNumber(int number) {
        this.printToLog("setPortNumber(): " + number);
        this.portNumber = number;
    }

    public int getPortNumber() {
        this.printToLog("getPortNumber(): " + this.portNumber);
        return this.portNumber;
    }

    public void setDescription(String d2) {
        this.printToLog("setDescription(): " + d2);
        this.description = d2;
    }

    public String getDescription() {
        this.printToLog("getDescription(): " + this.description);
        return this.description;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getPassword() {
        return "";
    }

    public void setUser(String user) {
        this.printToLog("setUser(): " + user);
        this.user = user;
    }

    public String getUser() {
        this.printToLog("getUser(): " + this.user);
        return this.user;
    }

    public void setConnectionAttribute(String attr) {
        this.printToLog("setConnectionAttribute(): " + attr);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setConnectionAttribute( " + attr + " )");
        }
        this.connectionAttribute = attr;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setConnectionAttribute()");
        }
    }

    public String getConnectionAttribute() {
        this.printToLog("getConnectionAttribute(): " + this.connectionAttribute);
        return this.connectionAttribute;
    }

    public void setLanguage(String lang) {
        this.printToLog("setLanguage(): " + lang);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLanguage( " + lang + " )");
        }
        this.language = lang;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLanguage()");
        }
    }

    public String getLanguage() {
        this.printToLog("getLanguage(): " + this.language);
        return this.language;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.printToLog("setLoginTimeout(): " + seconds);
        if (DB2Trace.TraceOn) {
            DB2Trace.methodEntry(this, "setLoginTimeout( " + seconds + " )");
        }
        this.timeout = seconds;
        if (DB2Trace.TraceOn) {
            DB2Trace.methodExit(this, "setLoginTimeout()");
        }
    }

    public int getLoginTimeout() throws SQLException {
        this.printToLog("getLoginTimeout(): " + this.timeout);
        return this.timeout;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName() + "Factory", null);
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        ref.add(new StringRefAddr("serverName", this.serverName));
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        return ref;
    }

    public void setFullyMaterializeLobData(boolean materialize) {
        this.printToLog("setFullyMaterializeLobData(): " + materialize);
        this.fullyMaterializeLobData = materialize;
    }

    public boolean getFullyMaterializeLobData() {
        this.printToLog("getFullyMaterializeLobData(): " + this.fullyMaterializeLobData);
        return this.fullyMaterializeLobData;
    }

    public String toString() {
        String newline = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
        String stringForm = "class               = " + this.getClass().getName();
        stringForm = stringForm + newline + "serverName          =";
        if (this.serverName != null) {
            stringForm = stringForm + " " + this.serverName;
        }
        stringForm = stringForm + newline + "portNumber          = " + this.portNumber;
        stringForm = stringForm + "\ndatabaseName        =";
        if (this.databaseName != null) {
            stringForm = stringForm + " " + this.databaseName;
        }
        stringForm = stringForm + newline + "user                =";
        if (this.user != null) {
            stringForm = stringForm + " " + this.user;
        }
        stringForm = stringForm + newline + "password            =";
        if (this.password != null) {
            stringForm = stringForm + "XXXXXXX";
        }
        stringForm = stringForm + newline + "connectionAttribute =";
        if (this.connectionAttribute != null) {
            stringForm = stringForm + " " + this.connectionAttribute;
        }
        stringForm = stringForm + newline + "language            =";
        if (this.language != null) {
            stringForm = stringForm + " " + this.language;
        }
        return stringForm;
    }

    protected void loadDLL() throws SQLException {
        if (this.isLoaded()) {
            DB2Driver dB2Driver = new DB2Driver();
        }
    }

    protected boolean isLoaded() {
        return DB2Driver.loaded;
    }

    void printToLog(String msg) {
        if (this.log != null) {
            this.log.println(logSource + msg);
        }
    }
}

