/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.File;

class FileDependency
implements Validatable {
    long timeStamp;
    File file;

    FileDependency(File file) {
        this.file = file;
        this.timeStamp = this.file.lastModified();
    }

    @Override
    public void validate() throws InvalidationException {
        if (!this.file.exists()) {
            throw new InvalidationException("FileDependency was invalidated", this.file.getAbsolutePath() + " has been deleted");
        }
        if (this.timeStamp != this.file.lastModified()) {
            throw new InvalidationException("FileDependency was invalidated", this.file.getAbsolutePath() + " has been updated");
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }
}

