/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app.classloader;

import COM.ibm.db2.app.classloader.ClassLoaderResource;
import COM.ibm.db2.app.classloader.ClassProvider;
import COM.ibm.db2.app.classloader.FileDependency;
import COM.ibm.db2.app.classloader.FileResource;
import COM.ibm.db2.app.classloader.NilResource;
import COM.ibm.db2.app.util.InvalidationException;
import COM.ibm.db2.app.util.Validatable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DirClassProvider
implements ClassProvider,
Validatable {
    File directory;
    Hashtable dependency;
    long timeStamp;

    public DirClassProvider(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(this.directory.getAbsolutePath() + " is not a directory");
        }
        this.directory = file;
        this.dependency = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getClassBytes(String string) {
        FileInputStream fileInputStream = null;
        FilterInputStream filterInputStream = null;
        byte[] byArray = null;
        try {
            string = string.replace('.', '/');
            String string2 = this.getRealResourcePath(string + ".class");
            File file = new File(string2);
            fileInputStream = new FileInputStream(file);
            filterInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[(int)file.length()];
            ((DataInputStream)filterInputStream).readFully(byArray);
            this.addDependency(string, file);
        }
        catch (Exception exception) {
            byArray = null;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                    filterInputStream = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    @Override
    public boolean hasResource(String string) {
        try {
            string = string.replace('/', File.separatorChar);
            String string2 = this.getRealResourcePath(string);
            File file = new File(string2);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getAbsoluteResourcePath(String string) {
        if (this.hasResource(string)) {
            return this.getRealResourcePath(string);
        }
        return null;
    }

    @Override
    public ClassLoaderResource getResource(String string) {
        try {
            if (this.hasResource(string)) {
                string = this.getRealResourcePath(string);
                File file = new File(string);
                this.addDependency(string, file);
                FileResource fileResource = new FileResource(file);
                return fileResource;
            }
            return null;
        }
        catch (Exception exception) {
            return NilResource.instance();
        }
    }

    @Override
    public void validate() throws InvalidationException {
        Enumeration enumeration = this.dependency.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            FileDependency fileDependency = (FileDependency)this.dependency.get(string);
            fileDependency.validate();
        }
    }

    @Override
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (InvalidationException invalidationException) {
            return false;
        }
    }

    void addDependency(String string, File file) {
        this.dependency.put(string, new FileDependency(file));
    }

    String getRealResourcePath(String string) {
        String string2;
        String string3;
        int n2 = string.lastIndexOf("/");
        if (string.startsWith("/")) {
            string = string.substring(0);
        }
        if (n2 == -1) {
            string3 = string;
            string2 = this.directory.getPath();
        } else {
            string3 = string.substring(n2 + 1);
            string2 = string.substring(0, n2);
            if (string2.startsWith("/")) {
                string2 = string2.substring(0);
            }
            string2 = string2.equals("") ? this.directory.getPath() : this.directory.getPath() + File.separator + string2;
        }
        string2 = string2.replace('/', File.separatorChar);
        return string2 + File.separator + string3;
    }

    @Override
    public String getClassPath() {
        return this.directory.getAbsolutePath();
    }

    @Override
    public Enumeration findResources(String string) {
        URL uRL;
        ClassLoaderResource classLoaderResource = this.getResource(string);
        Vector<URL> vector = new Vector<URL>(1);
        if (classLoaderResource != null && (uRL = classLoaderResource.getResourceURL()) != null) {
            vector.add(uRL);
        }
        return vector.elements();
    }
}

