/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.IPlatformLibrary;
import com.tridium.platform.NativePlatformLibraryTridium;
import com.tridium.platform.timezone.BDstSupportLevel;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSystemPlatformServiceWin32
extends BSystemPlatformService {
    public static final Type TYPE;
    private static long lastFileCheck;
    private static final IPlatformLibrary _PLATFORM_LIBRARY_INSTANCE;
    protected String[] fileSystems;
    protected Property[] filesystemProps;
    static /* synthetic */ Class class$com$tridium$platform$win32$BSystemPlatformServiceWin32;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        BSystemPlatformServiceWin32.startThreadDumpListener0(Sys.getStationHome().getName());
        this.loadFileSystems();
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        this.setNumCpus(iPlatformLibrary.getNumberCPUs());
    }

    void loadFileSystems() {
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.fileSystems = iPlatformLibrary.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        int n = 0;
        while (n < this.fileSystems.length) {
            BFilesystemAttributes bFilesystemAttributes = new BFilesystemAttributes(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getBlockSize(this.fileSystems[n]));
            this.filesystemProps[n] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[n]), (BValue)bFilesystemAttributes, 3);
            ++n;
        }
    }

    public String makeRootName(String string) {
        return string + '\\';
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        if (context != null && context.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(context);
        long l = Clock.ticks();
        if (l - lastFileCheck > 15000L) {
            lastFileCheck = l;
            int n = 0;
            while (n < this.fileSystems.length) {
                BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[n]);
                bFilesystemAttributes.setFreeSpace(iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L);
                bFilesystemAttributes.setTotalSpace(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L);
                bFilesystemAttributes.setBlockSize(iPlatformLibrary.getBlockSize(this.fileSystems[n]));
                ++n;
            }
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"SystemPlatformServiceWin32", 2);
        if (this.isProxy()) {
            spyWriter.prop((Object)"lastErrorMessage", (Object)"remote");
            spyWriter.prop((Object)"systemDir", (Object)"remote");
        } else if (NativePlatformLibraryTridium.load()) {
            spyWriter.prop((Object)"systemDir", (Object)BSystemPlatformServiceWin32.getSystemDirectory0());
            spyWriter.prop((Object)"lastErrorMessage", (Object)this.getPlatformLibrary().getLastErrorMessage());
        }
        spyWriter.endProps();
    }

    public IPlatformLibrary getPlatformLibrary() {
        if (!NativePlatformLibraryTridium.load()) {
            return null;
        }
        return _PLATFORM_LIBRARY_INSTANCE;
    }

    private static final native void startThreadDumpListener0(String var0);

    private static final native void stopThreadDumpListener0(String var0);

    private static final native String getSystemDirectory0();

    public static void main(String[] stringArray) {
        try {
            System.out.println("Platform Service Test");
            NativePlatformLibraryTridium.load();
            System.out.println("Natives loaded");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BSystemPlatformServiceWin32() {
        this.setTimezoneDayModeSupport(BDstSupportLevel.nthWeekday);
    }

    static {
        Class clazz = class$com$tridium$platform$win32$BSystemPlatformServiceWin32;
        if (clazz == null) {
            clazz = class$com$tridium$platform$win32$BSystemPlatformServiceWin32 = BSystemPlatformServiceWin32.class("[Lcom.tridium.platform.win32.BSystemPlatformServiceWin32;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lastFileCheck = 0L;
        _PLATFORM_LIBRARY_INSTANCE = new NativePlatformLibraryTridium();
    }
}

