/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.IPlatformLibrary;
import com.tridium.platform.NativePlatformLibraryTridium;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.ZipArchive;
import com.tridium.platform.ewf.BEwfBootCommand;
import com.tridium.platform.ewf.BEwfEnableState;
import com.tridium.platform.ewf.BEwfOverlayAttributes;
import com.tridium.platform.win32.BSystemPlatformServiceWin32;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSystemPlatformServiceNxs
extends BSystemPlatformServiceWin32 {
    public static final Property osOverlayAttributes = BSystemPlatformServiceNxs.newProperty((int)3, (BValue)new BEwfOverlayAttributes(), null);
    public static final Property historyOverlayAttributes = BSystemPlatformServiceNxs.newProperty((int)1, (BValue)new BEwfOverlayAttributes(), null);
    public static final Property lowHistorySpaceAlarmSupport = BSystemPlatformServiceNxs.newProperty((int)0, (BValue)BSystemPlatformServiceNxs.initLowHistorySpaceAlarmSupport(), null);
    public static final Property lowHistorySpaceAlarmProxy = BSystemPlatformServiceNxs.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property lowHistorySpaceThreshold = BSystemPlatformServiceNxs.newProperty((int)0, (int)80, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Action setCommitDriveC = BSystemPlatformServiceNxs.newAction((int)0, null);
    public static final Action setEnableDriveC = BSystemPlatformServiceNxs.newAction((int)0, null);
    public static final Action setCommitAndDisableDriveC = BSystemPlatformServiceNxs.newAction((int)0, null);
    public static final Action setNoCmdDriveC = BSystemPlatformServiceNxs.newAction((int)0, null);
    public static final Type TYPE;
    public static final char EWF_OS_DRIVE = 'C';
    public static final char EWF_HISTORY_DRIVE = 'E';
    static final int EWF_NO_CMD = 0;
    static final int EWF_ENABLE = 1;
    static final int EWF_DISABLE = 2;
    static final int EWF_SET_LEVEL = 3;
    static final int EWF_COMMIT = 4;
    private static long lastEwfCheck;
    private static final String ALARM_TYPE_HISTORY_SPACE = "history storage space";
    public static Log log;
    protected boolean nowHistorySpaceOk;
    protected boolean lastHistorySpaceOk;
    long totalDriveSize;
    long freeDriveSize;
    static /* synthetic */ Class class$com$tridium$platform$win32$BSystemPlatformServiceNxs;

    public BEwfOverlayAttributes getOsOverlayAttributes() {
        return (BEwfOverlayAttributes)this.get(osOverlayAttributes);
    }

    public void setOsOverlayAttributes(BEwfOverlayAttributes bEwfOverlayAttributes) {
        this.set(osOverlayAttributes, (BValue)bEwfOverlayAttributes, null);
    }

    public BEwfOverlayAttributes getHistoryOverlayAttributes() {
        return (BEwfOverlayAttributes)this.get(historyOverlayAttributes);
    }

    public void setHistoryOverlayAttributes(BEwfOverlayAttributes bEwfOverlayAttributes) {
        this.set(historyOverlayAttributes, (BValue)bEwfOverlayAttributes, null);
    }

    public BPlatformAlarmSupport getLowHistorySpaceAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(lowHistorySpaceAlarmSupport);
    }

    public void setLowHistorySpaceAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(lowHistorySpaceAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getLowHistorySpaceAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(lowHistorySpaceAlarmProxy);
    }

    public void setLowHistorySpaceAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(lowHistorySpaceAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public int getLowHistorySpaceThreshold() {
        return this.getInt(lowHistorySpaceThreshold);
    }

    public void setLowHistorySpaceThreshold(int n) {
        this.setInt(lowHistorySpaceThreshold, n, null);
    }

    public void setCommitDriveC() {
        this.invoke(setCommitDriveC, null, null);
    }

    public void setEnableDriveC() {
        this.invoke(setEnableDriveC, null, null);
    }

    public void setCommitAndDisableDriveC() {
        this.invoke(setCommitAndDisableDriveC, null, null);
    }

    public void setNoCmdDriveC() {
        this.invoke(setNoCmdDriveC, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.totalDriveSize = iPlatformLibrary.getTotalBytes("E:");
        this.freeDriveSize = iPlatformLibrary.getFreeBytes("E:");
        this.lastHistorySpaceOk = this.freeDriveSize / this.totalDriveSize >= (long)this.getLowHistorySpaceThreshold();
        this.getLowHistorySpaceAlarmProxy().setAlarmSupport(this.getLowHistorySpaceAlarmSupport());
        this.pollForEwfValues();
        try {
            BSystemPlatformServiceNxs.ewfCommand0('E', 4);
        }
        catch (Exception exception) {
            this.getOsOverlayAttributes().setBootCommand(BEwfBootCommand.unknown);
            this.getHistoryOverlayAttributes().setBootCommand(BEwfBootCommand.unknown);
            BPlatform.log.error("Unable to set COMMIT command on protected volume");
        }
    }

    void loadFileSystems() {
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.fileSystems = iPlatformLibrary.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        int n = 0;
        while (n < this.fileSystems.length) {
            log.trace("EWF OVERLAY for " + this.fileSystems[n] + " : " + (Object)((Object)this.getOverlayStateEwf(this.fileSystems[n].charAt(0))));
            boolean bl = !this.getOverlayStateEwf(this.fileSystems[n].charAt(0)).equals((Object)BEwfEnableState.enabled);
            this.filesystemProps[n] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[n]), (BValue)new BFilesystemAttributes(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getBlockSize(this.fileSystems[n]), bl), 3);
            ++n;
        }
    }

    public void doPoll(Context context) {
        long l;
        if (!this.isRunning()) {
            return;
        }
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        super.doPoll(context);
        if ((context == null || context.getFacets().getb("memory", true)) && (l = Clock.ticks()) - lastEwfCheck > 15000L) {
            lastEwfCheck = l;
            this.pollForEwfValues();
            this.freeDriveSize = iPlatformLibrary.getFreeBytes("E:");
            this.nowHistorySpaceOk = this.freeDriveSize / this.totalDriveSize >= (long)this.getLowHistorySpaceThreshold();
            if (this.nowHistorySpaceOk != this.lastHistorySpaceOk) {
                if (!this.nowHistorySpaceOk && this.lastHistorySpaceOk) {
                    log.trace("History Space is LOW");
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getLowHistorySpaceAlarmSupport().makeNewFaultAlarm();
                    this.getLowHistorySpaceAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else if (this.nowHistorySpaceOk && !this.lastHistorySpaceOk) {
                    log.trace("History Space is OK");
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getLowHistorySpaceAlarmSupport().makeToNormal();
                    this.getLowHistorySpaceAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
        }
    }

    public BEwfEnableState getOsOverlayState() {
        return this.getOsOverlayAttributes().getEnableState();
    }

    public BEwfBootCommand getOsOverlayCommand() {
        return this.getOsOverlayAttributes().getBootCommand();
    }

    public double getOsOverlayRamUsage() {
        return this.getOsOverlayAttributes().getRamUsage();
    }

    public BEwfEnableState getHistoryOverlayState() {
        return this.getHistoryOverlayAttributes().getEnableState();
    }

    public BEwfBootCommand getHistoryOverlayCommand() {
        return this.getHistoryOverlayAttributes().getBootCommand();
    }

    public double getHistoryOverlayRamUsage() {
        return this.getHistoryOverlayAttributes().getRamUsage();
    }

    private final void pollForEwfValues() {
        this.getOsOverlayAttributes().setRamUsage(this.getOverlayRamUsageEwf('C'));
        this.getOsOverlayAttributes().setBootCommand(this.getOverlayCommandEwf('C'));
        this.getOsOverlayAttributes().setEnableState(this.getOverlayStateEwf('C'));
        this.getHistoryOverlayAttributes().setRamUsage(this.getOverlayRamUsageEwf('E'));
        this.getHistoryOverlayAttributes().setBootCommand(this.getOverlayCommandEwf('E'));
        this.getHistoryOverlayAttributes().setEnableState(this.getOverlayStateEwf('E'));
        log.trace("OS Overlay RAM Usage:" + this.getOsOverlayRamUsage() + " MB");
        log.trace("OS Overlay Command:" + (Object)((Object)this.getOsOverlayCommand()));
        log.trace("OS Overlay State:" + (Object)((Object)this.getOsOverlayState()));
        log.trace("History Overlay RAM Usage:" + this.getHistoryOverlayRamUsage() + " MB");
        log.trace("History Overlay Command:" + (Object)((Object)this.getHistoryOverlayCommand()));
        log.trace("History Overlay State:" + (Object)((Object)this.getHistoryOverlayState()));
    }

    public void updateWatchdog(String string, int n, int n2, int n3) {
    }

    public double getOverlayRamUsageEwf(char c) {
        if (!NativePlatformLibraryTridium.load()) {
            return -1.0;
        }
        try {
            return (double)BSystemPlatformServiceNxs.getOverlayRamUsage0(c) / 1048576.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public BEwfBootCommand getOverlayCommandEwf(char c) {
        if (!NativePlatformLibraryTridium.load()) {
            return BEwfBootCommand.unknown;
        }
        try {
            return BEwfBootCommand.make(BSystemPlatformServiceNxs.getOverlayCommand0(c));
        }
        catch (Exception exception) {
            return BEwfBootCommand.unknown;
        }
    }

    public BEwfEnableState getOverlayStateEwf(char c) {
        if (!NativePlatformLibraryTridium.load()) {
            return BEwfEnableState.unknown;
        }
        try {
            return BEwfEnableState.make(BSystemPlatformServiceNxs.getOverlayState0(c));
        }
        catch (Exception exception) {
            return BEwfEnableState.unknown;
        }
    }

    public void doSetCommitDriveC() {
        if (!NativePlatformLibraryTridium.load()) {
            log.error("Could not load library when setting commit on drive C");
            return;
        }
        try {
            BSystemPlatformServiceNxs.ewfCommand0('C', 4);
        }
        catch (Exception exception) {
            log.error("exception setting commit on drive C", (Throwable)exception);
        }
    }

    public void doSetEnableDriveC() {
        if (!NativePlatformLibraryTridium.load()) {
            log.error("Could not load library when setting enable on drive C");
            return;
        }
        try {
            BSystemPlatformServiceNxs.ewfCommand0('C', 1);
        }
        catch (Exception exception) {
            log.error("exception setting enable on drive C", (Throwable)exception);
        }
    }

    public void doSetEnableDriveE() {
        if (!NativePlatformLibraryTridium.load()) {
            log.error("Could not load library when setting enable on drive E");
            return;
        }
        try {
            BSystemPlatformServiceNxs.ewfCommand0('E', 1);
        }
        catch (Exception exception) {
            log.error("exception setting enable on drive E", (Throwable)exception);
        }
    }

    public void doSetCommitAndDisableDriveC() {
        if (!NativePlatformLibraryTridium.load()) {
            log.error("Could not load library when setting commitAndDisable on drive C");
            return;
        }
        try {
            BSystemPlatformServiceNxs.ewfCommand0('C', 2);
        }
        catch (Exception exception) {
            log.error("exception setting commitAndDisable on drive C", (Throwable)exception);
        }
    }

    public void doSetNoCmdDriveC() {
        if (!NativePlatformLibraryTridium.load()) {
            log.error("Could not load library when setting noCmd on drive C");
            return;
        }
        try {
            BSystemPlatformServiceNxs.ewfCommand0('C', 0);
        }
        catch (Exception exception) {
            log.error("exception setting noCmd on drive C", (Throwable)exception);
        }
    }

    public boolean archiveEnabled(String string) {
        return true;
    }

    public FileArchive createFileArchive(String string) {
        String string2 = Sys.getStationHome().getPath() + '/' + string;
        String string3 = string + ".zip";
        File file = new File(Sys.getStationHome().getPath() + '/' + string);
        file.mkdir();
        return new ZipArchive(string2, string3, 1);
    }

    public synchronized void extractArchive(String string) {
        File file = new File("/E:/" + Sys.getStation().getStationName());
        file.mkdir();
        File file2 = new File("/E:/" + Sys.getStation().getStationName() + '/' + string);
        file2.mkdir();
        try {
            ZipArchive.unzip(Sys.getStationHome().getPath() + '/' + string, string + ".zip", "/E:/" + Sys.getStation().getStationName() + '/' + string);
        }
        catch (IOException iOException) {
            log.error("unable to unzip archive to runtime overlay");
        }
    }

    public String getRuntimeDirectory(String string) {
        return "/E:/" + Sys.getStation().getStationName() + '/' + string;
    }

    static BPlatformAlarmSupport initLowHistorySpaceAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platform:platformNxs.historySpaceLow)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platform:platformNxs.historySpaceOk)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_HISTORY_SPACE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    private static final native long getOverlayRamUsage0(char var0) throws Exception;

    private static final native int getOverlayCommand0(char var0) throws Exception;

    private static final native int getOverlayState0(char var0) throws Exception;

    protected static native boolean ewfCommand0(char var0, int var1) throws Exception;

    private static final native long dumpEwfProtectedVolumeList0();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$platform$win32$BSystemPlatformServiceNxs;
        if (clazz == null) {
            clazz = class$com$tridium$platform$win32$BSystemPlatformServiceNxs = BSystemPlatformServiceNxs.class("[Lcom.tridium.platform.win32.BSystemPlatformServiceNxs;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lastEwfCheck = 0L;
        log = Log.getLog((String)"platform.nxs");
    }
}

