/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.platform.ntp.BNtpMode;
import com.tridium.platform.ntp.BNtpServer;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNtpServerWin32
extends BNtpServer {
    public static final Property useSpecialPollInterval = BNtpServerWin32.newProperty((int)3, (boolean)false, null);
    public static final Property fallbackOnly = BNtpServerWin32.newProperty((int)3, (boolean)false, null);
    public static final Property peerMode = BNtpServerWin32.newProperty((int)3, (BValue)BNtpMode.unspecified, null);
    public static final Type TYPE;
    protected static final int FLAG_USE_SPECIAL_POLL_INTERVAL = 1;
    protected static final int FLAG_FALLBACK_ONLY = 2;
    protected static final int FLAG_SYMMETRIC_ACTIVE_MODE = 4;
    protected static final int FLAG_CLIENT_MODE = 8;
    protected String serverString;
    static /* synthetic */ Class class$com$tridium$platform$win32$BNtpServerWin32;

    public boolean getUseSpecialPollInterval() {
        return this.getBoolean(useSpecialPollInterval);
    }

    public void setUseSpecialPollInterval(boolean bl) {
        this.setBoolean(useSpecialPollInterval, bl, null);
    }

    public boolean getFallbackOnly() {
        return this.getBoolean(fallbackOnly);
    }

    public void setFallbackOnly(boolean bl) {
        this.setBoolean(fallbackOnly, bl, null);
    }

    public BNtpMode getPeerMode() {
        return (BNtpMode)this.get(peerMode);
    }

    public void setPeerMode(BNtpMode bNtpMode) {
        this.set(peerMode, (BValue)bNtpMode, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNtpServer makeServer(String string) {
        return new BNtpServerWin32(string);
    }

    public void updateServerString(String string) {
        this.serverString = string;
        int n = string.indexOf(44);
        if (n < 0) {
            this.setAddress(string);
        } else {
            this.setAddress(string.substring(0, n));
            int n2 = TextUtil.hexCharToInt((char)string.charAt(string.length() - 1));
            boolean bl = false;
            if ((n2 & 1) > 0) {
                bl = true;
            }
            this.setUseSpecialPollInterval(bl);
            boolean bl2 = false;
            if ((n2 & 2) > 0) {
                bl2 = true;
            }
            this.setFallbackOnly(bl2);
            if ((n2 & 4) > 0) {
                this.setPeerMode(BNtpMode.symmetricActive);
            } else if ((n2 & 8) > 0) {
                this.setPeerMode(BNtpMode.client);
            } else {
                this.setPeerMode(BNtpMode.unspecified);
            }
        }
    }

    public String getServerString() {
        if (this.serverString == null) {
            this.serverString = this.getServerString(this.getAddress(), this.getUseSpecialPollInterval(), this.getFallbackOnly(), this.getPeerMode());
        }
        return this.serverString;
    }

    public String getServerString(String string, boolean bl, boolean bl2, BNtpMode bNtpMode) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        if (bNtpMode == BNtpMode.symmetricActive) {
            n |= 4;
        } else if (bNtpMode == BNtpMode.client) {
            n |= 8;
        }
        if (n != 0) {
            stringBuffer.append(",0x");
            stringBuffer.append(TextUtil.byteToHexString((int)n).charAt(1));
        }
        return stringBuffer.toString();
    }

    public String getPropertyName(String string) {
        int n = string.indexOf(44);
        if (n < 0) {
            return SlotPath.escape((String)string);
        }
        return SlotPath.escape((String)string.substring(0, n));
    }

    public synchronized boolean equivalent(Object object) {
        if (object instanceof String) {
            return this.getServerString().equals(object);
        }
        if (object instanceof BNtpServerWin32) {
            return ((BNtpServerWin32)((Object)object)).getServerString().equals(this.getServerString());
        }
        return false;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == address || property == useSpecialPollInterval || property == fallbackOnly || property == peerMode) {
            this.serverString = null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serverString = null;
    }

    public BNtpServerWin32() {
        this.this();
    }

    public BNtpServerWin32(String string) {
        this.this();
        this.updateServerString(string);
    }

    static {
        Class clazz = class$com$tridium$platform$win32$BNtpServerWin32;
        if (clazz == null) {
            clazz = class$com$tridium$platform$win32$BNtpServerWin32 = BNtpServerWin32.class("[Lcom.tridium.platform.win32.BNtpServerWin32;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

