/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.win32;

import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.win32.BNtpSyncPolicyWin32;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNtpPlatformServiceWin32
extends BNtpPlatformService {
    public static final Property timeServers = BNtpPlatformServiceWin32.newProperty((int)3, (BValue)new BNtpServerVector(), (BFacets)BFacets.make((String)"elementType", (String)"platform:NtpServerWin32"));
    public static final Property syncPolicy = BNtpPlatformServiceWin32.newProperty((int)3, (BValue)BNtpSyncPolicyWin32.ntp, null);
    public static final Property maxPosPhaseCorrection = BNtpPlatformServiceWin32.newProperty((int)3, (int)54000, (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)8), BUnit.getUnit((String)"second")}));
    public static final Property maxNegPhaseCorrection = BNtpPlatformServiceWin32.newProperty((int)3, (int)54000, (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)8), BUnit.getUnit((String)"second")}));
    public static final Property minPollInterval = BNtpPlatformServiceWin32.newProperty((int)3, (int)10, (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)8), LOG_2_SEC_UNIT}));
    public static final Property maxPollInterval = BNtpPlatformServiceWin32.newProperty((int)3, (int)15, (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)8), LOG_2_SEC_UNIT}));
    public static final Property specialPollInterval = BNtpPlatformServiceWin32.newProperty((int)3, (int)604800, (BFacets)BFacets.make((String[])new String[]{"min", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)30), BInteger.make((int)8), BUnit.getUnit((String)"second")}));
    public static final Property domainMember = BNtpPlatformServiceWin32.newProperty((int)7, (boolean)false, null);
    public static final Type TYPE;
    protected boolean allowUpdate;
    static /* synthetic */ Class class$com$tridium$platform$win32$BNtpPlatformServiceWin32;

    public BNtpSyncPolicyWin32 getSyncPolicy() {
        return (BNtpSyncPolicyWin32)this.get(syncPolicy);
    }

    public void setSyncPolicy(BNtpSyncPolicyWin32 bNtpSyncPolicyWin32) {
        this.set(syncPolicy, (BValue)bNtpSyncPolicyWin32, null);
    }

    public int getMaxPosPhaseCorrection() {
        return this.getInt(maxPosPhaseCorrection);
    }

    public void setMaxPosPhaseCorrection(int n) {
        this.setInt(maxPosPhaseCorrection, n, null);
    }

    public int getMaxNegPhaseCorrection() {
        return this.getInt(maxNegPhaseCorrection);
    }

    public void setMaxNegPhaseCorrection(int n) {
        this.setInt(maxNegPhaseCorrection, n, null);
    }

    public int getMinPollInterval() {
        return this.getInt(minPollInterval);
    }

    public void setMinPollInterval(int n) {
        this.setInt(minPollInterval, n, null);
    }

    public int getMaxPollInterval() {
        return this.getInt(maxPollInterval);
    }

    public void setMaxPollInterval(int n) {
        this.setInt(maxPollInterval, n, null);
    }

    public int getSpecialPollInterval() {
        return this.getInt(specialPollInterval);
    }

    public void setSpecialPollInterval(int n) {
        this.setInt(specialPollInterval, n, null);
    }

    public boolean getDomainMember() {
        return this.getBoolean(domainMember);
    }

    public void setDomainMember(boolean bl) {
        this.setBoolean(domainMember, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return BOperatingSystemEnum.isOS(BOperatingSystemEnum.windows);
    }

    public int getSlotFlags() {
        return 0;
    }

    public void loadPlatformServiceProperties() {
        BSystemPlatformService bSystemPlatformService;
        super.loadPlatformServiceProperties();
        BSystemPlatformService bSystemPlatformService2 = bSystemPlatformService = Sys.getStation() == null ? null : (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (bSystemPlatformService == null || bSystemPlatformService.getPlatformLibrary() == null) {
            return;
        }
        this.allowUpdate = false;
        this.getTimeServers().sync(TextUtil.split((String)BNtpPlatformServiceWin32.getNtpServers0(), (char)' '));
        this.setDomainMember(BNtpPlatformServiceWin32.isDomainMember0());
        this.setSyncPolicy(BNtpSyncPolicyWin32.make(BNtpPlatformServiceWin32.getSyncPolicy0()));
        boolean bl = false;
        if (this.getSyncPolicy() != BNtpSyncPolicyWin32.none) {
            bl = true;
        }
        this.setEnabled(bl);
        this.setSpecialPollInterval(BNtpPlatformServiceWin32.getSpecialPollInterval0());
        this.setMinPollInterval(BNtpPlatformServiceWin32.getMinPollInterval0());
        this.setMaxPollInterval(BNtpPlatformServiceWin32.getMaxPollInterval0());
        int n = BNtpPlatformServiceWin32.getMaxPosPhaseCorrection0();
        this.setMaxPosPhaseCorrection(n == -1 ? Integer.MAX_VALUE : n);
        n = BNtpPlatformServiceWin32.getMaxNegPhaseCorrection0();
        this.setMaxNegPhaseCorrection(n == -1 ? Integer.MAX_VALUE : n);
        this.allowUpdate = true;
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(context);
        this.allowUpdate = false;
        this.getTimeServers().sync(TextUtil.split((String)BNtpPlatformServiceWin32.getNtpServers0(), (char)' '));
        this.setDomainMember(BNtpPlatformServiceWin32.isDomainMember0());
        this.setSyncPolicy(BNtpSyncPolicyWin32.make(BNtpPlatformServiceWin32.getSyncPolicy0()));
        boolean bl = false;
        if (this.getSyncPolicy() != BNtpSyncPolicyWin32.none) {
            bl = true;
        }
        this.setEnabled(bl);
        this.setSpecialPollInterval(BNtpPlatformServiceWin32.getSpecialPollInterval0());
        this.setMinPollInterval(BNtpPlatformServiceWin32.getMinPollInterval0());
        this.setMaxPollInterval(BNtpPlatformServiceWin32.getMaxPollInterval0());
        int n = BNtpPlatformServiceWin32.getMaxPosPhaseCorrection0();
        this.setMaxPosPhaseCorrection(n == -1 ? Integer.MAX_VALUE : n);
        n = BNtpPlatformServiceWin32.getMaxNegPhaseCorrection0();
        this.setMaxNegPhaseCorrection(n == -1 ? Integer.MAX_VALUE : n);
        this.allowUpdate = true;
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        StringBuffer stringBuffer = new StringBuffer();
        SlotCursor slotCursor = this.getTimeServers().getProperties();
        while (slotCursor.next()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(((BNtpServer)slotCursor.get()).getServerString());
        }
        String string = stringBuffer.toString();
        int n = 0;
        if (this.getEnabled()) {
            n = this.getSyncPolicy().getOrdinal();
        }
        BNtpPlatformServiceWin32.saveNtpSettings0(string, n, this.getSpecialPollInterval(), this.getMinPollInterval(), this.getMaxPollInterval(), this.getMaxPosPhaseCorrection() == Integer.MAX_VALUE ? -1 : this.getMaxPosPhaseCorrection(), this.getMaxNegPhaseCorrection() == Integer.MAX_VALUE ? -1 : this.getMaxNegPhaseCorrection());
    }

    protected static native String getNtpServers0();

    protected static native int getSyncPolicy0();

    protected static native int getSpecialPollInterval0();

    protected static native int getMinPollInterval0();

    protected static native int getMaxPollInterval0();

    protected static native int getMaxPosPhaseCorrection0();

    protected static native int getMaxNegPhaseCorrection0();

    protected static native boolean isDomainMember0();

    protected static native void saveNtpSettings0(String var0, int var1, int var2, int var3, int var4, int var5, int var6);

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.allowUpdate = true;
    }

    public BNtpPlatformServiceWin32() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$win32$BNtpPlatformServiceWin32;
        if (clazz == null) {
            clazz = class$com$tridium$platform$win32$BNtpPlatformServiceWin32 = BNtpPlatformServiceWin32.class("[Lcom.tridium.platform.win32.BNtpPlatformServiceWin32;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

