/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import java.util.Comparator;
import java.util.HashMap;

public class SortableTableUtil {

    private static class ColumnComparator
    implements Comparator {
        private int comparatorSortColumn;
        private boolean comparatorAscending;

        public ColumnComparator(int n, boolean bl) {
            this.comparatorSortColumn = n;
            this.comparatorAscending = bl;
        }

        public int compare(Object object, Object object2) {
            SortableRow sortableRow = (SortableRow)object;
            SortableRow sortableRow2 = (SortableRow)object2;
            int n = this.comparatorAscending ? 1 : -1;
            return n * sortableRow.compareToRowForColumn(sortableRow2, this.comparatorSortColumn);
        }
    }

    public static class OriginalOrderComparator
    implements Comparator {
        HashMap sequenceMapById = new HashMap();

        public OriginalOrderComparator(Model model) {
            if (model != null) {
                for (int i = 0; i < model.getRowCount(); ++i) {
                    this.sequenceMapById.put(model.getSortableRow(i).getRowId(), new Integer(i));
                }
            }
        }

        public int compare(Object object, Object object2) {
            SortableRow sortableRow = (SortableRow)object;
            SortableRow sortableRow2 = (SortableRow)object2;
            Integer n = (Integer)this.sequenceMapById.get(sortableRow.getRowId());
            Integer n2 = (Integer)this.sequenceMapById.get(sortableRow2.getRowId());
            if (n == null) {
                if (n2 == null) {
                    return 0;
                }
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n.compareTo(n2);
        }
    }

    public static class RowComparator
    implements Comparator {
        private Comparator[] comparators;

        public RowComparator(Model model, Comparator comparator) {
            int n;
            int[] nArray = new int[model.getColumnCount()];
            nArray[0] = model.getSortColumn();
            int n2 = 1;
            for (n = 0; n < nArray.length; ++n) {
                if (n == model.getSortColumn()) continue;
                nArray[n2++] = n;
            }
            if (comparator == null) {
                this.comparators = new Comparator[model.getColumnCount()];
                n = 0;
            } else {
                this.comparators = new Comparator[model.getColumnCount() + 1];
                this.comparators[0] = comparator;
                n = 1;
            }
            for (int i = n; i < this.comparators.length; ++i) {
                this.comparators[i] = new ColumnComparator(nArray[i - n], model.isSortAscending());
            }
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            for (int i = 0; i < this.comparators.length && n == 0; ++i) {
                n = this.comparators[i].compare(object, object2);
            }
            return n;
        }
    }

    public static interface SortableRow {
        public Object getRowId();

        public int compareToRowForColumn(SortableRow var1, int var2);
    }

    public static interface Model {
        public int getColumnCount();

        public int getRowCount();

        public SortableRow getSortableRow(int var1);

        public void sortByColumn(int var1, boolean var2);

        public int getSortColumn();

        public boolean isSortAscending();
    }
}

