/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.baja.gx.BInsets;
import javax.baja.gx.Point;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.event.BMouseEvent;

public class BToolTipTextField
extends BTextField {
    public static final Property toolTip = BToolTipTextField.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BToolTipTextField == null ? (class$com$tridium$platform$ui$util$BToolTipTextField = BToolTipTextField.class$("com.tridium.platform.ui.util.BToolTipTextField")) : class$com$tridium$platform$ui$util$BToolTipTextField));
    private static TextFieldToolTip window = new TextFieldToolTip(new Frame());
    private static Font font = new Font(Theme.textEditor().getFont().getName(), 0, (int)Theme.textEditor().getFont().getSize());
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BToolTipTextField;

    public String getToolTip() {
        return this.getString(toolTip);
    }

    public void setToolTip(String string) {
        this.setString(toolTip, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BToolTipTextField() {
    }

    public BToolTipTextField(String string) {
        super(string);
    }

    public BToolTipTextField(String string, int n) {
        super(string, n);
    }

    public BToolTipTextField(String string, int n, boolean bl) {
        super(string, n, bl);
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        BInsets bInsets;
        super.mouseHover(bMouseEvent);
        boolean bl = false;
        String string = this.getToolTip();
        if (string.trim().length() == 0) {
            string = this.getText();
            bInsets = this.getInsets();
            double d = this.getWidth() - bInsets.left() - bInsets.right();
            bl = d < (double)BToolTipTextField.getToolTipTextWidth(string);
        } else {
            bl = true;
        }
        if (bl) {
            bInsets = this.translateToScreen(new Point(0.0, 16.0));
            BToolTipTextField.openTextFieldToolTip((int)bInsets.x, (int)bInsets.y, string);
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        super.mouseExited(bMouseEvent);
        BToolTipTextField.closeTextFieldToolTip();
    }

    public static void openTextFieldToolTip(int n, int n2, String string) {
        window.setLocation(n, n2);
        BToolTipTextField.window.setText(string);
        window.checkLocation();
        window.pack();
        window.setVisible(true);
    }

    public static void closeTextFieldToolTip() {
        window.setVisible(false);
    }

    public static int getToolTipTextWidth(String string) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TextFieldToolTip
    extends Window {
        private String text;
        private int delta;
        private Color foreground;
        private Color background;

        private TextFieldToolTip(Frame frame) {
            super(frame);
            this.setLayout(null);
            this.foreground = Color.black;
            this.background = Color.white;
        }

        private void setText(String string) {
            this.text = string;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            this.delta = fontMetrics.getHeight();
            int n = fontMetrics.stringWidth(this.text) + 8;
            int n2 = this.delta + 4;
            this.setSize(n, n2);
        }

        public void checkLocation() {
            int n;
            int n2 = this.getLocation().x;
            int n3 = this.getLocation().y;
            int n4 = this.getSize().width;
            int n5 = this.getSize().height;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            Rectangle rectangle = null;
            for (n = 0; n < graphicsDeviceArray.length && !(rectangle = graphicsDeviceArray[n].getDefaultConfiguration().getBounds()).contains(this.getLocation()); ++n) {
            }
            if (rectangle != null) {
                int n6;
                n = this.getLocation().x + n4 + 5 - (rectangle.x + rectangle.width);
                if (n > 0) {
                    n2 -= n;
                }
                if ((n6 = this.getLocation().y + n5 + 5 - (rectangle.y + rectangle.height)) > 0) {
                    n3 -= n6;
                    n3 -= n5 * 2;
                }
            }
            this.setLocation(n2, n3);
        }

        public void paint(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.foreground);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(this.background);
            graphics.fillRect(1, 1, n - 2, n2 - 2);
            graphics.setColor(this.foreground);
            graphics.setFont(font);
            graphics.drawString(this.text, 4, this.delta);
        }
    }
}

