/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import javax.baja.gx.Graphics;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;

public class BTextOutputPane
extends BTextEditorPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BTextOutputPane == null ? (class$com$tridium$platform$ui$util$BTextOutputPane = BTextOutputPane.class$("com.tridium.platform.ui.util.BTextOutputPane")) : class$com$tridium$platform$ui$util$BTextOutputPane));
    private boolean autoScroll = false;
    private Object monitor = new Object();
    private CharArrayWriter outputA = new CharArrayWriter();
    private CharArrayWriter outputB = new CharArrayWriter();
    private CharArrayWriter output = this.outputA;
    private TextModelWriter textModelWriter = new TextModelWriter();
    private long maxSize = 32768L;
    private long currentSize = 0L;
    private boolean toEnd = false;
    private long lastUpdate = 0L;
    private AutoScrollThread autoScrollThread = null;
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BTextOutputPane;

    public Type getType() {
        return TYPE;
    }

    public BTextOutputPane(byte[] byArray, int n, int n2) {
        this();
        this.append(byArray, n, n2);
    }

    public BTextOutputPane(Throwable throwable) {
        this();
        this.append(throwable);
    }

    public BTextOutputPane(String string) {
        this();
        this.append(string);
    }

    public BTextOutputPane() {
        this(20, 80);
    }

    public BTextOutputPane(int n, int n2, Throwable throwable) {
        this(n, n2);
        this.append(throwable);
    }

    public BTextOutputPane(int n, int n2, String string) {
        this(n, n2);
        this.append(string);
    }

    public BTextOutputPane(int n, int n2) {
        super("", n, n2, false);
    }

    public void started() throws Exception {
        super.started();
        if (this.autoScrollThread != null) {
            this.autoScrollThread.terminate();
        }
        this.autoScrollThread = new AutoScrollThread();
        this.autoScrollThread.start();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.autoScrollThread != null) {
            this.autoScrollThread.terminate();
        }
        this.autoScrollThread = null;
    }

    public void clear() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        Object object = this.monitor;
        synchronized (object) {
            super.setText(string);
            this.currentSize = string.length();
        }
    }

    public void append(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        this.append(byteArrayOutputStream.toString());
    }

    public void append(byte[] byArray, int n, int n2) {
        this.append(new String(byArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.output.write(string, 0, string.length());
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        boolean bl;
        CharArrayWriter charArrayWriter = null;
        boolean bl2 = bl = this.output.size() > 0;
        if (bl) {
            this.toEnd = true;
            Object object = this.monitor;
            synchronized (object) {
                if (this.output == this.outputA) {
                    this.output = this.outputB;
                    charArrayWriter = this.outputA;
                } else {
                    this.output = this.outputA;
                    charArrayWriter = this.outputB;
                }
            }
            try {
                charArrayWriter.writeTo(this.textModelWriter);
                charArrayWriter.reset();
                this.currentSize = this.getEditor().getModel().getTextLength();
                if (this.currentSize > this.maxSize) {
                    int n = 0;
                    while ((double)this.currentSize > (double)this.maxSize * 0.95) {
                        Line line = this.getEditor().getModel().getLine(n);
                        this.currentSize -= (long)line.getColumnCount();
                        ++n;
                    }
                    this.getEditor().getModel().remove(new Position(0, 0), new Position(n, 0));
                }
            }
            catch (Exception exception) {
                System.out.println("*** exception adding/removing data:");
                exception.printStackTrace();
            }
            this.lastUpdate = Clock.ticks();
        }
        if (this.autoScroll && this.toEnd) {
            this.getEditor().scrollToVisible(this.getEditor().getModel().getEndPosition());
            this.toEnd = false;
        }
        super.paint(graphics);
    }

    public void scrollToEnd() {
        this.getEditor().moveCaretPosition(this.getEditor().getModel().getEndPosition());
        this.toEnd = true;
        this.repaint();
    }

    public void setOutputBufferSize(int n) {
        this.maxSize = n;
    }

    public void setUseAutoScroll(boolean bl) {
        this.autoScroll = bl;
    }

    public boolean useAutoScroll() {
        return this.autoScroll;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class AutoScrollThread
    extends Thread {
        private boolean running = true;
        private boolean dirty = true;

        public AutoScrollThread() {
            super("TextOutputPane:AutoScroll");
        }

        public void run() {
            while (this.running) {
                if (Clock.ticks() - BTextOutputPane.this.lastUpdate > 500L) {
                    if (this.dirty) {
                        BTextOutputPane.this.scrollToEnd();
                        this.dirty = false;
                    }
                } else {
                    this.dirty = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
        }

        public void terminate() {
            this.running = false;
        }
    }

    private class TextModelWriter
    extends Writer {
        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            BTextOutputPane.this.getEditor().getModel().insert(BTextOutputPane.this.getEditor().getModel().getEndPosition(), cArray, n, n2);
        }
    }
}

