/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.util.Lexicon;

public class BFileChooserPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BFileChooserPane == null ? (class$com$tridium$platform$ui$util$BFileChooserPane = BFileChooserPane.class$("com.tridium.platform.ui.util.BFileChooserPane")) : class$com$tridium$platform$ui$util$BFileChooserPane));
    private FileChooserModel model;
    private BFileChooserListView listView;
    private BTreeView treeView;
    private IFilePathFilter selectionPathFilter;
    private IFileFilter selectionFileFilter;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private Array listeners = new Array(class$com$tridium$platform$ui$util$BFileChooserPane$Listener == null ? (class$com$tridium$platform$ui$util$BFileChooserPane$Listener = BFileChooserPane.class$("com.tridium.platform.ui.util.BFileChooserPane$Listener")) : class$com$tridium$platform$ui$util$BFileChooserPane$Listener);
    private static final Lexicon LEX = Lexicon.make((String)"platform");
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BFileChooserPane;
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BFileChooserPane$Listener;

    public Type getType() {
        return TYPE;
    }

    public BFileChooserPane() {
        throw new UnsupportedOperationException();
    }

    public BFileChooserPane(BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2, IFilePathFilter iFilePathFilter, BFileChooserListView.ListModel listModel, boolean bl, boolean bl2, String string) {
        this(bIFile, null, iFileFilter, iFileFilter2, iFilePathFilter, listModel, bl, bl2, string);
    }

    public BFileChooserPane(BIFile bIFile, BIFile bIFile2, IFileFilter iFileFilter, IFileFilter iFileFilter2, IFilePathFilter iFilePathFilter, BFileChooserListView.ListModel listModel, boolean bl, boolean bl2, String string) {
        this.model = bIFile == null ? new FileChooserModel((BSpace)BFileSystem.INSTANCE) : new FileChooserModel((BSpace)bIFile.getFileSpace());
        if (bIFile2 != null) {
            this.model.select(bIFile2);
        }
        this.model.setFilter(iFileFilter);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BFileChooserListView(this.model);
        if (listModel == null) {
            this.listView.setDetailsView();
        } else {
            this.listView.setView(listModel, true);
        }
        this.listView.setMultipleSelection(bl);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        this.selectionPathFilter = iFilePathFilter == null ? new IFilePathFilter(){

            public boolean accept(FilePath filePath) {
                return true;
            }
        } : iFilePathFilter;
        this.selectionFileFilter = iFileFilter2 == null ? new IFileFilter(){

            public boolean accept(BIFile bIFile) {
                return true;
            }

            public String getDescription(Context context) {
                return "";
            }
        } : iFileFilter2;
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(33.0);
        bSplitPane.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        bFlowPane.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (Command)new HomeCommand());
        bToolBar.add(null, (Command)new UpLevelCommand());
        bFlowPane.add(null, (BValue)bToolBar);
        BEdgePane bEdgePane = null;
        this.fileNameTextField = new BTextField("", 32);
        this.fileNameTextField.setModel(new TextModel(){

            protected void textModified() {
                BFileChooserPane.this.notifyFileSelected();
            }
        });
        if (bl2) {
            bEdgePane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)new BLabel(LEX.getText("FileChooserPane.fileName")), BInsets.make((double)4.0, (double)4.0, (double)0.0, (double)0.0)), null, (BWidget)new BBorderPane((BWidget)this.fileNameTextField, BInsets.make((double)4.0, (double)0.0, (double)0.0, (double)0.0)));
        }
        bSplitPane.setWidget2((BWidget)new BEdgePane((BWidget)bFlowPane, bEdgePane, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bSplitPane, 6.0, 4.0, 4.0, 4.0));
        bConstrainedPane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)bConstrainedPane);
        if (bIFile != null && bIFile.isDirectory()) {
            this.model.setDirectory((BINavNode)bIFile);
            this.treeView.scrollToVisible((BINavNode)bIFile);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
            this.currentDirectoryLabel.setText(bIFile.getNavDisplayName(null));
        }
        if (string != null) {
            this.fileNameTextField.setText(string);
        }
    }

    public BIFile[] getSelectedFiles() {
        return this.model.getSelectedFiles();
    }

    public FilePath getSelectedFilePath() {
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText());
    }

    public BIFile getSelectedFile() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        return bIFileArray.length == 0 ? null : bIFileArray[0];
    }

    public BDirectory getDirectory() {
        BINavNode bINavNode = this.model.getDirectory();
        return bINavNode instanceof BDirectory ? (BDirectory)bINavNode : null;
    }

    public void started() {
        this.notifyFileSelected();
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    public void notifyFileSelected() {
        boolean bl = this.fileNameTextField.getText().trim().length() > 0 && this.model.getDirectory() != null && this.model.getDirectory() instanceof BDirectory && this.selectionPathFilter.accept(((BDirectory)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText().trim()));
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).fileSelected(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Controller
    extends TreeController {
        protected void mouseSelection(TreeNode treeNode, BMouseEvent bMouseEvent) {
            super.mouseSelection(treeNode, bMouseEvent);
            BFileChooserPane.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            BINavNode bINavNode = BFileChooserPane.this.treeView.getFileForNode(treeNode);
            if (bINavNode != null) {
                BFileChooserPane.this.model.setDirectory(bINavNode);
            }
        }
    }

    public class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BFileChooserPane.this, TYPE.getModule(), "FileChooserPane.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
                BFileChooserPane.this.model.setDirectory((BINavNode)bDirectory);
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    public class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BFileChooserPane.this, TYPE.getModule(), "FileChooserPane.upLevel");
        }

        public CommandArtifact doInvoke() {
            try {
                BFileChooserPane.this.model.moveUpDirectory();
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    public static interface Listener {
        public void fileSelected(boolean var1);
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BFileChooserPane.this.listView.populateChildren();
            BFileChooserPane.this.listView.relayout();
            BIFile bIFile = (BIFile)BFileChooserPane.this.model.getDirectory();
            if (bIFile != null) {
                BFileChooserPane.this.treeView.scrollToVisible((BINavNode)bIFile);
                BFileChooserPane.this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
                BFileChooserPane.this.currentDirectoryLabel.setText(bIFile.getNavDisplayName(null));
                BFileChooserPane.this.currentDirectoryLabel.relayout();
            }
            BFileChooserPane.this.model.deselectAll();
            BFileChooserPane.this.listView.getSelection().deselectAll();
            BFileChooserPane.this.notifyFileSelected();
        }

        public void selectionModified() {
            BIFile[] bIFileArray = BFileChooserPane.this.model.getSelectedFiles();
            if (bIFileArray.length == 0) {
                BFileChooserPane.this.notifyFileSelected();
                return;
            }
            BFileChooserPane.this.treeView.getSelection().deselectAll();
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (BFileChooserPane.this.selectionPathFilter.accept(bIFileArray[i].getFilePath()) && BFileChooserPane.this.selectionFileFilter.accept(bIFileArray[i])) continue;
                BFileChooserPane.this.notifyFileSelected();
                return;
            }
            BFileChooserPane.this.fileNameTextField.setText(bIFileArray[0].getFileName());
            BFileChooserPane.this.notifyFileSelected();
        }

        public void chooseSelectedFiles() {
        }
    }
}

