/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

public class BFileChooserDialog
extends BEdgePane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BFileChooserDialog == null ? (class$com$tridium$platform$ui$util$BFileChooserDialog = BFileChooserDialog.class$("com.tridium.platform.ui.util.BFileChooserDialog")) : class$com$tridium$platform$ui$util$BFileChooserDialog));
    private BCommandDialog dialog = null;
    private FileChooserModel model;
    private BFileChooserListView listView;
    private BTreeView treeView;
    private IFilePathFilter selectionPathFilter;
    private IFileFilter selectionFileFilter;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private static Lexicon lex = null;
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BFileChooserDialog;

    public Type getType() {
        return TYPE;
    }

    private BFileChooserDialog(BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2, IFilePathFilter iFilePathFilter, BFileChooserListView.ListModel listModel, boolean bl, boolean bl2, String string3) {
        this.model = bIFile == null ? new FileChooserModel((BSpace)BFileSystem.INSTANCE) : new FileChooserModel((BSpace)bIFile.getFileSpace());
        this.model.setFilter(iFileFilter);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BFileChooserListView(this.model);
        if (listModel == null) {
            this.listView.setDetailsView();
        } else {
            this.listView.setView(listModel, true);
        }
        this.listView.setMultipleSelection(bl);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        this.selectionPathFilter = iFilePathFilter == null ? new IFilePathFilter(){

            public boolean accept(FilePath filePath) {
                return true;
            }
        } : iFilePathFilter;
        this.selectionFileFilter = iFileFilter2 == null ? new IFileFilter(){

            public boolean accept(BIFile bIFile) {
                return true;
            }

            public String getDescription(Context context) {
                return "";
            }
        } : iFileFilter2;
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(33.0);
        bSplitPane.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        bFlowPane.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (Command)new HomeCommand());
        bToolBar.add(null, (Command)new UpLevelCommand());
        bFlowPane.add(null, (BValue)bToolBar);
        BEdgePane bEdgePane = null;
        this.fileNameTextField = new BTextField("", 32);
        this.fileNameTextField.setModel(new TextModel(){

            protected void textModified() {
                BFileChooserDialog.this.checkDialogButtonState();
            }
        });
        if (bl2) {
            bEdgePane = new BEdgePane(null, null, (BWidget)new BBorderPane((BWidget)new BLabel(this.getLexicon().getText("FileChooserDialog.fileName")), BInsets.make((double)4.0, (double)4.0, (double)0.0, (double)0.0)), null, (BWidget)new BBorderPane((BWidget)this.fileNameTextField, BInsets.make((double)4.0, (double)0.0, (double)0.0, (double)0.0)));
        }
        bSplitPane.setWidget2((BWidget)new BEdgePane((BWidget)bFlowPane, bEdgePane, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        this.setTop((BWidget)new BWizardHeader(bImage, string, string2 == null ? "" : string2));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bSplitPane, 6.0, 4.0, 4.0, 4.0));
        bConstrainedPane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)bConstrainedPane);
        if (bIFile != null && bIFile.isDirectory()) {
            this.model.setDirectory((BINavNode)bIFile);
            this.treeView.scrollToVisible((BINavNode)bIFile);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
            this.currentDirectoryLabel.setText(bIFile.getNavDisplayName(null));
        }
        if (string3 != null) {
            this.fileNameTextField.setText(string3);
        }
    }

    public static BIFile[] chooseFiles(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2) {
        return BFileChooserDialog.chooseFiles(bWidget, bImage, string, string2, bIFile, iFileFilter, iFileFilter2, null);
    }

    public static BIFile[] chooseFiles(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2, BFileChooserListView.ListModel listModel) {
        BFileChooserDialog bFileChooserDialog = new BFileChooserDialog(bImage, string, string2, bIFile, iFileFilter, iFileFilter2, null, listModel, true, false, null);
        if (1 == BCommandDialog.open(bWidget, string, (Object)bFileChooserDialog, 3)) {
            return bFileChooserDialog.getSelectedFiles();
        }
        return new BIFile[0];
    }

    public static BIFile chooseFile(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2) {
        return BFileChooserDialog.chooseFile(bWidget, bImage, string, string2, bIFile, iFileFilter, iFileFilter2, null);
    }

    public static BIFile chooseFile(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFileFilter iFileFilter2, BFileChooserListView.ListModel listModel) {
        BFileChooserDialog bFileChooserDialog = new BFileChooserDialog(bImage, string, string2, bIFile, iFileFilter, iFileFilter2, null, listModel, false, false, null);
        if (1 == BCommandDialog.open(bWidget, string, (Object)bFileChooserDialog, 3)) {
            return bFileChooserDialog.getSelectedFile();
        }
        return null;
    }

    public static FilePath chooseFilePath(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, IFileFilter iFileFilter, IFilePathFilter iFilePathFilter, BFileChooserListView.ListModel listModel, String string3) {
        BFileChooserDialog bFileChooserDialog = new BFileChooserDialog(bImage, string, string2, bIFile, iFileFilter, null, iFilePathFilter, listModel, false, true, string3);
        if (1 == BCommandDialog.open(bWidget, string, (Object)bFileChooserDialog, 3)) {
            return bFileChooserDialog.getSelectedFilePath();
        }
        return null;
    }

    public static BIFile[] chooseFiles(BWidget bWidget, String string) {
        return BFileChooserDialog.chooseFiles(bWidget, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.files.title"), string, null, IFileFilter.all, new IFileFilter(){

            public boolean accept(BIFile bIFile) {
                return !(bIFile instanceof BIDirectory);
            }

            public String getDescription(Context context) {
                return "TODO";
            }
        }, null);
    }

    public static BIFile chooseFile(BWidget bWidget, String string) {
        return BFileChooserDialog.chooseFile(bWidget, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.file.title"), string, null, IFileFilter.all, new IFileFilter(){

            public boolean accept(BIFile bIFile) {
                return !(bIFile instanceof BIDirectory);
            }

            public String getDescription(Context context) {
                return "TODO";
            }
        }, null);
    }

    public static FilePath chooseFilePath(BWidget bWidget, String string) {
        return BFileChooserDialog.chooseFilePath(bWidget, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.file.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.file.title"), string, null, IFileFilter.all, null, null, null);
    }

    public static BIFile[] chooseDirectories(BWidget bWidget, String string) {
        return BFileChooserDialog.chooseFiles(bWidget, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.dir.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.dirs.title"), string, null, IFileFilter.directory, null, null);
    }

    public static BIFile chooseDirectory(BWidget bWidget, String string) {
        return BFileChooserDialog.chooseFile(bWidget, BImage.make((String)BFileChooserDialog.lex().getText("FileChooserDialog.dir.icon")), BFileChooserDialog.lex().getText("FileChooserDialog.dir.title"), string, null, IFileFilter.directory, null, null);
    }

    public void setDialog(BCommandDialog bCommandDialog) {
        this.dialog = bCommandDialog;
        this.checkDialogButtonState();
    }

    public BCommandDialog getDialog() {
        if (this.dialog == null) {
            for (BComplex bComplex = this.getParent(); bComplex != null; bComplex = bComplex.getParent()) {
                if (!(bComplex instanceof BCommandDialog)) continue;
                this.dialog = (BCommandDialog)bComplex;
                break;
            }
        }
        return this.dialog;
    }

    public BIFile[] getSelectedFiles() {
        return this.model.getSelectedFiles();
    }

    public FilePath getSelectedFilePath() {
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText());
    }

    public BIFile getSelectedFile() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        return bIFileArray.length == 0 ? null : bIFileArray[0];
    }

    public void started() {
        this.checkDialogButtonState();
    }

    protected void checkDialogButtonState() {
        Command command;
        if (this.getDialog() != null && (command = this.getDialog().getButtonCommand(1)) != null) {
            command.setEnabled(this.fileNameTextField.getText().trim().length() > 0 && this.model.getDirectory() != null && this.model.getDirectory() instanceof BDirectory && this.selectionPathFilter.accept(((BDirectory)this.model.getDirectory()).getFilePath().merge(this.fileNameTextField.getText().trim())));
        }
    }

    private static Lexicon lex() {
        if (lex == null) {
            lex = TYPE.getModule().getLexicon();
        }
        return lex;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode treeNode, BMouseEvent bMouseEvent) {
            super.mouseSelection(treeNode, bMouseEvent);
            BFileChooserDialog.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            BINavNode bINavNode = BFileChooserDialog.this.treeView.getFileForNode(treeNode);
            if (bINavNode != null) {
                BFileChooserDialog.this.model.setDirectory(bINavNode);
            }
        }
    }

    class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BFileChooserDialog.this, TYPE.getModule(), "FileChooserDialog.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
                BFileChooserDialog.this.model.setDirectory((BINavNode)bDirectory);
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BFileChooserDialog.this, TYPE.getModule(), "FileChooserDialog.upLevel");
        }

        public CommandArtifact doInvoke() {
            try {
                BFileChooserDialog.this.model.moveUpDirectory();
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BFileChooserDialog.this.listView.populateChildren();
            BFileChooserDialog.this.listView.relayout();
            BIFile bIFile = (BIFile)BFileChooserDialog.this.model.getDirectory();
            if (bIFile != null) {
                BFileChooserDialog.this.treeView.scrollToVisible((BINavNode)bIFile);
                BFileChooserDialog.this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
                BFileChooserDialog.this.currentDirectoryLabel.setText(bIFile.getNavDisplayName(null));
                BFileChooserDialog.this.currentDirectoryLabel.relayout();
            }
            BFileChooserDialog.this.checkDialogButtonState();
        }

        public void selectionModified() {
            BIFile[] bIFileArray = BFileChooserDialog.this.model.getSelectedFiles();
            if (bIFileArray.length == 0) {
                return;
            }
            BFileChooserDialog.this.treeView.getSelection().deselectAll();
            for (int i = 0; i < bIFileArray.length; ++i) {
                if (BFileChooserDialog.this.selectionPathFilter.accept(bIFileArray[i].getFilePath()) && BFileChooserDialog.this.selectionFileFilter.accept(bIFileArray[i])) continue;
                return;
            }
            BFileChooserDialog.this.fileNameTextField.setText(bIFileArray[0].getFileName());
        }

        public void chooseSelectedFiles() {
        }
    }
}

