/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BDirectoryNodeEvent;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.PatternFilter;

public class BDirectoryTree
extends BTree {
    public static final Topic nodeChecked = BDirectoryTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BDirectoryTree == null ? (class$com$tridium$platform$ui$util$BDirectoryTree = BDirectoryTree.class$("com.tridium.platform.ui.util.BDirectoryTree")) : class$com$tridium$platform$ui$util$BDirectoryTree));
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BDirectoryTree;

    public void fireNodeChecked(BDirectoryNodeEvent bDirectoryNodeEvent) {
        this.fire(nodeChecked, (BValue)bDirectoryNodeEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDirectoryTree() {
        this(new DirectoryTreeModel(), new DirectoryTreeController());
    }

    public BDirectoryTree(TreeModel treeModel) {
        this(treeModel, new DirectoryTreeController());
    }

    public BDirectoryTree(TreeModel treeModel, TreeController treeController) {
        super(treeModel, treeController);
        this.setNodeRenderer(new DirectoryTreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    public void setModel(TreeModel treeModel) {
        super.setModel((TreeModel)((DirectoryTreeModel)treeModel));
    }

    public DirectoryTreeModel getDirectoryTreeModel() {
        return (DirectoryTreeModel)this.getModel();
    }

    public void setController(TreeController treeController) {
        super.setController((TreeController)((DirectoryTreeController)treeController));
    }

    public DirectoryTreeController getDirectoryTreeController() {
        return (DirectoryTreeController)this.getController();
    }

    public DirectoryTreeNodeRenderer getDirectoryTreeNodeRenderer() {
        return (DirectoryTreeNodeRenderer)this.getNodeRenderer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DirectoryTreeNodeRenderer
    extends TreeNodeRenderer {
        public double getWidth(TreeNode treeNode) {
            return super.getWidth(treeNode) + 10.0 + 2.0;
        }

        public BBrush getForeground(TreeNode treeNode) {
            DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treeNode;
            return directoryTreeNode.isCheckEnabled() ? super.getForeground((TreeNode)directoryTreeNode) : BColor.gray.toBrush();
        }

        public void paintNode(Graphics graphics, TreeNode treeNode, double d, double d2) {
            DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)treeNode;
            double d3 = d;
            double d4 = d2 + this.getHeight() / 2.0 - 5.0;
            double d5 = 10.0;
            double d6 = 10.0;
            graphics.setBrush(this.getForeground(treeNode));
            graphics.strokeRect(d3, d4, d5, d6);
            if (directoryTreeNode.isChecked()) {
                graphics.strokeLine(d3, d4, d3 + d5, d4 + d6);
                graphics.strokeLine(d3, d4 + d5, d3 + d5, d4);
            }
            super.paintNode(graphics, treeNode, d + 12.0, d2);
        }
    }

    public static class DirectoryTreeNode
    extends TreeNode {
        private BIDirectory dir;
        private boolean checked = true;
        private boolean checkEnabled = true;
        private ArrayList childNodes;
        public static final BImage icon = BImage.make((String)"module://icons/x16/folder.png");
        public static final BImage disabledIcon = icon.getDisabledImage();

        public DirectoryTreeNode(DirectoryTreeModel directoryTreeModel, BIDirectory bIDirectory) {
            super((TreeModel)directoryTreeModel);
            this.init(bIDirectory);
        }

        public DirectoryTreeNode(BIDirectory bIDirectory, DirectoryTreeNode directoryTreeNode) {
            super((TreeNode)directoryTreeNode);
            this.init(bIDirectory);
        }

        private void init(BIDirectory bIDirectory) {
            this.dir = bIDirectory;
            this.childNodes = new ArrayList();
            try {
                BIFile[] bIFileArray = bIDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!bIFileArray[i].isDirectory()) continue;
                    this.childNodes.add(new DirectoryTreeNode((BIDirectory)bIFileArray[i], this));
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.setExpanded(true);
        }

        public BIFile getFile() {
            return (BIFile)this.getDirectory();
        }

        public BIDirectory getDirectory() {
            return this.dir;
        }

        public boolean inCheckBox(double d, double d2) {
            double d3 = this.getX() + Theme.tree().getExpanderWidth() + 4.0;
            return d >= d3 && d <= d3 + 10.0;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean bl) {
            this.setChecked(bl, BTreeCascadePolicy.never, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy) {
            this.setChecked(bl, bTreeCascadePolicy, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2, boolean bl2) {
            BDirectoryNodeEvent bDirectoryNodeEvent = new BDirectoryNodeEvent();
            this.setChecked(bl, bTreeCascadePolicy, bTreeCascadePolicy2, bDirectoryNodeEvent, bl2);
            ((DirectoryTreeModel)this.getModel()).fireNodeChecked(bDirectoryNodeEvent);
        }

        private void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2, BDirectoryNodeEvent bDirectoryNodeEvent, boolean bl2) {
            TreeNode treeNode;
            if (this.checked != bl && (this.isCheckEnabled() || !bl2)) {
                this.checked = bl;
                bDirectoryNodeEvent.addNode(this);
            }
            if (bTreeCascadePolicy.cascade(bl)) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DirectoryTreeNode)this.getChild(i)).setChecked(bl, BTreeCascadePolicy.always, BTreeCascadePolicy.never, bDirectoryNodeEvent, bl2);
                }
            }
            if (bTreeCascadePolicy2.cascade(bl) && (treeNode = this.getParent()) != null && treeNode instanceof DirectoryTreeNode) {
                ((DirectoryTreeNode)treeNode).setChecked(bl, BTreeCascadePolicy.never, BTreeCascadePolicy.always, bDirectoryNodeEvent, bl2);
            }
        }

        public boolean isCheckEnabled() {
            return this.checkEnabled;
        }

        public void setCheckEnabled(boolean bl) {
            this.setCheckEnabled(bl, false);
        }

        public void setCheckEnabled(boolean bl, boolean bl2) {
            this.checkEnabled = bl;
            if (bl2) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DirectoryTreeNode)this.getChild(i)).setCheckEnabled(bl, true);
                }
            }
        }

        public void toggleChecked() {
            this.toggleChecked(BTreeCascadePolicy.never, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy bTreeCascadePolicy) {
            this.toggleChecked(bTreeCascadePolicy, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2) {
            this.setChecked(!this.isChecked(), bTreeCascadePolicy, bTreeCascadePolicy2, true);
        }

        public String getText() {
            return ((BIFile)this.dir).getFileName();
        }

        public BImage getIcon() {
            return this.checkEnabled ? icon : disabledIcon;
        }

        public int getChildCount() {
            return this.childNodes.size();
        }

        public TreeNode getChild(int n) {
            return (TreeNode)this.childNodes.get(n);
        }

        public TreeNode getChild(String string) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!((BIFile)((DirectoryTreeNode)this.getChild(i)).getDirectory()).getFileName().equals(string)) continue;
                return this.getChild(i);
            }
            return null;
        }
    }

    public static class DirectoryTreeModel
    extends TreeModel {
        private DirectoryTreeNode root;

        public void setRootDirectory(BIDirectory bIDirectory) {
            if (bIDirectory == null) {
                this.root = null;
            } else {
                this.root = new DirectoryTreeNode(this, bIDirectory);
                this.root.setCheckEnabled(false);
            }
            this.updateTree();
        }

        public void fireNodeChecked(BDirectoryNodeEvent bDirectoryNodeEvent) {
            if (this.getTree() instanceof BDirectoryTree) {
                ((BDirectoryTree)this.getTree()).fireNodeChecked(bDirectoryNodeEvent);
            }
        }

        public int getRootCount() {
            return this.root == null ? 0 : 1;
        }

        public Iterator getCheckedDirectories() {
            return this.getCheckedDirectories(true);
        }

        public Iterator getCheckedDirectories(boolean bl) {
            ArrayList arrayList = new ArrayList();
            this.getCheckedDirectories(this.root, bl, arrayList);
            return arrayList.iterator();
        }

        private void getCheckedDirectories(DirectoryTreeNode directoryTreeNode, boolean bl, Collection collection) {
            if (directoryTreeNode.isChecked() == bl) {
                collection.add(directoryTreeNode.getDirectory());
            }
            for (int i = 0; i < directoryTreeNode.getChildCount(); ++i) {
                this.getCheckedDirectories((DirectoryTreeNode)directoryTreeNode.getChild(i), bl, collection);
            }
        }

        public void setDirectoryStates(DirectoryTreeNode directoryTreeNode, PatternFilter[] patternFilterArray, boolean bl, boolean bl2, boolean bl3) {
            if (directoryTreeNode != null) {
                int n;
                String string = ((BIFile)directoryTreeNode.getDirectory()).getFileName();
                for (n = 0; n < patternFilterArray.length; ++n) {
                    if (!patternFilterArray[n].accept(string)) continue;
                    directoryTreeNode.setChecked(bl);
                    directoryTreeNode.setCheckEnabled(bl2);
                    directoryTreeNode.setExpanded(bl3);
                }
                for (n = 0; n < directoryTreeNode.getChildCount(); ++n) {
                    this.setDirectoryStates((DirectoryTreeNode)directoryTreeNode.getChild(n), patternFilterArray, bl, bl2, bl3);
                }
            }
        }

        public TreeNode getRoot(int n) {
            return this.root;
        }

        public TreeNode findNode(FilePath filePath) {
            FilePath filePath2 = ((BIFile)this.root.getDirectory()).getFilePath();
            if (filePath.getAbsoluteMode() != filePath2.getAbsoluteMode() || filePath.depth() < filePath2.depth()) {
                return null;
            }
            for (int i = 0; i < filePath2.depth(); ++i) {
                if (filePath2.nameAt(i).equals(filePath.nameAt(i))) continue;
                return null;
            }
            DirectoryTreeNode directoryTreeNode = this.root;
            for (int i = filePath2.depth(); i < filePath.depth(); ++i) {
                if ((directoryTreeNode = (DirectoryTreeNode)directoryTreeNode.getChild(filePath.nameAt(i))) != null) continue;
                return null;
            }
            return directoryTreeNode;
        }
    }

    public static class DirectoryTreeController
    extends TreeController {
        private BTreeCascadePolicy cascadeAncestorPolicy = BTreeCascadePolicy.never;
        private BTreeCascadePolicy cascadeDescendantPolicy = BTreeCascadePolicy.always;

        public void mousePressed(BMouseEvent bMouseEvent) {
            this.getTree().requestFocus();
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            DirectoryTreeNode directoryTreeNode = (DirectoryTreeNode)this.getTree().yToTreeNode(d2);
            if (directoryTreeNode != null) {
                if (directoryTreeNode.inExpander(d, d2)) {
                    this.getTree().toggleExpanded((TreeNode)directoryTreeNode);
                } else if (directoryTreeNode.inCheckBox(d, d2)) {
                    if (directoryTreeNode.isCheckEnabled()) {
                        directoryTreeNode.toggleChecked(this.getCascadeDescendantPolicy(), this.getCascadeAncestorPolicy());
                        this.getTree().relayout();
                    }
                } else if (directoryTreeNode.isSelection(d, d2)) {
                    this.mouseSelection(directoryTreeNode, bMouseEvent);
                    if (!bMouseEvent.isButton3Down() && bMouseEvent.getClickCount() == 2) {
                        this.doSelectAction(directoryTreeNode, bMouseEvent.getX(), bMouseEvent.getY());
                    }
                } else {
                    directoryTreeNode = null;
                    this.mouseSelection(null, bMouseEvent);
                }
            } else {
                this.mouseSelection(null, bMouseEvent);
            }
            if (bMouseEvent.isPopupTrigger()) {
                this.popup(bMouseEvent, directoryTreeNode);
            }
        }

        public BTreeCascadePolicy getCascadeAncestorPolicy() {
            return this.cascadeAncestorPolicy;
        }

        public void setCascadeAncestorPolicy(BTreeCascadePolicy bTreeCascadePolicy) {
            this.cascadeAncestorPolicy = bTreeCascadePolicy;
        }

        public BTreeCascadePolicy getCascadeDescendantPolicy() {
            return this.cascadeDescendantPolicy;
        }

        public void setCascadeDescendantPolicy(BTreeCascadePolicy bTreeCascadePolicy) {
            this.cascadeDescendantPolicy = bTreeCascadePolicy;
        }
    }
}

