/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;

public class AuditUtil {
    private static FilePath userHomePath;
    private static SimpleDateFormat timestampFormat;

    public static void audit(String string, BHost bHost, Type type, BComponent bComponent, BComponent bComponent2) throws Exception {
        AuditUtil.audit(string, bHost, type.toString(), bComponent, bComponent2);
    }

    public static void audit(String string, BHost bHost, String string2, BComponent bComponent, BComponent bComponent2) throws Exception {
        BFolder bFolder = new BFolder();
        if (bHost != null) {
            bFolder.add("host", (BValue)BString.make((String)bHost.getNavDisplayName(null)), 1);
        }
        bFolder.add("editor", (BValue)BString.make((String)string2), 1);
        bFolder.add("modTime", (BValue)BAbsTime.make(), 1);
        bFolder.add("priorValue", bComponent.newCopy(), 1);
        bFolder.add("newValue", bComponent2.newCopy(), 1);
        BIFile bIFile = BFileSystem.INSTANCE.findFile(AuditUtil.getUserHomePath().merge(string + ".bog"));
        BFolder bFolder2 = new BFolder();
        if (bIFile == null) {
            bIFile = BFileSystem.INSTANCE.makeFile(AuditUtil.getUserHomePath().merge(string + ".bog"));
        } else {
            bFolder2 = (BFolder)new ValueDocDecoder(bIFile).decodeDocument();
        }
        bFolder2.add(timestampFormat.format(new Date()), (BValue)bFolder);
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(bIFile.getOutputStream());
        valueDocEncoder.setEncodeTransients(true);
        valueDocEncoder.encodeDocument((BValue)bFolder2);
    }

    private static FilePath getUserHomePath() {
        if (userHomePath == null) {
            userHomePath = BFileSystem.INSTANCE.localFileToPath(Sys.getUserHome());
        }
        return userHomePath;
    }

    static {
        timestampFormat = new SimpleDateFormat("'d'yyyyMMddkkmmss");
    }

    public static class ViewAuditCommand
    extends Command {
        private BWbShell wbShell;
        private String auditName;

        public ViewAuditCommand(String string, BWidget bWidget) {
            super(bWidget, Sys.loadModule((String)"platform"), "AuditUtil.command");
            this.setEnabled(false);
            if (bWidget.getShell() instanceof BWbShell) {
                this.wbShell = (BWbShell)bWidget.getShell();
            }
            this.auditName = string;
        }

        public boolean auditFileExists() {
            return BFileSystem.INSTANCE.findFile(AuditUtil.getUserHomePath().merge(this.auditName + ".bog")) != null;
        }

        public CommandArtifact doInvoke() {
            if (this.wbShell != null) {
                this.wbShell.hyperlink(BOrd.make((String)("local:|" + AuditUtil.getUserHomePath().merge(this.auditName + ".bog") + "|bog:|slot:/|view:workbench:PropertySheet")));
            }
            return null;
        }
    }
}

