/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.tcpip.BIpHostVectorFE;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

public final class BTcpIpAdapterEditor
extends BWbView {
    public static final Action setEnabledStates = BTcpIpAdapterEditor.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$tcpip$BTcpIpAdapterEditor == null ? (class$com$tridium$platform$ui$tcpip$BTcpIpAdapterEditor = BTcpIpAdapterEditor.class$("com.tridium.platform.ui.tcpip.BTcpIpAdapterEditor")) : class$com$tridium$platform$ui$tcpip$BTcpIpAdapterEditor));
    private BLabel interfaceIdLabel = null;
    private BLabel interfaceDescLabel = null;
    private BLabel macAddressLabel = null;
    private boolean canDisableAdapter = false;
    private boolean canUseDhcp = false;
    private BCheckBox dhcpEnabledCheckBox = null;
    private BCheckBox adapterEnabledCheckBox = null;
    private BTextField domainTextField = null;
    private BIpHostFE gatewayFE = null;
    private BIpHostVectorFE dnsHostEditor = null;
    private BIpHostFE ipAddressFE = null;
    private BIpHostFE subnetMaskFE = null;
    private BLabel dhcpHostLabel = null;
    private BLabel dhcpLeaseGrantedLabel = null;
    private BLabel dhcpLeaseExpiresLabel = null;
    private boolean isIPv6Readonly = true;
    private BLabel ipv6DhcpHostLabel = null;
    private BLabel ipv6DhcpLeaseGrantedLabel = null;
    private BLabel ipv6DhcpLeaseExpiresLabel = null;
    private BLabel ipv6SupportedLabel = null;
    private BTextField ipv6SubnetPrefixLengthFE = null;
    private boolean canDisableIpv6 = false;
    private boolean isIpv6Supported = false;
    private boolean isIpv6Enabled = false;
    private boolean canUseIpv6Dhcp = false;
    private BCheckBox ipv6EnabledCheckBox = null;
    private BCheckBox ipv6DhcpEnabledCheckBox = null;
    private BIpHostFE ipv6AddressFE = null;
    private BIpHostFE ipv6GatewayFE = null;
    private BIpHostVectorFE ipv6DnsHostEditor = null;
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    static /* synthetic */ Class class$com$tridium$platform$ui$tcpip$BTcpIpAdapterEditor;

    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected final void doLoadValue(BObject bObject, Context context) {
        BBorderPane bBorderPane;
        BasicContext basicContext;
        BTcpIpAdapterSettings bTcpIpAdapterSettings = (BTcpIpAdapterSettings)bObject;
        BEdgePane bEdgePane = new BEdgePane();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.setRowAlign(BValign.top);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        bGridPane.setColorRows(false);
        this.canDisableAdapter = bTcpIpAdapterSettings.getCanDisableAdapter();
        this.interfaceIdLabel = new BLabel(bTcpIpAdapterSettings.getAdapterId());
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceId"), (BWidget)this.interfaceIdLabel);
        this.interfaceDescLabel = new BLabel(bTcpIpAdapterSettings.getDescription());
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.interfaceDesc"), (BWidget)this.interfaceDescLabel);
        this.macAddressLabel = new BLabel(bTcpIpAdapterSettings.getMediaAccessControlAddress());
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.macAddress"), (BWidget)this.macAddressLabel);
        this.adapterEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.adapterEnabled.value"));
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isAdapterEnabled"), (BWidget)this.adapterEnabledCheckBox);
        this.adapterEnabledCheckBox.setSelected(bTcpIpAdapterSettings.getIsAdapterEnabled());
        this.linkTo(null, (BComponent)this.adapterEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.adapterEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        bEdgePane.setTop((BWidget)bGridPane);
        BTabbedPane bTabbedPane = new BTabbedPane();
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setRowAlign(BValign.top);
        bGridPane2.setColumnGap(10.0);
        bGridPane2.setRowGap(6.0);
        bGridPane2.setColorRows(false);
        this.canUseDhcp = bTcpIpAdapterSettings.getCanUseDhcp();
        if (this.canUseDhcp) {
            this.dhcpEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isDhcpEnabled.value"));
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isDhcpEnabled"), (BWidget)this.dhcpEnabledCheckBox);
            this.dhcpEnabledCheckBox.setSelected(bTcpIpAdapterSettings.getIsDhcpEnabled());
            this.linkTo(null, (BComponent)this.dhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            this.linkTo(null, (BComponent)this.dhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        } else {
            this.dhcpEnabledCheckBox = null;
        }
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.domainTextField = new BTextField(bTcpIpAdapterSettings.getDomain(), 32);
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.domain"), (BWidget)this.domainTextField);
            this.linkTo(null, (BComponent)this.domainTextField, (Slot)BTextField.textModified, (Slot)setModified);
        } else {
            this.domainTextField = null;
        }
        this.ipAddressFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipAddress"), (BWidget)this.ipAddressFE);
        this.ipAddressFE.loadValue((BObject)BString.make((String)bTcpIpAdapterSettings.getIpAddress()), context);
        this.linkTo(null, (BComponent)this.ipAddressFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.gatewayFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.gateway"), (BWidget)this.gatewayFE);
            this.gatewayFE.loadValue((BObject)BString.make((String)bTcpIpAdapterSettings.getDefaultGateway()), context);
            this.linkTo(null, (BComponent)this.gatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        } else {
            this.gatewayFE = null;
        }
        this.subnetMaskFE = new BIpHostFE();
        LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.subnetMask"), (BWidget)this.subnetMaskFE);
        this.subnetMaskFE.loadValue((BObject)BString.make((String)bTcpIpAdapterSettings.getSubnetMask()), context);
        this.linkTo(null, (BComponent)this.subnetMaskFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
        if (this.canUseDhcp) {
            this.dhcpHostLabel = new BLabel(bTcpIpAdapterSettings.getDhcpHost().toString().trim());
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpHost"), (BWidget)this.dhcpHostLabel);
            this.dhcpLeaseGrantedLabel = new BLabel(bTcpIpAdapterSettings.getDhcpLeaseGranted());
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseGranted"), (BWidget)this.dhcpLeaseGrantedLabel);
            this.dhcpLeaseExpiresLabel = new BLabel(bTcpIpAdapterSettings.getDhcpLeaseExpires());
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dhcpLeaseExpires"), (BWidget)this.dhcpLeaseExpiresLabel);
        } else {
            this.dhcpHostLabel = null;
            this.dhcpLeaseGrantedLabel = null;
            this.dhcpLeaseExpiresLabel = null;
        }
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.dnsHostEditor = new BIpHostVectorFE();
            LabelUtil.addLabelWidgetPair(bGridPane2, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)this.dnsHostEditor);
            basicContext = new BasicContext(context, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)bTcpIpAdapterSettings.getMaxDnsHosts())));
            this.dnsHostEditor.loadValue((BObject)bTcpIpAdapterSettings.getDnsHosts(), (Context)basicContext);
            this.linkTo(null, (BComponent)this.dnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
        } else {
            this.dnsHostEditor = null;
        }
        bTabbedPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"connection.png")), LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.IPv4Settings").getText(context), BOLD_TEXT_FONT), (BWidget)new BBorderPane((BWidget)bGridPane2));
        basicContext = new BGridPane(2);
        basicContext.setHalign(BHalign.left);
        basicContext.setValign(BValign.top);
        basicContext.setRowAlign(BValign.top);
        basicContext.setColumnGap(10.0);
        basicContext.setRowGap(6.0);
        basicContext.setColorRows(false);
        this.isIpv6Supported = bTcpIpAdapterSettings.getIsIpv6Supported();
        this.isIpv6Enabled = this.isIpv6Supported && bTcpIpAdapterSettings.getIsIpv6Enabled();
        this.canDisableIpv6 = bTcpIpAdapterSettings.getCanDisableIpv6();
        this.canUseIpv6Dhcp = bTcpIpAdapterSettings.getCanUseIpv6Dhcp();
        bTcpIpAdapterSettings.getHostSettings().lease();
        this.isIPv6Readonly = bTcpIpAdapterSettings.getHostSettings().getIsIPv6Readonly();
        String string = this.isIpv6Supported ? this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Supported.true") : this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Supported.false");
        this.ipv6SupportedLabel = new BLabel(string);
        LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Supported"), (BWidget)this.ipv6SupportedLabel);
        if (this.isIpv6Supported && !this.isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && this.isIpv6Enabled) {
            this.ipv6EnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isIpv6Enabled.value"));
            LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6Enabled"), (BWidget)this.ipv6EnabledCheckBox);
            this.ipv6EnabledCheckBox.setSelected(this.isIpv6Supported && this.isIpv6Enabled);
            this.linkTo(null, (BComponent)this.ipv6EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            this.linkTo(null, (BComponent)this.ipv6EnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            if (this.canUseIpv6Dhcp) {
                this.ipv6DhcpEnabledCheckBox = new BCheckBox(this.getLexicon().getText("TcpIpAdapterEditor.isIpv6DhcpEnabled.value"));
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled"), (BWidget)this.ipv6DhcpEnabledCheckBox);
                this.ipv6DhcpEnabledCheckBox.setSelected(bTcpIpAdapterSettings.getIsIpv6DhcpEnabled());
                this.linkTo(null, (BComponent)this.ipv6DhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                this.linkTo(null, (BComponent)this.ipv6DhcpEnabledCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
            } else {
                this.ipv6DhcpEnabledCheckBox = null;
            }
        } else {
            this.ipv6EnabledCheckBox = null;
            this.ipv6DhcpEnabledCheckBox = null;
        }
        if (this.isIpv6Supported && !this.isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && this.isIpv6Enabled) {
            this.ipv6AddressFE = new BIpHostFE(true);
            LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Address"), (BWidget)this.ipv6AddressFE);
            this.ipv6AddressFE.loadValue((BObject)BString.make((String)bTcpIpAdapterSettings.getIpv6Address()), context);
            this.linkTo(null, (BComponent)this.ipv6AddressFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
                this.ipv6GatewayFE = new BIpHostFE(true);
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)this.ipv6GatewayFE);
                this.ipv6GatewayFE.loadValue((BObject)BString.make((String)bTcpIpAdapterSettings.getIpv6DefaultGateway()), context);
                this.linkTo(null, (BComponent)this.ipv6GatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            } else {
                this.ipv6GatewayFE = null;
            }
            this.ipv6SubnetPrefixLengthFE = new BTextField(String.valueOf(bTcpIpAdapterSettings.getIpv6SubnetPrefixLength()), 4);
            LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength"), (BWidget)this.ipv6SubnetPrefixLengthFE);
            this.linkTo(null, (BComponent)this.ipv6SubnetPrefixLengthFE, (Slot)BTextField.textModified, (Slot)setModified);
        } else {
            this.ipv6AddressFE = null;
            this.ipv6GatewayFE = null;
            this.ipv6SubnetPrefixLengthFE = null;
        }
        if ((this.isIpv6Supported && !this.isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && this.isIpv6Enabled) && this.canUseIpv6Dhcp) {
            if (!bTcpIpAdapterSettings.getIpv6DhcpHost().toString().trim().equalsIgnoreCase("n/a")) {
                this.ipv6DhcpHostLabel = new BLabel(bTcpIpAdapterSettings.getIpv6DhcpHost().toString().trim());
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpHost"), (BWidget)this.ipv6DhcpHostLabel);
                this.ipv6DhcpLeaseGrantedLabel = new BLabel(bTcpIpAdapterSettings.getIpv6DhcpLeaseGranted());
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseGranted"), (BWidget)this.ipv6DhcpLeaseGrantedLabel);
                this.ipv6DhcpLeaseExpiresLabel = new BLabel(bTcpIpAdapterSettings.getIpv6DhcpLeaseExpires());
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DhcpLeaseExpires"), (BWidget)this.ipv6DhcpLeaseExpiresLabel);
            }
        } else {
            this.ipv6DhcpHostLabel = null;
            this.ipv6DhcpLeaseGrantedLabel = null;
            this.ipv6DhcpLeaseExpiresLabel = null;
        }
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            if (this.isIpv6Supported && !this.isIpv6Enabled && this.canDisableIpv6 || this.isIpv6Supported && this.isIpv6Enabled) {
                this.ipv6DnsHostEditor = new BIpHostVectorFE(true);
                LabelUtil.addLabelWidgetPair((BGridPane)basicContext, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)this.ipv6DnsHostEditor);
                if (bTcpIpAdapterSettings.getIsIpv6Enabled()) {
                    bBorderPane = new BasicContext(context, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)bTcpIpAdapterSettings.getMaxDnsHosts())));
                    this.ipv6DnsHostEditor.loadValue((BObject)bTcpIpAdapterSettings.getIpv6DnsHosts(), (Context)bBorderPane);
                }
                this.linkTo(null, (BComponent)this.ipv6DnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
            } else {
                this.ipv6DnsHostEditor = null;
            }
        } else {
            this.ipv6DnsHostEditor = null;
        }
        bTabbedPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"connections.png")), LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.IPv6Settings").getText(context), BOLD_TEXT_FONT), (BWidget)new BBorderPane((BWidget)basicContext));
        bBorderPane = new BBorderPane((BWidget)bTabbedPane);
        bBorderPane.setBorder(BBorder.none);
        bBorderPane.setMargin(BInsets.make((double)8.0, (double)0.0, (double)0.0, (double)0.0));
        bBorderPane.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        bEdgePane.setCenter((BWidget)bBorderPane);
        this.doSetReadonly(this.isReadonly() || bTcpIpAdapterSettings.getHostSettings().getIsReadonly());
        this.setContent((BWidget)bEdgePane);
    }

    public BTcpIpAdapterSettings getAdapter() {
        return (BTcpIpAdapterSettings)this.getCurrentValue();
    }

    public boolean isAdapterEnabledSelected() {
        return this.adapterEnabledCheckBox.isSelected();
    }

    public boolean isIpv6EnabledSelected() {
        return this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected();
    }

    public boolean isDhcpEnabledSelected() {
        return this.dhcpEnabledCheckBox != null && this.dhcpEnabledCheckBox.isSelected();
    }

    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        if (!this.isModified()) {
            return bObject;
        }
        BTcpIpAdapterSettings bTcpIpAdapterSettings = (BTcpIpAdapterSettings)bObject;
        boolean bl = this.adapterEnabledCheckBox.isSelected();
        if (this.canDisableAdapter) {
            bTcpIpAdapterSettings.setIsAdapterEnabled(this.adapterEnabledCheckBox.isSelected());
        }
        if (bl) {
            String string;
            BString bString;
            BString bString2 = (BString)this.ipAddressFE.saveValue(context);
            BString bString3 = (BString)this.subnetMaskFE.saveValue(context);
            if (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) {
                if (bString2.toString().trim().length() == 0) {
                    this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullIpAddress");
                }
                if (bString3.toString().trim().length() == 0) {
                    this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullSubnetMask");
                }
                if (!IPAddressUtil.isIpv4SubnetMask((String)bString3.getString().trim())) {
                    this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.invalidSubnetMaskValue");
                }
            }
            if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                bString = (BString)this.ipv6AddressFE.saveValue(context);
                string = this.ipv6SubnetPrefixLengthFE.getText();
                if (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) {
                    if (bString.toString().trim().length() == 0) {
                        this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullIpv6Address");
                    }
                    if (string.trim().length() == 0) {
                        this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullIpv6SubnetPrefixLength");
                    }
                }
            }
            if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
                bString = (BString)this.gatewayFE.saveValue(context);
                if ((this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && bString.toString().trim().length() == 0) {
                    this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullGateway");
                }
                bTcpIpAdapterSettings.setDefaultGateway(this.gatewayFE.saveValue(context).toString().trim());
                bTcpIpAdapterSettings.setDomain(this.domainTextField.getText().trim());
                bTcpIpAdapterSettings.setDnsHosts((BVector)this.dnsHostEditor.saveValue(context));
                if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                    string = (BString)this.ipv6GatewayFE.saveValue(context);
                    if (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) {
                        if (string.toString().trim().length() == 0) {
                            this.saveError(bTcpIpAdapterSettings.getAdapterId(), "TcpIpAdapterEditor.nullIpv6Gateway");
                        }
                        bTcpIpAdapterSettings.setIpv6DefaultGateway(this.ipv6GatewayFE.saveValue(context).toString().trim());
                        bTcpIpAdapterSettings.setIpv6DnsHosts((BVector)this.ipv6DnsHostEditor.saveValue(context));
                    }
                }
            }
            if (bTcpIpAdapterSettings.getCanUseDhcp()) {
                bTcpIpAdapterSettings.setIsDhcpEnabled(this.dhcpEnabledCheckBox.isSelected());
            } else {
                bTcpIpAdapterSettings.setIsDhcpEnabled(false);
            }
            if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected()) {
                if (bTcpIpAdapterSettings.getCanUseIpv6Dhcp()) {
                    bTcpIpAdapterSettings.setIsIpv6DhcpEnabled(this.ipv6DhcpEnabledCheckBox.isSelected());
                } else {
                    bTcpIpAdapterSettings.setIsIpv6DhcpEnabled(false);
                }
            }
            if (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) {
                bTcpIpAdapterSettings.setIpAddress(this.ipAddressFE.saveValue(context).toString().trim());
                bTcpIpAdapterSettings.setSubnetMask(this.subnetMaskFE.saveValue(context).toString().trim());
            }
            if (this.isIpv6Supported) {
                if (bTcpIpAdapterSettings.getCanDisableIpv6()) {
                    bTcpIpAdapterSettings.setIsIpv6Enabled(this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected());
                }
                if (this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected()) {
                    bTcpIpAdapterSettings.setIpv6Address(this.ipv6AddressFE.saveValue(context).toString().trim());
                    try {
                        bTcpIpAdapterSettings.setIpv6SubnetPrefixLength(Integer.valueOf(this.ipv6SubnetPrefixLengthFE.getText().trim()));
                    }
                    catch (Exception exception) {
                        this.saveError(this.getAdapter().getAdapterId(), "TcpIpAdapterEditor.invalidIpv6SubnetPrefixLength");
                    }
                }
            }
        }
        return bTcpIpAdapterSettings;
    }

    protected void saveError(String string, String string2) throws CannotSaveException {
        BDialog.error((BWidget)this, (String)this.getLexicon().getText("TcpIpAdapterEditor.invalidDataTitle"), (Object)(string + ": " + this.getLexicon().getText(string2)));
        CannotSaveException cannotSaveException = new CannotSaveException();
        cannotSaveException.setSilent(true);
        throw cannotSaveException;
    }

    protected void doSetReadonly(boolean bl) {
        this.adapterEnabledCheckBox.setEnabled(!bl && this.canDisableAdapter);
        if (this.isIpv6Supported && this.ipv6EnabledCheckBox != null) {
            this.ipv6EnabledCheckBox.setEnabled(!bl && this.canDisableIpv6 && !this.isIPv6Readonly);
        }
        this.doSetEnabledStates();
    }

    public final void doSetEnabledStates() {
        boolean bl;
        if (this.dhcpEnabledCheckBox != null) {
            this.dhcpEnabledCheckBox.setEnabled(this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && this.canUseDhcp);
        }
        if (this.ipAddressFE != null) {
            bl = (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly();
            this.ipAddressFE.setEnabled(bl);
            this.ipAddressFE.setReadonly(!bl);
        }
        if (this.subnetMaskFE != null) {
            bl = (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly();
            this.subnetMaskFE.setEnabled(bl);
            this.subnetMaskFE.setReadonly(!bl);
        }
        if (this.gatewayFE != null) {
            bl = (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly();
            this.gatewayFE.setEnabled(bl);
            this.gatewayFE.setReadonly(!bl);
        }
        if (this.dnsHostEditor != null) {
            bl = (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly();
            this.dnsHostEditor.setEnabled(bl);
            this.dnsHostEditor.setReadonly(!bl);
        }
        if (this.domainTextField != null) {
            bl = (this.dhcpEnabledCheckBox != null && !this.dhcpEnabledCheckBox.isSelected() || this.dhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && !this.isReadonly();
            this.domainTextField.setEditable(bl);
            this.domainTextField.setEnabled(bl);
        }
        if (this.isIpv6Supported) {
            if (this.ipv6EnabledCheckBox != null) {
                bl = this.adapterEnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6EnabledCheckBox.setEnabled(bl);
            }
            if (this.ipv6DhcpEnabledCheckBox != null) {
                bl = this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && this.canUseIpv6Dhcp && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6DhcpEnabledCheckBox.setEnabled(bl);
            }
            if (this.ipv6DnsHostEditor != null) {
                bl = (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6DnsHostEditor.setEnabled(bl);
                this.ipv6DnsHostEditor.setReadonly(!bl);
            }
            if (this.ipv6AddressFE != null) {
                bl = (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6AddressFE.setEnabled(bl);
                this.ipv6AddressFE.setReadonly(!bl);
            }
            if (this.ipv6SubnetPrefixLengthFE != null) {
                bl = (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6SubnetPrefixLengthFE.setEditable(bl);
                this.ipv6SubnetPrefixLengthFE.setEnabled(bl);
            }
            if (this.ipv6GatewayFE != null) {
                bl = (this.ipv6DhcpEnabledCheckBox != null && !this.ipv6DhcpEnabledCheckBox.isSelected() || this.ipv6DhcpEnabledCheckBox == null) && this.adapterEnabledCheckBox.isSelected() && this.ipv6EnabledCheckBox != null && this.ipv6EnabledCheckBox.isSelected() && !this.isReadonly() && !this.isIPv6Readonly;
                this.ipv6GatewayFE.setEnabled(bl);
                this.ipv6GatewayFE.setReadonly(!bl);
            }
        }
    }

    public final void processComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BTcpIpAdapterSettings) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = (BTcpIpAdapterSettings)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            BValue bValue = bTcpIpAdapterSettings.get(property);
            if (property == BTcpIpAdapterSettings.isAdapterEnabled) {
                this.adapterEnabledCheckBox.setSelected(((BBoolean)bValue).getBoolean());
                this.doSetEnabledStates();
            } else if (property == BTcpIpAdapterSettings.isDhcpEnabled) {
                this.dhcpEnabledCheckBox.setSelected(((BBoolean)bValue).getBoolean());
                this.doSetEnabledStates();
            } else if (property == BTcpIpAdapterSettings.adapterId) {
                this.interfaceIdLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.description) {
                this.interfaceDescLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.mediaAccessControlAddress) {
                this.macAddressLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.dhcpHost) {
                this.dhcpHostLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.dhcpLeaseGranted) {
                this.dhcpLeaseGrantedLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.dhcpLeaseExpires) {
                this.dhcpLeaseExpiresLabel.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.domain) {
                this.domainTextField.setText(bValue.toString().trim());
            } else if (property == BTcpIpAdapterSettings.ipAddress) {
                this.ipAddressFE.loadValue((BObject)((BString)bValue));
            } else if (property == BTcpIpAdapterSettings.subnetMask) {
                this.subnetMaskFE.loadValue((BObject)((BString)bValue));
            } else if (property == BTcpIpAdapterSettings.defaultGateway) {
                this.gatewayFE.loadValue((BObject)((BString)bValue));
            } else if (property == BTcpIpAdapterSettings.dnsHosts) {
                this.dnsHostEditor.loadValue((BObject)((BVector)bValue));
            } else if (property == BTcpIpAdapterSettings.isIpv6Supported) {
                this.ipv6SupportedLabel.setText(bValue.toString().trim());
                this.doSetEnabledStates();
            } else if (this.isIpv6Supported) {
                if (property == BTcpIpAdapterSettings.isIpv6DhcpEnabled) {
                    this.ipv6DhcpEnabledCheckBox.setSelected(((BBoolean)bValue).getBoolean());
                    this.doSetEnabledStates();
                } else if (property == BTcpIpAdapterSettings.isIpv6Enabled) {
                    if (this.ipv6EnabledCheckBox != null) {
                        this.ipv6EnabledCheckBox.setSelected(((BBoolean)bValue).getBoolean());
                        this.doSetEnabledStates();
                    }
                } else if (property == BTcpIpAdapterSettings.ipv6DnsHosts) {
                    this.ipv6DnsHostEditor.loadValue((BObject)((BVector)bValue));
                } else if (property == BTcpIpAdapterSettings.ipv6Address) {
                    this.ipv6AddressFE.loadValue((BObject)((BString)bValue));
                } else if (property == BTcpIpAdapterSettings.ipv6SubnetPrefixLength) {
                    this.ipv6SubnetPrefixLengthFE.setText(bValue.toString().trim());
                } else if (property == BTcpIpAdapterSettings.ipv6DefaultGateway) {
                    this.ipv6GatewayFE.loadValue((BObject)((BString)bValue));
                } else if (property == BTcpIpAdapterSettings.ipv6DhcpHost) {
                    this.ipv6DhcpHostLabel.setText(bValue.toString().trim());
                } else if (property == BTcpIpAdapterSettings.ipv6DhcpLeaseExpires) {
                    this.ipv6DhcpLeaseExpiresLabel.setText(bValue.toString().trim());
                } else if (property == BTcpIpAdapterSettings.ipv6DhcpLeaseGranted) {
                    this.ipv6DhcpLeaseGrantedLabel.setText(bValue.toString().trim());
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

