/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.util.CommandUtil;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BIpHostVectorFE
extends BWbFieldEditor {
    public static final Action handleFocusChange = BIpHostVectorFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$tcpip$BIpHostVectorFE == null ? (class$com$tridium$platform$ui$tcpip$BIpHostVectorFE = BIpHostVectorFE.class$("com.tridium.platform.ui.tcpip.BIpHostVectorFE")) : class$com$tridium$platform$ui$tcpip$BIpHostVectorFE));
    private boolean isIpv6 = false;
    private BGridPane contentPane;
    private BWbFieldEditor focusedEditor = null;
    private Command addCommand;
    private Command deleteCommand;
    private Command upCommand;
    private Command downCommand;
    private int maxHosts = 2;
    public static final String MAX_HOSTS = "maxHosts";
    static /* synthetic */ Class class$com$tridium$platform$ui$tcpip$BIpHostVectorFE;
    static /* synthetic */ Class class$javax$baja$sys$BString;
    static /* synthetic */ Class class$javax$baja$workbench$fieldeditor$BWbFieldEditor;

    public void handleFocusChange(BFocusEvent bFocusEvent) {
        this.invoke(handleFocusChange, (BValue)bFocusEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIpHostVectorFE() {
        this(false);
    }

    public BIpHostVectorFE(boolean bl) {
        this.isIpv6 = bl;
        BFlowPane bFlowPane = new BFlowPane(BHalign.center);
        BToolBar bToolBar = new BToolBar();
        bFlowPane.add(null, (BValue)bToolBar, null);
        this.addCommand = new AddCommand();
        BButton bButton = new BButton(this.addCommand);
        bToolBar.add("add", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        bButton = new BButton(this.deleteCommand);
        bToolBar.add("delete", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.upCommand = new UpCommand();
        bButton = new BButton(this.upCommand);
        bToolBar.add("up", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.downCommand = new DownCommand();
        bButton = new BButton(this.downCommand);
        bToolBar.add("down", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(1);
        this.contentPane = new BGridPane(1);
        bGridPane.add(null, (BValue)this.contentPane);
        bGridPane.add(null, (BValue)bFlowPane);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.center);
        this.setContent((BWidget)bGridPane);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        try {
            this.maxHosts = context == null ? 2 : context.getFacets().geti(MAX_HOSTS, 2);
            BVector bVector = (BVector)bObject;
            this.contentPane.removeAll();
            SlotCursor slotCursor = bVector.loadSlots().getProperties();
            while (slotCursor.next(class$javax$baja$sys$BString == null ? BIpHostVectorFE.class$("javax.baja.sys.BString") : class$javax$baja$sys$BString)) {
                this.addElement((BValue)((BString)slotCursor.get()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BVector bVector = (BVector)bObject;
        bVector.removeAll();
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BString bString = (BString)((BWbFieldEditor)bWidgetArray[i]).saveValue(context);
            if (bString.toString().trim().length() == 0) {
                throw new LocalizableRuntimeException("platform", "IpHostVectorFE.emptyDnsHost");
            }
            String string = SlotPath.escape((String)bString.toString());
            if (bVector.getProperty(string) != null) {
                throw new LocalizableRuntimeException("platform", "IpHostVectorFE.duplicate", new Object[]{bString});
            }
            bVector.add(string, (BValue)bString, 1, (Context)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platform:IpHostFE")));
        }
        return bVector;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.deleteCommand.setEnabled(bl && this.focusedEditor != null);
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        this.addCommand.setEnabled(bl && bWidgetArray.length < this.maxHosts);
        for (int i = 0; i < bWidgetArray.length; ++i) {
            bWidgetArray[i].setEnabled(bl);
        }
    }

    protected void doSetReadonly(boolean bl) {
        this.setEnabled(!bl);
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            ((BWbFieldEditor)bWidgetArray[i]).setReadonly(bl);
        }
    }

    public void addElements(BValue[] bValueArray) {
        for (int i = 0; i < bValueArray.length; ++i) {
            this.addElement(bValueArray[i]);
        }
    }

    public void addElement(BValue bValue) {
        BIpHostFE bIpHostFE = new BIpHostFE(this.isIpv6);
        bIpHostFE.loadValue((BObject)bValue);
        this.contentPane.add(null, (BValue)bIpHostFE, 0);
        bIpHostFE.setEnabled(this.isEnabled());
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.linkTo(null, (BComponent)bIpHostFE, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)bIpHostFE, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
        this.setEnabled(this.isEnabled());
    }

    public void doHandleFocusChange(BFocusEvent bFocusEvent) {
        try {
            if (!this.isEnabled()) {
                return;
            }
            if (bFocusEvent.getId() == 1005) {
                if (this.focusedEditor == bFocusEvent.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (bFocusEvent.getId() == 1004) {
                this.focusedEditor = (BWbFieldEditor)bFocusEvent.getWidget();
            }
            this.setArrowCommandEnabledStates();
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Property[] getDynamicPropertiesArray(BObject bObject, boolean bl) {
        if (bl) {
            bObject.asComplex().loadSlots();
        }
        Property[] propertyArray = bObject.asComplex().getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].isFrozen()) continue;
            Property[] propertyArray2 = new Property[propertyArray.length - i];
            System.arraycopy(propertyArray, i, propertyArray2, 0, propertyArray2.length);
            return propertyArray2;
        }
        return new Property[0];
    }

    private void setArrowCommandEnabledStates() {
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        if (bWidgetArray.length > 1 && this.focusedEditor != null) {
            this.upCommand.setEnabled(bWidgetArray[0] != this.focusedEditor);
            this.downCommand.setEnabled(bWidgetArray[bWidgetArray.length - 1] != this.focusedEditor);
        } else {
            this.upCommand.setEnabled(false);
            this.downCommand.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownCommand
    extends Command {
        public DownCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowDown.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] propertyArray = BIpHostVectorFE.getDynamicPropertiesArray((BObject)BIpHostVectorFE.this.contentPane, true);
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (BIpHostVectorFE.this.focusedEditor != BIpHostVectorFE.this.contentPane.get(propertyArray[i])) continue;
                    Property property = propertyArray[i];
                    propertyArray[i] = propertyArray[i + 1];
                    propertyArray[i + 1] = property;
                    BIpHostVectorFE.this.contentPane.reorder(propertyArray);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    private class UpCommand
    extends Command {
        public UpCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowUp.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] propertyArray = BIpHostVectorFE.getDynamicPropertiesArray((BObject)BIpHostVectorFE.this.contentPane, true);
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (BIpHostVectorFE.this.focusedEditor != BIpHostVectorFE.this.contentPane.get(propertyArray[i])) continue;
                    Property property = propertyArray[i];
                    propertyArray[i] = propertyArray[i - 1];
                    propertyArray[i - 1] = property;
                    BIpHostVectorFE.this.contentPane.reorder(propertyArray);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
        }

        public CommandArtifact doInvoke() {
            BIpHostVectorFE.this.addElement((BValue)BString.DEFAULT);
            BIpHostVectorFE.this.setArrowCommandEnabledStates();
            this.setEnabled(BIpHostVectorFE.this.contentPane.getChildWidgets().length < BIpHostVectorFE.this.maxHosts);
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BIpHostVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BIpHostVectorFE.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor slotCursor = BIpHostVectorFE.this.contentPane.loadSlots().getProperties();
                while (slotCursor.next(class$javax$baja$workbench$fieldeditor$BWbFieldEditor == null ? BIpHostVectorFE.class$("javax.baja.workbench.fieldeditor.BWbFieldEditor") : class$javax$baja$workbench$fieldeditor$BWbFieldEditor)) {
                    if (slotCursor.get() != BIpHostVectorFE.this.focusedEditor) continue;
                    BIpHostVectorFE.this.contentPane.remove(slotCursor.property());
                    BIpHostVectorFE.this.focusedEditor = null;
                    BIpHostVectorFE.this.deleteCommand.setEnabled(false);
                    BIpHostVectorFE.this.addCommand.setEnabled(true);
                    BIpHostVectorFE.this.setModified();
                    BIpHostVectorFE.this.setArrowCommandEnabledStates();
                    BIpHostVectorFE.this.relayout();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }
}

