/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.ui.util.ValidatingTextController;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.text.TextController;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BIpHostFE
extends BWbFieldEditor {
    public static final Action propagateFocusEvent = BIpHostFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Action propagateKeyEvent = BIpHostFE.newAction((int)4, (BValue)new BKeyEvent(), null);
    public static final Action propagateMouseEvent = BIpHostFE.newAction((int)4, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$tcpip$BIpHostFE == null ? (class$com$tridium$platform$ui$tcpip$BIpHostFE = BIpHostFE.class$("com.tridium.platform.ui.tcpip.BIpHostFE")) : class$com$tridium$platform$ui$tcpip$BIpHostFE));
    private boolean isIpv6 = false;
    private BTextField field;
    private static final String HEX = "0123456789abcdefABCDEF";
    static /* synthetic */ Class class$com$tridium$platform$ui$tcpip$BIpHostFE;

    public void propagateFocusEvent(BFocusEvent bFocusEvent) {
        this.invoke(propagateFocusEvent, (BValue)bFocusEvent, null);
    }

    public void propagateKeyEvent(BKeyEvent bKeyEvent) {
        this.invoke(propagateKeyEvent, (BValue)bKeyEvent, null);
    }

    public void propagateMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(propagateMouseEvent, (BValue)bMouseEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIpHostFE() {
        this(false);
    }

    public BIpHostFE(boolean bl) {
        this.isIpv6 = bl;
        this.field = this.isIpv6 ? new BTextField("", 45) : new BTextField("", 15);
        this.field.setController((TextController)(this.isIpv6 ? new Ipv6Controller() : new Controller()));
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.field, (Slot)BTextField.focusEvent, (Slot)propagateFocusEvent);
        this.linkTo("lk3", (BComponent)this.field, (Slot)BTextField.keyEvent, (Slot)propagateKeyEvent);
        this.linkTo("lk4", (BComponent)this.field, (Slot)BTextField.mouseEvent, (Slot)propagateMouseEvent);
        this.setContent((BWidget)this.field);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BString bString = (BString)bObject;
        this.field.setText(bString.toString());
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        String string = this.field.getText();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (string.trim().length() == 0) {
            return BString.DEFAULT;
        }
        if (this.isIpv6) {
            int n2 = 0;
            int n3 = 0;
            if (string.indexOf("::") != string.lastIndexOf("::")) {
                throw new CannotSaveException("improper IPv6 address format: ambiguous expansion");
            }
            for (int n4 = 0; n4 < string.length(); n4 = (int)((short)(n4 + 1))) {
                char c = string.charAt(n4);
                if (c == ':') {
                    if (n2 >= 7) {
                        throw new CannotSaveException("improper IPv6 address format: too many colons");
                    }
                    if (n3 > 0) {
                        stringBuffer.append(Integer.toHexString(Integer.parseInt(string.substring(n, n4), 16)));
                    }
                    stringBuffer.append(':');
                    n3 = 0;
                    n2 = (short)(n2 + 1);
                    continue;
                }
                if (HEX.indexOf(c) != -1) {
                    if (n3 == 0) {
                        n = n4;
                    }
                    if (n3 >= 4) {
                        throw new CannotSaveException("improper IPv6 address format: exceeded field width");
                    }
                    n3 = (short)(n3 + 1);
                    continue;
                }
                throw new CannotSaveException("improper IPv6 address format: illegal character");
            }
            if (n3 > 0) {
                stringBuffer.append(Integer.toHexString(Integer.parseInt(string.substring(n, string.length()), 16)));
            }
            if (n2 < 2 || stringBuffer.indexOf("::") == -1 && n2 < 7 || n3 == 0 && stringBuffer.lastIndexOf(":") == stringBuffer.length() - 1 && stringBuffer.indexOf("::") != stringBuffer.length() - 2) {
                throw new CannotSaveException("improper IPv6 address format: not enough colons or trailing colon");
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    if (n6 == 0 || n5 >= 3) {
                        throw new CannotSaveException("improper IPv4 address format: leading dot, double dot, or too many dots");
                    }
                    stringBuffer.append(Integer.parseInt(string.substring(n, i)));
                    stringBuffer.append('.');
                    n6 = 0;
                    n7 = 0;
                    ++n5;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (n6 == 0) {
                        n = i;
                    }
                    if (n6 >= 3) {
                        throw new CannotSaveException("improper IPv4 address format: too many digits");
                    }
                    ++n6;
                    if ((n7 = n7 * 10 + Integer.valueOf(new String("" + c))) <= 255) continue;
                    throw new CannotSaveException("improper IPv4 address format: value > 255");
                }
                throw new CannotSaveException("improper IPv4 address format");
            }
            stringBuffer.append(Integer.parseInt(string.substring(n, string.length())));
            if (n5 != 3 || n6 == 0) {
                throw new CannotSaveException("improper IPv4 address format: too few dots or trailing dot");
            }
        }
        return BString.make((String)stringBuffer.toString());
    }

    public void setEnabled(boolean bl) {
        this.field.setEditable(bl);
    }

    protected void doSetReadonly(boolean bl) {
        this.setEnabled(!bl);
    }

    public void doPropagateFocusEvent(BFocusEvent bFocusEvent) {
        this.fireFocusEvent(new BFocusEvent(bFocusEvent.getId(), (BWidget)this, bFocusEvent.isTemporary()));
    }

    public void doPropagateKeyEvent(BKeyEvent bKeyEvent) {
        this.fireKeyEvent(new BKeyEvent(bKeyEvent.getId(), (BWidget)this, bKeyEvent.getModifiers(), bKeyEvent.getKeyCode(), bKeyEvent.getKeyChar()));
    }

    public void doPropagateMouseEvent(BMouseEvent bMouseEvent) {
        if (bMouseEvent instanceof BMouseWheelEvent) {
            this.fireMouseEvent((BMouseEvent)new BMouseWheelEvent(bMouseEvent.getId(), (BWidget)this, bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), bMouseEvent.isPopupTrigger(), ((BMouseWheelEvent)bMouseEvent).getWheelRotation()));
        } else {
            this.fireMouseEvent(new BMouseEvent(bMouseEvent.getId(), (BWidget)this, bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), bMouseEvent.isPopupTrigger()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Ipv6Controller
    extends Controller {
        private Ipv6Controller() {
        }

        protected boolean valid(String string) {
            if (string.trim().length() == 0) {
                return true;
            }
            int n = 0;
            int n2 = 0;
            if (string.indexOf("::") != string.lastIndexOf("::")) {
                return false;
            }
            for (int n3 = 0; n3 < string.length(); n3 = (int)((short)(n3 + 1))) {
                char c = string.charAt(n3);
                if (c == ':') {
                    if (n >= 7) {
                        return false;
                    }
                    n2 = 0;
                    n = (short)(n + 1);
                    continue;
                }
                if (BIpHostFE.HEX.indexOf(c) != -1) {
                    if (n2 >= 4) {
                        return false;
                    }
                    n2 = (short)(n2 + 1);
                    continue;
                }
                return false;
            }
            return true;
        }
    }

    private class Controller
    extends ValidatingTextController {
        private Controller() {
        }

        protected boolean valid(String string) {
            if (string.trim().length() == 0) {
                return true;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    if (n2 == 0 || n >= 3) {
                        return false;
                    }
                    n2 = 0;
                    n3 = 0;
                    ++n;
                    continue;
                }
                if (Character.isDigit(c)) {
                    if (n2 >= 3) {
                        return false;
                    }
                    ++n2;
                    if ((n3 = n3 * 10 + Integer.valueOf(new String("" + c))) <= 255) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
    }
}

