/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.pki;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.pki.PemCertInfo;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

public class BServerCertsTable
extends BCommandBoundTable
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$pki$BServerCertsTable == null ? (class$com$tridium$platform$ui$pki$BServerCertsTable = BServerCertsTable.class$("com.tridium.platform.ui.pki.BServerCertsTable")) : class$com$tridium$platform$ui$pki$BServerCertsTable));
    public static final Lexicon LEX = Lexicon.make((String)"platform");
    public static final ExtFileFilter PEM_FILTER = new ExtFileFilter("", "pem,crt,cer");
    protected BDirectory dir;
    protected FilePath dirPath;
    protected BFileSpace space;
    public static final int COL_SOURCE = 0;
    public static final int COL_ISSUER = 1;
    public static final int COL_SUBJECT = 2;
    public static final int COL_START = 3;
    public static final int COL_END = 4;
    public static final int COL_ALG = 5;
    protected boolean readonly = false;
    static /* synthetic */ Class class$com$tridium$platform$ui$pki$BServerCertsTable;
    static /* synthetic */ Class class$com$tridium$platform$pki$PemCertInfo;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public BServerCertsTable() {
        throw new UnsupportedOperationException();
    }

    public BServerCertsTable(FilePath filePath, BFileSpace bFileSpace, CommandBindings.TableController tableController) throws Exception {
        super(new ServerCertModel(), tableController);
        this.dirPath = filePath;
        this.space = bFileSpace;
        this.dir = this.initDir(filePath);
        this.initCommands();
    }

    public BServerCertsTable(FilePath filePath, BFileSpace bFileSpace) throws Exception {
        super(new ServerCertModel());
        this.dirPath = filePath;
        this.space = bFileSpace;
        this.dir = this.initDir(filePath);
        this.initCommands();
    }

    public void load() throws Exception {
        this.serverCertModel().load(this.dir);
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport(this);
        this.addCommand(new ImportCommand(), BCommandEnablePolicy.always);
        this.addCommand(new ExportCommand(), BCommandEnablePolicy.anySelection);
        ViewCommand viewCommand = new ViewCommand();
        this.addCommand(viewCommand, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(viewCommand);
        this.addCommand(new DeleteCommand(), BCommandEnablePolicy.anySelection);
    }

    protected ServerCertModel serverCertModel() {
        return (ServerCertModel)this.getModel();
    }

    protected BDirectory initDir(FilePath filePath) throws Exception {
        if (this.space instanceof BDaemonFileSpace) {
            BDirectory bDirectory = (BDirectory)this.space.findFile(filePath);
            if (bDirectory == null) {
                this.initDir(filePath.getParent());
                BDaemonFileSpace bDaemonFileSpace = (BDaemonFileSpace)this.space;
                DaemonFileUtil.transfer(bDaemonFileSpace.getDaemonSession(), FileTransferMessage.makeMkDir(filePath, bDaemonFileSpace), null);
                bDirectory = (BDirectory)this.space.findFile(filePath);
            }
            return bDirectory;
        }
        return this.space.makeDir(this.dirPath);
    }

    protected Object beginFileTransfer() {
        if (this.space instanceof BDaemonFileSpace) {
            return new FileTransferMessage((BDaemonFileSpace)this.space);
        }
        return null;
    }

    protected void installCertFile(BIFile bIFile, Object object) throws Exception {
        FilePath filePath = this.dir.getFilePath().merge(FileUtil.getBase((String)bIFile.getFileName()) + ".pem");
        if (this.space instanceof BDaemonFileSpace) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            fileTransferMessage.addFile(bIFile, filePath);
        } else {
            BIFile bIFile2 = this.dir.getFileSpace().makeFile(filePath);
            FileUtil.pipe((BIFile)bIFile, (BIFile)bIFile2);
        }
    }

    protected void deleteCertFile(BIFile bIFile, Object object) throws Exception {
        if (this.space instanceof BDaemonFileSpace) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            fileTransferMessage.addDelete(bIFile.getFilePath());
        } else {
            bIFile.delete();
        }
    }

    protected void commitFileTransfer(Object object) throws Exception {
        if (object != null) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            DaemonFileUtil.transfer(fileTransferMessage.getTargetFileSpace().getDaemonSession(), (FileTransferMessage)object, null);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (this.readonly && (command instanceof ImportCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            command.setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ExportCommand
    extends Command {
        public ExportCommand() {
            super((BWidget)BServerCertsTable.this, LEX, "ServerCertsTable.export");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = FavoriteDirectory.loadByPath(BServerCertsTable.this.getType().toString(), "exportDir", null);
                BDirectory bDirectory2 = (BDirectory)BFileChooserDialog.chooseFile(this.getOwner(), null, LEX.getText("ServerCertsTable.export.dlgTitle"), LEX.getText("ServerCertsTable.export.dlgMessage"), (BIFile)bDirectory, IFileFilter.directory, null, null);
                if (bDirectory2 != null) {
                    int[] nArray = BServerCertsTable.this.getSelection().getRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        BIFile bIFile = BServerCertsTable.this.serverCertModel().cert((int)nArray[i]).file;
                        BIFile bIFile2 = BFileSystem.INSTANCE.makeFile(bDirectory2.getFilePath().merge(bIFile.getFileName()));
                        FileUtil.pipe((BIFile)bIFile, (BIFile)bIFile2);
                    }
                    FavoriteDirectory.savePath(BServerCertsTable.this.getType().toString(), "exportDir", bDirectory2.getFilePath().getParent());
                }
            }
            catch (Exception exception) {
                CommandUtil.error(this, exception);
            }
            return null;
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BServerCertsTable.this, LEX, "ServerCertsTable.delete");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BServerCertsTable.this, (String)LEX.getText("ServerCertsTable.delete.dlgTitle"), (Object)LEX.getText("ServerCertsTable.delete.dlgMessage"), (int)12)) {
                    int[] nArray = BServerCertsTable.this.getSelection().getRows();
                    Object object = BServerCertsTable.this.beginFileTransfer();
                    for (int i = 0; i < nArray.length; ++i) {
                        BServerCertsTable.this.deleteCertFile(BServerCertsTable.this.serverCertModel().cert((int)nArray[i]).file, object);
                    }
                    BServerCertsTable.this.commitFileTransfer(object);
                    BServerCertsTable.this.serverCertModel().load(BServerCertsTable.this.dir);
                }
            }
            catch (Exception exception) {
                CommandUtil.error(this, exception);
            }
            return null;
        }
    }

    protected class ImportCommand
    extends Command {
        public ImportCommand() {
            super((BWidget)BServerCertsTable.this, LEX, "ServerCertsTable.import");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = FavoriteDirectory.loadByPath(BServerCertsTable.this.getType().toString(), "serverCertDir", null);
                BIFile[] bIFileArray = BFileChooserDialog.chooseFiles(this.getOwner(), BImage.make((String)LEX.getText("ServerCertsTable.import.dlgIcon")), LEX.getText("ServerCertsTable.import.dlgTitle"), LEX.getText("ServerCertsTable.import.dlgMessage"), (BIFile)bDirectory, (IFileFilter)PEM_FILTER, (IFileFilter)PEM_FILTER);
                if (bIFileArray == null || bIFileArray.length == 0) {
                    return null;
                }
                PemCertInfo[] pemCertInfoArray = PemCertInfo.makeCertificates(bIFileArray);
                Object object = BServerCertsTable.this.beginFileTransfer();
                Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BServerCertsTable.class$("java.lang.String")) : class$java$lang$String);
                for (int i = 0; i < pemCertInfoArray.length; ++i) {
                    if (pemCertInfoArray[i].cert == null) {
                        array.add((Object)pemCertInfoArray[i].file.getFileName());
                        continue;
                    }
                    BServerCertsTable.this.installCertFile(pemCertInfoArray[i].file, object);
                }
                BServerCertsTable.this.commitFileTransfer(object);
                if (array.size() > 0) {
                    BIndentPane bIndentPane = new BIndentPane();
                    bIndentPane.add(LEX.getText("ServerCertsTable.import.invalidFile.header"));
                    bIndentPane.indent();
                    for (int i = 0; i < array.size(); ++i) {
                        bIndentPane.add(array.get(i).toString());
                    }
                    BDialog.warning((BWidget)this.getOwner(), (String)LEX.getText("ServerCertsTable.import.invalidFile.dlgTitle"), (Object)((Object)bIndentPane));
                }
                BServerCertsTable.this.serverCertModel().load(BServerCertsTable.this.dir);
                if (bIFileArray.length > 0) {
                    FavoriteDirectory.savePath(BServerCertsTable.this.getType().toString(), "serverCertDir", bIFileArray[0].getFilePath().getParent());
                }
            }
            catch (Exception exception) {
                CommandUtil.error(this, exception);
            }
            return null;
        }
    }

    protected class ViewCommand
    extends Command {
        public ViewCommand() {
            super((BWidget)BServerCertsTable.this, LEX, "ServerCertsTable.view");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    protected static class ServerCertModel
    extends TableModel {
        private Array certs = new Array(class$com$tridium$platform$pki$PemCertInfo == null ? (class$com$tridium$platform$pki$PemCertInfo = BServerCertsTable.class$("com.tridium.platform.pki.PemCertInfo")) : class$com$tridium$platform$pki$PemCertInfo);

        protected ServerCertModel() {
        }

        public void load(BDirectory bDirectory) throws Exception {
            if (bDirectory == null) {
                this.certs.clear();
            } else {
                this.certs = new Array((Object[])PemCertInfo.makeCertificates(bDirectory.listFiles()));
            }
            this.updateTable(true);
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX.getText("ServerCertsTable.col.source");
                }
                case 1: {
                    return LEX.getText("ServerCertsTable.col.issuer");
                }
                case 2: {
                    return LEX.getText("ServerCertsTable.col.subject");
                }
                case 3: {
                    return LEX.getText("ServerCertsTable.col.start");
                }
                case 4: {
                    return LEX.getText("ServerCertsTable.col.end");
                }
                case 5: {
                    return LEX.getText("ServerCertsTable.col.sig");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public int getRowCount() {
            return this.certs.size();
        }

        public PemCertInfo cert(int n) {
            return (PemCertInfo)this.certs.get(n);
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.cert((int)n).file.getFileName();
                }
                case 1: {
                    return this.cert(n).getIssuer();
                }
                case 2: {
                    return this.cert(n).getSubject();
                }
                case 3: {
                    return this.cert(n).getStart();
                }
                case 4: {
                    return this.cert(n).getEnd();
                }
                case 5: {
                    return this.cert(n).getSignatureAlgName();
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

