/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.pki;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.pki.ClientPrivateKeyInfo;
import com.tridium.platform.pki.PemCertInfo;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BClientKeysTable
extends BCommandBoundTable
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$pki$BClientKeysTable == null ? (class$com$tridium$platform$ui$pki$BClientKeysTable = BClientKeysTable.class$("com.tridium.platform.ui.pki.BClientKeysTable")) : class$com$tridium$platform$ui$pki$BClientKeysTable));
    public static final Lexicon LEX = Lexicon.make((String)"platform");
    protected FilePath keyDirPath;
    protected BDirectory keyDir;
    protected FilePath certDirPath;
    protected BDirectory certDir;
    protected BFileSpace space;
    protected boolean readonly = false;
    public static final ExtFileFilter KEY_FILTER = new ExtFileFilter("", "p12,pks,pem");
    public static final ExtFileFilter CERT_FILTER = new ExtFileFilter("", "pem,crt,cer");
    protected static final int COL_KEY_FILE = 0;
    protected static final int COL_CERT_FILE = 1;
    static /* synthetic */ Class class$com$tridium$platform$ui$pki$BClientKeysTable;
    static /* synthetic */ Class class$com$tridium$platform$pki$ClientPrivateKeyInfo;

    public Type getType() {
        return TYPE;
    }

    public BClientKeysTable() {
        throw new UnsupportedOperationException();
    }

    public BClientKeysTable(FilePath filePath, FilePath filePath2, BFileSpace bFileSpace, CommandBindings.TableController tableController) throws Exception {
        this.setModel(new Model());
        this.setController(tableController);
        this.keyDirPath = filePath;
        this.certDirPath = filePath2;
        this.space = bFileSpace;
        this.keyDir = this.initDir(filePath);
        this.certDir = this.initDir(filePath2);
        this.initCommands();
    }

    public BClientKeysTable(FilePath filePath, FilePath filePath2, BFileSpace bFileSpace) throws Exception {
        this.setModel(new Model());
        this.keyDirPath = filePath;
        this.certDirPath = filePath2;
        this.space = bFileSpace;
        this.keyDir = this.initDir(filePath);
        this.certDir = this.initDir(filePath2);
        this.initCommands();
    }

    public void load() throws Exception {
        this.keysModel().load();
    }

    protected Model keysModel() {
        return (Model)this.getModel();
    }

    protected void initCommands() {
        this.getCommandBindings().setSupport(this);
        this.addCommand(new ImportCommand(), BCommandEnablePolicy.always);
        this.addCommand(new BackupCommand(), BCommandEnablePolicy.singleSelection);
        ViewCommand viewCommand = new ViewCommand();
        this.addCommand(viewCommand, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(viewCommand);
        this.addCommand(new DeleteCommand(), BCommandEnablePolicy.anySelection);
    }

    protected BDirectory initDir(FilePath filePath) throws Exception {
        if (this.space instanceof BDaemonFileSpace) {
            BDirectory bDirectory = (BDirectory)this.space.findFile(filePath);
            if (bDirectory == null) {
                this.initDir(filePath.getParent());
                BDaemonFileSpace bDaemonFileSpace = (BDaemonFileSpace)this.space;
                DaemonFileUtil.transfer(bDaemonFileSpace.getDaemonSession(), FileTransferMessage.makeMkDir(filePath, bDaemonFileSpace), null);
                bDirectory = (BDirectory)this.space.findFile(filePath);
            }
            return bDirectory;
        }
        return this.space.makeDir(filePath);
    }

    protected Object beginFileTransfer() {
        if (this.space instanceof BDaemonFileSpace) {
            return new FileTransferMessage((BDaemonFileSpace)this.space);
        }
        return null;
    }

    protected void install(ClientPrivateKeyInfo clientPrivateKeyInfo, Object object) throws Exception {
        FilePath filePath = this.keyDir.getFilePath().merge(clientPrivateKeyInfo.keyFile.getFileName());
        FilePath filePath2 = null;
        if (clientPrivateKeyInfo.certFile != null && clientPrivateKeyInfo.certFile != clientPrivateKeyInfo.keyFile) {
            filePath2 = this.certDir.getFilePath().merge(clientPrivateKeyInfo.getNormalCertFilename());
        }
        if (this.space instanceof BDaemonFileSpace) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            fileTransferMessage.addFile(clientPrivateKeyInfo.keyFile, filePath);
            if (filePath2 != null) {
                fileTransferMessage.addFile(clientPrivateKeyInfo.certFile, filePath2);
            }
        } else {
            BIFile bIFile = this.keyDir.getFileSpace().makeFile(filePath);
            FileUtil.pipe((BIFile)clientPrivateKeyInfo.keyFile, (BIFile)bIFile);
            if (filePath2 != null) {
                bIFile = this.certDir.getFileSpace().makeFile(filePath2);
                FileUtil.pipe((BIFile)clientPrivateKeyInfo.certFile, (BIFile)bIFile);
            }
        }
    }

    protected void delete(ClientPrivateKeyInfo clientPrivateKeyInfo, Object object) throws Exception {
        if (this.space instanceof BDaemonFileSpace) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            fileTransferMessage.addDelete(clientPrivateKeyInfo.keyFile.getFilePath());
            if (clientPrivateKeyInfo.certFile != null) {
                fileTransferMessage.addDelete(clientPrivateKeyInfo.certFile.getFilePath());
            }
        } else {
            clientPrivateKeyInfo.keyFile.delete();
            if (clientPrivateKeyInfo.certFile != null) {
                clientPrivateKeyInfo.certFile.delete();
            }
        }
    }

    protected void commitFileTransfer(Object object) throws Exception {
        if (object != null) {
            FileTransferMessage fileTransferMessage = (FileTransferMessage)object;
            DaemonFileUtil.transfer(fileTransferMessage.getTargetFileSpace().getDaemonSession(), (FileTransferMessage)object, null);
        }
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
        this.setCommandEnabledStates();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (this.readonly && (command instanceof ImportCommand || command instanceof DeleteCommand)) {
            command.setEnabled(false);
        } else {
            command.setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class CertFileStep
    extends ImportWizardStep
    implements BFileChooserPane.Listener {
        private int mode = 0;
        private BFileChooserPane chooser;

        public CertFileStep(ImportWizardModel importWizardModel) {
            super(importWizardModel);
            this.chooser = new BFileChooserPane((BIFile)FavoriteDirectory.loadByPath(BClientKeysTable.this.getType().toString(), "clientCertDir", null), (IFileFilter)CERT_FILTER, (IFileFilter)CERT_FILTER, null, null, false, false, null);
            this.setContent((BWidget)this.chooser);
            this.chooser.addListener(this);
        }

        public String getStepName() {
            return "certFile";
        }

        public int getMode() {
            return this.mode;
        }

        public void enter() {
            this.chooser.notifyFileSelected();
        }

        public boolean exit(int n) {
            if (this.chooser.getSelectedFile() != null) {
                FavoriteDirectory.savePath(BClientKeysTable.this.getType().toString(), "clientCertDir", this.chooser.getSelectedFile().getFilePath().getParent());
            }
            if (n == 4) {
                this.wizardModel.getKeyInfo().certFile = this.chooser.getSelectedFile();
            }
            return true;
        }

        public void fileSelected(boolean bl) {
            if (bl) {
                try {
                    bl = PemCertInfo.getPEMCertificate(this.chooser.getSelectedFile(), new int[0]) != null;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            this.mode = bl ? 5 : 1;
            this.wizardModel.update(this.mode);
        }
    }

    protected class KeyFileStep
    extends ImportWizardStep
    implements BFileChooserPane.Listener {
        private int mode = 0;
        private BFileChooserPane chooser;
        private ClientPrivateKeyInfo info;

        public KeyFileStep(ImportWizardModel importWizardModel) {
            super(importWizardModel);
            this.chooser = new BFileChooserPane((BIFile)FavoriteDirectory.loadByPath(BClientKeysTable.this.getType().toString(), "clientKeyDir", null), (IFileFilter)KEY_FILTER, (IFileFilter)KEY_FILTER, null, null, false, false, null);
            this.setContent((BWidget)this.chooser);
            this.chooser.addListener(this);
            this.nextStep = new CertFileStep(importWizardModel);
            this.nextStep.priorStep = this;
        }

        public String getStepName() {
            return "keyFile";
        }

        public int getMode() {
            return this.mode;
        }

        public void enter() {
            this.chooser.notifyFileSelected();
        }

        public boolean exit(int n) {
            FavoriteDirectory.savePath(BClientKeysTable.this.getType().toString(), "clientKeyDir", this.chooser.getSelectedFile().getFilePath().getParent());
            this.wizardModel.setKeyInfo(this.info);
            return true;
        }

        public void fileSelected(boolean bl) {
            this.info = null;
            if (bl) {
                try {
                    this.info = new ClientPrivateKeyInfo(this.chooser.getSelectedFile());
                    if (this.info.hasKey) {
                        this.mode = this.info.certFile == null ? 2 : 4;
                        this.wizardModel.update(this.mode);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mode = 0;
            this.wizardModel.update(0);
        }
    }

    protected abstract class ImportWizardStep {
        protected BEdgePane contentPane;
        protected BEdgePane stepPane;
        protected ImportWizardStep priorStep = null;
        protected ImportWizardStep nextStep = null;
        protected ImportWizardStep lastStep = this;
        protected ImportWizardStep stepAfterSection = null;
        protected ImportWizardModel wizardModel;

        public ImportWizardStep(ImportWizardModel importWizardModel) {
            this.wizardModel = importWizardModel;
            this.contentPane = new BEdgePane(null, null, null, null, null);
            this.stepPane = new BEdgePane((BWidget)new BWizardHeader(this.getIcon(), LEX.get("ClientKeysTable.importWizard." + this.getStepName() + ".title", ""), LEX.get("ClientKeysTable.importWizard." + this.getStepName() + ".desc", "")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        }

        public BWidget getWidget() {
            return this.stepPane;
        }

        public final BImage getIcon() {
            String string = LEX.get("ClientKeysTable.importWizard." + this.getStepName() + ".stepIcon", null);
            return string == null ? null : BImage.make((String)string);
        }

        public abstract String getStepName();

        protected void checkMode() {
        }

        public void sendDaemonMessages() {
        }

        protected void setContent(BWidget bWidget) {
            this.contentPane.setCenter(bWidget);
            bWidget.relayout();
            this.contentPane.relayout();
        }

        public boolean showCancelPrompt() {
            return true;
        }

        public int getMode() {
            int n = 0;
            ImportWizardStep importWizardStep = this.priorStep;
            while (importWizardStep != null && importWizardStep.isSkipped()) {
                importWizardStep = importWizardStep.priorStep;
            }
            if (importWizardStep != null) {
                n = 1;
            }
            importWizardStep = this.nextStep;
            while (importWizardStep != null && importWizardStep.isSkipped()) {
                importWizardStep = importWizardStep.nextStep;
            }
            n = importWizardStep == null ? (n |= 4) : (n |= 2);
            return n;
        }

        public void enter() {
        }

        public boolean checkBack() {
            return true;
        }

        public boolean checkNext() {
            return true;
        }

        public boolean exit(int n) {
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }

        public void setStepAfterSection(ImportWizardStep importWizardStep) {
            this.stepAfterSection = importWizardStep;
            this.lastStep.nextStep = importWizardStep;
            if (importWizardStep != null) {
                importWizardStep.priorStep = this.lastStep;
            }
        }

        public void setPriorStep(ImportWizardStep importWizardStep) {
            this.priorStep = importWizardStep;
        }
    }

    protected class ImportWizardModel
    extends WizardModel {
        protected BWidget owner;
        protected Context context;
        protected BWbShell shell;
        protected boolean noChanges = false;
        protected boolean canceled;
        protected ImportWizardStep currentStep = null;
        protected ClientPrivateKeyInfo keyInfo = null;

        public ImportWizardModel(BWidget bWidget, Context context) throws Exception {
            this.context = context;
            this.owner = bWidget;
            this.shell = BWbShell.getWbShell((BWidget)bWidget);
            this.currentStep = new KeyFileStep(this);
        }

        public ClientPrivateKeyInfo getKeyInfo() {
            return this.keyInfo;
        }

        public void setKeyInfo(ClientPrivateKeyInfo clientPrivateKeyInfo) {
            this.keyInfo = clientPrivateKeyInfo;
        }

        public Context getContext() {
            return this.context;
        }

        public BWidget getOwner() {
            return this.owner;
        }

        public BWbShell getWbShell() {
            return this.shell;
        }

        public boolean hasNoChanges() {
            return this.noChanges;
        }

        public String getTitle() {
            return LEX.getText("ClientKeysTable.importWizard.title");
        }

        public boolean cancel() {
            if ((!this.getCurrentStep().showCancelPrompt() || BDialog.confirm((BWidget)this.getWizard(), (String)LEX.getText("ClientKeysTable.importWizard.cancel.title"), (Object)LEX.getText("ClientKeysTable.importWizard.cancel.message")) == 4) && this.getCurrentStep().cancel()) {
                this.keyInfo = null;
                return true;
            }
            return false;
        }

        public void setWizard(BWizard bWizard) {
            super.setWizard(bWizard);
            this.owner = bWizard;
        }

        public boolean hasNoSteps() {
            ImportWizardStep importWizardStep = this.currentStep;
            while (importWizardStep != null && importWizardStep.isSkipped()) {
                importWizardStep = importWizardStep.nextStep;
            }
            return importWizardStep == null;
        }

        public void init() {
            ImportWizardStep importWizardStep = this.currentStep;
            while (importWizardStep != null && importWizardStep.isSkipped()) {
                importWizardStep = importWizardStep.nextStep;
            }
            if (importWizardStep != null) {
                this.update(importWizardStep);
                importWizardStep.enter();
            }
        }

        public void back() {
            try {
                if (!this.getCurrentStep().checkBack()) {
                    return;
                }
                ImportWizardStep importWizardStep = this.getCurrentStep().priorStep;
                if (importWizardStep != null && this.getCurrentStep().exit(1)) {
                    while (importWizardStep != null && importWizardStep.isSkipped()) {
                        importWizardStep = importWizardStep.priorStep;
                    }
                    if (importWizardStep != null) {
                        this.update(importWizardStep);
                        importWizardStep.enter();
                    }
                }
            }
            catch (Throwable throwable) {
                BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ClientKeysTable.importWizard.error.dlgTitle"), (Object)LEX.getText("ClientKeysTable.importWizard.error.dlgMessage"), (Throwable)throwable);
            }
        }

        public void next() {
            if (!this.getCurrentStep().checkNext()) {
                return;
            }
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ImportWizardStep importWizardStep;
                        if (ImportWizardModel.this.owner != null) {
                            ImportWizardModel.this.owner.enterBusy();
                        }
                        if ((importWizardStep = ImportWizardModel.this.getCurrentStep().nextStep) != null && ImportWizardModel.this.getCurrentStep().exit(2)) {
                            while (importWizardStep != null && importWizardStep.isSkipped()) {
                                importWizardStep = importWizardStep.nextStep;
                            }
                            if (importWizardStep != null) {
                                importWizardStep.enter();
                                ImportWizardModel.this.update(importWizardStep);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        BDialog.error((BWidget)ImportWizardModel.this.getWizard(), (String)LEX.getText("ClientKeysTable.importWizard.error.dlgTitle"), (Object)LEX.getText("ClientKeysTable.importWizard.error.dlgMessage"), (Throwable)throwable);
                    }
                    finally {
                        if (ImportWizardModel.this.owner != null) {
                            ImportWizardModel.this.owner.exitBusy();
                        }
                    }
                }
            }.start();
        }

        public boolean finish() {
            return this.getCurrentStep().exit(4);
        }

        public ImportWizardStep getCurrentStep() {
            return this.currentStep;
        }

        public void update(ImportWizardStep importWizardStep) {
            this.currentStep = importWizardStep;
            this.update(importWizardStep.getWidget(), importWizardStep.getMode());
        }

        public Size getPreferredSizeOfSteps() {
            return new Size(680.0, 480.0);
        }
    }

    protected class ImportCommand
    extends Command {
        public ImportCommand() {
            super((BWidget)BClientKeysTable.this, LEX, "ClientKeysTable.import");
        }

        public CommandArtifact doInvoke() {
            try {
                ImportWizardModel importWizardModel = new ImportWizardModel(this.getOwner(), null);
                BWizard.open((BWidget)this.getOwner(), (WizardModel)importWizardModel);
                ClientPrivateKeyInfo clientPrivateKeyInfo = importWizardModel.getKeyInfo();
                if (clientPrivateKeyInfo != null) {
                    Object object = BClientKeysTable.this.beginFileTransfer();
                    BClientKeysTable.this.install(clientPrivateKeyInfo, object);
                    BClientKeysTable.this.commitFileTransfer(object);
                    BClientKeysTable.this.keysModel().load();
                }
            }
            catch (Exception exception) {
                CommandUtil.error(this, exception);
            }
            return null;
        }
    }

    protected class BackupCommand
    extends Command {
        public BackupCommand() {
            super((BWidget)BClientKeysTable.this, LEX, "ClientKeysTable.backup");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    protected class ViewCommand
    extends Command {
        public ViewCommand() {
            super((BWidget)BClientKeysTable.this, LEX, "ClientKeysTable.view");
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BClientKeysTable.this, LEX, "ClientKeysTable.delete");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BClientKeysTable.this, (String)LEX.getText("ClientKeysTable.delete.dlgTitle"), (Object)LEX.getText("ClientKeysTable.delete.dlgMessage"), (int)12)) {
                    int[] nArray = BClientKeysTable.this.getSelection().getRows();
                    Object object = BClientKeysTable.this.beginFileTransfer();
                    for (int i = 0; i < nArray.length; ++i) {
                        BClientKeysTable.this.delete(BClientKeysTable.this.keysModel().keyInfo(nArray[i]), object);
                    }
                    BClientKeysTable.this.commitFileTransfer(object);
                    BClientKeysTable.this.keysModel().load();
                }
            }
            catch (Exception exception) {
                CommandUtil.error(this, exception);
            }
            return null;
        }
    }

    protected class Model
    extends TableModel {
        private Array keys = new Array(class$com$tridium$platform$pki$ClientPrivateKeyInfo == null ? (class$com$tridium$platform$pki$ClientPrivateKeyInfo = BClientKeysTable.class$("com.tridium.platform.pki.ClientPrivateKeyInfo")) : class$com$tridium$platform$pki$ClientPrivateKeyInfo);

        protected Model() {
        }

        public void load() throws Exception {
            if (BClientKeysTable.this.keyDir == null) {
                this.keys.clear();
            } else {
                this.keys = new Array((Object[])ClientPrivateKeyInfo.make(BClientKeysTable.this.keyDir.listFiles(), BClientKeysTable.this.certDir));
            }
            this.updateTable(true);
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX.getText("ClientKeysTable.col.keyFile");
                }
                case 1: {
                    return LEX.getText("ClientKeysTable.col.certFile");
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public int getRowCount() {
            return this.keys.size();
        }

        public ClientPrivateKeyInfo keyInfo(int n) {
            return (ClientPrivateKeyInfo)this.keys.get(n);
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.keyInfo((int)n).keyFile.getFileName();
                }
                case 1: {
                    return this.keyInfo((int)n).certFile == null ? null : this.keyInfo((int)n).certFile.getFileName();
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

