/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.ntp;

import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.ui.ntp.BNtpServerFE;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.HashSet;
import javax.baja.agent.AgentFilter;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BNtpServerVectorFE
extends BWbFieldEditor {
    public static final Action handleFocusChange = BNtpServerVectorFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$ntp$BNtpServerVectorFE == null ? (class$com$tridium$platform$ui$ntp$BNtpServerVectorFE = BNtpServerVectorFE.class$("com.tridium.platform.ui.ntp.BNtpServerVectorFE")) : class$com$tridium$platform$ui$ntp$BNtpServerVectorFE));
    private BNtpServerFE feFactory = null;
    private BNtpServerVector vector = null;
    private BWidget header = null;
    private BGridPane contentPane;
    private BWbFieldEditor focusedEditor = null;
    private boolean readonlyInitialized = false;
    private Command addCommand;
    private Command deleteCommand;
    private Command upCommand;
    private Command downCommand;
    static /* synthetic */ Class class$com$tridium$platform$ui$ntp$BNtpServerVectorFE;
    static /* synthetic */ Class class$com$tridium$platform$ntp$BNtpServer;
    static /* synthetic */ Class class$javax$baja$workbench$fieldeditor$BWbFieldEditor;

    public void handleFocusChange(BFocusEvent bFocusEvent) {
        this.invoke(handleFocusChange, (BValue)bFocusEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNtpServerVectorFE() {
        this(null);
    }

    public BNtpServerVectorFE(Type type) {
        if (type != null) {
            this.feFactory = (BNtpServerFE)type.getInstance();
        }
        BFlowPane bFlowPane = new BFlowPane(BHalign.center);
        BToolBar bToolBar = new BToolBar();
        bFlowPane.add(null, (BValue)bToolBar, null);
        this.addCommand = new AddCommand();
        BButton bButton = new BButton(this.addCommand);
        bToolBar.add("add", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        bButton = new BButton(this.deleteCommand);
        bToolBar.add("delete", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.upCommand = new UpCommand();
        bButton = new BButton(this.upCommand);
        bToolBar.add("up", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.downCommand = new DownCommand();
        bButton = new BButton(this.downCommand);
        bToolBar.add("down", (BValue)bButton, null);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(1);
        this.contentPane = new BGridPane(1);
        bGridPane.add(null, (BValue)this.contentPane);
        bGridPane.add(null, (BValue)bFlowPane);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.center);
        this.setContent((BWidget)bGridPane);
    }

    public void doValidate(Context context) throws Exception {
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        int n = this.header == null ? 0 : 1;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = n; i < bWidgetArray.length; ++i) {
            BNtpServerFE bNtpServerFE = (BNtpServerFE)bWidgetArray[i];
            bNtpServerFE.doValidate(context);
            String string = bNtpServerFE.getServerPropertyName(context);
            if (hashSet.contains(string)) {
                throw new LocalizableRuntimeException("platform", "NtpServerVectorFE.duplicateServer");
            }
            hashSet.add(string);
        }
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        try {
            BComplex bComplex;
            this.vector = (BNtpServerVector)bObject;
            this.vector.lease(Integer.MAX_VALUE);
            if (context != null && context.getFacet("fieldEditor") != null) {
                this.feFactory = (BNtpServerFE)BTypeSpec.make((String)context.getFacet("fieldEditor").toString()).getInstance();
            }
            if (!this.readonlyInitialized && (bComplex = this.vector.getParent()) != null) {
                this.setReadonly((bComplex.loadSlots().getFlags((Slot)this.vector.getPropertyInParent()) & 1) > 0);
            }
            this.contentPane.removeAll();
            this.header = this.getFeFactory().makeHeader();
            if (this.header != null) {
                this.contentPane.add(null, (BValue)this.header, 0);
            }
            bComplex = this.vector.loadSlots().getProperties();
            while (bComplex.next(class$com$tridium$platform$ntp$BNtpServer == null ? BNtpServerVectorFE.class$("com.tridium.platform.ntp.BNtpServer") : class$com$tridium$platform$ntp$BNtpServer)) {
                this.addElement((BNtpServer)bComplex.get());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BNtpServerVector bNtpServerVector = (BNtpServerVector)bObject;
        bNtpServerVector.lease();
        bNtpServerVector.removeAll();
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        int n = this.header == null ? 0 : 1;
        String[] stringArray = new String[bWidgetArray.length - n];
        for (int i = n; i < bWidgetArray.length; ++i) {
            BNtpServer bNtpServer = (BNtpServer)((BWbFieldEditor)bWidgetArray[i]).saveValue(context);
            stringArray[i - n] = bNtpServer.getServerString();
        }
        bNtpServerVector.sync(stringArray);
        return bNtpServerVector;
    }

    protected void doSetReadonly(boolean bl) {
        int n;
        this.readonlyInitialized = true;
        super.doSetReadonly(bl);
        this.deleteCommand.setEnabled(!bl && this.focusedEditor != null);
        this.addCommand.setEnabled(!bl);
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        for (int i = n = this.header == null ? 0 : 1; i < bWidgetArray.length; ++i) {
            ((BWbFieldEditor)bWidgetArray[i]).setReadonly(bl);
        }
    }

    protected BNtpServerFE getFeFactory() {
        if (this.feFactory == null) {
            this.feFactory = (BNtpServerFE)Sys.getRegistry().getAgents(this.vector.getElementType()).filter(AgentFilter.is((Type)BNtpServerFE.TYPE)).getDefault().getInstance();
        }
        return this.feFactory;
    }

    public void addElement(BNtpServer bNtpServer) {
        BNtpServerFE bNtpServerFE = (BNtpServerFE)this.getFeFactory().getType().getInstance();
        if (this.header != null) {
            bNtpServerFE.useHeader(this.header);
        }
        if (bNtpServer != null) {
            bNtpServerFE.loadValue((BObject)bNtpServer);
        }
        this.contentPane.add(null, (BValue)bNtpServerFE, 0);
        bNtpServerFE.setReadonly(this.isReadonly());
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.linkTo(null, (BComponent)bNtpServerFE, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)bNtpServerFE, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
    }

    public void doHandleFocusChange(BFocusEvent bFocusEvent) {
        try {
            if (this.isReadonly()) {
                return;
            }
            if (bFocusEvent.getId() == 1005) {
                if (this.focusedEditor == bFocusEvent.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (bFocusEvent.getId() == 1004) {
                this.focusedEditor = (BWbFieldEditor)bFocusEvent.getWidget();
            }
            this.setArrowCommandEnabledStates();
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Property[] getDynamicPropertiesArray(BObject bObject, boolean bl) {
        if (bl) {
            bObject.asComplex().loadSlots();
        }
        Property[] propertyArray = bObject.asComplex().getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (propertyArray[i].isFrozen()) continue;
            Property[] propertyArray2 = new Property[propertyArray.length - i];
            System.arraycopy(propertyArray, i, propertyArray2, 0, propertyArray2.length);
            return propertyArray2;
        }
        return new Property[0];
    }

    private void setArrowCommandEnabledStates() {
        BWidget[] bWidgetArray = this.contentPane.getChildWidgets();
        if (bWidgetArray.length > 1 && this.focusedEditor != null) {
            int n = this.header == null ? 0 : 1;
            this.upCommand.setEnabled(bWidgetArray[n] != this.focusedEditor);
            this.downCommand.setEnabled(bWidgetArray[bWidgetArray.length - 1] != this.focusedEditor);
        } else {
            this.upCommand.setEnabled(false);
            this.downCommand.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownCommand
    extends Command {
        public DownCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowDown.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] propertyArray = BNtpServerVectorFE.getDynamicPropertiesArray((BObject)BNtpServerVectorFE.this.contentPane, true);
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (BNtpServerVectorFE.this.focusedEditor != BNtpServerVectorFE.this.contentPane.get(propertyArray[i])) continue;
                    Property property = propertyArray[i];
                    propertyArray[i] = propertyArray[i + 1];
                    propertyArray[i + 1] = property;
                    BNtpServerVectorFE.this.contentPane.reorder(propertyArray);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    private class UpCommand
    extends Command {
        public UpCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowUp.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] propertyArray = BNtpServerVectorFE.getDynamicPropertiesArray((BObject)BNtpServerVectorFE.this.contentPane, true);
                for (int i = 0; i < propertyArray.length; ++i) {
                    if (BNtpServerVectorFE.this.focusedEditor != BNtpServerVectorFE.this.contentPane.get(propertyArray[i])) continue;
                    Property property = propertyArray[i];
                    propertyArray[i] = propertyArray[i - 1];
                    propertyArray[i - 1] = property;
                    BNtpServerVectorFE.this.contentPane.reorder(propertyArray);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BNtpServerVectorFE.this.addElement((BNtpServer)BNtpServerVectorFE.this.vector.getElementType().getInstance());
            BNtpServerVectorFE.this.setArrowCommandEnabledStates();
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BNtpServerVectorFE.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor slotCursor = BNtpServerVectorFE.this.contentPane.loadSlots().getProperties();
                while (slotCursor.next(class$javax$baja$workbench$fieldeditor$BWbFieldEditor == null ? BNtpServerVectorFE.class$("javax.baja.workbench.fieldeditor.BWbFieldEditor") : class$javax$baja$workbench$fieldeditor$BWbFieldEditor)) {
                    if (slotCursor.get() != BNtpServerVectorFE.this.focusedEditor) continue;
                    BNtpServerVectorFE.this.contentPane.remove(slotCursor.property());
                    BNtpServerVectorFE.this.focusedEditor = null;
                    BNtpServerVectorFE.this.deleteCommand.setEnabled(false);
                    BNtpServerVectorFE.this.addCommand.setEnabled(true);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    BNtpServerVectorFE.this.relayout();
                    return null;
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
            return null;
        }
    }
}

