/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.list.ListModel;
import javax.baja.util.Version;

public class FileInfoListModel
extends ListModel {
    private Array kids = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = FileInfoListModel.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
    private FilePath directoryPath;
    private String ext;
    private BFileSpace space;
    private Class elementClass;
    static /* synthetic */ Class class$com$tridium$platform$license$IFileInfo;

    public FileInfoListModel(FilePath filePath, String string, Class clazz) {
        this.directoryPath = filePath;
        this.ext = string;
        this.elementClass = clazz;
    }

    public int getItemCount() {
        return this.kids.size();
    }

    public Object getItem(int n) {
        return this.getFileName(n);
    }

    public IFileInfo getInfo(int n) {
        return (IFileInfo)this.kids.get(n);
    }

    public BIFile getFile(int n) {
        return this.getInfo(n).getFile();
    }

    public String getFileName(int n) {
        return this.getFile(n).getFileName();
    }

    public int getFileSize(int n) {
        return (int)this.getFile(n).getSize();
    }

    public synchronized IFileInfo[] getInfo() {
        IFileInfo[] iFileInfoArray = (IFileInfo[])java.lang.reflect.Array.newInstance(this.elementClass, this.getItemCount());
        for (int i = 0; i < this.getItemCount(); ++i) {
            iFileInfoArray[i] = this.getInfo(i);
        }
        return iFileInfoArray;
    }

    public FilePath getFilePath(int n) {
        return this.directoryPath.merge(this.getFileName(n));
    }

    public InputStream getFileContentStream(int n) {
        BLicenseChannel bLicenseChannel = this.getChannel();
        if (bLicenseChannel != null) {
            try {
                return bLicenseChannel.read((BFoxFileStore)this.getFile(n).getStore());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return this.getFile(n).getInputStream();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void deleteFiles(int[] nArray) {
        try {
            BIFile[] bIFileArray = new BIFile[nArray.length];
            for (int i = 0; i < bIFileArray.length; ++i) {
                this.getFile(nArray[i]).delete();
            }
            this.reload();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void deleteFile(int n) {
        try {
            this.getFile(n).delete();
            this.kids.remove(n);
            this.updateList();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public String getFileContents(int n) {
        BLicenseChannel bLicenseChannel = this.getChannel();
        if (bLicenseChannel != null) {
            try {
                ByteBuffer byteBuffer = new ByteBuffer();
                byteBuffer.readToEnd(bLicenseChannel.read((BFoxFileStore)this.getFile(n).getStore()));
                return new String(byteBuffer.toByteArray());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return new String(this.getFile(n).read());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void reload() {
        this.loadValue(this.space);
    }

    public synchronized void loadValue(BFileSpace bFileSpace) {
        BDirectory bDirectory;
        this.kids.clear();
        this.space = bFileSpace;
        BIFile[] bIFileArray = null;
        BLicenseChannel bLicenseChannel = this.getChannel();
        if (bLicenseChannel != null) {
            try {
                if (this.directoryPath.equals((Object)CertificateInfo.CERTS_PATH)) {
                    bIFileArray = bLicenseChannel.listcertificates((BFoxFileSpace)this.space);
                } else if (this.directoryPath.equals((Object)LicenseInfo.LICENSES_PATH)) {
                    bIFileArray = bLicenseChannel.listlicenses((BFoxFileSpace)this.space);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bIFileArray == null && (bDirectory = (BDirectory)this.space.findFile(this.directoryPath)) != null) {
            bIFileArray = bDirectory.listFiles();
        }
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i].getExtension() == null || !bIFileArray[i].getExtension().equals(this.ext)) continue;
            try {
                InputStream inputStream;
                IFileInfo iFileInfo = PortalLicenseUtil.makeFileInfo(bIFileArray[i]);
                this.kids.add((Object)iFileInfo);
                if (!(iFileInfo instanceof LicenseInfo)) continue;
                VendorLicense vendorLicense = null;
                try {
                    if (bLicenseChannel != null) {
                        inputStream = bLicenseChannel.read((BFoxFileStore)bIFileArray[i].getStore());
                        vendorLicense = VendorLicense.make((String)bIFileArray[i].getFileName(), (InputStream)inputStream);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (vendorLicense == null) {
                    vendorLicense = VendorLicense.make((BIFile)bIFileArray[i]);
                }
                if ((inputStream = LicenseDatabase.LOCAL_INSTANCE.getLicense(vendorLicense.getHostId(), vendorLicense.getVendor(), vendorLicense.getBrandId())) != null && inputStream.getGenerated() >= vendorLicense.getGenerated()) continue;
                LicenseDatabase.LOCAL_INSTANCE.add(vendorLicense);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.updateList();
    }

    public BLicenseChannel getChannel() {
        BLicenseChannel bLicenseChannel = null;
        if (this.space instanceof BFoxFileSpace) {
            BFoxFileSpace bFoxFileSpace = (BFoxFileSpace)this.space;
            try {
                Version version = (Version)bFoxFileSpace.getFoxSession().fw(404, (Object)"platform", null, null, null);
                if (version != null && version.compareTo((Object)new Version("3.7.201")) != -1) {
                    bLicenseChannel = (BLicenseChannel)bFoxFileSpace.getFoxSession().getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bLicenseChannel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

