/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class BWorkbenchLicenseTree
extends BTree {
    public static final Action handleSelectionModified = BWorkbenchLicenseTree.newAction((int)0, null);
    public static final Topic valueUpdated = BWorkbenchLicenseTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$license$BWorkbenchLicenseTree == null ? (class$com$tridium$platform$ui$license$BWorkbenchLicenseTree = BWorkbenchLicenseTree.class$("com.tridium.platform.ui.license.BWorkbenchLicenseTree")) : class$com$tridium$platform$ui$license$BWorkbenchLicenseTree));
    private static final BIcon HOST_ICON = BIcon.std((String)"host.png");
    private static final BIcon LICENSE_ICON = BIcon.std((String)"file.png");
    private static final IFileFilter LAR_FILTER = new ExtFileFilter("TODO", "lar");
    private static final IFilePathFilter LAR_PATH_FILTER = new ExtPathFilter("lar");
    private static final IFileFilter LICENSE_FILTER = new ExtFileFilter("TODO", "license,lar");
    private static final Lexicon LEX = Lexicon.make((String)"platform");
    private Command importFile = new ImportFile();
    private Command exportFile = new ExportFile();
    private Command delete = new Delete();
    private SyncOnline syncOnline = new SyncOnline();
    static /* synthetic */ Class class$com$tridium$platform$ui$license$BWorkbenchLicenseTree;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorLicense;
    static /* synthetic */ Class class$com$tridium$platform$license$BEnvLicenseSummary;

    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    public void fireValueUpdated(BValue bValue) {
        this.fire(valueUpdated, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWorkbenchLicenseTree() {
        this.setModel(new Model());
        this.setMultipleSelection(true);
        this.linkTo(null, (BComponent)this, (Slot)BTree.selectionModified, (Slot)handleSelectionModified);
    }

    public String getDetailsText() throws Exception {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        if (treeNodeArray.length == 1 && treeNodeArray[0] instanceof LicenseNode) {
            return ((LicenseNode)treeNodeArray[0]).getContents();
        }
        return "";
    }

    public void importLicenseArchive(BLicenseArchiveFile bLicenseArchiveFile, Context context) throws Exception {
        LicenseDatabase.LOCAL_INSTANCE.importFile((BIFile)bLicenseArchiveFile);
        this.load(context);
        BDialog.message((BWidget)this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
    }

    public void load(Context context) throws Exception {
        ((Model)this.getModel()).load(context);
    }

    public void reload() throws Exception {
        ((Model)this.getModel()).reload();
    }

    public Command[] getCommands() {
        if (PortalLicenseUtil.requestLicensesOnline()) {
            return new Command[]{this.importFile, this.exportFile, this.delete, this.syncOnline};
        }
        return new Command[]{this.importFile, this.exportFile, this.delete};
    }

    public int dragOver(TransferContext transferContext) {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BLicenseFile) && !(bObjectArray[i] instanceof BLicenseArchiveFile)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            boolean bl = false;
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (!(bObjectArray[i] instanceof BLicenseFile) && !(bObjectArray[i] instanceof BLicenseArchiveFile)) continue;
                LicenseDatabase.LOCAL_INSTANCE.importFile((BIFile)bObjectArray[i]);
                bl = true;
            }
            if (bl) {
                this.load((Context)transferContext);
                BDialog.message((BWidget)this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
            }
        }
        return null;
    }

    public void doHandleSelectionModified() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        this.delete.setEnabled(treeNodeArray.length > 0);
        this.fireValueUpdated(null);
    }

    private String[] getSelectedHostIds() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (treeNodeArray[i] instanceof HostNode) {
                hashSet.add(((HostNode)treeNodeArray[i]).getHostId());
                continue;
            }
            hashSet.add(((LicenseNode)treeNodeArray[i]).getHostId());
        }
        String[] stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SyncOnline
    extends AsyncCommand {
        public boolean canceled = false;

        public SyncOnline() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.syncOnline.label"), null, null, LEX.getText("WorkbenchLicenseTree.syncOnline.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block21: {
                try {
                    TreeNode[] treeNodeArray = BWorkbenchLicenseTree.this.getSelection().getNodes();
                    int n = 0;
                    int n2 = 0;
                    if (treeNodeArray.length == 0) {
                        if (4 != BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.syncAll.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.syncAll.confirmMessage"))) {
                            return;
                        }
                        this.canceled = false;
                        BLabel bLabel = new BLabel(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{"0"}));
                        bLabel.setHalign(BHalign.left);
                        BDialog bDialog = new BDialog(this.getOwner(), LEX.getText("WorkbenchLicenseTree.syncAll.workingTitle"), false, (BWidget)new BEdgePane((BWidget)new BBox(300.0, 0.0), (BWidget)new BBorderPane((BWidget)new BButtonPane(new Command[]{new CancelSync()}), 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)bLabel, 10.0, 10.0, 10.0, 10.0)));
                        bDialog.setBoundsCenteredOnOwner();
                        bDialog.open();
                        try {
                            Array array = new Array(class$com$tridium$sys$license$dom$VendorLicense == null ? (class$com$tridium$sys$license$dom$VendorLicense = BWorkbenchLicenseTree.class$("com.tridium.sys.license.dom.VendorLicense")) : class$com$tridium$sys$license$dom$VendorLicense);
                            VendorCertificate[] vendorCertificateArray = LicenseDatabase.LOCAL_INSTANCE.iterator();
                            while (vendorCertificateArray.hasNext()) {
                                if (this.canceled) {
                                    array.clear();
                                    break;
                                }
                                array.add(vendorCertificateArray.next());
                                if (array.size() < 100) continue;
                                VendorLicense[] vendorLicenseArray = PortalLicenseUtil.getPortalUpdates((VendorLicense[])array.trim());
                                for (int i = 0; i < vendorLicenseArray.length; ++i) {
                                    if (!LicenseDatabase.LOCAL_INSTANCE.add(vendorLicenseArray[i])) continue;
                                    bLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{String.valueOf(++n)}));
                                }
                                array.clear();
                            }
                            if (array.size() > 0) {
                                vendorCertificateArray = PortalLicenseUtil.getPortalUpdates((VendorLicense[])array.trim());
                                for (int i = 0; i < vendorCertificateArray.length; ++i) {
                                    if (!LicenseDatabase.LOCAL_INSTANCE.add((VendorLicense)vendorCertificateArray[i])) continue;
                                    bLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.working", new Object[]{String.valueOf(++n)}));
                                }
                            }
                            vendorCertificateArray = PortalLicenseUtil.getPortalUpdates(CertificateDatabase.LOCAL_INSTANCE.getCertificates());
                            for (int i = 0; i < vendorCertificateArray.length; ++i) {
                                if (!CertificateDatabase.LOCAL_INSTANCE.add(vendorCertificateArray[i])) continue;
                                bLabel.setText(LEX.getText("WorkbenchLicenseTree.syncAll.cert.working", new Object[]{String.valueOf(++n2)}));
                            }
                        }
                        finally {
                            bDialog.close();
                        }
                        if (n > 0 || n2 > 0) {
                            BWorkbenchLicenseTree.this.reload();
                        }
                        BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("WorkbenchLicenseTree.syncOnline.completeTitle"), (Object)new BEdgePane((BWidget)new BBox(300.0, 1.0), null, null, null, (BWidget)new BLabel(LEX.getText("WorkbenchLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(n), String.valueOf(n2)}), BHalign.left)));
                        break block21;
                    }
                    Array array = new Array(class$com$tridium$platform$license$BEnvLicenseSummary == null ? (class$com$tridium$platform$license$BEnvLicenseSummary = BWorkbenchLicenseTree.class$("com.tridium.platform.license.BEnvLicenseSummary")) : class$com$tridium$platform$license$BEnvLicenseSummary);
                    for (int i = 0; i < treeNodeArray.length; ++i) {
                        TreeNode treeNode;
                        if (treeNodeArray[i] instanceof HostNode) {
                            treeNode = (HostNode)treeNodeArray[i];
                            LicenseNode[] licenseNodeArray = treeNode.getChildren();
                            for (int j = 0; j < licenseNodeArray.length; ++j) {
                                array.add((Object)BEnvLicenseSummary.make(licenseNodeArray[j].getVendorLicense()));
                            }
                            continue;
                        }
                        treeNode = (LicenseNode)treeNodeArray[i];
                        array.add((Object)BEnvLicenseSummary.make(treeNode.getVendorLicense()));
                    }
                    VendorLicense[] vendorLicenseArray = PortalLicenseUtil.getPortalUpdates((BEnvLicenseSummary[])array.trim());
                    for (int i = 0; i < vendorLicenseArray.length; ++i) {
                        if (!LicenseDatabase.LOCAL_INSTANCE.add(vendorLicenseArray[i])) continue;
                        ++n;
                    }
                    VendorCertificate[] vendorCertificateArray = PortalLicenseUtil.getPortalUpdates(CertificateDatabase.LOCAL_INSTANCE.getCertificates());
                    for (int i = 0; i < vendorCertificateArray.length; ++i) {
                        if (!CertificateDatabase.LOCAL_INSTANCE.add(vendorCertificateArray[i])) continue;
                        ++n2;
                    }
                    if (n > 0 || n2 > 0) {
                        BWorkbenchLicenseTree.this.reload();
                    }
                    BDialog.message((BWidget)this.getOwner(), (String)LEX.getText("WorkbenchLicenseTree.syncOnline.completeTitle"), (Object)LEX.getText("WorkbenchLicenseTree.syncOnline.completeMessage", new Object[]{String.valueOf(n), String.valueOf(n2)}));
                }
                catch (Exception exception) {
                    CommandUtil.error(this, exception);
                }
            }
        }
    }

    private class CancelSync
    extends Command {
        public CancelSync() {
            super((BWidget)BWorkbenchLicenseTree.this, UiLexicon.bajaui().getText("cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            ((BWorkbenchLicenseTree)BWorkbenchLicenseTree.this).syncOnline.canceled = true;
            return null;
        }
    }

    private class Delete
    extends Command {
        public Delete() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.delete.label"), null, null, LEX.getText("WorkbenchLicenseTree.delete.description"));
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] treeNodeArray = BWorkbenchLicenseTree.this.getSelection().getNodes();
            if (treeNodeArray.length > 0 && 4 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.delete.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.delete.confirmMessage"))) {
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    if (treeNodeArray[i] instanceof HostNode) {
                        for (int j = 0; j < treeNodeArray[i].getChildCount(); ++j) {
                            LicenseDatabase.LOCAL_INSTANCE.remove(((LicenseNode)treeNodeArray[i].getChild(j)).getVendorLicense());
                        }
                        continue;
                    }
                    LicenseDatabase.LOCAL_INSTANCE.remove(((LicenseNode)treeNodeArray[i]).getVendorLicense());
                }
                BWorkbenchLicenseTree.this.getSelection().deselectAll();
                BWorkbenchLicenseTree.this.reload();
            }
            return null;
        }
    }

    private class ExportFile
    extends Command {
        public ExportFile() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.exportFile.label"), null, null, LEX.getText("WorkbenchLicenseTree.exportFile.description"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            TreeNode[] treeNodeArray = BWorkbenchLicenseTree.this.getSelection().getNodes();
            if (treeNodeArray.length == 0 && 8 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.exportFile.confirmTitle"), (Object)LEX.getText("WorkbenchLicenseTree.exportFile.confirmMessage"))) {
                return null;
            }
            BDirectory bDirectory = FavoriteDirectory.loadByPath(TYPE.toString(), "larDir", null);
            FilePath filePath = BFileChooserDialog.chooseFilePath((BWidget)BWorkbenchLicenseTree.this, null, LEX.getText("WorkbenchLicenseTree.exportFile.title"), LEX.getText("WorkbenchLicenseTree.exportFile.message"), (BIFile)bDirectory, LAR_FILTER, LAR_PATH_FILTER, null, "licenses.lar");
            if (filePath == null) {
                return null;
            }
            BIFile bIFile = BFileSystem.INSTANCE.findFile(filePath);
            if (bIFile == null) {
                bIFile = BFileSystem.INSTANCE.makeFile(filePath);
            } else if (8 == BDialog.confirm((BWidget)BWorkbenchLicenseTree.this, (String)LEX.getText("WorkbenchLicenseTree.exportFile.replaceTitle"), (Object)LEX.getText("WorkbenchLicenseTree.exportFile.replaceMessage", new Object[]{filePath.getName()}))) {
                return null;
            }
            FavoriteDirectory.savePath(TYPE.toString(), "larDir", (BDirectory)bIFile.getNavParent());
            OutputStream outputStream = bIFile.getOutputStream();
            try {
                if (treeNodeArray.length == 0) {
                    LicenseDatabase.LOCAL_INSTANCE.exportLicenses(outputStream);
                } else {
                    LicenseDatabase.LOCAL_INSTANCE.exportLicenses(BWorkbenchLicenseTree.this.getSelectedHostIds(), outputStream);
                }
                BDialog.message((BWidget)BWorkbenchLicenseTree.this, (Object)LEX.getText("WorkbenchLicenseTree.exportFile.success"));
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            return null;
        }
    }

    private class ImportFile
    extends Command {
        public ImportFile() {
            super((BWidget)BWorkbenchLicenseTree.this, LEX.getText("WorkbenchLicenseTree.importFile.label"), null, null, LEX.getText("WorkbenchLicenseTree.importFile.description"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BIFile bIFile = BFileChooserDialog.chooseFile((BWidget)BWorkbenchLicenseTree.this, null, LEX.getText("WorkbenchLicenseTree.importFile.title"), LEX.getText("WorkbenchLicenseTree.importFile.message"), (BIFile)FavoriteDirectory.loadByPath(TYPE.toString(), "larDir", null), LICENSE_FILTER, LICENSE_FILTER);
            if (bIFile == null) {
                return null;
            }
            LicenseDatabase.LOCAL_INSTANCE.importFile(bIFile);
            BWorkbenchLicenseTree.this.reload();
            BDialog.message((BWidget)BWorkbenchLicenseTree.this, (Object)LEX.getText("WorkbenchLicenseTree.importFile.success"));
            return null;
        }
    }

    private class LicenseNode
    extends TreeNode {
        private VendorLicense vendorLicense;
        private Context cx;

        public LicenseNode(HostNode hostNode, VendorLicense vendorLicense, Context context) {
            super((TreeNode)hostNode);
            this.update(vendorLicense);
            this.cx = context;
        }

        public String getText() {
            return LicenseInfo.getSummaryText(this.vendorLicense, this.cx);
        }

        public boolean update(VendorLicense vendorLicense) {
            if (this.vendorLicense == null || !vendorLicense.getSignature().equals(this.vendorLicense.getSignature())) {
                this.vendorLicense = vendorLicense;
                return true;
            }
            return false;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)LICENSE_ICON);
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int n) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public VendorLicense getVendorLicense() {
            return this.vendorLicense;
        }

        public String getHostId() {
            return this.getVendorLicense().getHostId();
        }

        public String getContents() throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
    }

    private class HostNode
    extends TreeNode {
        private String hostId;
        private LicenseNode[] children = null;
        private Context cx;

        public HostNode(TreeModel treeModel, String string, Context context) {
            super(treeModel);
            this.hostId = string;
            this.cx = context;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getText() {
            return this.getHostId();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)HOST_ICON);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeNode getChild(int n) {
            return this.getChildren()[n];
        }

        public synchronized boolean update() throws Exception {
            if (this.children == null) {
                return false;
            }
            TreeMap<String, LicenseNode> treeMap = new TreeMap<String, LicenseNode>();
            TreeSet<String> treeSet = new TreeSet<String>();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.children.length; ++i) {
                treeSet.add(this.children[i].getText());
                treeMap.put(this.children[i].getText(), this.children[i]);
            }
            VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
            for (int i = 0; i < vendorLicenseArray.length; ++i) {
                String string = LicenseInfo.getSummaryText(vendorLicenseArray[i], this.cx);
                LicenseNode licenseNode = (LicenseNode)((Object)treeMap.get(string));
                if (licenseNode == null) {
                    treeMap.put(string, new LicenseNode(this, vendorLicenseArray[i], this.cx));
                    bl = true;
                    bl2 = true;
                    continue;
                }
                bl = licenseNode.update(vendorLicenseArray[i]) || bl;
                treeSet.remove(licenseNode.getText());
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                treeMap.remove(iterator.next());
                bl2 = true;
                bl = true;
            }
            if (bl2) {
                this.children = new LicenseNode[treeMap.size()];
                treeMap.values().toArray(this.children);
            }
            return bl;
        }

        public LicenseNode[] getChildren() {
            try {
                if (this.children == null) {
                    VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
                    this.children = new LicenseNode[vendorLicenseArray.length];
                    for (int i = 0; i < vendorLicenseArray.length; ++i) {
                        this.children[i] = new LicenseNode(this, vendorLicenseArray[i], this.cx);
                    }
                }
                return this.children;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    private class Model
    extends TreeModel {
        private HostNode[] hostNodes = new HostNode[0];
        private Context cx;

        private Model() {
        }

        public synchronized void load(Context context) throws Exception {
            int n;
            this.cx = context;
            String[] stringArray = LicenseDatabase.LOCAL_INSTANCE.getHostIds();
            TreeMap<String, HostNode> treeMap = new TreeMap<String, HostNode>();
            boolean bl = false;
            boolean bl2 = false;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (n = 0; n < this.hostNodes.length; ++n) {
                treeMap.put(this.hostNodes[n].getHostId(), this.hostNodes[n]);
                treeSet.add(this.hostNodes[n].getHostId());
            }
            for (n = 0; n < stringArray.length; ++n) {
                HostNode hostNode = (HostNode)((Object)treeMap.get(stringArray[n]));
                if (hostNode == null) {
                    treeMap.put(stringArray[n], new HostNode(this, stringArray[n], context));
                    bl2 = true;
                    continue;
                }
                treeSet.remove(stringArray[n]);
                bl = hostNode.update() || bl;
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                treeMap.remove(iterator.next());
                bl2 = true;
            }
            if (bl2) {
                bl = true;
                this.hostNodes = new HostNode[treeMap.size()];
                treeMap.values().toArray(this.hostNodes);
            }
            if (bl) {
                this.updateTree();
                BWorkbenchLicenseTree.this.fireValueUpdated(null);
            }
        }

        public synchronized void reload() throws Exception {
            this.load(this.cx);
        }

        public int getRootCount() {
            return this.hostNodes.length;
        }

        public TreeNode getRoot(int n) {
            return this.hostNodes[n];
        }

        public Context getContext() {
            return this.cx;
        }
    }
}

