/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BLicensePlatformService;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.license.BFileInfoList;
import com.tridium.platform.ui.license.FileInfoListModel;
import com.tridium.platform.ui.license.UiUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.workbench.tools.BRequestLicenseTool;
import java.io.OutputStream;
import java.util.HashSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BLicensePlatformServicePlugin
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$license$BLicensePlatformServicePlugin == null ? (class$com$tridium$platform$ui$license$BLicensePlatformServicePlugin = BLicensePlatformServicePlugin.class$("com.tridium.platform.ui.license.BLicensePlatformServicePlugin")) : class$com$tridium$platform$ui$license$BLicensePlatformServicePlugin));
    private static IFileFilter licenseFilter = new ExtFileFilter("TODO", "license,lar");
    private static IFileFilter larFilter = new ExtFileFilter("TODO", "lar");
    private static IFilePathFilter larPathFilter = new ExtPathFilter("lar");
    private static IFileFilter certFilter = new ExtFileFilter("TODO", "certificate");
    private BFileInfoList certs;
    private FileInfoListModel certModel;
    private BFileInfoList licenses;
    private FileInfoListModel licenseModel;
    private BLabel hostNameLabel;
    private BLabel hostIdLabel;
    private BLabel brandIdLabel;
    private BFileSpace fileSpace;
    private String brandId;
    private String hostId;
    private static final Lexicon lex = Lexicon.make((String)"platform");
    static /* synthetic */ Class class$com$tridium$platform$ui$license$BLicensePlatformServicePlugin;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$CertificateInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$IFileInfo;

    public Type getType() {
        return TYPE;
    }

    public BLicensePlatformServicePlugin() {
        BIBeamPane bIBeamPane = new BIBeamPane();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        BLabel bLabel = LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.hostNameLabel"), true);
        bGridPane.add(null, (BValue)bLabel);
        this.hostNameLabel = new BLabel();
        bGridPane.add(null, (BValue)this.hostNameLabel);
        bLabel = LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.hostIdLabel"), true);
        bGridPane.add(null, (BValue)bLabel);
        this.hostIdLabel = new BLabel();
        bGridPane.add(null, (BValue)this.hostIdLabel);
        bLabel = LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"LicensePlatformServicePlugin.brandIdLabel"), true);
        bGridPane.add(null, (BValue)bLabel);
        this.brandIdLabel = new BLabel();
        bGridPane.add(null, (BValue)this.brandIdLabel);
        bIBeamPane.setTop((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 6.0, 0.0));
        this.licenseModel = new FileInfoListModel(LicenseInfo.LICENSES_PATH, "license", class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        this.licenses = new BFileInfoList(this.licenseModel, licenseFilter, new LicenseValidator(), new LicenseTransfer());
        CommandBindings commandBindings = new CommandBindings();
        ImportCommand importCommand = new ImportCommand(this.licenses);
        ExportCommand exportCommand = new ExportCommand(this.licenses);
        commandBindings.addCommand(importCommand, BCommandEnablePolicy.always);
        commandBindings.addCommand(exportCommand, BCommandEnablePolicy.anySelection);
        commandBindings.addCommand(this.licenses.getViewCommand(), BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand(this.licenses.getDeleteCommand(), BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand(this.licenses.getViewCommand());
        this.licenses.setController(new FileListController(commandBindings));
        this.licenses.setSelection(new CommandBindings.ListSelection(commandBindings));
        this.licenses.setMultipleSelection(true);
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.setUniformColumnWidth(false);
        bButtonPane.add(importCommand);
        bButtonPane.add(exportCommand);
        bButtonPane.add(this.licenses.getViewCommand());
        bButtonPane.add(this.licenses.getDeleteCommand());
        bLabel = new BLabel(lex.getText("LicensePlatformServicePlugin.licenseList.header"));
        bIBeamPane.setLeft((BWidget)new BEdgePane((BWidget)bLabel, (BWidget)bButtonPane, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.licenses, BBorder.inset, BInsets.DEFAULT), 5.0, 0.0, 5.0, 0.0)));
        bLabel.setHalign(BHalign.left);
        this.certModel = new FileInfoListModel(CertificateInfo.CERTS_PATH, "certificate", class$com$tridium$platform$license$CertificateInfo == null ? (class$com$tridium$platform$license$CertificateInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.CertificateInfo")) : class$com$tridium$platform$license$CertificateInfo);
        this.certs = new BFileInfoList(this.certModel, certFilter, new CertificateTransfer());
        AddCertCommand addCertCommand = new AddCertCommand(this.certs);
        commandBindings = new CommandBindings();
        commandBindings.addCommand(addCertCommand, BCommandEnablePolicy.always);
        commandBindings.addCommand(this.certs.getViewCommand(), BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand(this.certs.getDeleteCommand(), BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand(this.certs.getViewCommand());
        this.certs.setController(new FileListController(commandBindings));
        this.certs.setSelection(new CommandBindings.ListSelection(commandBindings));
        this.certs.setMultipleSelection(true);
        bButtonPane = new BButtonPane();
        bButtonPane.setUniformColumnWidth(false);
        bButtonPane.add(addCertCommand);
        bButtonPane.add(this.certs.getViewCommand());
        bButtonPane.add(this.certs.getDeleteCommand());
        bLabel = new BLabel(lex.getText("LicensePlatformServicePlugin.certList.header"));
        bIBeamPane.setRight((BWidget)new BEdgePane((BWidget)bLabel, (BWidget)bButtonPane, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.certs, BBorder.inset, BInsets.DEFAULT), 5.0, 0.0, 5.0, 0.0)));
        bLabel.setHalign(BHalign.left);
        bIBeamPane.setCenter(new BBox(20.0, 0.0));
        this.setContent((BWidget)bIBeamPane);
        this.autoRegisterForComponentEvents = false;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BLicensePlatformService bLicensePlatformService = (BLicensePlatformService)bObject;
        this.registerForComponentEvents(bLicensePlatformService, 4);
        bLicensePlatformService.poll();
        this.hostNameLabel.setText(bLicensePlatformService.getHost().getNavDisplayName(null));
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)bLicensePlatformService);
        bSystemPlatformService.lease(2);
        this.hostId = bSystemPlatformService.getHostId();
        this.hostIdLabel.setText(this.hostId);
        this.fileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)bLicensePlatformService);
        this.certModel.loadValue(this.fileSpace);
        this.licenseModel.loadValue(this.fileSpace);
        this.findBrandId();
    }

    protected void findBrandId() throws Exception {
        this.brandId = null;
        for (int i = 0; this.brandId == null && i < this.licenseModel.getItemCount(); ++i) {
            VendorLicense vendorLicense = ((LicenseInfo)this.licenseModel.getInfo((int)i)).vendorLicense;
            this.brandId = vendorLicense.getBrandId();
        }
        if (this.brandId == null) {
            this.brandId = new BrandProps(this.fileSpace).get("brand.id", null);
        }
        this.brandIdLabel.setText(this.brandId == null ? "" : this.brandId);
    }

    protected LicenseInfo[] getDatabaseLicenses() throws Exception {
        Array array = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.hostId);
        String string = this.brandId;
        for (int i = 0; i < vendorLicenseArray.length; ++i) {
            if (vendorLicenseArray[i].getBrandId() != null && string != null && !string.equals(vendorLicenseArray[i].getBrandId())) continue;
            array.add((Object)new LicenseInfo(vendorLicenseArray[i], null));
            string = vendorLicenseArray[i].getBrandId();
        }
        return (LicenseInfo[])array.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToStation(IFileInfo iFileInfo) throws Exception {
        BIFile bIFile = this.fileSpace.makeFile(iFileInfo.getInstalledFilePath());
        OutputStream outputStream = bIFile.getOutputStream();
        try {
            iFileInfo.write(outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void sync(LicenseSync licenseSync, LicenseSync licenseSync2) throws Exception {
        IFileInfo iFileInfo;
        int n;
        int n2;
        Array array = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        Array array2 = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        Array array3 = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicensePlatformServicePlugin.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        boolean bl = false;
        boolean bl2 = false;
        if (licenseSync != null) {
            n2 = licenseSync.toRemove.size();
            array3.addAll(licenseSync.toRemove);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (LicenseInfo)licenseSync.toRemove.get(n);
                iFileInfo.file.delete();
                bl = true;
            }
            n2 = licenseSync.toAdd.size();
            array.addAll(licenseSync.toAdd);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (LicenseInfo)licenseSync.toAdd.get(n);
                this.saveToStation(iFileInfo);
                bl2 = true;
                bl = true;
            }
            n2 = licenseSync.toUpdate.size();
            array2.addAll(licenseSync.toUpdate);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (LicenseInfo)licenseSync.toUpdate.get(n);
                this.saveToStation(iFileInfo);
                bl2 = true;
                bl = true;
            }
        }
        if (licenseSync2 != null) {
            n2 = licenseSync2.toAdd.size();
            array.addAll(licenseSync2.toAdd);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (CertificateInfo)licenseSync2.toAdd.get(n);
                this.saveToStation(iFileInfo);
                bl = true;
            }
            n2 = licenseSync2.toUpdate.size();
            array2.addAll(licenseSync2.toUpdate);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (CertificateInfo)licenseSync2.toUpdate.get(n);
                this.saveToStation(iFileInfo);
                bl = true;
            }
        }
        if (bl) {
            if (bl2) {
                BWidget bWidget = UiUtil.buildUpdateDescription(lex.getText("LicensePlatformServicePlugin.sync.successMessage"), lex.getText("LicensePlatformServicePlugin.sync.restartMessage"), (IFileInfo[])array.trim(), (IFileInfo[])array2.trim(), (IFileInfo[])array3.trim());
                if (4 == BDialog.confirm((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.successTitle"), (Object)bWidget, (int)12)) {
                    BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get(this.getCurrentValue());
                    bSystemPlatformService.lease(Integer.MAX_VALUE);
                    bSystemPlatformService.restartStation();
                    return;
                }
            } else {
                BWidget bWidget = UiUtil.buildUpdateDescription(lex.getText("LicensePlatformServicePlugin.sync.successMessage"), null, (IFileInfo[])array.trim(), (IFileInfo[])array2.trim(), (IFileInfo[])array3.trim());
                BDialog.message((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.successTitle"), (Object)bWidget);
            }
            this.loadValue(this.getCurrentValue());
        } else {
            BDialog.message((BWidget)this, (String)lex.getText("LicensePlatformServicePlugin.sync.currentTitle"), (Object)lex.getText("LicensePlatformServicePlugin.sync.currentMessage"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CertificateTransfer
    implements BFileInfoList.ListTransfer {
        private CertificateTransfer() {
        }

        public void processFile(BIFile bIFile) throws Exception {
            CertificateInfo[] certificateInfoArray = new CertificateInfo[]{new CertificateInfo(bIFile)};
            CertificateInfo[] certificateInfoArray2 = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
            LicenseSync licenseSync = PortalLicenseUtil.syncCertificates(certificateInfoArray2, certificateInfoArray);
            BLicensePlatformServicePlugin.this.sync(null, licenseSync);
        }
    }

    private class LicenseTransfer
    implements BFileInfoList.ListTransfer {
        private LicenseTransfer() {
        }

        public void processFile(BIFile bIFile) throws Exception {
            LicenseInfo[] licenseInfoArray = PortalLicenseUtil.getLicenseInfo(bIFile, BLicensePlatformServicePlugin.this.hostId, BLicensePlatformServicePlugin.this.brandId);
            LicenseInfo[] licenseInfoArray2 = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            LicenseSync licenseSync = PortalLicenseUtil.syncLicenses(BLicensePlatformServicePlugin.this.hostId, licenseInfoArray2, licenseInfoArray);
            BLicensePlatformServicePlugin.this.sync(licenseSync, null);
        }
    }

    private class AddCertCommand
    extends AsyncCommand {
        public AddCertCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicensePlatformServicePlugin.addCert");
        }

        public void doInvokeAsync() {
            block5: {
                try {
                    BIFile[] bIFileArray;
                    BIFile bIFile = BFileSystem.INSTANCE.findFile(CertificateInfo.CERTS_PATH);
                    if (bIFile == null) {
                        bIFile = BFileSystem.INSTANCE.getSysHome();
                    }
                    if ((bIFileArray = BFileChooserDialog.chooseFiles(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.addCertDialog.icon")), lex.getText("LicensePlatformServicePlugin.addCertDialog.title"), lex.getText("LicensePlatformServicePlugin.addCertDialog.message", new Object[]{BLicensePlatformServicePlugin.this.hostNameLabel.getText()}), bIFile, certFilter, certFilter)).length <= 0) break block5;
                    try {
                        CertificateInfo[] certificateInfoArray = CertificateInfo.make(bIFileArray);
                        CertificateInfo[] certificateInfoArray2 = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
                        LicenseSync licenseSync = PortalLicenseUtil.syncCertificates(certificateInfoArray2, certificateInfoArray);
                        BLicensePlatformServicePlugin.this.sync(null, licenseSync);
                    }
                    catch (Exception exception) {
                        throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.addCertException", (Throwable)exception);
                    }
                    BLicensePlatformServicePlugin.this.loadValue(BLicensePlatformServicePlugin.this.getCurrentValue());
                }
                catch (Throwable throwable) {
                    CommandUtil.error(this, throwable);
                }
            }
        }
    }

    private class ImportCommand
    extends AsyncCommand {
        public ImportCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicensePlatformServicePlugin.importLicense");
        }

        private void importFile() throws Exception {
            BIFile bIFile = BFileSystem.INSTANCE.findFile(LicenseInfo.LICENSES_PATH);
            if (bIFile == null) {
                bIFile = BFileSystem.INSTANCE.getSysHome();
            }
            Object[] objectArray = BFileChooserDialog.chooseFiles(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.importFileDialog.icon")), lex.getText("LicensePlatformServicePlugin.importFileDialog.title"), lex.getText("LicensePlatformServicePlugin.importFileDialog.message", new Object[]{BLicensePlatformServicePlugin.this.hostNameLabel.getText()}), bIFile, licenseFilter, licenseFilter, new LicenseListModel());
            Array array = new Array(objectArray);
            if ((array = array.filter((IFilter)new LicenseValidator())).size() == 0) {
                return;
            }
            LicenseInfo[] licenseInfoArray = PortalLicenseUtil.getLicenseInfo((BIFile[])array.trim(), BLicensePlatformServicePlugin.this.hostId, BLicensePlatformServicePlugin.this.brandId);
            LicenseInfo[] licenseInfoArray2 = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            LicenseSync licenseSync = PortalLicenseUtil.syncLicenses(BLicensePlatformServicePlugin.this.hostId, licenseInfoArray2, licenseInfoArray);
            BLicensePlatformServicePlugin.this.sync(licenseSync, null);
        }

        public void requestLicense() {
            UiUtil.requestLicense(this.getOwner().getShell(), BLicensePlatformServicePlugin.this.hostId);
        }

        public void getOnline() throws Exception {
            int n;
            LicenseInfo[] licenseInfoArray = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
            CertificateInfo[] certificateInfoArray = (CertificateInfo[])BLicensePlatformServicePlugin.this.certModel.getInfo();
            LicenseInfo[] licenseInfoArray2 = null;
            CertificateInfo[] certificateInfoArray2 = null;
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < licenseInfoArray.length; ++n) {
                hashSet.add(licenseInfoArray[n].vendorLicense.getVendor());
            }
            for (n = 0; n < certificateInfoArray.length; ++n) {
                hashSet.add(certificateInfoArray[n].vendorCertificate.getVendor());
            }
            n = 1;
            LicenseSync licenseSync = null;
            LicenseSync licenseSync2 = null;
            try {
                licenseInfoArray2 = LicenseInfo.make(PortalLicenseUtil.getExistingLicenses(BLicensePlatformServicePlugin.this.hostId, BLicensePlatformServicePlugin.this.brandId));
                licenseSync = PortalLicenseUtil.syncLicenses(BLicensePlatformServicePlugin.this.hostId, licenseInfoArray, licenseInfoArray2);
                for (int i = 0; i < licenseInfoArray2.length; ++i) {
                    hashSet.add(licenseInfoArray2[i].vendorLicense.getVendor());
                }
                n = licenseSync.unchanged() && LicenseInfo.countActiveLicenses(licenseInfoArray, BAbsTime.now()) == 0 ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] stringArray = new String[hashSet.size()];
                hashSet.toArray(stringArray);
                certificateInfoArray2 = CertificateInfo.make(PortalLicenseUtil.getCertificates(stringArray));
                licenseSync2 = PortalLicenseUtil.syncCertificates(certificateInfoArray, certificateInfoArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BLicensePlatformServicePlugin.this.sync(licenseSync, licenseSync2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                BRequestLicenseTool.requestLicense((BWidget)BLicensePlatformServicePlugin.this.getWbShell(), (String)BLicensePlatformServicePlugin.this.hostId);
            }
        }

        public void doInvokeAsync() {
            try {
                if (Nre.bootEnv.isRemote()) {
                    this.importFile();
                    return;
                }
                BGridPane bGridPane = new BGridPane(1);
                ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
                BRadioButton bRadioButton = new BRadioButton(toggleCommandGroup, lex.getText("LicensePlatformServicePlugin.importType.file"), true);
                bGridPane.add(null, (BValue)bRadioButton);
                BRadioButton bRadioButton2 = new BRadioButton(toggleCommandGroup, lex.getText("LicensePlatformServicePlugin.importType.localDb"), false);
                bGridPane.add(null, (BValue)bRadioButton2);
                LicenseInfo[] licenseInfoArray = (LicenseInfo[])BLicensePlatformServicePlugin.this.licenseModel.getInfo();
                LicenseInfo[] licenseInfoArray2 = BLicensePlatformServicePlugin.this.getDatabaseLicenses();
                LicenseSync licenseSync = PortalLicenseUtil.syncLicenses(BLicensePlatformServicePlugin.this.hostId, licenseInfoArray, licenseInfoArray2);
                if (licenseSync.unchanged()) {
                    bRadioButton2.setEnabled(false);
                }
                BRadioButton bRadioButton3 = new BRadioButton(toggleCommandGroup, lex.getText("LicensePlatformServicePlugin.importType.getOnline"), false);
                BRadioButton bRadioButton4 = new BRadioButton(toggleCommandGroup, lex.getText("LicensePlatformServicePlugin.importType.requestLicense"), false);
                if (PortalLicenseUtil.isApiAvailable()) {
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        bGridPane.add(null, (BValue)bRadioButton3);
                    } else {
                        bGridPane.add(null, (BValue)bRadioButton4);
                    }
                }
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.importType.dlgTitle"), (Object)new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    if (bRadioButton.isSelected()) {
                        this.importFile();
                    } else if (bRadioButton2.isSelected()) {
                        BLicensePlatformServicePlugin.this.sync(licenseSync, null);
                    } else if (bRadioButton3.isSelected()) {
                        this.getOnline();
                    } else if (bRadioButton4.isSelected()) {
                        this.requestLicense();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
        }
    }

    private class ExportCommand
    extends AsyncCommand {
        public ExportCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicensePlatformServicePlugin.exportLicense");
        }

        public void doInvokeAsync() {
            try {
                BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
                FilePath filePath = BFileChooserDialog.chooseFilePath(this.getOwner(), BImage.make((String)lex.getText("LicensePlatformServicePlugin.exportDialog.icon")), lex.getText("LicensePlatformServicePlugin.exportDialog.title"), lex.getText("LicensePlatformServicePlugin.exportDialog.message"), (BIFile)bDirectory, larFilter, larPathFilter, new LicenseListModel(), "licenses.lar");
                if (filePath != null) {
                    BLicenseArchiveFile bLicenseArchiveFile = (BLicenseArchiveFile)BFileSystem.INSTANCE.findFile(filePath);
                    if (bLicenseArchiveFile == null) {
                        bLicenseArchiveFile = (BLicenseArchiveFile)BFileSystem.INSTANCE.makeFile(filePath);
                    } else if (8 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.replaceFileDialog.title"), (Object)lex.getText("LicensePlatformServicePlugin.replaceFileDialog.message", new Object[]{filePath.getName()}))) {
                        return;
                    }
                    if (filePath.getParent().getBody().equals(LicenseInfo.LICENSES_PATH.getBody())) {
                        BLicensePlatformServicePlugin.this.licenseModel.reload();
                    }
                    int[] nArray = BLicensePlatformServicePlugin.this.licenseModel.getSelection().getItems();
                    VendorLicense[] vendorLicenseArray = new VendorLicense[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        vendorLicenseArray[i] = ((LicenseInfo)((BLicensePlatformServicePlugin)BLicensePlatformServicePlugin.this).licenseModel.getInfo((int)nArray[i])).vendorLicense;
                    }
                    bLicenseArchiveFile.writeLicenses(vendorLicenseArray);
                    BDialog.message((BWidget)this.getOwner(), (String)lex.getText("LicensePlatformServicePlugin.fileWrittenDialog.title"), (Object)lex.getText("LicensePlatformServicePlugin.fileWrittenDialog.message", new Object[]{filePath.getName()}));
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error(this, throwable);
            }
        }
    }

    public static class LicenseListModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UiLexicon.bajaui.getText("fileChooser.name");
                }
                case 1: {
                    return lex.getText("LicensePlatformServicePlugin.hostIdLabel");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    try {
                        if (bIFile.getExtension() == null || !(bIFile instanceof BLicenseFile)) {
                            return "";
                        }
                        LicenseInfo licenseInfo = new LicenseInfo(bIFile);
                        return licenseInfo.vendorLicense.getHostId();
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private class LicenseValidator
    implements IFileFilter,
    IFilter {
        private LicenseValidator() {
        }

        public boolean accept(Object object) {
            if (object instanceof BIFile) {
                return this.accept((BIFile)object);
            }
            return false;
        }

        public boolean accept(BIFile bIFile) {
            try {
                if (bIFile instanceof BLicenseFile) {
                    LicenseInfo licenseInfo = new LicenseInfo(bIFile);
                    if (BLicensePlatformServicePlugin.this.hostId.equals(licenseInfo.vendorLicense.getHostId())) {
                        if (BLicensePlatformServicePlugin.this.brandId != null && licenseInfo.vendorLicense.getBrandId() != null && !BLicensePlatformServicePlugin.this.brandId.equals(licenseInfo.vendorLicense.getBrandId())) {
                            BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.cantChangeBrand.title"), (Object)lex.getText("LicensePlatformServicePlugin.cantChangeBrand.message", new Object[]{licenseInfo}));
                            return false;
                        }
                        if (licenseInfo.allowsLocalWbAccess()) {
                            return true;
                        }
                        BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noAccess.title"), (Object)lex.getText("LicensePlatformServicePlugin.noAccess.message", new Object[]{licenseInfo}));
                        return false;
                    }
                    BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.badHostId.title"), (Object)lex.getText("LicensePlatformServicePlugin.badHostId.message", new Object[]{licenseInfo}));
                    return false;
                }
                if (bIFile instanceof BLicenseArchiveFile) {
                    VendorLicense[] vendorLicenseArray = ((BLicenseArchiveFile)bIFile).getLicenses(BLicensePlatformServicePlugin.this.hostId);
                    int n = 0;
                    for (int i = 0; i < vendorLicenseArray.length; ++i) {
                        if (BLicensePlatformServicePlugin.this.brandId != null && vendorLicenseArray[i].getBrandId() != null && !BLicensePlatformServicePlugin.this.brandId.equals(vendorLicenseArray[i].getBrandId())) continue;
                        LicenseInfo licenseInfo = new LicenseInfo(vendorLicenseArray[i], bIFile);
                        if (!licenseInfo.allowsLocalWbAccess()) {
                            BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noAccess.title"), (Object)lex.getText("LicensePlatformServicePlugin.noAccess.message", new Object[]{licenseInfo}));
                            return false;
                        }
                        ++n;
                    }
                    if (n == 0) {
                        BDialog.error((BWidget)BLicensePlatformServicePlugin.this, (String)lex.getText("LicensePlatformServicePlugin.noHostLicenses.title"), (Object)lex.getText("LicensePlatformServicePlugin.noHostLicenses.message"));
                        return false;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.addLicenseException", (Throwable)exception);
            }
        }

        public String getDescription(Context context) {
            return "TODO";
        }
    }

    private class FileListController
    extends CommandBindings.ListController {
        public FileListController(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            BLicensePlatformServicePlugin.this.setTransferWidget((BTransferWidget)this.getList());
            if (this.getList() == BLicensePlatformServicePlugin.this.certs) {
                BLicensePlatformServicePlugin.this.licenses.getSelection().deselectAll();
            } else {
                BLicensePlatformServicePlugin.this.certs.getSelection().deselectAll();
            }
        }
    }
}

