/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.license;

import com.tridium.platform.ui.license.FileInfoListModel;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.log.Log;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;

public class BFileInfoList
extends BList {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$license$BFileInfoList == null ? (class$com$tridium$platform$ui$license$BFileInfoList = BFileInfoList.class$("com.tridium.platform.ui.license.BFileInfoList")) : class$com$tridium$platform$ui$license$BFileInfoList));
    private IFileFilter dragOverFilter;
    private IFileFilter dropFilter;
    private Command deleteCommand;
    private Command viewCommand;
    private ListTransfer listTransfer;
    private static Log log = Log.getLog((String)"platform");
    static /* synthetic */ Class class$com$tridium$platform$ui$license$BFileInfoList;

    public BFileInfoList() {
        throw new UnsupportedOperationException();
    }

    public BFileInfoList(FileInfoListModel fileInfoListModel, IFileFilter iFileFilter, ListTransfer listTransfer) {
        this(fileInfoListModel, iFileFilter, iFileFilter, listTransfer);
    }

    public BFileInfoList(FileInfoListModel fileInfoListModel, IFileFilter iFileFilter, IFileFilter iFileFilter2, ListTransfer listTransfer) {
        super((ListModel)fileInfoListModel);
        this.dragOverFilter = iFileFilter;
        this.dropFilter = iFileFilter2;
        this.listTransfer = listTransfer;
        this.setPasteEnabled(true);
        this.deleteCommand = new DeleteFileCommand();
        this.viewCommand = new ViewFileCommand();
    }

    public FileInfoListModel getFileInfoListModel() {
        return (FileInfoListModel)this.getModel();
    }

    public CommandArtifact doDelete() throws Exception {
        this.deleteCommand.invoke();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        BObject[] bObjectArray;
        Mark mark = Mark.getCurrent();
        if (mark != null && (bObjectArray = mark.getValues())[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)bObjectArray[0]) && this.dropFilter.accept((BIFile)bObjectArray[0])) {
            this.listTransfer.processFile((BIFile)bObjectArray[0]);
        }
        return null;
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark;
        if (transferContext.getEnvelope().supports(TransferFormat.mark) && (mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues()[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)mark.getValues()[0])) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (mark.getValues()[0] instanceof BIFile && this.dragOverFilter.accept((BIFile)mark.getValues()[0]) && this.dropFilter.accept((BIFile)mark.getValues()[0])) {
            this.listTransfer.processFile((BIFile)mark.getValues()[0]);
        }
        return null;
    }

    public Command getDeleteCommand() {
        return this.deleteCommand;
    }

    public Command getViewCommand() {
        return this.viewCommand;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ListTransfer {
        public void processFile(BIFile var1) throws Exception;
    }

    private class ViewFileCommand
    extends Command {
        public ViewFileCommand() {
            super((BWidget)BFileInfoList.this, TYPE.getModule(), "FileList.view");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                FileInfoListModel fileInfoListModel = (FileInfoListModel)BFileInfoList.this.getModel();
                int n = BFileInfoList.this.getSelectedIndex();
                BDialog.message((BWidget)BFileInfoList.this, (String)fileInfoListModel.getFileName(n), (Object)new BTextEditorPane(fileInfoListModel.getFileContents(n), 20, 80, false));
            }
            catch (Exception exception) {
                log.error("error reading contents of file", (Throwable)exception);
            }
            return null;
        }
    }

    private class DeleteFileCommand
    extends Command {
        public DeleteFileCommand() {
            super((BWidget)BFileInfoList.this, TYPE.getModule(), "FileList.delete");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            FileInfoListModel fileInfoListModel = (FileInfoListModel)BFileInfoList.this.getModel();
            int[] nArray = BFileInfoList.this.getSelectedIndices();
            if (4 == BDialog.confirm((BWidget)BFileInfoList.this, (String)BFileInfoList.this.getLexicon().getText("FileList.delete.confirmTitle"), (Object)BFileInfoList.this.getLexicon().getText("FileList.delete.confirmMessage"))) {
                for (int i = 0; i < nArray.length; ++i) {
                    fileInfoListModel.deleteFiles(nArray);
                }
            }
            BFileInfoList.this.getSelection().deselectAll();
            return null;
        }
    }
}

