/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui;

import com.tridium.platform.BEngineWatchdogPolicy;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platform.win32.BSystemPlatformServiceNxs;
import com.tridium.platform.win32.BSystemPlatformServiceNxtFlash;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDateFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BSystemPlatformServicePlugin
extends BWbComponentView {
    public static final Action timeModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    public static final Action timeZoneModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    public static final Action localeModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    public static final Action markRebootFieldDirty = BSystemPlatformServicePlugin.newAction((int)4, null);
    public static final Action markRestartFieldDirty = BSystemPlatformServicePlugin.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$BSystemPlatformServicePlugin == null ? (class$com$tridium$platform$ui$BSystemPlatformServicePlugin = BSystemPlatformServicePlugin.class$("com.tridium.platform.ui.BSystemPlatformServicePlugin")) : class$com$tridium$platform$ui$BSystemPlatformServicePlugin));
    protected ToggleCommand toggleAutoSaveCommand;
    protected BGridPane ledgerPane;
    protected BGridPane filesystemPane;
    protected BButtonPane buttonPane;
    protected BLabel javaVmNameLabel;
    protected BLabel javaVmVendorLabel;
    protected BLabel javaVmVersionLabel;
    protected BLabel osArchLabel;
    protected BLabel osNameLabel;
    protected BLabel modelLabel;
    protected BLabel hostLabel;
    protected BLabel niagaraVersionLabel;
    protected BLabel fipsStatusLabel;
    protected BWbFieldEditor localeEditor;
    protected BLabel osVersionLabel;
    protected BLabel hostIdLabel;
    protected BLabel nameLabel;
    protected BLabel numCpusLabel;
    protected BLabel currentCpuLabel;
    protected BLabel overallCpuLabel;
    protected BLabel daemonPortLabel;
    protected BLabel daemonSSLPortLabel;
    protected BLabel freePhysicalMemoryLabel;
    protected BLabel totalPhysicalMemoryLabel;
    protected BWbFieldEditor watchdogPolicyEditor;
    protected BWbFieldEditor watchdogTimeoutEditor;
    protected BWbFieldEditor stationAutoSaveFrequencyEditor;
    protected BIntegerFE stationSaveBackupCountEditor;
    protected BListDropDown timeZoneDropDown;
    protected BWbFieldEditor timeEditor;
    protected BDateFE dateEditor;
    protected boolean isTimeModified = false;
    protected boolean isLocaleModified = false;
    protected boolean isTimeZoneModified = false;
    protected boolean tzRequiresReboot = false;
    protected boolean restartEnabled = false;
    protected boolean saving = false;
    protected boolean loading = false;
    protected boolean rebootFieldDirty = false;
    protected boolean restartFieldDirty = false;
    protected boolean fipsLicensed = false;
    protected boolean fipsInstalled = false;
    private static final BFacets HOUR_MINUTE = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"HH:mm"), BBoolean.FALSE, BBoolean.TRUE, BBoolean.FALSE});
    static /* synthetic */ Class class$com$tridium$platform$ui$BSystemPlatformServicePlugin;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public void timeModified() {
        this.invoke(timeModified, null, null);
    }

    public void timeZoneModified() {
        this.invoke(timeZoneModified, null, null);
    }

    public void localeModified() {
        this.invoke(localeModified, null, null);
    }

    public void markRebootFieldDirty() {
        this.invoke(markRebootFieldDirty, null, null);
    }

    public void markRestartFieldDirty() {
        this.invoke(markRestartFieldDirty, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setValign(BValign.top);
        this.ledgerPane.setColumnGap(10.0);
        this.ledgerPane.setRowGap(6.0);
        this.ledgerPane.setColorRows(true);
        this.nameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.name"), (BWidget)this.nameLabel);
        this.hostLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.host"), (BWidget)this.hostLabel);
        this.modelLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.model"), (BWidget)this.modelLabel);
        this.hostIdLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.hostId"), (BWidget)this.hostIdLabel);
        this.niagaraVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.niagaraVersion"), (BWidget)this.niagaraVersionLabel);
        this.javaVmNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.javaVmName"), (BWidget)this.javaVmNameLabel);
        this.javaVmVendorLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVendor"), (BWidget)this.javaVmVendorLabel);
        this.javaVmVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVersion"), (BWidget)this.javaVmVersionLabel);
        this.osNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.osName"), (BWidget)this.osNameLabel);
        this.osArchLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.osArch"), (BWidget)this.osArchLabel);
        this.osVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.osVersion"), (BWidget)this.osVersionLabel);
        this.daemonPortLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.daemonPort"), (BWidget)this.daemonPortLabel);
        this.daemonSSLPortLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.daemonSSLPort"), (BWidget)this.daemonSSLPortLabel);
        this.localeEditor = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.locale"), (BWidget)this.localeEditor);
        this.timeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemTime"), (BWidget)this.timeEditor);
        this.dateEditor = new BDateFE();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemDate"), (BWidget)this.dateEditor);
        this.timeZoneDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone"), (BWidget)this.timeZoneDropDown);
        this.timeZoneDropDown.getList().setMultipleSelection(false);
        this.watchdogPolicyEditor = BWbFieldEditor.makeFor((BObject)BEngineWatchdogPolicy.terminate);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogPolicy"), (BWidget)this.watchdogPolicyEditor);
        this.watchdogTimeoutEditor = BWbFieldEditor.makeFor((BObject)BRelTime.MINUTE, (Context)BSystemPlatformService.engineWatchdogTimeout.getFacets());
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogTimeout"), (BWidget)this.watchdogTimeoutEditor);
        this.toggleAutoSaveCommand = new ToggleAutoSaveEnabledCommand();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.isStationAutoSaveEnabled"), (BWidget)new BCheckBox(this.toggleAutoSaveCommand));
        this.stationAutoSaveFrequencyEditor = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR, (Context)BSystemPlatformService.stationAutoSaveFrequency.getFacets());
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.stationAutoSaveFrequency"), (BWidget)this.stationAutoSaveFrequencyEditor);
        this.stationSaveBackupCountEditor = new BIntegerFE();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.stationSaveBackupCount"), (BWidget)this.stationSaveBackupCountEditor);
        this.numCpusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.numCpus"), (BWidget)this.numCpusLabel);
        this.currentCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.currentCpuUsage"), (BWidget)this.currentCpuLabel);
        this.overallCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.overallCpuUsage"), (BWidget)this.overallCpuLabel);
        this.filesystemPane = new BGridPane(6);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.filesystem"), (BWidget)this.filesystemPane);
        this.filesystemPane.setColumnAlign(BHalign.fill);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.totalKb"), true, BHalign.center));
        bGridPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.freeKb"), true, BHalign.center));
        this.totalPhysicalMemoryLabel = new BLabel("", BHalign.right);
        bGridPane.add(null, (BValue)this.totalPhysicalMemoryLabel);
        this.freePhysicalMemoryLabel = new BLabel("", BHalign.right);
        bGridPane.add(null, (BValue)this.freePhysicalMemoryLabel);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.physicalMemory"), (BWidget)bGridPane);
        this.buttonPane = new BButtonPane();
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.ledgerPane));
        bScrollPane.setViewportBackground(bBrush);
        this.linkTo(null, (BComponent)this.timeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)timeZoneModified);
        this.linkTo(null, (BComponent)this.timeEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.dateEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.localeEditor, (Slot)BWbPlugin.pluginModified, (Slot)localeModified);
        this.linkTo(null, (BComponent)this.watchdogPolicyEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.watchdogTimeoutEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationAutoSaveFrequencyEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationSaveBackupCountEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)this.buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT)));
    }

    public BSystemPlatformService getSystemPlatformService() {
        return (BSystemPlatformService)this.getCurrentValue();
    }

    protected void loadTimeEditors(long l, BTimeZone bTimeZone, Context context) {
        Context context2 = context == null ? new BasicContext() : context;
        BAbsTime bAbsTime = BAbsTime.make((long)l, (BTimeZone)bTimeZone);
        BasicContext basicContext = new BasicContext(context2, BFacets.make((BFacets)HOUR_MINUTE, (String)"TimeZone", (BIDataValue)bTimeZone));
        this.timeEditor.loadValue((BObject)bAbsTime, (Context)basicContext);
        basicContext = new BasicContext(context2, BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone));
        this.dateEditor.loadValue((BObject)bAbsTime, (Context)basicContext);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        Context context2 = context == null ? new BasicContext() : context;
        boolean bl = this.loading;
        this.loading = true;
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)bObject;
        bSystemPlatformService.poll();
        this.registerForComponentEvents(bSystemPlatformService, 4);
        this.javaVmNameLabel.setText(bSystemPlatformService.getJavaVmName());
        this.hostLabel.setText(BOrd.toHost((BObject)bSystemPlatformService).getNavDisplayName(null));
        this.javaVmVendorLabel.setText(bSystemPlatformService.getJavaVmVendor());
        this.javaVmVersionLabel.setText(bSystemPlatformService.getJavaVmVersion());
        this.osArchLabel.setText(bSystemPlatformService.getOsArch());
        this.modelLabel.setText(bSystemPlatformService.getModel());
        this.osNameLabel.setText(bSystemPlatformService.getOsName());
        this.niagaraVersionLabel.setText(bSystemPlatformService.getNiagaraVersion());
        this.osVersionLabel.setText(bSystemPlatformService.getOsVersion());
        this.hostIdLabel.setText(bSystemPlatformService.getHostId());
        this.nameLabel.setText(bSystemPlatformService.getStationName());
        String string = bSystemPlatformService.getFipsStatus();
        if (string != null && !string.equals("")) {
            this.fipsStatusLabel = new BLabel(string);
            LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.fipsStatus"), (BWidget)this.fipsStatusLabel);
        }
        if (bSystemPlatformService.getLocalDaemonPort() > 0) {
            this.daemonPortLabel.setText(String.valueOf(bSystemPlatformService.getLocalDaemonPort()));
        } else {
            this.daemonPortLabel.setText(this.getLexicon().getText("unknown"));
        }
        if (bSystemPlatformService.getLocalDaemonSslPort() > 0) {
            this.daemonSSLPortLabel.setText(String.valueOf(bSystemPlatformService.getLocalDaemonSslPort()));
        } else {
            this.daemonSSLPortLabel.setText(this.getLexicon().getText("unknown"));
        }
        this.localeEditor.loadValue((BObject)BString.make((String)bSystemPlatformService.getLocale()), (Context)new BasicContext(context2, BSystemPlatformService.locale.getFacets()));
        this.loadTimeEditors(bSystemPlatformService.getSystemTime().getMillis(), bSystemPlatformService.getTimeZone(), context2);
        this.timeEditor.setReadonly(bSystemPlatformService.getLocalDaemonAccess() == BDaemonAccessLevel.restricted);
        this.dateEditor.setReadonly(bSystemPlatformService.getLocalDaemonAccess() == BDaemonAccessLevel.restricted);
        this.watchdogPolicyEditor.loadValue((BObject)bSystemPlatformService.getEngineWatchdogPolicy(), context2);
        this.watchdogTimeoutEditor.loadValue((BObject)bSystemPlatformService.getEngineWatchdogTimeout(), (Context)new BasicContext(context2, BSystemPlatformService.engineWatchdogTimeout.getFacets()));
        this.toggleAutoSaveCommand.setSelected(bSystemPlatformService.getIsStationAutoSaveEnabled());
        this.stationAutoSaveFrequencyEditor.loadValue((BObject)bSystemPlatformService.getStationAutoSaveFrequency(), (Context)new BasicContext(context2, BSystemPlatformService.stationAutoSaveFrequency.getFacets()));
        this.stationSaveBackupCountEditor.loadValue((BObject)BInteger.make((int)bSystemPlatformService.getStationSaveBackupCount()), context2);
        this.stationAutoSaveFrequencyEditor.setEnabled(bSystemPlatformService.getIsStationAutoSaveEnabled());
        this.stationSaveBackupCountEditor.setEnabled(bSystemPlatformService.getIsStationAutoSaveEnabled());
        this.numCpusLabel.setText(String.valueOf(bSystemPlatformService.getNumCpus()));
        int n = bSystemPlatformService.getCurrentCpuUsage();
        if (n < 0) {
            this.currentCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
        } else {
            this.currentCpuLabel.setText(n + "%");
        }
        n = bSystemPlatformService.getOverallCpuUsage();
        if (n < 0) {
            this.overallCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
        } else {
            this.overallCpuLabel.setText(n + "%");
        }
        this.freePhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(bSystemPlatformService.getFreePhysicalMemory()));
        this.totalPhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(bSystemPlatformService.getTotalPhysicalMemory()));
        this.filesystemPane.removeAll();
        this.filesystemPane.add(null, (BValue)new BNullWidget());
        this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.totalKb"), true, BHalign.center));
        this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.freeKb"), true, BHalign.center));
        this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.blockSize"), true, BHalign.center));
        if (bSystemPlatformService instanceof BSystemPlatformServiceQnx) {
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.currentFileCount"), true, BHalign.center));
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel(LexiconText.make((Type)TYPE, (String)"labels.system.maxFileCount"), true, BHalign.center));
        } else {
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)new BNullWidget());
        }
        Object object = bSystemPlatformService.getFilesystemAttributes().loadSlots().getProperties();
        while (object.next()) {
            Property property = object.property();
            this.filesystemPane.add(null, (BValue)new BLabel(SlotPath.unescape((String)property.getName())));
            BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)object.get();
            this.filesystemPane.add(property.getName() + "total", (BValue)new BLabel(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getTotalSpace()), BHalign.right));
            this.filesystemPane.add(property.getName() + "free", (BValue)new BLabel(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getFreeSpace()), BHalign.right));
            this.filesystemPane.add(property.getName() + "block", (BValue)new BLabel(DaemonFileUtil.byteFormat.format(bFilesystemAttributes.getBlockSize()), BHalign.right));
            if (bSystemPlatformService instanceof BSystemPlatformServiceQnx) {
                String string2 = bFilesystemAttributes.getCurrentFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(bFilesystemAttributes.getCurrentFileCount());
                String string3 = bFilesystemAttributes.getMaxFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(bFilesystemAttributes.getMaxFileCount());
                this.filesystemPane.add(property.getName() + "currentFile", (BValue)new BLabel(string2, BHalign.right));
                this.filesystemPane.add(property.getName() + "maxFile", (BValue)new BLabel(string3, BHalign.right));
                continue;
            }
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)new BNullWidget());
        }
        object = new ZoneListModel(bSystemPlatformService.getStationTimeZones());
        this.timeZoneDropDown.getList().setModel((ListModel)object);
        this.timeZoneDropDown.setSelectedItem((Object)bSystemPlatformService.getTimeZone());
        this.isTimeModified = false;
        this.isTimeZoneModified = false;
        this.restartEnabled = bSystemPlatformService.getAllowStationRestart();
        this.tzRequiresReboot = bSystemPlatformService instanceof BSystemPlatformServiceQnx || bSystemPlatformService instanceof BSystemPlatformServiceNxs || bSystemPlatformService instanceof BSystemPlatformServiceNxtFlash;
        this.buttonPane.removeAll();
        this.buttonPane.addWorkbenchButtons((BWidget)this);
        this.getContent().relayout();
        this.loading = bl;
    }

    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        this.saving = true;
        BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)bObject;
        bSystemPlatformService.setEngineWatchdogPolicy((BEngineWatchdogPolicy)this.watchdogPolicyEditor.saveValue());
        bSystemPlatformService.setEngineWatchdogTimeout((BRelTime)this.watchdogTimeoutEditor.saveValue());
        bSystemPlatformService.setIsStationAutoSaveEnabled(this.toggleAutoSaveCommand.isSelected());
        bSystemPlatformService.setStationAutoSaveFrequency((BRelTime)this.stationAutoSaveFrequencyEditor.saveValue());
        bSystemPlatformService.setStationSaveBackupCount(((BInteger)this.stationSaveBackupCountEditor.saveValue()).getInt());
        if (this.isLocaleModified) {
            bSystemPlatformService.setLocale(((BString)this.localeEditor.saveValue()).toString());
            this.isLocaleModified = false;
        }
        if (this.isTimeModified || this.isTimeZoneModified) {
            BAbsTime bAbsTime = (BAbsTime)this.dateEditor.saveValue();
            BAbsTime bAbsTime2 = (BAbsTime)this.timeEditor.saveValue();
            BAbsTime bAbsTime3 = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime2.getHour(), (int)bAbsTime2.getMinute(), (int)0, (int)0, (BTimeZone)((BTimeZone)this.timeZoneDropDown.getSelectedItem()));
            if (bSystemPlatformService.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                bSystemPlatformService.set(BSystemPlatformService.systemTime, (BValue)bAbsTime3, context);
            }
            this.isTimeModified = false;
        }
        if (this.isTimeZoneModified) {
            bSystemPlatformService.setTimeZone((BTimeZone)this.timeZoneDropDown.getSelectedItem());
            this.isTimeZoneModified = false;
        }
        this.doSaveSystemPlatformServiceFields(bSystemPlatformService, context);
        bSystemPlatformService.savePlatformServiceProperties();
        if (this.rebootFieldDirty) {
            if (bSystemPlatformService.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.message"))) {
                    bSystemPlatformService.reboot();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.message"));
            }
        } else if (this.restartFieldDirty) {
            if (bSystemPlatformService.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.message"))) {
                    bSystemPlatformService.restartStation();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.message"));
            }
        }
        this.rebootFieldDirty = false;
        this.restartFieldDirty = false;
        this.saving = false;
        return bObject;
    }

    protected void doSaveSystemPlatformServiceFields(BSystemPlatformService bSystemPlatformService, Context context) throws Exception {
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.saving || this.loading || bComponentEvent == null || bComponentEvent.getSlot() == null || !bComponentEvent.getSlot().isProperty()) {
            return;
        }
        if (bComponentEvent.getSourceComponent() instanceof BSystemPlatformService) {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            BValue bValue = bSystemPlatformService.get(property);
            if (property == BSystemPlatformService.javaVmName) {
                this.javaVmNameLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.javaVmVendor) {
                this.javaVmVendorLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.javaVmVersion) {
                this.javaVmVersionLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.osArch) {
                this.osArchLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.osName) {
                this.osNameLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.osVersion) {
                this.osVersionLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.hostId) {
                this.hostIdLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.stationName) {
                this.nameLabel.setText(bValue.toString());
            } else if (property == BSystemPlatformService.locale) {
                if (!this.isLocaleModified) {
                    this.localeEditor.loadValue((BObject)BString.make((String)bValue.toString()), (Context)new BasicContext((Context)bComponentEvent.getSlot().getFacets()));
                }
            } else if (property == BSystemPlatformService.systemTime) {
                if (!this.isTimeModified) {
                    this.loadTimeEditors(((BAbsTime)bValue).getMillis(), bSystemPlatformService.getTimeZone(), this.getCurrentContext());
                }
            } else if (property == BSystemPlatformService.timeZone) {
                if (!this.isTimeZoneModified) {
                    this.timeZoneDropDown.setSelectedItem((Object)bSystemPlatformService.getTimeZone());
                }
            } else if (property == BSystemPlatformService.engineWatchdogPolicy) {
                this.watchdogPolicyEditor.loadValue((BObject)((BEngineWatchdogPolicy)bValue), (Context)new BasicContext((Context)bComponentEvent.getSlot().getFacets()));
            } else if (property == BSystemPlatformService.engineWatchdogTimeout) {
                this.watchdogTimeoutEditor.loadValue((BObject)((BRelTime)bValue), (Context)new BasicContext((Context)bComponentEvent.getSlot().getFacets()));
            } else if (property == BSystemPlatformService.totalPhysicalMemory) {
                this.totalPhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(bSystemPlatformService.getTotalPhysicalMemory()));
            } else if (property == BSystemPlatformService.freePhysicalMemory) {
                this.freePhysicalMemoryLabel.setText(DaemonFileUtil.kbFormat.format(bSystemPlatformService.getFreePhysicalMemory()));
            } else if (property == BSystemPlatformService.isStationAutoSaveEnabled) {
                this.lockModifiedState();
                this.toggleAutoSaveCommand.setSelected(bSystemPlatformService.getIsStationAutoSaveEnabled());
                this.unlockModifiedState();
            } else if (property == BSystemPlatformService.stationAutoSaveFrequency || property == BSystemPlatformServiceQnx.stationAutoSaveFrequency) {
                this.stationAutoSaveFrequencyEditor.loadValue((BObject)((BRelTime)bValue), (Context)new BasicContext((Context)bComponentEvent.getSlot().getFacets()));
            } else if (property == BSystemPlatformService.stationSaveBackupCount || property == BSystemPlatformServiceQnx.stationSaveBackupCount) {
                this.stationSaveBackupCountEditor.loadValue((BObject)BInteger.make((int)bSystemPlatformService.getStationSaveBackupCount()));
            } else if (property == BSystemPlatformService.currentCpuUsage) {
                int n = bSystemPlatformService.getCurrentCpuUsage();
                if (n < 0) {
                    this.currentCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
                } else {
                    this.currentCpuLabel.setText(n + "%");
                }
            } else if (property == BSystemPlatformService.overallCpuUsage) {
                int n = bSystemPlatformService.getOverallCpuUsage();
                if (n < 0) {
                    this.overallCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
                } else {
                    this.overallCpuLabel.setText(n + "%");
                }
            } else if (property == BSystemPlatformService.localDaemonPort) {
                if (bSystemPlatformService.getLocalDaemonPort() > 0) {
                    this.daemonPortLabel.setText(String.valueOf(bSystemPlatformService.getLocalDaemonPort()));
                } else {
                    this.daemonPortLabel.setText(this.getLexicon().getText("unknown"));
                }
            } else if (property == BSystemPlatformService.localDaemonSslPort) {
                if (bSystemPlatformService.getLocalDaemonSslPort() > 0) {
                    this.daemonSSLPortLabel.setText(String.valueOf(bSystemPlatformService.getLocalDaemonSslPort()));
                } else {
                    this.daemonSSLPortLabel.setText(this.getLexicon().getText("unknown"));
                }
            }
            this.getContent().relayout();
        } else if (bComponentEvent.getSourceComponent() instanceof BFilesystemAttributes) {
            BLabel bLabel;
            BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            String string = bFilesystemAttributes.getPropertyInParent().getName();
            if (property == BFilesystemAttributes.freeSpace) {
                BLabel bLabel2 = (BLabel)this.filesystemPane.get(string + "free");
                if (bLabel2 != null) {
                    bLabel2.setText(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getFreeSpace()));
                }
            } else if (property == BFilesystemAttributes.blockSize) {
                BLabel bLabel3 = (BLabel)this.filesystemPane.get(string + "block");
                if (bLabel3 != null) {
                    bLabel3.setText(DaemonFileUtil.byteFormat.format(bFilesystemAttributes.getBlockSize()));
                }
            } else if (property == BFilesystemAttributes.totalSpace) {
                BLabel bLabel4 = (BLabel)this.filesystemPane.get(string + "total");
                if (bLabel4 != null) {
                    bLabel4.setText(DaemonFileUtil.kbFormat.format(bFilesystemAttributes.getTotalSpace()));
                }
            } else if (property == BFilesystemAttributes.currentFileCount) {
                BLabel bLabel5 = (BLabel)this.filesystemPane.get(string + "currentFile");
                if (bLabel5 != null) {
                    String string2 = bFilesystemAttributes.getCurrentFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(bFilesystemAttributes.getCurrentFileCount());
                    bLabel5.setText(string2);
                }
            } else if (property == BFilesystemAttributes.maxFileCount && (bLabel = (BLabel)this.filesystemPane.get(string + "maxFile")) != null) {
                String string3 = bFilesystemAttributes.getMaxFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(bFilesystemAttributes.getMaxFileCount());
                bLabel.setText(string3);
            }
        } else {
            BPlatform.log.trace("unhandled event " + bComponentEvent);
        }
    }

    public void doTimeModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeModified = true;
            this.invoke(setModified, null, null);
        }
    }

    public void doTimeZoneModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeZoneModified = true;
            if (this.tzRequiresReboot || !this.restartEnabled) {
                this.rebootFieldDirty = true;
            } else {
                this.restartFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    public void doLocaleModified() {
        if (!this.isModifiedStateLocked()) {
            this.isLocaleModified = true;
            if (this.restartEnabled) {
                this.restartFieldDirty = true;
            } else {
                this.rebootFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    public void doMarkRestartFieldDirty() {
        if (this.restartEnabled) {
            if (!this.isModifiedStateLocked()) {
                this.restartFieldDirty = true;
                this.invoke(setModified, null, null);
            }
        } else {
            this.doMarkRebootFieldDirty();
        }
    }

    public void doMarkRebootFieldDirty() {
        if (!this.isModifiedStateLocked()) {
            this.rebootFieldDirty = true;
            this.invoke(setModified, null, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ToggleAutoSaveEnabledCommand
    extends ToggleCommand {
        public ToggleAutoSaveEnabledCommand() {
            super((BWidget)BSystemPlatformServicePlugin.this, BSystemPlatformServicePlugin.this.getLexicon().getText("labels.system.enableStationAutoSave"));
        }

        public CommandArtifact doInvoke() {
            BSystemPlatformServicePlugin.this.stationAutoSaveFrequencyEditor.setEnabled(this.isSelected());
            BSystemPlatformServicePlugin.this.stationSaveBackupCountEditor.setEnabled(this.isSelected());
            BSystemPlatformServicePlugin.this.setModified();
            return null;
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BVector bVector) {
            this.items = (BTimeZone[])bVector.getChildren(class$javax$baja$timezone$BTimeZone == null ? (class$javax$baja$timezone$BTimeZone = BSystemPlatformServicePlugin.class$("javax.baja.timezone.BTimeZone")) : class$javax$baja$timezone$BTimeZone);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int n) {
            return this.items[n];
        }

        public Object getItem(int n) {
            return this.getTimeZone(n);
        }
    }
}

