/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui;

import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platform.win32.BSystemPlatformServiceNxs;
import com.tridium.platform.win32.BSystemPlatformServiceNxtFlash;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.fieldeditors.BDateFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BSystemDateTimeEditor
extends BWbComponentView {
    public static final Action timeModified = BSystemDateTimeEditor.newAction((int)4, null);
    public static final Action timeZoneModified = BSystemDateTimeEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$BSystemDateTimeEditor == null ? (class$com$tridium$platform$ui$BSystemDateTimeEditor = BSystemDateTimeEditor.class$("com.tridium.platform.ui.BSystemDateTimeEditor")) : class$com$tridium$platform$ui$BSystemDateTimeEditor));
    protected BGridPane ledgerPane;
    private BButtonPane buttonPane;
    private BListDropDown timeZoneDropDown;
    private BWbFieldEditor timeEditor;
    private BDateFE dateEditor;
    private boolean isTimeModified = false;
    private boolean isTimeZoneModified = false;
    protected boolean saving = false;
    protected boolean loading = false;
    protected boolean tzRequiresReboot = false;
    protected boolean restartEnabled = false;
    private boolean restartFieldDirty = false;
    private boolean rebootFieldDirty = false;
    private BSystemPlatformService systemPlatformService = null;
    private static final BFacets HOUR_MINUTE = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"HH:mm"), BBoolean.FALSE, BBoolean.TRUE, BBoolean.FALSE});
    static /* synthetic */ Class class$com$tridium$platform$ui$BSystemDateTimeEditor;
    static /* synthetic */ Class class$com$tridium$platform$BSystemPlatformService;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public void timeModified() {
        this.invoke(timeModified, null, null);
    }

    public void timeZoneModified() {
        this.invoke(timeZoneModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSystemDateTimeEditor() {
        this.autoRegisterForComponentEvents = false;
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setValign(BValign.top);
        this.ledgerPane.setColumnGap(10.0);
        this.ledgerPane.setRowGap(6.0);
        this.ledgerPane.setColorRows(true);
        this.timeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemTime"), (BWidget)this.timeEditor);
        this.dateEditor = new BDateFE();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemDate"), (BWidget)this.dateEditor);
        this.timeZoneDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair(this.ledgerPane, LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone"), (BWidget)this.timeZoneDropDown);
        this.timeZoneDropDown.getList().setMultipleSelection(false);
        this.buttonPane = new BButtonPane();
        BBrush bBrush = Theme.scrollPane().getControlBackground();
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.ledgerPane));
        bScrollPane.setViewportBackground(bBrush);
        this.linkTo(null, (BComponent)this.timeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)timeZoneModified);
        this.linkTo(null, (BComponent)this.timeEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.dateEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)this.buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT)));
    }

    public BSystemPlatformService getSystemPlatformService() {
        return this.systemPlatformService;
    }

    protected void loadTimeEditors(long l, BTimeZone bTimeZone, Context context) {
        Context context2 = context == null ? new BasicContext() : context;
        BAbsTime bAbsTime = BAbsTime.make((long)l, (BTimeZone)bTimeZone);
        BasicContext basicContext = new BasicContext(context2, BFacets.make((BFacets)HOUR_MINUTE, (String)"TimeZone", (BIDataValue)bTimeZone));
        this.timeEditor.loadValue((BObject)bAbsTime, (Context)basicContext);
        basicContext = new BasicContext(context2, BFacets.make((String)"TimeZone", (BIDataValue)bTimeZone));
        this.dateEditor.loadValue((BObject)bAbsTime, (Context)basicContext);
        this.timeEditor.setReadonly(this.systemPlatformService.getLocalDaemonAccess() == BDaemonAccessLevel.restricted);
        this.dateEditor.setReadonly(this.systemPlatformService.getLocalDaemonAccess() == BDaemonAccessLevel.restricted);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        Context context2 = context == null ? new BasicContext() : context;
        boolean bl = this.loading;
        this.loading = true;
        if (bObject instanceof BSystemPlatformService) {
            this.systemPlatformService = (BSystemPlatformService)bObject;
        } else if (bObject instanceof BPlatformServiceContainer) {
            this.systemPlatformService = (BSystemPlatformService)((BPlatformServiceContainer)bObject).getChildren(class$com$tridium$platform$BSystemPlatformService == null ? (class$com$tridium$platform$BSystemPlatformService = BSystemDateTimeEditor.class$("com.tridium.platform.BSystemPlatformService")) : class$com$tridium$platform$BSystemPlatformService)[0];
        } else {
            throw new ClassCastException();
        }
        this.systemPlatformService.poll();
        this.registerForComponentEvents(this.systemPlatformService, 4);
        this.loadTimeEditors(this.systemPlatformService.getSystemTime().getMillis(), this.systemPlatformService.getTimeZone(), context2);
        ZoneListModel zoneListModel = new ZoneListModel(this.systemPlatformService.getAllTimeZones());
        this.timeZoneDropDown.getList().setModel((ListModel)zoneListModel);
        this.timeZoneDropDown.setSelectedItem((Object)this.systemPlatformService.getTimeZone());
        this.isTimeModified = false;
        this.isTimeZoneModified = false;
        this.restartEnabled = this.systemPlatformService.getAllowStationRestart();
        this.tzRequiresReboot = this.systemPlatformService instanceof BSystemPlatformServiceQnx || this.systemPlatformService instanceof BSystemPlatformServiceNxs || this.systemPlatformService instanceof BSystemPlatformServiceNxtFlash;
        this.buttonPane.removeAll();
        this.buttonPane.addWorkbenchButtons((BWidget)this);
        this.getContent().relayout();
        this.loading = bl;
    }

    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        this.saving = true;
        if (bObject instanceof BSystemPlatformService) {
            this.systemPlatformService = (BSystemPlatformService)bObject;
        } else if (bObject instanceof BPlatformServiceContainer) {
            this.systemPlatformService = (BSystemPlatformService)((BPlatformServiceContainer)bObject).getChildren(class$com$tridium$platform$BSystemPlatformService == null ? (class$com$tridium$platform$BSystemPlatformService = BSystemDateTimeEditor.class$("com.tridium.platform.BSystemPlatformService")) : class$com$tridium$platform$BSystemPlatformService)[0];
        } else {
            throw new ClassCastException();
        }
        if (this.isTimeModified || this.isTimeZoneModified) {
            BAbsTime bAbsTime = (BAbsTime)this.dateEditor.saveValue();
            BAbsTime bAbsTime2 = (BAbsTime)this.timeEditor.saveValue();
            BAbsTime bAbsTime3 = BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)bAbsTime.getDay(), (int)bAbsTime2.getHour(), (int)bAbsTime2.getMinute(), (int)0, (int)0, (BTimeZone)((BTimeZone)this.timeZoneDropDown.getSelectedItem()));
            this.systemPlatformService.set(BSystemPlatformService.systemTime, (BValue)bAbsTime3, context);
            this.isTimeModified = false;
        }
        if (this.isTimeZoneModified) {
            this.systemPlatformService.setTimeZone((BTimeZone)this.timeZoneDropDown.getSelectedItem());
            this.isTimeZoneModified = false;
        }
        this.systemPlatformService.savePlatformServiceProperties();
        if (this.rebootFieldDirty) {
            if (this.systemPlatformService.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.message"))) {
                    this.systemPlatformService.reboot();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.message"));
            }
        } else if (this.restartFieldDirty) {
            if (this.systemPlatformService.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.message"))) {
                    this.systemPlatformService.restartStation();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.message"));
            }
        }
        this.rebootFieldDirty = false;
        this.restartFieldDirty = false;
        this.saving = false;
        return bObject;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.saving || !bComponentEvent.getSlot().isProperty()) {
            return;
        }
        if (bComponentEvent.getSourceComponent() instanceof BSystemPlatformService) {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            BValue bValue = bSystemPlatformService.get(property);
            if (property == BSystemPlatformService.systemTime) {
                if (!this.isTimeModified) {
                    this.loadTimeEditors(((BAbsTime)bValue).getMillis(), bSystemPlatformService.getTimeZone(), this.getCurrentContext());
                }
            } else if (property == BSystemPlatformService.timeZone && !this.isTimeZoneModified) {
                this.timeZoneDropDown.setSelectedItem((Object)bSystemPlatformService.getTimeZone());
            }
        }
    }

    public void doTimeModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeModified = true;
            this.invoke(setModified, null, null);
        }
    }

    public void doTimeZoneModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeZoneModified = true;
            if (this.tzRequiresReboot || !this.restartEnabled) {
                this.rebootFieldDirty = true;
            } else {
                this.restartFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BVector bVector) {
            this.items = (BTimeZone[])bVector.getChildren(class$javax$baja$timezone$BTimeZone == null ? (class$javax$baja$timezone$BTimeZone = BSystemDateTimeEditor.class$("javax.baja.timezone.BTimeZone")) : class$javax$baja$timezone$BTimeZone);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int n) {
            return this.items[n];
        }

        public Object getItem(int n) {
            return this.getTimeZone(n);
        }
    }
}

