/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.timezone;

import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.timezone.HistoricalTimeZoneEra;
import java.util.Comparator;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneException;

public class TimeZoneUtil {
    public static final Comparator TZ_COMPARATOR = new Comparator(){

        public final int compare(Object object, Object object2) {
            long l = System.currentTimeMillis();
            BTimeZone bTimeZone = (BTimeZone)object;
            BTimeZone bTimeZone2 = (BTimeZone)object2;
            if (bTimeZone.getUtcOffset(l) == bTimeZone2.getUtcOffset(l)) {
                return bTimeZone.getId().compareTo(bTimeZone2.getId());
            }
            if (bTimeZone.getUtcOffset(l) < bTimeZone2.getUtcOffset(l)) {
                return -1;
            }
            return 1;
        }
    };

    public static boolean isEquivalent(BTimeZone bTimeZone, BTimeZone bTimeZone2) {
        int n;
        int n2;
        int n3;
        int n4;
        long l = System.currentTimeMillis();
        HistoricalTimeZoneEra historicalTimeZoneEra = null;
        DstRule dstRule = null;
        DstRule dstRule2 = null;
        DstRule dstRule3 = null;
        DstRule dstRule4 = null;
        if (bTimeZone.isHistorical()) {
            historicalTimeZoneEra = (HistoricalTimeZoneEra)bTimeZone.fw(1101, (Object)new Long(l), null, null, null);
            n4 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            dstRule = (DstRule)DstRule.fw((int)1103, (Object)historicalTimeZoneEra.getStartRule());
            dstRule2 = (DstRule)DstRule.fw((int)1103, (Object)historicalTimeZoneEra.getEndRule());
            int n5 = 0;
            if (dstRule != null) {
                n5 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n3 = n5;
        } else {
            n4 = bTimeZone.getUtcOffset();
            n3 = bTimeZone.getDaylightAdjustment();
            dstRule = bTimeZone.getDaylightStartRule();
            dstRule2 = bTimeZone.getDaylightEndRule();
        }
        if (bTimeZone2.isHistorical()) {
            historicalTimeZoneEra = (HistoricalTimeZoneEra)bTimeZone2.fw(1101, (Object)new Long(l), null, null, null);
            n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            dstRule3 = (DstRule)DstRule.fw((int)1103, (Object)historicalTimeZoneEra.getStartRule());
            dstRule4 = (DstRule)DstRule.fw((int)1103, (Object)historicalTimeZoneEra.getEndRule());
            int n6 = 0;
            if (dstRule3 != null) {
                n6 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n = n6;
        } else {
            n2 = bTimeZone2.getUtcOffset();
            n = bTimeZone2.getDaylightAdjustment();
            dstRule3 = bTimeZone2.getDaylightStartRule();
            dstRule4 = bTimeZone2.getDaylightEndRule();
        }
        if (n4 != n2) {
            return false;
        }
        if (n3 != n) {
            return false;
        }
        if (n3 == 0) {
            return true;
        }
        DstRule dstRule5 = null;
        DstRule dstRule6 = null;
        try {
            dstRule5 = DstRule.asWeekdayRule((DstRule)dstRule);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule5 = dstRule;
        }
        try {
            dstRule6 = DstRule.asWeekdayRule((DstRule)dstRule3);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule6 = dstRule3;
        }
        if (TimeZoneUtil.isSupported(dstRule5, bTimeZone, 0, BDstSupportLevel.full)) {
            dstRule5 = DstRule.getWallTimeRule((DstRule)dstRule5, (int)0, (BTimeZone)bTimeZone);
        }
        if (TimeZoneUtil.isSupported(dstRule6, bTimeZone2, 0, BDstSupportLevel.full)) {
            dstRule6 = DstRule.getWallTimeRule((DstRule)dstRule6, (int)0, (BTimeZone)bTimeZone2);
        }
        if (!DstRule.equals((DstRule)dstRule5, (DstRule)dstRule6)) {
            return false;
        }
        try {
            dstRule5 = DstRule.asWeekdayRule((DstRule)dstRule2);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule5 = dstRule2;
        }
        try {
            dstRule6 = DstRule.asWeekdayRule((DstRule)dstRule4);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule6 = dstRule4;
        }
        if (TimeZoneUtil.isSupported(dstRule5, bTimeZone, 1, BDstSupportLevel.full)) {
            dstRule5 = DstRule.getWallTimeRule((DstRule)dstRule5, (int)1, (BTimeZone)bTimeZone);
        }
        if (TimeZoneUtil.isSupported(dstRule6, bTimeZone2, 1, BDstSupportLevel.full)) {
            dstRule6 = DstRule.getWallTimeRule((DstRule)dstRule6, (int)1, (BTimeZone)bTimeZone2);
        }
        return DstRule.equals((DstRule)dstRule5, (DstRule)dstRule6);
    }

    public static boolean isSupported(BTimeZone bTimeZone, BDstSupportLevel bDstSupportLevel) {
        return TimeZoneUtil.isSupported(System.currentTimeMillis(), bTimeZone, bDstSupportLevel);
    }

    public static boolean isSupported(long l, BTimeZone bTimeZone, BDstSupportLevel bDstSupportLevel) {
        boolean bl = false;
        if (TimeZoneUtil.isSupported(bTimeZone.getDaylightStartRule(l), bTimeZone, 0, bDstSupportLevel) && TimeZoneUtil.isSupported(bTimeZone.getDaylightEndRule(l), bTimeZone, 1, bDstSupportLevel)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSupported(DstRule dstRule, BTimeZone bTimeZone, int n, BDstSupportLevel bDstSupportLevel) {
        if (dstRule == null) {
            return true;
        }
        if (bDstSupportLevel == BDstSupportLevel.none) {
            return false;
        }
        switch (bDstSupportLevel.getOrdinal()) {
            case 0: {
                return false;
            }
            case 1: {
                if (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) {
                    try {
                        dstRule = DstRule.asWeekdayRule((DstRule)dstRule);
                        break;
                    }
                    catch (TimeZoneException timeZoneException) {
                        return false;
                    }
                }
                if (dstRule.getDayMode() == -1) break;
                return false;
            }
            case 2: {
                if (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) {
                    try {
                        dstRule = DstRule.asWeekdayRule((DstRule)dstRule);
                        break;
                    }
                    catch (TimeZoneException timeZoneException) {
                        return false;
                    }
                }
                if (dstRule.getDayMode() == -1 || dstRule.getDayMode() == 0) break;
                return false;
            }
        }
        if (dstRule.getTimeMode() == 2) {
            BAbsTime bAbsTime = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)dstRule.getMonth(), (int)2, (int)dstRule.getTime().getHour(), (int)dstRule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
            if ((bAbsTime = BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone)).getDay() != 2) {
                return false;
            }
        } else if (dstRule.getTimeMode() == 1 && n == 1) {
            BAbsTime bAbsTime = BAbsTime.make((int)BAbsTime.now().getYear(), (BMonth)dstRule.getMonth(), (int)2, (int)dstRule.getTime().getHour(), (int)dstRule.getTime().getMinute(), (int)0, (int)0, (BTimeZone)BTimeZone.makeIgnoringCache((String)(bTimeZone.getId() + "-std"), (int)bTimeZone.getUtcOffset()));
            if ((bAbsTime = BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone)).getDay() != 2) {
                return false;
            }
        }
        return true;
    }

    public static BTimeZone makeCompatible(BTimeZone bTimeZone, BDstSupportLevel bDstSupportLevel) {
        return TimeZoneUtil.makeCompatible(System.currentTimeMillis(), bTimeZone, bDstSupportLevel);
    }

    public static BTimeZone makeCompatible(long l, BTimeZone bTimeZone, BDstSupportLevel bDstSupportLevel) {
        DstRule dstRule = bTimeZone.getDaylightStartRule(l);
        DstRule dstRule2 = bTimeZone.getDaylightEndRule(l);
        boolean bl = false;
        if (dstRule != null && (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) && bDstSupportLevel.getOrdinal() != 3) {
            bl = true;
            dstRule = DstRule.asWeekdayRule((DstRule)dstRule);
        }
        if (dstRule2 != null && (dstRule2.getDayMode() == 1 || dstRule2.getDayMode() == 2) && bDstSupportLevel.getOrdinal() != 3) {
            bl = true;
            dstRule2 = DstRule.asWeekdayRule((DstRule)dstRule2);
        }
        if (bl) {
            return BTimeZone.makeIgnoringCache((String)bTimeZone.getId(), (String)bTimeZone.getDisplayName(false, null), (String)bTimeZone.getShortDisplayName(false, null), (String)bTimeZone.getDisplayName(true, null), (String)bTimeZone.getShortDisplayName(true, null), (int)bTimeZone.getUtcOffset(l), (int)bTimeZone.getDaylightAdjustment(l), (DstRule)dstRule, (DstRule)dstRule2);
        }
        return bTimeZone;
    }
}

