/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip;

import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.tcpip.BPingArgs;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.sys.NreLib;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTcpIpPlatformService
extends BPlatformService {
    public static final Property settings = BTcpIpPlatformService.newProperty((int)3, (BValue)new BTcpIpHostSettings(), null);
    public static final Action ping = BTcpIpPlatformService.newAction((int)4, (BValue)new BPingArgs(), null);
    public static final Action ping6 = BTcpIpPlatformService.newAction((int)4, (BValue)new BPingArgs(true), null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpPlatformService;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public BTcpIpHostSettings getSettings() {
        return (BTcpIpHostSettings)this.get(settings);
    }

    public void setSettings(BTcpIpHostSettings bTcpIpHostSettings) {
        this.set(settings, (BValue)bTcpIpHostSettings, null);
    }

    public BInteger ping(BPingArgs bPingArgs) {
        return (BInteger)this.invoke(ping, (BValue)bPingArgs, null);
    }

    public BInteger ping6(BPingArgs bPingArgs) {
        return (BInteger)this.invoke(ping6, (BValue)bPingArgs, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return true;
    }

    public int getSlotFlags() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void doSavePlatformServiceProperties() throws Exception {
        block10: {
            if (!this.isRunning()) {
                return;
            }
            if (!this.loadSystemPlatformServiceLibrary() && this.getSettings().getIsReadonly()) {
                return;
            }
            super.doSavePlatformServiceProperties();
            var1_1 = false;
            var2_2 = this.getSettings().getAdapters().getProperties();
            if (true) ** GOTO lbl13
            do {
                if (((BTcpIpAdapterSettings)var2_2.get()).getIsIpv6Supported()) {
                    var1_1 = true;
                    break;
                }
lbl13:
                // 3 sources

                if ((v0 = BTcpIpPlatformService.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
                v0 = BTcpIpPlatformService.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
            } while (var2_2.next(v0));
            if (var1_1 && System.getProperty("java.vm.vendor", "null").equalsIgnoreCase("IBM Corporation") && this.getSettings().getNiagaraUsesIpv6()) {
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.cannotUseIPv6"));
            }
            NreLib.setSystemProperty((String)"niagara.ipv6Enabled", (String)String.valueOf(this.getSettings().getNiagaraUsesIpv6()));
            if (this.getSettings().getHostName().length() > 15 && BOperatingSystemEnum.isOS(BOperatingSystemEnum.windows)) {
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.invalidHostName"));
            }
            if (!BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx)) break block10;
            var2_3 = 0;
            var3_4 = this.getSettings().getAdapters().getProperties();
            if (true) ** GOTO lbl29
            do {
                if ((var4_5 = (BTcpIpAdapterSettings)var3_4.get()).getIsDhcpEnabled()) {
                    ++var2_3;
                }
lbl29:
                // 4 sources

                if ((v1 = BTcpIpPlatformService.class$com$tridium$platform$tcpip$BTcpIpAdapterSettings) != null) continue;
                v1 = BTcpIpPlatformService.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
            } while (var3_4.next(v1));
            if (var2_3 > 1) {
                throw new BajaRuntimeException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleDhcpAdapters"));
            }
        }
        var2_2 = TcpUtil.getHostSettingsXml(this.getSettings());
        var3_4 = new ByteBuffer();
        var4_5 = new XWriter(var3_4.getOutputStream());
        var2_2.write((XWriter)var4_5);
        var4_5.flush();
        var4_5.close();
        BTcpIpPlatformService.setHostSettingsXML0(new String(var3_4.toByteArray()));
        if (!BOperatingSystemEnum.isOS(BOperatingSystemEnum.linux)) {
            var5_6 = new BufferedOutputStream(new FileOutputStream(new File(BTcpIpPlatformService.getHostFileName0())));
            var5_6.write(this.getSettings().getHostFileContents().getBytes());
            var5_6.close();
        }
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.refreshProperties();
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.doPoll(context);
        this.refreshProperties();
    }

    private final boolean loadSystemPlatformServiceLibrary() {
        BSystemPlatformService bSystemPlatformService;
        BSystemPlatformService bSystemPlatformService2 = bSystemPlatformService = Sys.getStation() == null ? null : (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        return bSystemPlatformService != null && bSystemPlatformService.getPlatformLibrary() != null;
    }

    protected synchronized void refreshProperties() {
        if (!this.loadSystemPlatformServiceLibrary()) {
            return;
        }
        try {
            XElem xElem = XParser.make((String)BTcpIpPlatformService.getHostSettingsXML0()).parse();
            if (xElem.attrIndex("niagaraUsesIpv6") == -1) {
                xElem.addAttr("niagaraUsesIpv6", System.getProperty("niagara.ipv6Enabled", "false"));
            }
            TcpUtil.updateFields(this.getSettings(), xElem);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        try {
            this.getSettings().loadHostFileContents(new FileInputStream(new File(BTcpIpPlatformService.getHostFileName0())));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getSettings().setHostFileContents("");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BInteger doPing(BPingArgs bPingArgs) {
        if (!this.loadSystemPlatformServiceLibrary()) {
            return BInteger.make((int)-1);
        }
        return BInteger.make((int)BTcpIpPlatformService.ping0(bPingArgs.getDestHost(), bPingArgs.getTimeout()));
    }

    public BInteger doPing6(BPingArgs bPingArgs) {
        if (!this.loadSystemPlatformServiceLibrary()) {
            return BInteger.make((int)-1);
        }
        return BInteger.make((int)BTcpIpPlatformService.ping60(bPingArgs.getDestHost(), bPingArgs.getTimeout()));
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static final synchronized native int ping0(String var0, int var1);

    private static final synchronized native int ping60(String var0, int var1);

    private static final native String getHostSettingsXML0();

    private static final native int setHostSettingsXML0(String var0);

    private static final native void saveSettings0();

    private static final native String getHostFileName0();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BTcpIpPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("TcpIpPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platform$tcpip$BTcpIpPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platform$tcpip$BTcpIpPlatformService = BTcpIpPlatformService.class("[Lcom.tridium.platform.tcpip.BTcpIpPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceNetwork.png");
    }
}

