/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.IPlatformLibrary;
import com.tridium.platform.NativePlatformLibraryTridium;
import com.tridium.platform.archive.FileArchive;
import com.tridium.platform.archive.NullFileArchive;
import com.tridium.platform.archive.ZipArchive;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.qnx.QnxDiagnosticsPage;
import com.tridium.platform.qnx.QnxNativeUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.station.Station;
import java.io.File;
import java.io.InputStream;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSystemPlatformServiceQnx
extends BSystemPlatformService {
    public static final Property stationAutoSaveFrequency = BSystemPlatformServiceQnx.newProperty((int)1, (BValue)BRelTime.DAY, (BFacets)BSystemPlatformService.stationAutoSaveFrequency.getFacets());
    public static final Property stationSaveBackupCount = BSystemPlatformServiceQnx.newProperty((int)1, (int)0, null);
    public static final Property serialNumber = BSystemPlatformServiceQnx.newProperty((int)3, (String)"", null);
    public static final Property hardwareRevision = BSystemPlatformServiceQnx.newProperty((int)3, (String)"", null);
    public static final Property isJumperPresent = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property isBatteryPresent = BSystemPlatformServiceQnx.newProperty((int)1, (boolean)true, null);
    public static final Property ramDiskSize = BSystemPlatformServiceQnx.newProperty((int)1, (int)16, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property minFreeRamDiskPercentage = BSystemPlatformServiceQnx.newProperty((int)0, (int)5, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property lowRamDiskSpace = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minFreeHeap = BSystemPlatformServiceQnx.newProperty((int)1, (int)8, null);
    public static final Property lowHeap = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property freeHeap = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property maxHeap = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property minFreeDiskPercentage = BSystemPlatformServiceQnx.newProperty((int)0, (int)10, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Property lowDiskSpace = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minFreeFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)50)));
    public static final Property openFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)3, (int)0, null);
    public static final Property maxOpenFileDescriptors = BSystemPlatformServiceQnx.newProperty((int)3, (int)1000, null);
    public static final Property tooManyOpenFiles = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property lowAvailableFiles = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property minAvailableFiles = BSystemPlatformServiceQnx.newProperty((int)3, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)50)));
    public static final Property minFreePhysicalMemory = BSystemPlatformServiceQnx.newProperty((int)0, (int)1024, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)512)));
    public static final Property lowMemory = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property factroyDefaultCredentials = BSystemPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property failureRebootLimit = BSystemPlatformServiceQnx.newProperty((int)3, (int)3, (BFacets)BFacets.make((String[])new String[]{"min"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1)}));
    public static final Property failureRebootLimitPeriod = BSystemPlatformServiceQnx.newProperty((int)3, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String[])new String[]{"units", "min", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"minute"), BRelTime.make((long)0L), BBoolean.FALSE}));
    public static final Type TYPE;
    private static long lastFileCheck;
    private static final IPlatformLibrary _PLATFORM_LIBRARY_INSTANCE;
    private boolean ramDiskCreated;
    private String[] fileSystems;
    private Property[] filesystemProps;
    private int ramFsNdx;
    private boolean allowRebootLimitUpdate;
    private boolean rebootLimitUpdated;
    private AgentList agentList;
    static /* synthetic */ Class class$com$tridium$platform$qnx$BSystemPlatformServiceQnx;

    public String getSerialNumber() {
        return this.getString(serialNumber);
    }

    public void setSerialNumber(String string) {
        this.setString(serialNumber, string, null);
    }

    public String getHardwareRevision() {
        return this.getString(hardwareRevision);
    }

    public void setHardwareRevision(String string) {
        this.setString(hardwareRevision, string, null);
    }

    public boolean getIsJumperPresent() {
        return this.getBoolean(isJumperPresent);
    }

    public void setIsJumperPresent(boolean bl) {
        this.setBoolean(isJumperPresent, bl, null);
    }

    public boolean getIsBatteryPresent() {
        return this.getBoolean(isBatteryPresent);
    }

    public void setIsBatteryPresent(boolean bl) {
        this.setBoolean(isBatteryPresent, bl, null);
    }

    public int getRamDiskSize() {
        return this.getInt(ramDiskSize);
    }

    public void setRamDiskSize(int n) {
        this.setInt(ramDiskSize, n, null);
    }

    public int getMinFreeRamDiskPercentage() {
        return this.getInt(minFreeRamDiskPercentage);
    }

    public void setMinFreeRamDiskPercentage(int n) {
        this.setInt(minFreeRamDiskPercentage, n, null);
    }

    public boolean getLowRamDiskSpace() {
        return this.getBoolean(lowRamDiskSpace);
    }

    public void setLowRamDiskSpace(boolean bl) {
        this.setBoolean(lowRamDiskSpace, bl, null);
    }

    public int getMinFreeHeap() {
        return this.getInt(minFreeHeap);
    }

    public void setMinFreeHeap(int n) {
        this.setInt(minFreeHeap, n, null);
    }

    public boolean getLowHeap() {
        return this.getBoolean(lowHeap);
    }

    public void setLowHeap(boolean bl) {
        this.setBoolean(lowHeap, bl, null);
    }

    public int getFreeHeap() {
        return this.getInt(freeHeap);
    }

    public void setFreeHeap(int n) {
        this.setInt(freeHeap, n, null);
    }

    public int getMaxHeap() {
        return this.getInt(maxHeap);
    }

    public void setMaxHeap(int n) {
        this.setInt(maxHeap, n, null);
    }

    public int getMinFreeDiskPercentage() {
        return this.getInt(minFreeDiskPercentage);
    }

    public void setMinFreeDiskPercentage(int n) {
        this.setInt(minFreeDiskPercentage, n, null);
    }

    public boolean getLowDiskSpace() {
        return this.getBoolean(lowDiskSpace);
    }

    public void setLowDiskSpace(boolean bl) {
        this.setBoolean(lowDiskSpace, bl, null);
    }

    public int getMinFreeFileDescriptors() {
        return this.getInt(minFreeFileDescriptors);
    }

    public void setMinFreeFileDescriptors(int n) {
        this.setInt(minFreeFileDescriptors, n, null);
    }

    public int getOpenFileDescriptors() {
        return this.getInt(openFileDescriptors);
    }

    public void setOpenFileDescriptors(int n) {
        this.setInt(openFileDescriptors, n, null);
    }

    public int getMaxOpenFileDescriptors() {
        return this.getInt(maxOpenFileDescriptors);
    }

    public void setMaxOpenFileDescriptors(int n) {
        this.setInt(maxOpenFileDescriptors, n, null);
    }

    public boolean getTooManyOpenFiles() {
        return this.getBoolean(tooManyOpenFiles);
    }

    public void setTooManyOpenFiles(boolean bl) {
        this.setBoolean(tooManyOpenFiles, bl, null);
    }

    public boolean getLowAvailableFiles() {
        return this.getBoolean(lowAvailableFiles);
    }

    public void setLowAvailableFiles(boolean bl) {
        this.setBoolean(lowAvailableFiles, bl, null);
    }

    public int getMinAvailableFiles() {
        return this.getInt(minAvailableFiles);
    }

    public void setMinAvailableFiles(int n) {
        this.setInt(minAvailableFiles, n, null);
    }

    public int getMinFreePhysicalMemory() {
        return this.getInt(minFreePhysicalMemory);
    }

    public void setMinFreePhysicalMemory(int n) {
        this.setInt(minFreePhysicalMemory, n, null);
    }

    public boolean getLowMemory() {
        return this.getBoolean(lowMemory);
    }

    public void setLowMemory(boolean bl) {
        this.setBoolean(lowMemory, bl, null);
    }

    public boolean getFactroyDefaultCredentials() {
        return this.getBoolean(factroyDefaultCredentials);
    }

    public void setFactroyDefaultCredentials(boolean bl) {
        this.setBoolean(factroyDefaultCredentials, bl, null);
    }

    public int getFailureRebootLimit() {
        return this.getInt(failureRebootLimit);
    }

    public void setFailureRebootLimit(int n) {
        this.setInt(failureRebootLimit, n, null);
    }

    public BRelTime getFailureRebootLimitPeriod() {
        return (BRelTime)this.get(failureRebootLimitPeriod);
    }

    public void setFailureRebootLimitPeriod(BRelTime bRelTime) {
        this.set(failureRebootLimitPeriod, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (!this.getIsBatteryPresent()) {
            if (!NativePlatformLibraryTridium.load()) {
                return;
            }
            BPlatform.log.trace("battery is not present, slaying powerd");
            QnxNativeUtil.slay("powerd", 3);
        }
    }

    public boolean isValidPlatform() {
        return false;
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.createRamDisk();
        this.fileSystems = iPlatformLibrary.getAllFileSystemNames();
        this.filesystemProps = new Property[this.fileSystems.length];
        this.getFilesystemAttributes().removeAll();
        int n = 0;
        while (n < this.fileSystems.length) {
            BFilesystemAttributes bFilesystemAttributes = new BFilesystemAttributes(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L, iPlatformLibrary.getBlockSize(this.fileSystems[n]), iPlatformLibrary.getMaxFileCount(this.fileSystems[n]), iPlatformLibrary.getCurrentFileCount(this.fileSystems[n]), iPlatformLibrary.isFlash(this.fileSystems[n]));
            if (this.fileSystems[n].equals("/aram0")) {
                this.ramFsNdx = n;
            }
            this.filesystemProps[n] = this.getFilesystemAttributes().add(SlotPath.escape((String)this.fileSystems[n]), (BValue)bFilesystemAttributes, 3);
            ++n;
        }
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        this.setNumCpus(iPlatformLibrary.getNumberCPUs());
        this.setHardwareRevision(BSystemPlatformServiceQnx.getHardwareRevision0());
        this.setSerialNumber(BSystemPlatformServiceQnx.getSerialNumber0());
        this.setIsJumperPresent(BSystemPlatformServiceQnx.isJumperPresent0());
        this.setMaxOpenFileDescriptors(BSystemPlatformServiceQnx.getMaxOpenFds0());
        String string = System.getProperty("platform.maxHeap");
        int n2 = 0;
        n2 = string == null ? 0 : (string.endsWith("M") ? Integer.parseInt(string.substring(0, string.length() - 1)) : (string.endsWith("K") ? Integer.parseInt(string.substring(0, string.length() - 1)) / 1024 : 0));
        this.setMaxHeap(n2);
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        this.checkPropertiesLoaded();
        if (this.rebootLimitUpdated) {
            this.allowRebootLimitUpdate = false;
            BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
            String string = bDaemonSession.getErrorText(new UpdateRebootLimits(this.getFailureRebootLimit(), this.getFailureRebootLimitPeriod()));
            if (string != null) {
                throw new BajaRuntimeException(string);
            }
            this.rebootLimitUpdated = false;
            this.allowRebootLimitUpdate = true;
        }
    }

    public static final String getSystemDirectory() {
        return "/";
    }

    public String makeRootName(String string) {
        return "/" + string;
    }

    public final void doRestartStation() throws Exception {
        this.doReboot();
    }

    public final void doReboot() throws Exception {
        this.savePlatformServiceProperties();
        new Thread(new Runnable(){

            public final void run() {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
                if (LocalSessionUtil.localDaemonIsAvailable()) {
                    try {
                        if (!LocalSessionUtil.getLocalSession().sendRebootRequest(false)) {
                            BPlatform.log.error("niagarad reboot request failed, rebooting manually");
                            BSystemPlatformServiceQnx.this.rebootManually();
                        }
                    }
                    catch (Exception exception) {
                        BPlatform.log.error("niagarad reboot request failed(2), rebooting manually");
                        BSystemPlatformServiceQnx.this.rebootManually();
                    }
                } else {
                    BPlatform.log.message("niagarad not available, rebooting manually");
                    BSystemPlatformServiceQnx.this.rebootManually();
                }
            }
        }, "BSystemPlatformServiceQnx::doReboot()").start();
    }

    private final void rebootManually() {
        try {
            Station.shutdown((boolean)false);
        }
        catch (Exception exception) {
            BPlatform.log.error("Failed to shut station", (Throwable)exception);
        }
        try {
            Runtime.getRuntime().exec("/proc/boot/shutdown");
        }
        catch (Exception exception) {
            BPlatform.log.error("Failed to execute QNX shutdown command", (Throwable)exception);
        }
    }

    public void doPoll(Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (!NativePlatformLibraryTridium.load()) {
            return;
        }
        IPlatformLibrary iPlatformLibrary = this.getPlatformLibrary();
        this.setTotalPhysicalMemory((int)(iPlatformLibrary.getTotalPhysicalMemoryBytes() / 1024L));
        this.setFreePhysicalMemory((int)(iPlatformLibrary.getFreePhysicalMemoryBytes() / 1024L));
        this.setCurrentCpuUsage(iPlatformLibrary.getCurrentCPUUtilization());
        this.setOverallCpuUsage(iPlatformLibrary.getOverallCPUUtilization());
        this.setFreeHeap((int)(Runtime.getRuntime().freeMemory() / 0x100000L));
        long l = Clock.ticks();
        if (l - lastFileCheck > 15000L) {
            lastFileCheck = l;
            if (this.fileSystems != null) {
                int n = 0;
                while (n < this.fileSystems.length) {
                    BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[n]);
                    bFilesystemAttributes.setFreeSpace(iPlatformLibrary.getFreeBytes(this.fileSystems[n]) / 1024L);
                    bFilesystemAttributes.setTotalSpace(iPlatformLibrary.getTotalBytes(this.fileSystems[n]) / 1024L);
                    bFilesystemAttributes.setBlockSize(iPlatformLibrary.getBlockSize(this.fileSystems[n]));
                    bFilesystemAttributes.setMaxFileCount((int)iPlatformLibrary.getMaxFileCount(this.fileSystems[n]));
                    bFilesystemAttributes.setCurrentFileCount((int)iPlatformLibrary.getCurrentFileCount(this.fileSystems[n]));
                    if (n == this.ramFsNdx) {
                        bFilesystemAttributes.setIsRamDisk(true);
                    }
                    ++n;
                }
            }
            this.setOpenFileDescriptors(BSystemPlatformServiceQnx.getFdUsageCount0());
        }
        if (context != null && context.getFacets().getb("resourceOnly", false)) {
            return;
        }
        super.doPoll(context);
        if (!this.rebootLimitUpdated) {
            new Thread(new Runnable(){

                public final void run() {
                    BSystemPlatformServiceQnx.this.allowRebootLimitUpdate = false;
                    try {
                        if (LocalSessionUtil.localDaemonIsAvailable()) {
                            BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
                            bDaemonSession.reloadHostProperties();
                            BHostProperties bHostProperties = bDaemonSession.getHostProperties();
                            BSystemPlatformServiceQnx.this.setFailureRebootLimit(bHostProperties.getFailureRebootLimit());
                            BSystemPlatformServiceQnx.this.setFailureRebootLimitPeriod(bHostProperties.getFailureRebootLimitPeriod());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    BSystemPlatformServiceQnx.this.allowRebootLimitUpdate = true;
                }
            }, "BSystemPlatformServiceQnx::failureRebootUpdateThread").start();
        }
    }

    protected boolean isLowJavaHeap() {
        long l = (long)this.getMinFreeHeap() * 1024L * 1024L;
        long l2 = (long)this.getMaxHeap() * 1024L * 1024L;
        boolean bl = false;
        boolean bl2 = this.getLowHeap();
        long l3 = Runtime.getRuntime().totalMemory();
        if (l == 0L || l3 < l2) {
            bl = false;
        } else {
            long l4 = Runtime.getRuntime().freeMemory();
            if (l4 < l) {
                BPlatform.log.trace("Low Heap Monitor forcing GC, heapFree " + l4 + " < minFree " + l);
                System.gc();
                l4 = Runtime.getRuntime().freeMemory();
                if (l4 < l) {
                    if (!bl2) {
                        BPlatform.log.warning("Low Heap: heapFree " + l4 + " < minFree " + l);
                    }
                    bl = true;
                }
            }
            BPlatform.log.trace("Low Heap Monitor: heapFree " + l4 + " minFree " + l);
        }
        this.setLowHeap(bl);
        return bl;
    }

    protected boolean isLowRamDisk() {
        boolean bl;
        if (this.filesystemProps == null || this.ramFsNdx < 0) {
            return false;
        }
        int n = this.getMinFreeRamDiskPercentage();
        BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[this.ramFsNdx]);
        int n2 = (int)(bFilesystemAttributes.getFreeSpace() * 100L / bFilesystemAttributes.getTotalSpace());
        if (n2 < n) {
            bl = true;
            if (!this.getLowRamDiskSpace()) {
                BPlatform.log.warning("Low RAM Disk Space: " + n2 + "% free, minimum " + n + '%');
            }
        } else {
            bl = false;
        }
        this.setLowRamDiskSpace(bl);
        return bl;
    }

    protected boolean isFactoryDefaultCredentials() {
        boolean bl = false;
        if (LocalSessionUtil.localDaemonIsAvailable()) {
            BDaemonSession bDaemonSession = LocalSessionUtil.getLocalSession();
            try {
                XElem xElem;
                XElem xElem2 = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new XmlResponseMessage(){

                    public final String getMessageString() {
                        return "auth";
                    }
                }, "text/xml")).parse();
                XElem xElem3 = xElem2.elem("auth");
                if (xElem3 != null && (xElem = xElem3.elem("user")) != null) {
                    bl = xElem.getb("default", false);
                }
                if (bl && !this.getFactroyDefaultCredentials()) {
                    BPlatform.log.warning("Factory default platform credentials detected");
                }
            }
            catch (Exception exception) {}
        }
        this.setFactroyDefaultCredentials(bl);
        return bl;
    }

    protected boolean isLowDisk() {
        boolean bl;
        if (this.filesystemProps == null) {
            return false;
        }
        int n = this.getMinFreeDiskPercentage();
        BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[0]);
        int n2 = (int)(bFilesystemAttributes.getFreeSpace() * 100L / bFilesystemAttributes.getTotalSpace());
        if (n2 < n) {
            bl = true;
            if (!this.getLowDiskSpace()) {
                BPlatform.log.warning("Low Disk Space " + n2 + "% free, minimum " + n + '%');
            }
        } else {
            bl = false;
        }
        this.setLowDiskSpace(bl);
        return bl;
    }

    private final boolean isFdUsageHigh() {
        boolean bl;
        int n;
        int n2 = this.getOpenFileDescriptors();
        int n3 = this.getMaxOpenFileDescriptors();
        if (n3 - n2 < (n = this.getMinFreeFileDescriptors())) {
            bl = true;
            if (!this.getTooManyOpenFiles()) {
                BPlatform.log.warning("Too many open files or sockets: " + n2 + " in use, maximum available is " + n3);
            }
        } else {
            bl = false;
        }
        this.setTooManyOpenFiles(bl);
        return bl;
    }

    private final boolean isFileCountHigh() {
        int n = this.getMinAvailableFiles();
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        BFilesystemAttributes bFilesystemAttributes = (BFilesystemAttributes)this.getFilesystemAttributes().get(this.filesystemProps[0]);
        l2 = bFilesystemAttributes.getMaxFileCount();
        if (l2 - (l = bFilesystemAttributes.getCurrentFileCount()) < (long)n) {
            bl = true;
            if (!this.getLowAvailableFiles()) {
                BPlatform.log.warning("Too many files: " + l + " on file system: " + this.fileSystems[0] + ", maximum available is " + l2);
            }
        } else {
            bl = false;
        }
        this.setLowAvailableFiles(bl);
        return bl;
    }

    private final boolean isLowMemory() {
        boolean bl;
        int n;
        int n2 = this.getFreePhysicalMemory();
        if (n2 < (n = this.getMinFreePhysicalMemory())) {
            bl = true;
            if (!this.getLowMemory()) {
                BPlatform.log.warning("Low System Memory " + n2 + " KB available");
            }
        } else {
            bl = false;
        }
        this.setLowMemory(bl);
        return bl;
    }

    public String checkForStationFault() {
        if (this.isLowMemory()) {
            return "stationFault.lowSystemMemory";
        }
        if (this.isLowJavaHeap()) {
            return "stationFault.lowHeap";
        }
        if (this.isLowDisk()) {
            return "stationFault.diskSpace";
        }
        if (this.isLowRamDisk()) {
            return "stationFault.ramDiskSpace";
        }
        if (this.isFdUsageHigh()) {
            return "stationFault.fdUsage";
        }
        if (this.isFileCountHigh()) {
            return "stationFault.fileUsage";
        }
        return null;
    }

    public void queryResources(ResourceReport resourceReport) {
        resourceReport.put("fd.open", "" + this.getOpenFileDescriptors());
        resourceReport.put("fd.max", "" + this.getMaxOpenFileDescriptors());
    }

    public boolean archiveEnabled(String string) {
        return true;
    }

    public FileArchive createFileArchive(String string) {
        if (this.getRamDiskSize() == 0) {
            return new NullFileArchive();
        }
        String string2 = Sys.getStationHome().getPath() + '/' + string;
        String string3 = string + ".zip";
        File file = new File(Sys.getStationHome().getPath() + '/' + string);
        file.mkdir();
        return new ZipArchive(string2, string3, 1);
    }

    public synchronized void extractArchive(String string) {
        if (this.getRamDiskSize() != 0) {
            this.createRamDisk();
            try {
                ZipArchive.unzip(Sys.getStationHome().getPath() + '/' + string, string + ".zip", "/" + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BPlatform.log.error("Failed to extrace archive \"" + string + "\" to RAM disk", (Throwable)exception);
            }
        }
    }

    private final synchronized void createRamDisk() {
        if (!this.ramDiskCreated) {
            try {
                String string = System.getProperty("os.arch", "").equals("x86") ? "/bin/ksh /niagara/bin/ramdisk.sh " + this.getRamDiskSize() * 2 * 1024 : "/proc/boot/ksh /niagara/bin/ramdisk.sh " + this.getRamDiskSize() * 2 * 1024;
                Process process = Runtime.getRuntime().exec(string);
                process.waitFor();
                if (process.exitValue() != 0) {
                    BPlatform.log.error("Unable to create archive RAM disk");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BPlatform.log.error("Failed to initialize RAM disk", (Throwable)exception);
            }
            this.ramDiskCreated = true;
        }
    }

    public String getRuntimeDirectory(String string) {
        if (this.getRamDiskSize() == 0) {
            return super.getRuntimeDirectory(string);
        }
        return "/" + string;
    }

    public AgentList getAgents(Context context) {
        if (this.agentList == null) {
            this.agentList = super.getAgents(context);
            this.agentList.remove("platform:SystemPlatformServicePlugin");
        }
        return this.agentList;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"SystemPlatformServiceQnx", 2);
        if (this.isProxy()) {
            spyWriter.prop((Object)"lastErrorMessage", (Object)"remote");
        } else if (NativePlatformLibraryTridium.load()) {
            spyWriter.prop((Object)"lastErrorMessage", (Object)this.getPlatformLibrary().getLastErrorMessage());
        }
        spyWriter.endProps();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.allowRebootLimitUpdate && this.platformServicePropertiesLoaded && (property == failureRebootLimit || property == failureRebootLimitPeriod)) {
            this.rebootLimitUpdated = true;
        }
    }

    protected void doRenameAndRestart(BDaemonSession bDaemonSession, String string, String string2) throws Exception {
        Station.shutdown((boolean)false);
        FilePath filePath = new FilePath("!stations");
        BFileSystem.INSTANCE.delete(filePath.merge(string2));
        BFileSystem.INSTANCE.move(filePath.merge(string), filePath.merge(string2));
        XmlResponseMessage[] xmlResponseMessageArray = new XmlResponseMessage[]{new UpdateStationMessage(), new UpdateStationMessage(string2, false, true, true, true)};
        bDaemonSession.sendMessages(xmlResponseMessageArray, BDaemonSession.DEFAULT_TIMEOUT);
        bDaemonSession.sendForceRebootRequest();
    }

    public IPlatformLibrary getPlatformLibrary() {
        if (!NativePlatformLibraryTridium.load()) {
            return null;
        }
        return _PLATFORM_LIBRARY_INSTANCE;
    }

    private static final native String getHardwareRevision0();

    private static final native String getSerialNumber0();

    private static final native boolean isJumperPresent0();

    private static final native int getFdUsageCount0();

    private static final native int getMaxOpenFds0();

    public static void main(String[] stringArray) {
        try {
            System.out.println("Platform Service Test");
            NativePlatformLibraryTridium.load();
            System.out.println("Natives loaded");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ boolean access$1(BSystemPlatformServiceQnx bSystemPlatformServiceQnx) {
        return bSystemPlatformServiceQnx.allowRebootLimitUpdate;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ramDiskCreated = false;
        this.ramFsNdx = -1;
        this.allowRebootLimitUpdate = true;
        this.rebootLimitUpdated = false;
        this.agentList = null;
    }

    public BSystemPlatformServiceQnx() {
        this.this();
        this.setTimezoneDayModeSupport(BDstSupportLevel.exact);
    }

    static {
        Class clazz = class$com$tridium$platform$qnx$BSystemPlatformServiceQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platform$qnx$BSystemPlatformServiceQnx = BSystemPlatformServiceQnx.class("[Lcom.tridium.platform.qnx.BSystemPlatformServiceQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        if (BOperatingSystemEnum.getOS() == BOperatingSystemEnum.qnx) {
            Spy.ROOT.add("platform diagnostics", (Spy)new QnxDiagnosticsPage());
        }
        lastFileCheck = 0L;
        _PLATFORM_LIBRARY_INSTANCE = new NativePlatformLibraryTridium();
    }

    private static class UpdateRebootLimits
    extends XmlResponseMessage {
        private int limit;
        private BRelTime period;

        public String getMessageString() {
            StringBuffer stringBuffer = new StringBuffer("updatedaemon");
            stringBuffer.append("?failureRebootLimit=");
            stringBuffer.append(String.valueOf(this.limit));
            stringBuffer.append("&failureRebootLimitPeriod=");
            stringBuffer.append(String.valueOf(this.period.getMillis()));
            return stringBuffer.toString();
        }

        public UpdateRebootLimits(int n, BRelTime bRelTime) {
            this.limit = n;
            this.period = bRelTime;
        }
    }
}

