/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.qnx;

import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.ntp.BNtpPlatformService;
import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.posix.NtpConfUtil;
import com.tridium.platform.qnx.BNtpServerQnx;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.sys.station.Station;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.baja.file.FileUtil;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNtpPlatformServiceQnx
extends BNtpPlatformService {
    public static final Property timeServers = BNtpPlatformServiceQnx.newProperty((int)3, (BValue)new BNtpServerVector(), (BFacets)BFacets.make((String)"elementType", (String)"platform:NtpServerQnx"));
    public static final Property statistics = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Property ntp = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    public static final Property localBackup = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)true, null);
    public static final Property authentication = BNtpPlatformServiceQnx.newProperty((int)7, (boolean)false, null);
    public static final Property monitor = BNtpPlatformServiceQnx.newProperty((int)7, (boolean)false, null);
    public static final Property panic = BNtpPlatformServiceQnx.newProperty((int)7, (int)(BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx) ? 0 : 1000), null);
    public static final Property syncAtBoot = BNtpPlatformServiceQnx.newProperty((int)3, (boolean)false, null);
    public static final Action syncRTC = BNtpPlatformServiceQnx.newAction((int)4, null);
    public static final Action syncNow = BNtpPlatformServiceQnx.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Type TYPE;
    protected boolean allowUpdate;
    private final NtpServiceSaveListener saveListener;
    static /* synthetic */ Class class$com$tridium$platform$qnx$BNtpPlatformServiceQnx;
    static /* synthetic */ Class class$java$lang$String;

    public boolean getStatistics() {
        return this.getBoolean(statistics);
    }

    public void setStatistics(boolean bl) {
        this.setBoolean(statistics, bl, null);
    }

    public boolean getNtp() {
        return this.getBoolean(ntp);
    }

    public void setNtp(boolean bl) {
        this.setBoolean(ntp, bl, null);
    }

    public boolean getLocalBackup() {
        return this.getBoolean(localBackup);
    }

    public void setLocalBackup(boolean bl) {
        this.setBoolean(localBackup, bl, null);
    }

    public boolean getAuthentication() {
        return this.getBoolean(authentication);
    }

    public void setAuthentication(boolean bl) {
        this.setBoolean(authentication, bl, null);
    }

    public boolean getMonitor() {
        return this.getBoolean(monitor);
    }

    public void setMonitor(boolean bl) {
        this.setBoolean(monitor, bl, null);
    }

    public int getPanic() {
        return this.getInt(panic);
    }

    public void setPanic(int n) {
        this.setInt(panic, n, null);
    }

    public boolean getSyncAtBoot() {
        return this.getBoolean(syncAtBoot);
    }

    public void setSyncAtBoot(boolean bl) {
        this.setBoolean(syncAtBoot, bl, null);
    }

    public BInteger syncRTC() {
        return (BInteger)this.invoke(syncRTC, null, null);
    }

    public BInteger syncNow(BString bString) {
        return (BInteger)this.invoke(syncNow, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void stationStarted() throws Exception {
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        if (this.isServiceStarted()) {
            Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)6), (Action)syncRTC, null);
        }
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        Station.removeSaveListener((Station.SaveListener)this.saveListener);
    }

    public boolean isValidPlatform() {
        return BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx);
    }

    public int getSlotFlags() {
        return 0;
    }

    public void loadPlatformServiceProperties() {
        super.loadPlatformServiceProperties();
        this.allowUpdate = false;
        this.setEnabled(NtpConfUtil.isEnabled());
        this.setPanic(NtpConfUtil.getPanic());
        this.setSyncAtBoot(NtpConfUtil.getSyncAtBoot());
        String string = NtpConfUtil.getDisabledString();
        boolean bl = false;
        if (string.indexOf("ntp") == -1) {
            bl = true;
        }
        this.setNtp(bl);
        this.setLocalBackup(NtpConfUtil.getUseLocalBackup());
        boolean bl2 = false;
        if (string.indexOf("stats") == -1) {
            bl2 = true;
        }
        this.setStatistics(bl2);
        this.setMonitor(false);
        this.setAuthentication(false);
        this.getTimeServers().sync(NtpConfUtil.getNtpServers());
        this.allowUpdate = true;
    }

    public void doPoll(Context context) {
        super.doPoll(context);
        if (!this.isRunning()) {
            return;
        }
        this.allowUpdate = false;
        this.setEnabled(NtpConfUtil.isEnabled());
        this.setPanic(NtpConfUtil.getPanic());
        this.setSyncAtBoot(NtpConfUtil.getSyncAtBoot());
        String string = NtpConfUtil.getDisabledString();
        boolean bl = false;
        if (string.indexOf("ntp") == -1) {
            bl = true;
        }
        this.setNtp(bl);
        this.setLocalBackup(NtpConfUtil.getUseLocalBackup());
        boolean bl2 = false;
        if (string.indexOf("stats") == -1) {
            bl2 = true;
        }
        this.setStatistics(bl2);
        this.setMonitor(false);
        this.setAuthentication(false);
        this.getTimeServers().sync(NtpConfUtil.getNtpServers());
        this.allowUpdate = true;
    }

    public void doSavePlatformServiceProperties() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        super.doSavePlatformServiceProperties();
        NtpConfUtil.setEnabled(this.getEnabled());
        NtpConfUtil.setPanic(this.getPanic());
        NtpConfUtil.setSyncAtBoot(this.getSyncAtBoot());
        StringBuffer stringBuffer = new StringBuffer("enable");
        StringBuffer stringBuffer2 = new StringBuffer("disable");
        (this.getNtp() ? stringBuffer : stringBuffer2).append(" ntp");
        (this.getStatistics() ? stringBuffer : stringBuffer2).append(" stats");
        (this.getAuthentication() ? stringBuffer : stringBuffer2).append(" auth");
        (this.getMonitor() ? stringBuffer : stringBuffer2).append(" monitor");
        NtpConfUtil.setEnabledString(stringBuffer.toString());
        NtpConfUtil.setDisabledString(stringBuffer2.toString());
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BNtpPlatformServiceQnx.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        SlotCursor slotCursor = this.getTimeServers().getProperties();
        while (slotCursor.next()) {
            array.add((Object)((BNtpServer)slotCursor.get()).getServerString());
        }
        NtpConfUtil.setNtpServers((String[])array.trim());
        NtpConfUtil.setLocalBackup(this.getLocalBackup());
        NtpConfUtil.write();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter spyWriter) throws Exception {
        Process process;
        Object var6_13;
        super.spy(spyWriter);
        if (!BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx)) {
            return;
        }
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        String string = null;
        spyWriter.startTable(false);
        spyWriter.trTitle((Object)"NTP Configuration File", 1);
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader("/niagara/lib/ntp.conf"));
                while ((string = bufferedReader.readLine()) != null) {
                    spyWriter.tr((Object)string.trim());
                }
            }
            catch (IOException iOException) {
                spyWriter.tr((Object)("Error reading /niagara/lib/ntp.conf: " + iOException.getMessage()));
            }
            var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        spyWriter.endTable();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"NTP Daemon Log", 1);
        try {
            try {
                process = Runtime.getRuntime().exec("/proc/boot/slogin");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.indexOf("ntpd") == -1) continue;
                    spyWriter.tr((Object)string.trim());
                }
            }
            catch (IOException iOException) {
                spyWriter.tr((Object)("Error reading NTP Daemon Log: " + iOException.getMessage()));
            }
            var6_13 = null;
        }
        catch (Throwable throwable) {
            var6_13 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        spyWriter.endTable();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"NTP Daemon Drift", 1);
        try {
            block57: {
                try {
                    bufferedReader = new BufferedReader(new FileReader("/tmp/ntp.drift.TEMP"));
                    while ((string = bufferedReader.readLine()) != null) {
                        spyWriter.tr((Object)string.trim());
                    }
                    break block57;
                }
                catch (IOException iOException) {
                    try {
                        try {
                            bufferedReader2 = new BufferedReader(new FileReader("/tmp/ntp.drift"));
                            while ((string = bufferedReader2.readLine()) != null) {
                                spyWriter.tr((Object)string.trim());
                            }
                        }
                        catch (IOException iOException2) {
                            spyWriter.tr((Object)("Error reading /tmp/ntp.drift: " + iOException.getMessage()));
                        }
                        Object var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        try {
                            bufferedReader2.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                try {}
                catch (Exception exception) {}
                bufferedReader2.close();
            }
            var6_13 = null;
        }
        catch (Throwable throwable) {
            var6_13 = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        spyWriter.endTable();
        if (!this.getStatistics()) return;
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"NTP Daemon Clock Stats", 1);
        spyWriter.tr((Object)"Modified Julian Day | Secs. Past UTC Midnight | Clock Address | Last Time Code");
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader("/var/run/ntpdstats/clockstats"));
                while ((string = bufferedReader.readLine()) != null) {
                    spyWriter.tr((Object)string.trim());
                }
            }
            catch (IOException iOException) {
                spyWriter.tr((Object)("Error reading /var/run/ntpdstats/clockstats: " + iOException.getMessage()));
            }
            process = null;
        }
        catch (Throwable throwable) {
            process = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        spyWriter.endTable();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"NTP Daemon Loop Stats", 1);
        spyWriter.tr((Object)"Modified Julian Day | Secs. Past UTC Midnight | Time Offset Secs. | Drift Compenstation | Estimated Error | Stability | Polling Interval");
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader("/var/run/ntpdstats/loopstats"));
                while ((string = bufferedReader.readLine()) != null) {
                    spyWriter.tr((Object)string.trim());
                }
            }
            catch (IOException iOException) {
                spyWriter.tr((Object)("Error reading /var/run/ntpdstats/loopstats: " + iOException.getMessage()));
            }
            process = null;
        }
        catch (Throwable throwable) {
            process = null;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        spyWriter.endTable();
    }

    public BInteger doSyncNow(BString bString) {
        Object object;
        if (!new File("/proc/boot/ntpdate").exists()) {
            return BInteger.make((int)2);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (bString != null && bString.toString().trim().length() > 0) {
            string = bString.toString().trim();
        } else {
            object = this.getTimeServers().getProperties();
            while (object.next()) {
                if (!((BNtpServerQnx)object.get()).getServerPreferred()) continue;
                string2 = ((BNtpServerQnx)object.get()).getAddress().trim();
                break;
            }
            if (string2 == null) {
                object = this.getTimeServers().getProperties();
                while (object.next()) {
                    if (((BNtpServerQnx)object.get()).getPeerMode().getOrdinal() != 2 && ((BNtpServerQnx)object.get()).getPeerMode().getOrdinal() != 1) continue;
                    string3 = ((BNtpServerQnx)object.get()).getAddress().trim();
                    break;
                }
            }
            if (string2 != null) {
                string = string2;
            } else if (string3 != null) {
                string = string3;
            } else {
                return BInteger.make((int)1);
            }
        }
        object = new DoSyncThread();
        DoSyncThread.targetServer = string;
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        return BInteger.make((int)0);
    }

    public BInteger doSyncRTC() {
        if (NtpConfUtil.isEnabled()) {
            try {
                BSystemPlatformServiceQnx bSystemPlatformServiceQnx = (BSystemPlatformServiceQnx)Sys.getService((Type)BSystemPlatformService.TYPE);
                bSystemPlatformServiceQnx.setPlatformSystemTime(0L);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                serviceNotFoundException.printStackTrace();
                return BInteger.make((int)-1);
            }
        }
        return BInteger.make((int)0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.allowUpdate = true;
        this.saveListener = new NtpServiceSaveListener();
    }

    public BNtpPlatformServiceQnx() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$qnx$BNtpPlatformServiceQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platform$qnx$BNtpPlatformServiceQnx = BNtpPlatformServiceQnx.class("[Lcom.tridium.platform.qnx.BNtpPlatformServiceQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class DoSyncThread
    extends Thread {
        public static String targetServer;

        public void run() {
            try {
                String string = "/proc/boot/ntpdate -u -s " + targetServer;
                Runtime.getRuntime().exec(string);
            }
            catch (Exception exception) {}
        }

        public DoSyncThread() {
            super("NtpPlatformService:DoSyncThread");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class NtpServiceSaveListener
    implements Station.SaveListener {
        public final void stationSave() {
            try {
                File file = new File("/etc/ntp.drift");
                File file2 = new File("/tmp/ntp.drift.TEMP");
                File file3 = new File("/tmp/ntp.drift");
                if (file.exists()) {
                    FileUtil.delete((File)file);
                }
                if (file2.exists()) {
                    FileUtil.copy((File)file2, (File)file);
                } else if (file3.exists()) {
                    FileUtil.copy((File)file3, (File)file);
                }
                BNtpPlatformServiceQnx.this.syncRTC();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public final void stationSaveOk() {
        }

        public final void stationSaveFail(String string) {
        }

        public final String toString() {
            return "NtpServiceSaveListener " + BNtpPlatformServiceQnx.this.getNavOrd();
        }

        private NtpServiceSaveListener() {
        }
    }
}

