/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.pki;

import com.tridium.platform.pki.PemInputStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PemCertInfo {
    public static final FilePath CA_CERTS_PATH = new FilePath("!pki/cacerts");
    public static final FilePath SERVER_CERTS_PATH = new FilePath("!pki/servercerts");
    public static final PemCertInfo BLANK_CERTIFICATE = new PemCertInfo();
    public static final int CERT_USAGE_CERT_SIGN = 5;
    public BIFile file;
    public X509Certificate cert;
    public String subjectCn;
    public String subject;
    public String issuerCn;
    public String issuer;
    public Exception parseException;
    static /* synthetic */ Class class$com$tridium$platform$pki$PemCertInfo;

    public static PemCertInfo[] listCACerts(BFileSpace bFileSpace) throws Exception {
        return PemCertInfo.list(bFileSpace, CA_CERTS_PATH);
    }

    public static PemCertInfo[] listServerCerts(BFileSpace bFileSpace) throws Exception {
        return PemCertInfo.list(bFileSpace, SERVER_CERTS_PATH);
    }

    public static PemCertInfo[] list(BFileSpace bFileSpace, FilePath filePath) throws Exception {
        BDirectory bDirectory = (BDirectory)bFileSpace.findFile(filePath);
        if (bDirectory == null) {
            return new PemCertInfo[0];
        }
        return PemCertInfo.makeCertificates(bDirectory.listFiles());
    }

    public static PemCertInfo[] makeCACertificates(BFileSpace bFileSpace) throws Exception {
        BDirectory bDirectory = (BDirectory)bFileSpace.findFile(CA_CERTS_PATH);
        return PemCertInfo.makeCertificates(bDirectory == null ? null : bDirectory.listFiles());
    }

    public static PemCertInfo[] makeServerCertificates(BFileSpace bFileSpace) throws Exception {
        BDirectory bDirectory = (BDirectory)bFileSpace.findFile(SERVER_CERTS_PATH);
        return PemCertInfo.makeCertificates(bDirectory == null ? null : bDirectory.listFiles());
    }

    public static PemCertInfo[] makeCertificates(BIFile[] bIFileArray) throws Exception {
        if (bIFileArray == null) {
            return new PemCertInfo[0];
        }
        Class clazz = class$com$tridium$platform$pki$PemCertInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platform$pki$PemCertInfo = PemCertInfo.class("[Lcom.tridium.platform.pki.PemCertInfo;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bIFileArray.length) {
            if (!bIFileArray[n].getFileName().endsWith(".0")) {
                array.add((Object)new PemCertInfo(bIFileArray[n], new int[]{5}));
            }
            ++n;
        }
        return (PemCertInfo[])array.trim();
    }

    public static X509Certificate getPEMCertificate(BIFile bIFile, int n) {
        return PemCertInfo.getPEMCertificate(bIFile, new int[]{n});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getPEMCertificate(BIFile bIFile, int[] nArray) {
        if (bIFile == null) return null;
        if (bIFile instanceof BDirectory) return null;
        try {
            PemInputStream pemInputStream;
            block18: {
                X509Certificate x509Certificate;
                block21: {
                    X509Certificate x509Certificate2;
                    block20: {
                        InputStream inputStream = bIFile.getInputStream();
                        pemInputStream = new PemInputStream(new BufferedInputStream(inputStream));
                        try {
                            if (pemInputStream.readToEntry(1) <= 0) break block18;
                            X509Certificate x509Certificate3 = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(pemInputStream);
                            if (nArray != null) {
                                if (x509Certificate3.getKeyUsage() != null) {
                                    int n = 0;
                                    while (n < nArray.length) {
                                        if (!x509Certificate3.getKeyUsage()[nArray[n]]) {
                                            X509Certificate x509Certificate4 = null;
                                            Object var5_11 = null;
                                            try {
                                                pemInputStream.close();
                                                return x509Certificate4;
                                            }
                                            catch (Exception exception) {}
                                            return x509Certificate4;
                                        }
                                        ++n;
                                    }
                                } else {
                                    int n = 0;
                                    while (n < nArray.length) {
                                        if (nArray[n] == 5) {
                                            if (x509Certificate3.getBasicConstraints() != -1) break;
                                            x509Certificate2 = null;
                                            break block20;
                                        }
                                        ++n;
                                    }
                                }
                            }
                            x509Certificate = x509Certificate3;
                            break block21;
                        }
                        catch (Throwable throwable) {
                            Object var5_14 = null;
                            try {}
                            catch (Exception exception) {}
                            pemInputStream.close();
                            throw throwable;
                            throw throwable;
                        }
                    }
                    Object var5_12 = null;
                    try {}
                    catch (Exception exception) {}
                    pemInputStream.close();
                    return x509Certificate2;
                }
                Object var5_13 = null;
                try {}
                catch (Exception exception) {}
                pemInputStream.close();
                return x509Certificate;
            }
            Object var5_15 = null;
            try {}
            catch (Exception exception) {
                return null;
            }
            pemInputStream.close();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected void load(BIFile bIFile, int[] nArray) throws Exception {
        this.file = bIFile;
        this.cert = PemCertInfo.getPEMCertificate(bIFile, nArray);
        this.subject = this.cert == null ? null : this.cert.getSubjectX500Principal().toString();
        this.issuer = this.cert == null ? null : this.cert.getIssuerX500Principal().toString();
        this.subjectCn = this.subject == null ? null : PemCertInfo.getX500Cn(this.subject);
        this.issuerCn = this.issuer == null ? null : PemCertInfo.getX500Cn(this.issuer);
    }

    public static String getX500Cn(String string) {
        String[] stringArray = TextUtil.split((String)string, (char)',');
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(61);
            String string2 = stringArray[n].substring(0, n2).trim();
            String string3 = stringArray[n].substring(n2 + 1);
            if (string3.charAt(0) == '\"') {
                while (string3.charAt(string3.length() - 1) != '\"') {
                    string3 = string3 + stringArray[++n];
                }
            }
            if (string2.equals("CN")) {
                return string3;
            }
            ++n;
        }
        return null;
    }

    public String getSubject() {
        return this.subjectCn == null ? this.subject : this.subjectCn;
    }

    public BAbsTime getStart() {
        if (this.cert != null) {
            return BAbsTime.make((long)this.cert.getNotBefore().getTime());
        }
        return null;
    }

    public BAbsTime getEnd() {
        if (this.cert != null) {
            return BAbsTime.make((long)this.cert.getNotAfter().getTime());
        }
        return null;
    }

    public String getSignatureAlgName() {
        if (this.cert != null) {
            return this.cert.getSigAlgName();
        }
        return null;
    }

    public String getIssuer() {
        return this.issuerCn == null ? this.issuer : this.issuerCn;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Context context) {
        if (this == BLANK_CERTIFICATE) {
            return "NONE";
        }
        if (this.subjectCn == null) {
            if (this.subject == null) {
                return this.file.getFileName();
            }
            return this.subject;
        }
        return this.subjectCn;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.file = null;
        this.cert = null;
        this.subjectCn = null;
        this.subject = null;
        this.issuerCn = null;
        this.issuer = null;
        this.parseException = null;
    }

    private PemCertInfo() {
        this.this();
        this.file = new BDataFile();
        this.cert = null;
        this.subjectCn = null;
        this.subject = null;
        this.issuerCn = null;
        this.issuer = null;
        this.parseException = null;
    }

    public PemCertInfo(BIFile bIFile, int n) throws Exception {
        this(bIFile, new int[]{n});
    }

    public PemCertInfo(BIFile bIFile, int[] nArray) throws Exception {
        this.this();
        this.load(bIFile, nArray);
    }
}

