/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.pki;

import com.tridium.platform.pki.PemInputStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClientPrivateKeyInfo {
    public static final FilePath CLIENT_KEYS_PATH = new FilePath("!pki/clientkeys");
    public static final FilePath CLIENT_CERTS_PATH = new FilePath("!pki/clientcerts");
    public static final ClientPrivateKeyInfo BLANK_KEY_CERTIFICATE = new ClientPrivateKeyInfo();
    public BIFile keyFile;
    public BIFile certFile;
    public boolean hasKey;
    public Exception parseException;

    public static ClientPrivateKeyInfo[] list(BFileSpace bFileSpace) throws Exception {
        return ClientPrivateKeyInfo.list(bFileSpace, CLIENT_KEYS_PATH, CLIENT_CERTS_PATH);
    }

    public static ClientPrivateKeyInfo[] list(BFileSpace bFileSpace, FilePath filePath, FilePath filePath2) throws Exception {
        BDirectory bDirectory = (BDirectory)bFileSpace.findFile(filePath);
        BDirectory bDirectory2 = (BDirectory)bFileSpace.findFile(filePath2);
        if (bDirectory == null || bDirectory2 == null) {
            return new ClientPrivateKeyInfo[0];
        }
        return ClientPrivateKeyInfo.make(bDirectory.listFiles(), bDirectory2);
    }

    public static ClientPrivateKeyInfo[] make(BIFile[] bIFileArray, BDirectory bDirectory) throws Exception {
        if (bIFileArray == null) {
            return new ClientPrivateKeyInfo[0];
        }
        ClientPrivateKeyInfo[] clientPrivateKeyInfoArray = new ClientPrivateKeyInfo[bIFileArray.length];
        int n = 0;
        while (n < bIFileArray.length) {
            clientPrivateKeyInfoArray[n] = new ClientPrivateKeyInfo(bIFileArray[n]);
            if (clientPrivateKeyInfoArray[n].keyFile != null && clientPrivateKeyInfoArray[n].certFile == null && bDirectory != null) {
                clientPrivateKeyInfoArray[n].certFile = clientPrivateKeyInfoArray[n].keyFile.getFileSpace().findFile(bDirectory.getFilePath().merge(clientPrivateKeyInfoArray[n].getNormalCertFilename()));
            }
            ++n;
        }
        return clientPrivateKeyInfoArray;
    }

    public String getNormalCertFilename() {
        return FileUtil.getBase((String)this.keyFile.getFileName()) + "_cert.pem";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(BIFile bIFile) throws Exception {
        this.keyFile = bIFile;
        String string = this.keyFile.getExtension();
        if ("PFX".equalsIgnoreCase(string) || "P12".equalsIgnoreCase(string)) {
            this.hasKey = true;
            this.certFile = bIFile;
            return;
        }
        if (!"PEM".equalsIgnoreCase(string)) return;
        InputStream inputStream = bIFile.getInputStream();
        PemInputStream pemInputStream = new PemInputStream(new BufferedInputStream(inputStream));
        try {
            try {
                this.certFile = null;
                if (pemInputStream.readToEntry(2) > 0) {
                    this.hasKey = true;
                }
            }
            catch (Exception exception) {
                this.hasKey = false;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            pemInputStream.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        pemInputStream.close();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Context context) {
        if (this == BLANK_KEY_CERTIFICATE) {
            return "NONE";
        }
        return this.keyFile.getFileName();
    }

    private final /* synthetic */ void this() {
        this.keyFile = null;
        this.certFile = null;
        this.hasKey = false;
        this.parseException = null;
    }

    public ClientPrivateKeyInfo(BIFile bIFile) throws Exception {
        this.this();
        this.load(bIFile);
    }

    private ClientPrivateKeyInfo() {
        this.this();
        this.keyFile = new BDataFile();
        this.certFile = new BDataFile();
        this.hasKey = false;
        this.parseException = null;
    }
}

